/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.database.DataSetObserver;
import android.os.Parcelable;
import android.os.SystemClock;
import android.util.AttributeSet;
import android.util.SparseArray;
import android.view.ContextMenu;
import android.view.RemotableViewMethod;
import android.view.View;
import android.view.ViewDebug;
import android.view.ViewGroup;
import android.view.ViewHierarchyEncoder;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityManager;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.autofill.AutoFillManager;
import android.widget.Adapter;

public abstract class AdapterView<T extends Adapter>
extends ViewGroup {
    public static final int ITEM_VIEW_TYPE_IGNORE = -1;
    public static final int ITEM_VIEW_TYPE_HEADER_OR_FOOTER = -2;
    @ViewDebug.ExportedProperty(category="scrolling")
    int mFirstPosition = 0;
    int mSpecificTop;
    int mSyncPosition;
    long mSyncRowId = Long.MIN_VALUE;
    long mSyncHeight;
    boolean mNeedSync = false;
    int mSyncMode;
    private int mLayoutHeight;
    static final int SYNC_SELECTED_POSITION = 0;
    static final int SYNC_FIRST_POSITION = 1;
    static final int SYNC_MAX_DURATION_MILLIS = 100;
    boolean mInLayout = false;
    OnItemSelectedListener mOnItemSelectedListener;
    OnItemClickListener mOnItemClickListener;
    OnItemLongClickListener mOnItemLongClickListener;
    boolean mDataChanged;
    @ViewDebug.ExportedProperty(category="list")
    int mNextSelectedPosition = -1;
    long mNextSelectedRowId = Long.MIN_VALUE;
    @ViewDebug.ExportedProperty(category="list")
    int mSelectedPosition = -1;
    long mSelectedRowId = Long.MIN_VALUE;
    private View mEmptyView;
    @ViewDebug.ExportedProperty(category="list")
    int mItemCount;
    int mOldItemCount;
    public static final int INVALID_POSITION = -1;
    public static final long INVALID_ROW_ID = Long.MIN_VALUE;
    int mOldSelectedPosition = -1;
    long mOldSelectedRowId = Long.MIN_VALUE;
    private boolean mDesiredFocusableState;
    private boolean mDesiredFocusableInTouchModeState;
    private SelectionNotifier mSelectionNotifier;
    private SelectionNotifier mPendingSelectionNotifier;
    boolean mBlockLayoutRequests = false;

    public AdapterView(Context context) {
        this(context, null);
    }

    public AdapterView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public AdapterView(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public AdapterView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        if (this.getImportantForAccessibility() == 0) {
            this.setImportantForAccessibility(1);
        }
    }

    public void setOnItemClickListener(OnItemClickListener listener) {
        this.mOnItemClickListener = listener;
    }

    public final OnItemClickListener getOnItemClickListener() {
        return this.mOnItemClickListener;
    }

    public boolean performItemClick(View view, int position, long id2) {
        boolean result;
        if (this.mOnItemClickListener != null) {
            this.playSoundEffect(0);
            this.mOnItemClickListener.onItemClick(this, view, position, id2);
            result = true;
        } else {
            result = false;
        }
        if (view != null) {
            view.sendAccessibilityEvent(1);
        }
        return result;
    }

    public void setOnItemLongClickListener(OnItemLongClickListener listener) {
        if (!this.isLongClickable()) {
            this.setLongClickable(true);
        }
        this.mOnItemLongClickListener = listener;
    }

    public final OnItemLongClickListener getOnItemLongClickListener() {
        return this.mOnItemLongClickListener;
    }

    public void setOnItemSelectedListener(OnItemSelectedListener listener) {
        this.mOnItemSelectedListener = listener;
    }

    public final OnItemSelectedListener getOnItemSelectedListener() {
        return this.mOnItemSelectedListener;
    }

    public abstract T getAdapter();

    public abstract void setAdapter(T var1);

    @Override
    public void addView(View child) {
        throw new UnsupportedOperationException("addView(View) is not supported in AdapterView");
    }

    @Override
    public void addView(View child, int index) {
        throw new UnsupportedOperationException("addView(View, int) is not supported in AdapterView");
    }

    @Override
    public void addView(View child, ViewGroup.LayoutParams params) {
        throw new UnsupportedOperationException("addView(View, LayoutParams) is not supported in AdapterView");
    }

    @Override
    public void addView(View child, int index, ViewGroup.LayoutParams params) {
        throw new UnsupportedOperationException("addView(View, int, LayoutParams) is not supported in AdapterView");
    }

    @Override
    public void removeView(View child) {
        throw new UnsupportedOperationException("removeView(View) is not supported in AdapterView");
    }

    @Override
    public void removeViewAt(int index) {
        throw new UnsupportedOperationException("removeViewAt(int) is not supported in AdapterView");
    }

    @Override
    public void removeAllViews() {
        throw new UnsupportedOperationException("removeAllViews() is not supported in AdapterView");
    }

    @Override
    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        this.mLayoutHeight = this.getHeight();
    }

    @ViewDebug.CapturedViewProperty
    public int getSelectedItemPosition() {
        return this.mNextSelectedPosition;
    }

    @ViewDebug.CapturedViewProperty
    public long getSelectedItemId() {
        return this.mNextSelectedRowId;
    }

    public abstract View getSelectedView();

    public Object getSelectedItem() {
        T adapter = this.getAdapter();
        int selection = this.getSelectedItemPosition();
        if (adapter != null && adapter.getCount() > 0 && selection >= 0) {
            return adapter.getItem(selection);
        }
        return null;
    }

    @ViewDebug.CapturedViewProperty
    public int getCount() {
        return this.mItemCount;
    }

    public int getPositionForView(View view) {
        View listItem = view;
        try {
            View v;
            while ((v = (View)((Object)listItem.getParent())) != null && !v.equals(this)) {
                listItem = v;
            }
        }
        catch (ClassCastException e) {
            return -1;
        }
        if (listItem != null) {
            int childCount = this.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                if (!this.getChildAt(i).equals(listItem)) continue;
                return this.mFirstPosition + i;
            }
        }
        return -1;
    }

    public int getFirstVisiblePosition() {
        return this.mFirstPosition;
    }

    public int getLastVisiblePosition() {
        return this.mFirstPosition + this.getChildCount() - 1;
    }

    public abstract void setSelection(int var1);

    @RemotableViewMethod
    public void setEmptyView(View emptyView) {
        T adapter;
        this.mEmptyView = emptyView;
        if (emptyView != null && emptyView.getImportantForAccessibility() == 0) {
            emptyView.setImportantForAccessibility(1);
        }
        boolean empty = (adapter = this.getAdapter()) == null || adapter.isEmpty();
        this.updateEmptyStatus(empty);
    }

    public View getEmptyView() {
        return this.mEmptyView;
    }

    boolean isInFilterMode() {
        return false;
    }

    @Override
    public void setFocusable(boolean focusable) {
        T adapter = this.getAdapter();
        boolean empty = adapter == null || adapter.getCount() == 0;
        this.mDesiredFocusableState = focusable;
        if (!focusable) {
            this.mDesiredFocusableInTouchModeState = false;
        }
        super.setFocusable(focusable && (!empty || this.isInFilterMode()));
    }

    @Override
    public void setFocusableInTouchMode(boolean focusable) {
        T adapter = this.getAdapter();
        boolean empty = adapter == null || adapter.getCount() == 0;
        this.mDesiredFocusableInTouchModeState = focusable;
        if (focusable) {
            this.mDesiredFocusableState = true;
        }
        super.setFocusableInTouchMode(focusable && (!empty || this.isInFilterMode()));
    }

    void checkFocus() {
        T adapter = this.getAdapter();
        boolean empty = adapter == null || adapter.getCount() == 0;
        boolean focusable = !empty || this.isInFilterMode();
        super.setFocusableInTouchMode(focusable && this.mDesiredFocusableInTouchModeState);
        super.setFocusable(focusable && this.mDesiredFocusableState);
        if (this.mEmptyView != null) {
            this.updateEmptyStatus(adapter == null || adapter.isEmpty());
        }
    }

    private void updateEmptyStatus(boolean empty) {
        if (this.isInFilterMode()) {
            empty = false;
        }
        if (empty) {
            if (this.mEmptyView != null) {
                this.mEmptyView.setVisibility(0);
                this.setVisibility(8);
            } else {
                this.setVisibility(0);
            }
            if (this.mDataChanged) {
                this.onLayout(false, this.mLeft, this.mTop, this.mRight, this.mBottom);
            }
        } else {
            if (this.mEmptyView != null) {
                this.mEmptyView.setVisibility(8);
            }
            this.setVisibility(0);
        }
    }

    public Object getItemAtPosition(int position) {
        T adapter = this.getAdapter();
        return adapter == null || position < 0 ? null : adapter.getItem(position);
    }

    public long getItemIdAtPosition(int position) {
        T adapter = this.getAdapter();
        return adapter == null || position < 0 ? Long.MIN_VALUE : adapter.getItemId(position);
    }

    @Override
    public void setOnClickListener(View.OnClickListener l) {
        throw new RuntimeException("Don't call setOnClickListener for an AdapterView. You probably want setOnItemClickListener instead");
    }

    @Override
    protected void dispatchSaveInstanceState(SparseArray<Parcelable> container) {
        this.dispatchFreezeSelfOnly(container);
    }

    @Override
    protected void dispatchRestoreInstanceState(SparseArray<Parcelable> container) {
        this.dispatchThawSelfOnly(container);
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.removeCallbacks(this.mSelectionNotifier);
    }

    void selectionChanged() {
        AutoFillManager afm;
        this.mPendingSelectionNotifier = null;
        if (this.mOnItemSelectedListener != null || AccessibilityManager.getInstance(this.mContext).isEnabled()) {
            if (this.mInLayout || this.mBlockLayoutRequests) {
                if (this.mSelectionNotifier == null) {
                    this.mSelectionNotifier = new SelectionNotifier();
                } else {
                    this.removeCallbacks(this.mSelectionNotifier);
                }
                this.post(this.mSelectionNotifier);
            } else {
                this.dispatchOnItemSelected();
            }
        }
        if ((afm = this.mContext.getSystemService(AutoFillManager.class)) != null) {
            afm.valueChanged(this);
        }
    }

    private void dispatchOnItemSelected() {
        this.fireOnSelected();
        this.performAccessibilityActionsOnSelected();
    }

    private void fireOnSelected() {
        if (this.mOnItemSelectedListener == null) {
            return;
        }
        int selection = this.getSelectedItemPosition();
        if (selection >= 0) {
            View v = this.getSelectedView();
            this.mOnItemSelectedListener.onItemSelected(this, v, selection, this.getAdapter().getItemId(selection));
        } else {
            this.mOnItemSelectedListener.onNothingSelected(this);
        }
    }

    private void performAccessibilityActionsOnSelected() {
        if (!AccessibilityManager.getInstance(this.mContext).isEnabled()) {
            return;
        }
        int position = this.getSelectedItemPosition();
        if (position >= 0) {
            this.sendAccessibilityEvent(4);
        }
    }

    @Override
    public boolean dispatchPopulateAccessibilityEventInternal(AccessibilityEvent event) {
        View selectedView = this.getSelectedView();
        return selectedView != null && selectedView.getVisibility() == 0 && selectedView.dispatchPopulateAccessibilityEvent(event);
    }

    @Override
    public boolean onRequestSendAccessibilityEventInternal(View child, AccessibilityEvent event) {
        if (super.onRequestSendAccessibilityEventInternal(child, event)) {
            AccessibilityEvent record = AccessibilityEvent.obtain();
            this.onInitializeAccessibilityEvent(record);
            child.dispatchPopulateAccessibilityEvent(record);
            event.appendRecord(record);
            return true;
        }
        return false;
    }

    @Override
    public CharSequence getAccessibilityClassName() {
        return AdapterView.class.getName();
    }

    @Override
    public void onInitializeAccessibilityNodeInfoInternal(AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfoInternal(info);
        info.setScrollable(this.isScrollableForAccessibility());
        View selectedView = this.getSelectedView();
        if (selectedView != null) {
            info.setEnabled(selectedView.isEnabled());
        }
    }

    @Override
    public void onInitializeAccessibilityEventInternal(AccessibilityEvent event) {
        super.onInitializeAccessibilityEventInternal(event);
        event.setScrollable(this.isScrollableForAccessibility());
        View selectedView = this.getSelectedView();
        if (selectedView != null) {
            event.setEnabled(selectedView.isEnabled());
        }
        event.setCurrentItemIndex(this.getSelectedItemPosition());
        event.setFromIndex(this.getFirstVisiblePosition());
        event.setToIndex(this.getLastVisiblePosition());
        event.setItemCount(this.getCount());
    }

    private boolean isScrollableForAccessibility() {
        T adapter = this.getAdapter();
        if (adapter != null) {
            int itemCount = adapter.getCount();
            return itemCount > 0 && (this.getFirstVisiblePosition() > 0 || this.getLastVisiblePosition() < itemCount - 1);
        }
        return false;
    }

    @Override
    protected boolean canAnimate() {
        return super.canAnimate() && this.mItemCount > 0;
    }

    void handleDataChanged() {
        int count = this.mItemCount;
        boolean found = false;
        if (count > 0) {
            int selectablePos;
            int newPos;
            if (this.mNeedSync) {
                this.mNeedSync = false;
                newPos = this.findSyncPosition();
                if (newPos >= 0 && (selectablePos = this.lookForSelectablePosition(newPos, true)) == newPos) {
                    this.setNextSelectedPositionInt(newPos);
                    found = true;
                }
            }
            if (!found) {
                newPos = this.getSelectedItemPosition();
                if (newPos >= count) {
                    newPos = count - 1;
                }
                if (newPos < 0) {
                    newPos = 0;
                }
                if ((selectablePos = this.lookForSelectablePosition(newPos, true)) < 0) {
                    selectablePos = this.lookForSelectablePosition(newPos, false);
                }
                if (selectablePos >= 0) {
                    this.setNextSelectedPositionInt(selectablePos);
                    this.checkSelectionChanged();
                    found = true;
                }
            }
        }
        if (!found) {
            this.mSelectedPosition = -1;
            this.mSelectedRowId = Long.MIN_VALUE;
            this.mNextSelectedPosition = -1;
            this.mNextSelectedRowId = Long.MIN_VALUE;
            this.mNeedSync = false;
            this.checkSelectionChanged();
        }
        this.notifySubtreeAccessibilityStateChangedIfNeeded();
    }

    void checkSelectionChanged() {
        if (this.mSelectedPosition != this.mOldSelectedPosition || this.mSelectedRowId != this.mOldSelectedRowId) {
            this.selectionChanged();
            this.mOldSelectedPosition = this.mSelectedPosition;
            this.mOldSelectedRowId = this.mSelectedRowId;
        }
        if (this.mPendingSelectionNotifier != null) {
            this.mPendingSelectionNotifier.run();
        }
    }

    int findSyncPosition() {
        int count = this.mItemCount;
        if (count == 0) {
            return -1;
        }
        long idToMatch = this.mSyncRowId;
        int seed = this.mSyncPosition;
        if (idToMatch == Long.MIN_VALUE) {
            return -1;
        }
        seed = Math.max(0, seed);
        seed = Math.min(count - 1, seed);
        long endTime = SystemClock.uptimeMillis() + 100L;
        int first = seed;
        int last = seed;
        boolean next = false;
        T adapter = this.getAdapter();
        if (adapter == null) {
            return -1;
        }
        while (SystemClock.uptimeMillis() <= endTime) {
            boolean hitFirst;
            long rowId = adapter.getItemId(seed);
            if (rowId == idToMatch) {
                return seed;
            }
            boolean hitLast = last == count - 1;
            boolean bl = hitFirst = first == 0;
            if (hitLast && hitFirst) break;
            if (hitFirst || next && !hitLast) {
                seed = ++last;
                next = false;
                continue;
            }
            if (!hitLast && (next || hitFirst)) continue;
            seed = --first;
            next = true;
        }
        return -1;
    }

    int lookForSelectablePosition(int position, boolean lookDown) {
        return position;
    }

    void setSelectedPositionInt(int position) {
        this.mSelectedPosition = position;
        this.mSelectedRowId = this.getItemIdAtPosition(position);
    }

    void setNextSelectedPositionInt(int position) {
        this.mNextSelectedPosition = position;
        this.mNextSelectedRowId = this.getItemIdAtPosition(position);
        if (this.mNeedSync && this.mSyncMode == 0 && position >= 0) {
            this.mSyncPosition = position;
            this.mSyncRowId = this.mNextSelectedRowId;
        }
    }

    void rememberSyncState() {
        if (this.getChildCount() > 0) {
            this.mNeedSync = true;
            this.mSyncHeight = this.mLayoutHeight;
            if (this.mSelectedPosition >= 0) {
                View v = this.getChildAt(this.mSelectedPosition - this.mFirstPosition);
                this.mSyncRowId = this.mNextSelectedRowId;
                this.mSyncPosition = this.mNextSelectedPosition;
                if (v != null) {
                    this.mSpecificTop = v.getTop();
                }
                this.mSyncMode = 0;
            } else {
                View v = this.getChildAt(0);
                T adapter = this.getAdapter();
                this.mSyncRowId = this.mFirstPosition >= 0 && this.mFirstPosition < adapter.getCount() ? adapter.getItemId(this.mFirstPosition) : -1L;
                this.mSyncPosition = this.mFirstPosition;
                if (v != null) {
                    this.mSpecificTop = v.getTop();
                }
                this.mSyncMode = 1;
            }
        }
    }

    @Override
    protected void encodeProperties(ViewHierarchyEncoder encoder) {
        super.encodeProperties(encoder);
        encoder.addProperty("scrolling:firstPosition", this.mFirstPosition);
        encoder.addProperty("list:nextSelectedPosition", this.mNextSelectedPosition);
        encoder.addProperty("list:nextSelectedRowId", this.mNextSelectedRowId);
        encoder.addProperty("list:selectedPosition", this.mSelectedPosition);
        encoder.addProperty("list:itemCount", this.mItemCount);
    }

    private class SelectionNotifier
    implements Runnable {
        private SelectionNotifier() {
        }

        @Override
        public void run() {
            AdapterView.this.mPendingSelectionNotifier = null;
            if (AdapterView.this.mDataChanged && AdapterView.this.getViewRootImpl() != null && AdapterView.this.getViewRootImpl().isLayoutRequested()) {
                if (AdapterView.this.getAdapter() != null) {
                    AdapterView.this.mPendingSelectionNotifier = this;
                }
            } else {
                AdapterView.this.dispatchOnItemSelected();
            }
        }
    }

    class AdapterDataSetObserver
    extends DataSetObserver {
        private Parcelable mInstanceState = null;

        AdapterDataSetObserver() {
        }

        @Override
        public void onChanged() {
            AdapterView.this.mDataChanged = true;
            AdapterView.this.mOldItemCount = AdapterView.this.mItemCount;
            AdapterView.this.mItemCount = AdapterView.this.getAdapter().getCount();
            if (AdapterView.this.getAdapter().hasStableIds() && this.mInstanceState != null && AdapterView.this.mOldItemCount == 0 && AdapterView.this.mItemCount > 0) {
                AdapterView.this.onRestoreInstanceState(this.mInstanceState);
                this.mInstanceState = null;
            } else {
                AdapterView.this.rememberSyncState();
            }
            AdapterView.this.checkFocus();
            AdapterView.this.requestLayout();
        }

        @Override
        public void onInvalidated() {
            AdapterView.this.mDataChanged = true;
            if (AdapterView.this.getAdapter().hasStableIds()) {
                this.mInstanceState = AdapterView.this.onSaveInstanceState();
            }
            AdapterView.this.mOldItemCount = AdapterView.this.mItemCount;
            AdapterView.this.mItemCount = 0;
            AdapterView.this.mSelectedPosition = -1;
            AdapterView.this.mSelectedRowId = Long.MIN_VALUE;
            AdapterView.this.mNextSelectedPosition = -1;
            AdapterView.this.mNextSelectedRowId = Long.MIN_VALUE;
            AdapterView.this.mNeedSync = false;
            AdapterView.this.checkFocus();
            AdapterView.this.requestLayout();
        }

        public void clearSavedState() {
            this.mInstanceState = null;
        }
    }

    public static class AdapterContextMenuInfo
    implements ContextMenu.ContextMenuInfo {
        public View targetView;
        public int position;
        public long id;

        public AdapterContextMenuInfo(View targetView, int position, long id2) {
            this.targetView = targetView;
            this.position = position;
            this.id = id2;
        }
    }

    public static interface OnItemSelectedListener {
        public void onItemSelected(AdapterView<?> var1, View var2, int var3, long var4);

        public void onNothingSelected(AdapterView<?> var1);
    }

    public static interface OnItemLongClickListener {
        public boolean onItemLongClick(AdapterView<?> var1, View var2, int var3, long var4);
    }

    public static interface OnItemClickListener {
        public void onItemClick(AdapterView<?> var1, View var2, int var3, long var4);
    }
}

