/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.appwidget.AppWidgetHostView;
import android.appwidget.AppWidgetManager;
import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import android.util.Slog;
import android.util.SparseArray;
import android.util.SparseBooleanArray;
import android.util.SparseIntArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.RemoteViews;
import android.widget.TextView;
import com.android.internal.widget.IRemoteViewsAdapterConnection;
import com.android.internal.widget.IRemoteViewsFactory;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.concurrent.Executor;

public class RemoteViewsAdapter
extends BaseAdapter
implements Handler.Callback {
    private static final String MULTI_USER_PERM = "android.permission.INTERACT_ACROSS_USERS_FULL";
    private static final String TAG = "RemoteViewsAdapter";
    private static final int sDefaultCacheSize = 40;
    private static final int sUnbindServiceDelay = 5000;
    private static final int sDefaultLoadingViewHeight = 50;
    private static final int sDefaultMessageType = 0;
    private static final int sUnbindServiceMessageType = 1;
    private final Context mContext;
    private final Intent mIntent;
    private final int mAppWidgetId;
    private final Executor mAsyncViewLoadExecutor;
    private RemoteViewsAdapterServiceConnection mServiceConnection;
    private WeakReference<RemoteAdapterConnectionCallback> mCallback;
    private RemoteViews.OnClickHandler mRemoteViewsOnClickHandler;
    private final FixedSizeRemoteViewsCache mCache;
    private int mVisibleWindowLowerBound;
    private int mVisibleWindowUpperBound;
    private boolean mNotifyDataSetChangedAfterOnServiceConnected = false;
    private RemoteViewsFrameLayoutRefSet mRequestedViews;
    private HandlerThread mWorkerThread;
    private Handler mWorkerQueue;
    private Handler mMainQueue;
    private static final HashMap<RemoteViewsCacheKey, FixedSizeRemoteViewsCache> sCachedRemoteViewsCaches = new HashMap();
    private static final HashMap<RemoteViewsCacheKey, Runnable> sRemoteViewsCacheRemoveRunnables = new HashMap();
    private static HandlerThread sCacheRemovalThread;
    private static Handler sCacheRemovalQueue;
    private static final int REMOTE_VIEWS_CACHE_DURATION = 5000;
    private boolean mDataReady = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteViewsAdapter(Context context, Intent intent, RemoteAdapterConnectionCallback callback, boolean useAsyncLoader) {
        this.mContext = context;
        this.mIntent = intent;
        if (this.mIntent == null) {
            throw new IllegalArgumentException("Non-null Intent must be specified.");
        }
        this.mAppWidgetId = intent.getIntExtra("remoteAdapterAppWidgetId", -1);
        this.mRequestedViews = new RemoteViewsFrameLayoutRefSet();
        if (intent.hasExtra("remoteAdapterAppWidgetId")) {
            intent.removeExtra("remoteAdapterAppWidgetId");
        }
        this.mWorkerThread = new HandlerThread("RemoteViewsCache-loader");
        this.mWorkerThread.start();
        this.mWorkerQueue = new Handler(this.mWorkerThread.getLooper());
        this.mMainQueue = new Handler(Looper.myLooper(), this);
        Executor executor = this.mAsyncViewLoadExecutor = useAsyncLoader ? new HandlerThreadExecutor(this.mWorkerThread) : null;
        if (sCacheRemovalThread == null) {
            sCacheRemovalThread = new HandlerThread("RemoteViewsAdapter-cachePruner");
            sCacheRemovalThread.start();
            sCacheRemovalQueue = new Handler(sCacheRemovalThread.getLooper());
        }
        this.mCallback = new WeakReference<RemoteAdapterConnectionCallback>(callback);
        this.mServiceConnection = new RemoteViewsAdapterServiceConnection(this);
        RemoteViewsCacheKey key = new RemoteViewsCacheKey(new Intent.FilterComparison(this.mIntent), this.mAppWidgetId);
        HashMap<RemoteViewsCacheKey, FixedSizeRemoteViewsCache> hashMap = sCachedRemoteViewsCaches;
        synchronized (hashMap) {
            if (sCachedRemoteViewsCaches.containsKey(key)) {
                this.mCache = sCachedRemoteViewsCaches.get(key);
                RemoteViewsMetaData remoteViewsMetaData = this.mCache.mMetaData;
                synchronized (remoteViewsMetaData) {
                    if (((FixedSizeRemoteViewsCache)this.mCache).mMetaData.count > 0) {
                        this.mDataReady = true;
                    }
                }
            } else {
                this.mCache = new FixedSizeRemoteViewsCache(40);
            }
            if (!this.mDataReady) {
                this.requestBindService();
            }
        }
    }

    protected void finalize() throws Throwable {
        try {
            if (this.mWorkerThread != null) {
                this.mWorkerThread.quit();
            }
        }
        finally {
            super.finalize();
        }
    }

    public boolean isDataReady() {
        return this.mDataReady;
    }

    public void setRemoteViewsOnClickHandler(RemoteViews.OnClickHandler handler) {
        this.mRemoteViewsOnClickHandler = handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveRemoteViewsCache() {
        final RemoteViewsCacheKey key = new RemoteViewsCacheKey(new Intent.FilterComparison(this.mIntent), this.mAppWidgetId);
        HashMap<RemoteViewsCacheKey, FixedSizeRemoteViewsCache> hashMap = sCachedRemoteViewsCaches;
        synchronized (hashMap) {
            if (sRemoteViewsCacheRemoveRunnables.containsKey(key)) {
                sCacheRemovalQueue.removeCallbacks(sRemoteViewsCacheRemoveRunnables.get(key));
                sRemoteViewsCacheRemoveRunnables.remove(key);
            }
            int metaDataCount = 0;
            int numRemoteViewsCached = 0;
            Object object = this.mCache.mMetaData;
            synchronized (object) {
                metaDataCount = ((FixedSizeRemoteViewsCache)this.mCache).mMetaData.count;
            }
            object = this.mCache;
            synchronized (object) {
                numRemoteViewsCached = this.mCache.mIndexRemoteViews.size();
            }
            if (metaDataCount > 0 && numRemoteViewsCached > 0) {
                sCachedRemoteViewsCaches.put(key, this.mCache);
            }
            Runnable r = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    HashMap hashMap = sCachedRemoteViewsCaches;
                    synchronized (hashMap) {
                        if (sCachedRemoteViewsCaches.containsKey(key)) {
                            sCachedRemoteViewsCaches.remove(key);
                        }
                        if (sRemoteViewsCacheRemoveRunnables.containsKey(key)) {
                            sRemoteViewsCacheRemoveRunnables.remove(key);
                        }
                    }
                }
            };
            sRemoteViewsCacheRemoveRunnables.put(key, r);
            sCacheRemovalQueue.postDelayed(r, 5000L);
        }
    }

    private void loadNextIndexInBackground() {
        this.mWorkerQueue.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (RemoteViewsAdapter.this.mServiceConnection.isConnected()) {
                    int position = -1;
                    FixedSizeRemoteViewsCache fixedSizeRemoteViewsCache = RemoteViewsAdapter.this.mCache;
                    synchronized (fixedSizeRemoteViewsCache) {
                        position = RemoteViewsAdapter.this.mCache.getNextIndexToLoad();
                    }
                    if (position > -1) {
                        RemoteViewsAdapter.this.updateRemoteViews(position, true);
                        RemoteViewsAdapter.this.loadNextIndexInBackground();
                    } else {
                        RemoteViewsAdapter.this.enqueueDeferredUnbindServiceMessage();
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processException(String method, Exception e) {
        Log.e(TAG, "Error in " + method + ": " + e.getMessage());
        RemoteViewsMetaData metaData = this.mCache.getMetaData();
        Object object = metaData;
        synchronized (object) {
            metaData.reset();
        }
        object = this.mCache;
        synchronized (object) {
            this.mCache.reset();
        }
        this.mMainQueue.post(new Runnable(){

            @Override
            public void run() {
                RemoteViewsAdapter.this.superNotifyDataSetChanged();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTemporaryMetaData() {
        IRemoteViewsFactory factory = this.mServiceConnection.getRemoteViewsFactory();
        try {
            RemoteViewsMetaData tmpMetaData;
            RemoteViews firstView;
            boolean hasStableIds = factory.hasStableIds();
            int viewTypeCount = factory.getViewTypeCount();
            int count = factory.getCount();
            LoadingViewTemplate loadingTemplate = new LoadingViewTemplate(factory.getLoadingView(), this.mContext);
            if (count > 0 && loadingTemplate.remoteViews == null && (firstView = factory.getViewAt(0)) != null) {
                loadingTemplate.loadFirstViewHeight(firstView, this.mContext, new HandlerThreadExecutor(this.mWorkerThread));
            }
            RemoteViewsMetaData remoteViewsMetaData = tmpMetaData = this.mCache.getTemporaryMetaData();
            synchronized (remoteViewsMetaData) {
                tmpMetaData.hasStableIds = hasStableIds;
                tmpMetaData.viewTypeCount = viewTypeCount + 1;
                tmpMetaData.count = count;
                tmpMetaData.loadingTemplate = loadingTemplate;
            }
        }
        catch (RemoteException e) {
            this.processException("updateMetaData", e);
        }
        catch (RuntimeException e) {
            this.processException("updateMetaData", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRemoteViews(final int position, boolean notifyWhenLoaded) {
        int cacheCount;
        boolean viewTypeInRange;
        IRemoteViewsFactory factory = this.mServiceConnection.getRemoteViewsFactory();
        RemoteViews remoteViews = null;
        long itemId = 0L;
        try {
            remoteViews = factory.getViewAt(position);
            itemId = factory.getItemId(position);
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error in updateRemoteViews(" + position + "): " + e.getMessage());
            return;
        }
        catch (RuntimeException e) {
            Log.e(TAG, "Error in updateRemoteViews(" + position + "): " + e.getMessage());
            return;
        }
        if (remoteViews == null) {
            Log.e(TAG, "Error in updateRemoteViews(" + position + "): " + " null RemoteViews " + "returned from RemoteViewsFactory.");
            return;
        }
        int layoutId = remoteViews.getLayoutId();
        RemoteViewsMetaData metaData = this.mCache.getMetaData();
        Object object = metaData;
        synchronized (object) {
            viewTypeInRange = metaData.isViewTypeInRange(layoutId);
            cacheCount = ((FixedSizeRemoteViewsCache)this.mCache).mMetaData.count;
        }
        object = this.mCache;
        synchronized (object) {
            if (viewTypeInRange) {
                int[] visibleWindow = this.getVisibleWindow(this.mVisibleWindowLowerBound, this.mVisibleWindowUpperBound, cacheCount);
                this.mCache.insert(position, remoteViews, itemId, visibleWindow);
                final RemoteViews rv = remoteViews;
                if (notifyWhenLoaded) {
                    this.mMainQueue.post(new Runnable(){

                        @Override
                        public void run() {
                            RemoteViewsAdapter.this.mRequestedViews.notifyOnRemoteViewsLoaded(position, rv);
                        }
                    });
                }
            } else {
                Log.e(TAG, "Error: widget's RemoteViewsFactory returns more view types than  indicated by getViewTypeCount() ");
            }
        }
    }

    public Intent getRemoteViewsServiceIntent() {
        return this.mIntent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getCount() {
        RemoteViewsMetaData metaData;
        RemoteViewsMetaData remoteViewsMetaData = metaData = this.mCache.getMetaData();
        synchronized (remoteViewsMetaData) {
            return metaData.count;
        }
    }

    @Override
    public Object getItem(int position) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getItemId(int position) {
        FixedSizeRemoteViewsCache fixedSizeRemoteViewsCache = this.mCache;
        synchronized (fixedSizeRemoteViewsCache) {
            if (this.mCache.containsMetaDataAt(position)) {
                return this.mCache.getMetaDataAt((int)position).itemId;
            }
            return 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getItemViewType(int position) {
        RemoteViewsMetaData metaData;
        int typeId = 0;
        FixedSizeRemoteViewsCache fixedSizeRemoteViewsCache = this.mCache;
        synchronized (fixedSizeRemoteViewsCache) {
            if (!this.mCache.containsMetaDataAt(position)) {
                return 0;
            }
            typeId = this.mCache.getMetaDataAt((int)position).typeId;
        }
        RemoteViewsMetaData remoteViewsMetaData = metaData = this.mCache.getMetaData();
        synchronized (remoteViewsMetaData) {
            return metaData.getMappedViewType(typeId);
        }
    }

    public void setVisibleRangeHint(int lowerBound, int upperBound) {
        this.mVisibleWindowLowerBound = lowerBound;
        this.mVisibleWindowUpperBound = upperBound;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public View getView(int position, View convertView, ViewGroup parent) {
        FixedSizeRemoteViewsCache fixedSizeRemoteViewsCache = this.mCache;
        synchronized (fixedSizeRemoteViewsCache) {
            RemoteViewsFrameLayout layout2;
            RemoteViews rv = this.mCache.getRemoteViewsAt(position);
            boolean isInCache = rv != null;
            boolean isConnected = this.mServiceConnection.isConnected();
            boolean hasNewItems = false;
            if (convertView != null && convertView instanceof RemoteViewsFrameLayout) {
                this.mRequestedViews.removeView((RemoteViewsFrameLayout)convertView);
            }
            if (!isInCache && !isConnected) {
                this.requestBindService();
            } else {
                hasNewItems = this.mCache.queuePositionsToBePreloadedFromRequestedPosition(position);
            }
            if (convertView instanceof RemoteViewsFrameLayout) {
                layout2 = (RemoteViewsFrameLayout)convertView;
            } else {
                layout2 = new RemoteViewsFrameLayout(parent.getContext(), this.mCache);
                layout2.setAsyncExecutor(this.mAsyncViewLoadExecutor);
            }
            if (isInCache) {
                layout2.onRemoteViewsLoaded(rv, this.mRemoteViewsOnClickHandler, false);
                if (hasNewItems) {
                    this.loadNextIndexInBackground();
                }
            } else {
                layout2.onRemoteViewsLoaded(this.mCache.getMetaData().getLoadingTemplate((Context)this.mContext).remoteViews, this.mRemoteViewsOnClickHandler, false);
                this.mRequestedViews.add(position, layout2);
                this.mCache.queueRequestedPositionToLoad(position);
                this.loadNextIndexInBackground();
            }
            return layout2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getViewTypeCount() {
        RemoteViewsMetaData metaData;
        RemoteViewsMetaData remoteViewsMetaData = metaData = this.mCache.getMetaData();
        synchronized (remoteViewsMetaData) {
            return metaData.viewTypeCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasStableIds() {
        RemoteViewsMetaData metaData;
        RemoteViewsMetaData remoteViewsMetaData = metaData = this.mCache.getMetaData();
        synchronized (remoteViewsMetaData) {
            return metaData.hasStableIds;
        }
    }

    @Override
    public boolean isEmpty() {
        return this.getCount() <= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onNotifyDataSetChanged() {
        int[] visibleWindow;
        int newCount;
        IRemoteViewsFactory factory = this.mServiceConnection.getRemoteViewsFactory();
        try {
            factory.onDataSetChanged();
        }
        catch (RemoteException e) {
            Log.e(TAG, "Error in updateNotifyDataSetChanged(): " + e.getMessage());
            return;
        }
        catch (RuntimeException e) {
            Log.e(TAG, "Error in updateNotifyDataSetChanged(): " + e.getMessage());
            return;
        }
        FixedSizeRemoteViewsCache e = this.mCache;
        synchronized (e) {
            this.mCache.reset();
        }
        this.updateTemporaryMetaData();
        RemoteViewsMetaData remoteViewsMetaData = this.mCache.getTemporaryMetaData();
        synchronized (remoteViewsMetaData) {
            newCount = this.mCache.getTemporaryMetaData().count;
            visibleWindow = this.getVisibleWindow(this.mVisibleWindowLowerBound, this.mVisibleWindowUpperBound, newCount);
        }
        for (Object i : (RemoteViewsMetaData)visibleWindow) {
            if (i >= newCount) continue;
            this.updateRemoteViews((int)i, false);
        }
        this.mMainQueue.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                FixedSizeRemoteViewsCache fixedSizeRemoteViewsCache = RemoteViewsAdapter.this.mCache;
                synchronized (fixedSizeRemoteViewsCache) {
                    RemoteViewsAdapter.this.mCache.commitTemporaryMetaData();
                }
                RemoteViewsAdapter.this.superNotifyDataSetChanged();
                RemoteViewsAdapter.this.enqueueDeferredUnbindServiceMessage();
            }
        });
        this.mNotifyDataSetChangedAfterOnServiceConnected = false;
    }

    private int[] getVisibleWindow(int lower, int upper, int count) {
        int[] window;
        if (lower == 0 && upper == 0 || lower < 0 || upper < 0) {
            return new int[0];
        }
        if (lower <= upper) {
            window = new int[upper + 1 - lower];
            int i = lower;
            int j = 0;
            while (i <= upper) {
                window[j] = i++;
                ++j;
            }
        } else {
            count = Math.max(count, lower);
            window = new int[count - lower + upper + 1];
            int j = 0;
            int i = 0;
            while (i <= upper) {
                window[j] = i++;
                ++j;
            }
            i = lower;
            while (i < count) {
                window[j] = i++;
                ++j;
            }
        }
        return window;
    }

    @Override
    public void notifyDataSetChanged() {
        this.mMainQueue.removeMessages(1);
        if (!this.mServiceConnection.isConnected()) {
            this.mNotifyDataSetChangedAfterOnServiceConnected = true;
            this.requestBindService();
            return;
        }
        this.mWorkerQueue.post(new Runnable(){

            @Override
            public void run() {
                RemoteViewsAdapter.this.onNotifyDataSetChanged();
            }
        });
    }

    void superNotifyDataSetChanged() {
        super.notifyDataSetChanged();
    }

    @Override
    public boolean handleMessage(Message msg) {
        boolean result = false;
        switch (msg.what) {
            case 1: {
                if (this.mServiceConnection.isConnected()) {
                    this.mServiceConnection.unbind(this.mContext, this.mAppWidgetId, this.mIntent);
                }
                result = true;
                break;
            }
        }
        return result;
    }

    private void enqueueDeferredUnbindServiceMessage() {
        this.mMainQueue.removeMessages(1);
        this.mMainQueue.sendEmptyMessageDelayed(1, 5000L);
    }

    private boolean requestBindService() {
        if (!this.mServiceConnection.isConnected()) {
            this.mServiceConnection.bind(this.mContext, this.mAppWidgetId, this.mIntent);
        }
        this.mMainQueue.removeMessages(1);
        return this.mServiceConnection.isConnected();
    }

    private static class LoadingViewTemplate {
        public final RemoteViews remoteViews;
        public int defaultHeight;

        LoadingViewTemplate(RemoteViews views, Context context) {
            this.remoteViews = views;
            float density = context.getResources().getDisplayMetrics().density;
            this.defaultHeight = Math.round(50.0f * density);
        }

        public void loadFirstViewHeight(RemoteViews firstView, Context context, Executor executor) {
            firstView.applyAsync(context, new RemoteViewsFrameLayout(context, null), executor, new RemoteViews.OnViewAppliedListener(){

                @Override
                public void onViewApplied(View v) {
                    try {
                        v.measure(View.MeasureSpec.makeMeasureSpec(0, 0), View.MeasureSpec.makeMeasureSpec(0, 0));
                        defaultHeight = v.getMeasuredHeight();
                    }
                    catch (Exception e) {
                        this.onError(e);
                    }
                }

                @Override
                public void onError(Exception e) {
                    Log.w(RemoteViewsAdapter.TAG, "Error inflating first RemoteViews", e);
                }
            });
        }
    }

    private static class HandlerThreadExecutor
    implements Executor {
        private final HandlerThread mThread;

        HandlerThreadExecutor(HandlerThread thread) {
            this.mThread = thread;
        }

        @Override
        public void execute(Runnable runnable) {
            if (Thread.currentThread().getId() == this.mThread.getId()) {
                runnable.run();
            } else {
                new Handler(this.mThread.getLooper()).post(runnable);
            }
        }
    }

    static class RemoteViewsCacheKey {
        final Intent.FilterComparison filter;
        final int widgetId;

        RemoteViewsCacheKey(Intent.FilterComparison filter, int widgetId) {
            this.filter = filter;
            this.widgetId = widgetId;
        }

        public boolean equals(Object o) {
            if (!(o instanceof RemoteViewsCacheKey)) {
                return false;
            }
            RemoteViewsCacheKey other = (RemoteViewsCacheKey)o;
            return other.filter.equals(this.filter) && other.widgetId == this.widgetId;
        }

        public int hashCode() {
            return (this.filter == null ? 0 : this.filter.hashCode()) ^ this.widgetId << 2;
        }
    }

    private static class FixedSizeRemoteViewsCache {
        private static final String TAG = "FixedSizeRemoteViewsCache";
        private final RemoteViewsMetaData mMetaData = new RemoteViewsMetaData();
        private final RemoteViewsMetaData mTemporaryMetaData = new RemoteViewsMetaData();
        private final SparseArray<RemoteViewsIndexMetaData> mIndexMetaData = new SparseArray();
        private final SparseArray<RemoteViews> mIndexRemoteViews = new SparseArray();
        private final SparseBooleanArray mIndicesToLoad = new SparseBooleanArray();
        private int mLastRequestedIndex;
        private int mPreloadLowerBound;
        private int mPreloadUpperBound;
        private final int mMaxCount;
        private final int mMaxCountSlack;
        private static final float sMaxCountSlackPercent = 0.75f;
        private static final int sMaxMemoryLimitInBytes = 0x200000;

        public FixedSizeRemoteViewsCache(int maxCacheSize) {
            this.mMaxCount = maxCacheSize;
            this.mMaxCountSlack = Math.round(0.75f * (float)(this.mMaxCount / 2));
            this.mPreloadLowerBound = 0;
            this.mPreloadUpperBound = -1;
            this.mLastRequestedIndex = -1;
        }

        public void insert(int position, RemoteViews v, long itemId, int[] visibleWindow) {
            int trimIndex;
            int pruneFromPosition;
            if (this.mIndexRemoteViews.size() >= this.mMaxCount) {
                this.mIndexRemoteViews.remove(this.getFarthestPositionFrom(position, visibleWindow));
            }
            int n = pruneFromPosition = this.mLastRequestedIndex > -1 ? this.mLastRequestedIndex : position;
            while (this.getRemoteViewsBitmapMemoryUsage() >= 0x200000 && (trimIndex = this.getFarthestPositionFrom(pruneFromPosition, visibleWindow)) >= 0) {
                this.mIndexRemoteViews.remove(trimIndex);
            }
            RemoteViewsIndexMetaData metaData = this.mIndexMetaData.get(position);
            if (metaData != null) {
                metaData.set(v, itemId);
            } else {
                this.mIndexMetaData.put(position, new RemoteViewsIndexMetaData(v, itemId));
            }
            this.mIndexRemoteViews.put(position, v);
        }

        public RemoteViewsMetaData getMetaData() {
            return this.mMetaData;
        }

        public RemoteViewsMetaData getTemporaryMetaData() {
            return this.mTemporaryMetaData;
        }

        public RemoteViews getRemoteViewsAt(int position) {
            return this.mIndexRemoteViews.get(position);
        }

        public RemoteViewsIndexMetaData getMetaDataAt(int position) {
            return this.mIndexMetaData.get(position);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void commitTemporaryMetaData() {
            RemoteViewsMetaData remoteViewsMetaData = this.mTemporaryMetaData;
            synchronized (remoteViewsMetaData) {
                RemoteViewsMetaData remoteViewsMetaData2 = this.mMetaData;
                synchronized (remoteViewsMetaData2) {
                    this.mMetaData.set(this.mTemporaryMetaData);
                }
            }
        }

        private int getRemoteViewsBitmapMemoryUsage() {
            int mem = 0;
            for (int i = this.mIndexRemoteViews.size() - 1; i >= 0; --i) {
                RemoteViews v = this.mIndexRemoteViews.valueAt(i);
                if (v == null) continue;
                mem += v.estimateMemoryUsage();
            }
            return mem;
        }

        private int getFarthestPositionFrom(int pos, int[] visibleWindow) {
            int maxDist = 0;
            int maxDistIndex = -1;
            int maxDistNotVisible = 0;
            int maxDistIndexNotVisible = -1;
            for (int i = this.mIndexRemoteViews.size() - 1; i >= 0; --i) {
                int index = this.mIndexRemoteViews.keyAt(i);
                int dist = Math.abs(index - pos);
                if (dist > maxDistNotVisible && Arrays.binarySearch(visibleWindow, index) < 0) {
                    maxDistIndexNotVisible = index;
                    maxDistNotVisible = dist;
                }
                if (dist < maxDist) continue;
                maxDistIndex = index;
                maxDist = dist;
            }
            if (maxDistIndexNotVisible > -1) {
                return maxDistIndexNotVisible;
            }
            return maxDistIndex;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void queueRequestedPositionToLoad(int position) {
            this.mLastRequestedIndex = position;
            SparseBooleanArray sparseBooleanArray = this.mIndicesToLoad;
            synchronized (sparseBooleanArray) {
                this.mIndicesToLoad.put(position, true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean queuePositionsToBePreloadedFromRequestedPosition(int position) {
            int center;
            if (this.mPreloadLowerBound <= position && position <= this.mPreloadUpperBound && Math.abs(position - (center = (this.mPreloadUpperBound + this.mPreloadLowerBound) / 2)) < this.mMaxCountSlack) {
                return false;
            }
            int count = 0;
            Object object = this.mMetaData;
            synchronized (object) {
                count = this.mMetaData.count;
            }
            object = this.mIndicesToLoad;
            synchronized (object) {
                for (int i = this.mIndicesToLoad.size() - 1; i >= 0; --i) {
                    if (this.mIndicesToLoad.valueAt(i)) continue;
                    this.mIndicesToLoad.removeAt(i);
                }
                int halfMaxCount = this.mMaxCount / 2;
                this.mPreloadLowerBound = position - halfMaxCount;
                this.mPreloadUpperBound = position + halfMaxCount;
                int effectiveLowerBound = Math.max(0, this.mPreloadLowerBound);
                int effectiveUpperBound = Math.min(this.mPreloadUpperBound, count - 1);
                for (int i = effectiveLowerBound; i <= effectiveUpperBound; ++i) {
                    if (this.mIndexRemoteViews.indexOfKey(i) >= 0 || this.mIndicesToLoad.get(i)) continue;
                    this.mIndicesToLoad.put(i, false);
                }
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getNextIndexToLoad() {
            SparseBooleanArray sparseBooleanArray = this.mIndicesToLoad;
            synchronized (sparseBooleanArray) {
                int index = this.mIndicesToLoad.indexOfValue(true);
                if (index < 0) {
                    index = this.mIndicesToLoad.indexOfValue(false);
                }
                if (index < 0) {
                    return -1;
                }
                int key = this.mIndicesToLoad.keyAt(index);
                this.mIndicesToLoad.removeAt(index);
                return key;
            }
        }

        public boolean containsRemoteViewAt(int position) {
            return this.mIndexRemoteViews.indexOfKey(position) >= 0;
        }

        public boolean containsMetaDataAt(int position) {
            return this.mIndexMetaData.indexOfKey(position) >= 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reset() {
            this.mPreloadLowerBound = 0;
            this.mPreloadUpperBound = -1;
            this.mLastRequestedIndex = -1;
            this.mIndexRemoteViews.clear();
            this.mIndexMetaData.clear();
            SparseBooleanArray sparseBooleanArray = this.mIndicesToLoad;
            synchronized (sparseBooleanArray) {
                this.mIndicesToLoad.clear();
            }
        }
    }

    private static class RemoteViewsIndexMetaData {
        int typeId;
        long itemId;

        public RemoteViewsIndexMetaData(RemoteViews v, long itemId) {
            this.set(v, itemId);
        }

        public void set(RemoteViews v, long id2) {
            this.itemId = id2;
            this.typeId = v != null ? v.getLayoutId() : 0;
        }
    }

    private static class RemoteViewsMetaData {
        int count;
        int viewTypeCount;
        boolean hasStableIds;
        LoadingViewTemplate loadingTemplate;
        private final SparseIntArray mTypeIdIndexMap = new SparseIntArray();

        public RemoteViewsMetaData() {
            this.reset();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void set(RemoteViewsMetaData d) {
            RemoteViewsMetaData remoteViewsMetaData = d;
            synchronized (remoteViewsMetaData) {
                this.count = d.count;
                this.viewTypeCount = d.viewTypeCount;
                this.hasStableIds = d.hasStableIds;
                this.loadingTemplate = d.loadingTemplate;
            }
        }

        public void reset() {
            this.count = 0;
            this.viewTypeCount = 1;
            this.hasStableIds = true;
            this.loadingTemplate = null;
            this.mTypeIdIndexMap.clear();
        }

        public int getMappedViewType(int typeId) {
            int mappedTypeId = this.mTypeIdIndexMap.get(typeId, -1);
            if (mappedTypeId == -1) {
                mappedTypeId = this.mTypeIdIndexMap.size() + 1;
                this.mTypeIdIndexMap.put(typeId, mappedTypeId);
            }
            return mappedTypeId;
        }

        public boolean isViewTypeInRange(int typeId) {
            int mappedType = this.getMappedViewType(typeId);
            return mappedType < this.viewTypeCount;
        }

        public synchronized LoadingViewTemplate getLoadingTemplate(Context context) {
            if (this.loadingTemplate == null) {
                this.loadingTemplate = new LoadingViewTemplate(null, context);
            }
            return this.loadingTemplate;
        }
    }

    private class RemoteViewsFrameLayoutRefSet {
        private final SparseArray<LinkedList<RemoteViewsFrameLayout>> mReferences = new SparseArray();
        private final HashMap<RemoteViewsFrameLayout, LinkedList<RemoteViewsFrameLayout>> mViewToLinkedList = new HashMap();

        private RemoteViewsFrameLayoutRefSet() {
        }

        public void add(int position, RemoteViewsFrameLayout layout2) {
            LinkedList<RemoteViewsFrameLayout> refs = this.mReferences.get(position);
            if (refs == null) {
                refs = new LinkedList();
                this.mReferences.put(position, refs);
            }
            this.mViewToLinkedList.put(layout2, refs);
            refs.add(layout2);
        }

        public void notifyOnRemoteViewsLoaded(int position, RemoteViews view) {
            if (view == null) {
                return;
            }
            LinkedList<RemoteViewsFrameLayout> refs = this.mReferences.get(position);
            if (refs != null) {
                for (RemoteViewsFrameLayout ref : refs) {
                    ref.onRemoteViewsLoaded(view, RemoteViewsAdapter.this.mRemoteViewsOnClickHandler, true);
                    if (!this.mViewToLinkedList.containsKey(ref)) continue;
                    this.mViewToLinkedList.remove(ref);
                }
                refs.clear();
                this.mReferences.remove(position);
            }
        }

        public void removeView(RemoteViewsFrameLayout rvfl) {
            if (this.mViewToLinkedList.containsKey(rvfl)) {
                this.mViewToLinkedList.get(rvfl).remove(rvfl);
                this.mViewToLinkedList.remove(rvfl);
            }
        }

        public void clear() {
            this.mReferences.clear();
            this.mViewToLinkedList.clear();
        }
    }

    static class RemoteViewsFrameLayout
    extends AppWidgetHostView {
        private final FixedSizeRemoteViewsCache mCache;

        public RemoteViewsFrameLayout(Context context, FixedSizeRemoteViewsCache cache) {
            super(context);
            this.mCache = cache;
        }

        public void onRemoteViewsLoaded(RemoteViews view, RemoteViews.OnClickHandler handler, boolean forceApplyAsync) {
            this.setOnClickHandler(handler);
            this.applyRemoteViews(view, forceApplyAsync || view != null && view.prefersAsyncApply());
        }

        @Override
        protected View getDefaultView() {
            int viewHeight = this.mCache.getMetaData().getLoadingTemplate((Context)this.getContext()).defaultHeight;
            TextView loadingTextView = (TextView)LayoutInflater.from(this.getContext()).inflate(17367234, (ViewGroup)this, false);
            loadingTextView.setHeight(viewHeight);
            return loadingTextView;
        }

        @Override
        protected Context getRemoteContext() {
            return null;
        }

        @Override
        protected View getErrorView() {
            return this.getDefaultView();
        }
    }

    private static class RemoteViewsAdapterServiceConnection
    extends IRemoteViewsAdapterConnection.Stub {
        private boolean mIsConnected;
        private boolean mIsConnecting;
        private WeakReference<RemoteViewsAdapter> mAdapter;
        private IRemoteViewsFactory mRemoteViewsFactory;

        public RemoteViewsAdapterServiceConnection(RemoteViewsAdapter adapter) {
            this.mAdapter = new WeakReference<RemoteViewsAdapter>(adapter);
        }

        public synchronized void bind(Context context, int appWidgetId, Intent intent) {
            if (!this.mIsConnecting) {
                try {
                    AppWidgetManager mgr = AppWidgetManager.getInstance(context);
                    RemoteViewsAdapter adapter = (RemoteViewsAdapter)this.mAdapter.get();
                    if (adapter != null) {
                        mgr.bindRemoteViewsService(context.getOpPackageName(), appWidgetId, intent, this.asBinder());
                    } else {
                        Slog.w(RemoteViewsAdapter.TAG, "bind: adapter was null");
                    }
                    this.mIsConnecting = true;
                }
                catch (Exception e) {
                    Log.e("RVAServiceConnection", "bind(): " + e.getMessage());
                    this.mIsConnecting = false;
                    this.mIsConnected = false;
                }
            }
        }

        public synchronized void unbind(Context context, int appWidgetId, Intent intent) {
            try {
                AppWidgetManager mgr = AppWidgetManager.getInstance(context);
                RemoteViewsAdapter adapter = (RemoteViewsAdapter)this.mAdapter.get();
                if (adapter != null) {
                    mgr.unbindRemoteViewsService(context.getOpPackageName(), appWidgetId, intent);
                } else {
                    Slog.w(RemoteViewsAdapter.TAG, "unbind: adapter was null");
                }
                this.mIsConnecting = false;
            }
            catch (Exception e) {
                Log.e("RVAServiceConnection", "unbind(): " + e.getMessage());
                this.mIsConnecting = false;
                this.mIsConnected = false;
            }
        }

        @Override
        public synchronized void onServiceConnected(IBinder service) {
            this.mRemoteViewsFactory = IRemoteViewsFactory.Stub.asInterface(service);
            final RemoteViewsAdapter adapter = (RemoteViewsAdapter)this.mAdapter.get();
            if (adapter == null) {
                return;
            }
            adapter.mWorkerQueue.post(new Runnable(){

                @Override
                public void run() {
                    if (adapter.mNotifyDataSetChangedAfterOnServiceConnected) {
                        adapter.onNotifyDataSetChanged();
                    } else {
                        IRemoteViewsFactory factory = adapter.mServiceConnection.getRemoteViewsFactory();
                        try {
                            if (!factory.isCreated()) {
                                factory.onDataSetChanged();
                            }
                        }
                        catch (RemoteException e) {
                            Log.e(RemoteViewsAdapter.TAG, "Error notifying factory of data set changed in onServiceConnected(): " + e.getMessage());
                            return;
                        }
                        catch (RuntimeException e) {
                            Log.e(RemoteViewsAdapter.TAG, "Error notifying factory of data set changed in onServiceConnected(): " + e.getMessage());
                        }
                        adapter.updateTemporaryMetaData();
                        adapter.mMainQueue.post(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                FixedSizeRemoteViewsCache fixedSizeRemoteViewsCache = adapter.mCache;
                                synchronized (fixedSizeRemoteViewsCache) {
                                    adapter.mCache.commitTemporaryMetaData();
                                }
                                RemoteAdapterConnectionCallback callback = (RemoteAdapterConnectionCallback)adapter.mCallback.get();
                                if (callback != null) {
                                    callback.onRemoteAdapterConnected();
                                }
                            }
                        });
                    }
                    adapter.enqueueDeferredUnbindServiceMessage();
                    mIsConnected = true;
                    mIsConnecting = false;
                }
            });
        }

        @Override
        public synchronized void onServiceDisconnected() {
            this.mIsConnected = false;
            this.mIsConnecting = false;
            this.mRemoteViewsFactory = null;
            final RemoteViewsAdapter adapter = (RemoteViewsAdapter)this.mAdapter.get();
            if (adapter == null) {
                return;
            }
            adapter.mMainQueue.post(new Runnable(){

                @Override
                public void run() {
                    adapter.mMainQueue.removeMessages(1);
                    RemoteAdapterConnectionCallback callback = (RemoteAdapterConnectionCallback)adapter.mCallback.get();
                    if (callback != null) {
                        callback.onRemoteAdapterDisconnected();
                    }
                }
            });
        }

        public synchronized IRemoteViewsFactory getRemoteViewsFactory() {
            return this.mRemoteViewsFactory;
        }

        public synchronized boolean isConnected() {
            return this.mIsConnected;
        }
    }

    public static class AsyncRemoteAdapterAction
    implements Runnable {
        private final RemoteAdapterConnectionCallback mCallback;
        private final Intent mIntent;

        public AsyncRemoteAdapterAction(RemoteAdapterConnectionCallback callback, Intent intent) {
            this.mCallback = callback;
            this.mIntent = intent;
        }

        @Override
        public void run() {
            this.mCallback.setRemoteViewsAdapter(this.mIntent, true);
        }
    }

    public static interface RemoteAdapterConnectionCallback {
        public boolean onRemoteAdapterConnected();

        public void onRemoteAdapterDisconnected();

        public void deferNotifyDataSetChanged();

        public void setRemoteViewsAdapter(Intent var1, boolean var2);
    }
}

