/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.os.AsyncTask;
import android.text.Selection;
import android.text.Spannable;
import android.text.TextUtils;
import android.view.ActionMode;
import android.view.textclassifier.TextClassificationResult;
import android.view.textclassifier.TextClassifier;
import android.view.textclassifier.TextSelection;
import android.widget.Editor;
import android.widget.SelectionActionModeHelper$$Lambda$60;
import android.widget.SelectionActionModeHelper$$Lambda$61;
import android.widget.SelectionActionModeHelper$$Lambda$62;
import android.widget.SelectionActionModeHelper$$Lambda$63;
import android.widget.SelectionActionModeHelper$TextClassificationAsyncTask$$Lambda$64;
import android.widget.TextView;
import com.android.internal.util.Preconditions;
import java.util.function.Consumer;
import java.util.function.Supplier;

final class SelectionActionModeHelper {
    private static final int TIMEOUT_DURATION = 200;
    private final Editor mEditor;
    private final TextClassificationHelper mTextClassificationHelper;
    private TextClassificationResult mTextClassificationResult;
    private AsyncTask mTextClassificationAsyncTask;

    SelectionActionModeHelper(Editor editor) {
        this.mEditor = Preconditions.checkNotNull(editor);
        TextView textView = this.mEditor.getTextView();
        this.mTextClassificationHelper = new TextClassificationHelper(textView.getTextClassifier(), textView.getText(), textView.getSelectionStart(), textView.getSelectionEnd());
    }

    public void startActionModeAsync() {
        this.cancelAsyncTask();
        if (this.isNoOpTextClassifier()) {
            this.startActionMode(null);
        } else {
            this.resetTextClassificationHelper();
            TextView textView = this.mEditor.getTextView();
            TextClassificationHelper textClassificationHelper = this.mTextClassificationHelper;
            textClassificationHelper.getClass();
            this.mTextClassificationAsyncTask = new TextClassificationAsyncTask(textView, 200, SelectionActionModeHelper$$Lambda$60.get$Lambda(textClassificationHelper), SelectionActionModeHelper$$Lambda$61.get$Lambda(this)).execute(new Void[0]);
        }
    }

    public void startActionMode() {
        this.startActionMode(null);
    }

    public void invalidateActionModeAsync() {
        this.cancelAsyncTask();
        if (this.isNoOpTextClassifier()) {
            this.invalidateActionMode(null);
        } else {
            this.resetTextClassificationHelper();
            TextView textView = this.mEditor.getTextView();
            TextClassificationHelper textClassificationHelper = this.mTextClassificationHelper;
            textClassificationHelper.getClass();
            this.mTextClassificationAsyncTask = new TextClassificationAsyncTask(textView, 200, SelectionActionModeHelper$$Lambda$62.get$Lambda(textClassificationHelper), SelectionActionModeHelper$$Lambda$63.get$Lambda(this)).execute(new Void[0]);
        }
    }

    public void cancelAsyncTask() {
        if (this.mTextClassificationAsyncTask != null) {
            this.mTextClassificationAsyncTask.cancel(true);
            this.mTextClassificationAsyncTask = null;
        }
        this.mTextClassificationResult = null;
    }

    public TextClassificationResult getTextClassificationResult() {
        return this.mTextClassificationResult;
    }

    private boolean isNoOpTextClassifier() {
        return this.mEditor.getTextView().getTextClassifier() == TextClassifier.NO_OP;
    }

    private void startActionMode(SelectionResult result) {
        Editor.SelectionModifierCursorController controller;
        CharSequence text = this.mEditor.getTextView().getText();
        if (result != null && text instanceof Spannable) {
            Selection.setSelection((Spannable)text, result.mStart, result.mEnd);
            this.mTextClassificationResult = result.mResult;
        } else {
            this.mTextClassificationResult = null;
        }
        if (this.mEditor.startSelectionActionModeInternal() && (controller = this.mEditor.getSelectionController()) != null) {
            controller.show();
        }
        this.mEditor.setRestartActionModeOnNextRefresh(false);
        this.mTextClassificationAsyncTask = null;
    }

    private void invalidateActionMode(SelectionResult result) {
        this.mTextClassificationResult = result != null ? result.mResult : null;
        ActionMode actionMode = this.mEditor.getTextActionMode();
        if (actionMode != null) {
            actionMode.invalidate();
        }
        this.mTextClassificationAsyncTask = null;
    }

    private void resetTextClassificationHelper() {
        TextView textView = this.mEditor.getTextView();
        this.mTextClassificationHelper.reset(textView.getTextClassifier(), textView.getText(), textView.getSelectionStart(), textView.getSelectionEnd());
    }

    private static final class SelectionResult {
        private final int mStart;
        private final int mEnd;
        private final TextClassificationResult mResult;

        SelectionResult(int start, int end, TextClassificationResult result) {
            this.mStart = start;
            this.mEnd = end;
            this.mResult = Preconditions.checkNotNull(result);
        }
    }

    private static final class TextClassificationHelper {
        private static final int TRIM_DELTA = 50;
        private TextClassifier mTextClassifier;
        private String mText;
        private int mSelectionStart;
        private int mSelectionEnd;
        private CharSequence mTrimmedText;
        private int mTrimStart;
        private int mRelativeStart;
        private int mRelativeEnd;

        TextClassificationHelper(TextClassifier textClassifier, CharSequence text, int selectionStart, int selectionEnd) {
            this.reset(textClassifier, text, selectionStart, selectionEnd);
        }

        public void reset(TextClassifier textClassifier, CharSequence text, int selectionStart, int selectionEnd) {
            this.mTextClassifier = Preconditions.checkNotNull(textClassifier);
            this.mText = Preconditions.checkNotNull(text).toString();
            this.mSelectionStart = selectionStart;
            this.mSelectionEnd = selectionEnd;
        }

        public SelectionResult classifyText() {
            this.trimText();
            return new SelectionResult(this.mSelectionStart, this.mSelectionEnd, this.mTextClassifier.getTextClassificationResult(this.mTrimmedText, this.mRelativeStart, this.mRelativeEnd));
        }

        public SelectionResult suggestSelection() {
            this.trimText();
            TextSelection sel = this.mTextClassifier.suggestSelection(this.mTrimmedText, this.mRelativeStart, this.mRelativeEnd);
            this.mSelectionStart = Math.max(0, sel.getSelectionStartIndex() + this.mTrimStart);
            this.mSelectionEnd = Math.min(this.mText.length(), sel.getSelectionEndIndex() + this.mTrimStart);
            return this.classifyText();
        }

        private void trimText() {
            this.mTrimStart = Math.max(0, this.mSelectionStart - 50);
            int referenceEnd = Math.min(this.mText.length(), this.mSelectionEnd + 50);
            this.mTrimmedText = this.mText.subSequence(this.mTrimStart, referenceEnd);
            this.mRelativeStart = this.mSelectionStart - this.mTrimStart;
            this.mRelativeEnd = this.mSelectionEnd - this.mTrimStart;
        }
    }

    private static final class TextClassificationAsyncTask
    extends AsyncTask<Void, Void, SelectionResult> {
        private final int mTimeOutDuration;
        private final Supplier<SelectionResult> mSelectionResultSupplier;
        private final Consumer<SelectionResult> mSelectionResultCallback;
        private final TextView mTextView;
        private final String mOriginalText;

        TextClassificationAsyncTask(TextView textView, int timeOut, Supplier<SelectionResult> selectionResultSupplier, Consumer<SelectionResult> selectionResultCallback) {
            this.mTextView = Preconditions.checkNotNull(textView);
            this.mTimeOutDuration = timeOut;
            this.mSelectionResultSupplier = Preconditions.checkNotNull(selectionResultSupplier);
            this.mSelectionResultCallback = Preconditions.checkNotNull(selectionResultCallback);
            this.mOriginalText = this.mTextView.getText().toString();
        }

        protected SelectionResult doInBackground(Void ... params) {
            Runnable onTimeOut = SelectionActionModeHelper$TextClassificationAsyncTask$$Lambda$64.get$Lambda(this);
            this.mTextView.postDelayed(onTimeOut, this.mTimeOutDuration);
            SelectionResult result = this.mSelectionResultSupplier.get();
            this.mTextView.removeCallbacks(onTimeOut);
            return result;
        }

        @Override
        protected void onPostExecute(SelectionResult result) {
            result = TextUtils.equals(this.mOriginalText, this.mTextView.getText()) ? result : null;
            this.mSelectionResultCallback.accept(result);
        }

        private void onTimeOut() {
            if (this.getStatus() == AsyncTask.Status.RUNNING) {
                this.onPostExecute(null);
            }
            this.cancel(true);
        }
    }
}

