/*
 * Decompiled with CFR 0.152.
 */
package com.android.dex;

public final class DexFormat {
    public static final int API_CURRENT = 24;
    public static final int API_NO_EXTENDED_OPCODES = 13;
    public static final String DEX_IN_JAR_NAME = "classes.dex";
    public static final String MAGIC_PREFIX = "dex\n";
    public static final String MAGIC_SUFFIX = "\u0000";
    public static final String VERSION_CURRENT = "038";
    static final String[] VERSIONS_SUPPORTED = new String[]{"035", "037", "038"};
    public static final String VERSION_FOR_API_13 = "035";
    public static final int ENDIAN_TAG = 305419896;
    public static final int MAX_MEMBER_IDX = 65535;
    public static final int MAX_TYPE_IDX = 65535;

    private DexFormat() {
    }

    public static int magicToApi(byte[] magic) {
        if (magic.length != 8) {
            return -1;
        }
        if (magic[0] != 100 || magic[1] != 101 || magic[2] != 120 || magic[3] != 10 || magic[7] != 0) {
            return -1;
        }
        String version = "" + (char)magic[4] + (char)magic[5] + (char)magic[6];
        for (String supported : VERSIONS_SUPPORTED) {
            if (!version.equals(supported)) continue;
            return 24;
        }
        if (version.equals(VERSION_FOR_API_13)) {
            return 13;
        }
        return -1;
    }

    public static String apiToMagic(int targetApiLevel) {
        String version = targetApiLevel >= 24 ? VERSION_CURRENT : VERSION_FOR_API_13;
        return MAGIC_PREFIX + version + MAGIC_SUFFIX;
    }

    public static boolean isSupportedDexMagic(byte[] magic) {
        int api = DexFormat.magicToApi(magic);
        return api == 13 || api == 24;
    }
}

