/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.alsa;

import android.util.Slog;
import com.android.internal.alsa.LineTokenizer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;

public class AlsaDevicesParser {
    private static final String TAG = "AlsaDevicesParser";
    protected static final boolean DEBUG = false;
    private static final String kDevicesFilePath = "/proc/asound/devices";
    private static final int kIndex_CardDeviceField = 5;
    private static final int kStartIndex_CardNum = 6;
    private static final int kEndIndex_CardNum = 8;
    private static final int kStartIndex_DeviceNum = 9;
    private static final int kEndIndex_DeviceNum = 11;
    private static final int kStartIndex_Type = 14;
    private static LineTokenizer mTokenizer = new LineTokenizer(" :[]-");
    private boolean mHasCaptureDevices = false;
    private boolean mHasPlaybackDevices = false;
    private boolean mHasMIDIDevices = false;
    private ArrayList<AlsaDeviceRecord> mDeviceRecords = new ArrayList();

    public int getDefaultDeviceNum(int card) {
        return 0;
    }

    public boolean hasPlaybackDevices() {
        return this.mHasPlaybackDevices;
    }

    public boolean hasPlaybackDevices(int card) {
        for (AlsaDeviceRecord deviceRecord : this.mDeviceRecords) {
            if (deviceRecord.mCardNum != card || deviceRecord.mDeviceType != 0 || deviceRecord.mDeviceDir != 1) continue;
            return true;
        }
        return false;
    }

    public boolean hasCaptureDevices() {
        return this.mHasCaptureDevices;
    }

    public boolean hasCaptureDevices(int card) {
        for (AlsaDeviceRecord deviceRecord : this.mDeviceRecords) {
            if (deviceRecord.mCardNum != card || deviceRecord.mDeviceType != 0 || deviceRecord.mDeviceDir != 0) continue;
            return true;
        }
        return false;
    }

    public boolean hasMIDIDevices() {
        return this.mHasMIDIDevices;
    }

    public boolean hasMIDIDevices(int card) {
        for (AlsaDeviceRecord deviceRecord : this.mDeviceRecords) {
            if (deviceRecord.mCardNum != card || deviceRecord.mDeviceType != 2) continue;
            return true;
        }
        return false;
    }

    private boolean isLineDeviceRecord(String line) {
        return line.charAt(5) == '[';
    }

    public void scan() {
        this.mDeviceRecords.clear();
        File devicesFile = new File(kDevicesFilePath);
        try {
            FileReader reader = new FileReader(devicesFile);
            BufferedReader bufferedReader = new BufferedReader(reader);
            String line = "";
            while ((line = bufferedReader.readLine()) != null) {
                if (!this.isLineDeviceRecord(line)) continue;
                AlsaDeviceRecord deviceRecord = new AlsaDeviceRecord();
                deviceRecord.parse(line);
                this.mDeviceRecords.add(deviceRecord);
            }
            reader.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void Log(String heading) {
    }

    public class AlsaDeviceRecord {
        public static final int kDeviceType_Unknown = -1;
        public static final int kDeviceType_Audio = 0;
        public static final int kDeviceType_Control = 1;
        public static final int kDeviceType_MIDI = 2;
        public static final int kDeviceDir_Unknown = -1;
        public static final int kDeviceDir_Capture = 0;
        public static final int kDeviceDir_Playback = 1;
        int mCardNum = -1;
        int mDeviceNum = -1;
        int mDeviceType = -1;
        int mDeviceDir = -1;

        public boolean parse(String line) {
            boolean kToken_LineNum = false;
            boolean kToken_CardNum = true;
            int kToken_DeviceNum = 2;
            int kToken_Type0 = 3;
            int kToken_Type1 = 4;
            int kToken_Type2 = 5;
            int tokenOffset = 0;
            int delimOffset = 0;
            int tokenIndex = 0;
            while ((tokenOffset = mTokenizer.nextToken(line, delimOffset)) != -1) {
                delimOffset = mTokenizer.nextDelimiter(line, tokenOffset);
                if (delimOffset == -1) {
                    delimOffset = line.length();
                }
                String token = line.substring(tokenOffset, delimOffset);
                try {
                    switch (tokenIndex) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            this.mCardNum = Integer.parseInt(token);
                            if (line.charAt(delimOffset) == '-') break;
                            ++tokenIndex;
                            break;
                        }
                        case 2: {
                            this.mDeviceNum = Integer.parseInt(token);
                            break;
                        }
                        case 3: {
                            if (token.equals("digital")) break;
                            if (token.equals("control")) {
                                this.mDeviceType = 1;
                                break;
                            }
                            if (!token.equals("raw")) break;
                            break;
                        }
                        case 4: {
                            if (token.equals("audio")) {
                                this.mDeviceType = 0;
                                break;
                            }
                            if (!token.equals("midi")) break;
                            this.mDeviceType = 2;
                            AlsaDevicesParser.this.mHasMIDIDevices = true;
                            break;
                        }
                        case 5: {
                            if (token.equals("capture")) {
                                this.mDeviceDir = 0;
                                AlsaDevicesParser.this.mHasCaptureDevices = true;
                                break;
                            }
                            if (!token.equals("playback")) break;
                            this.mDeviceDir = 1;
                            AlsaDevicesParser.this.mHasPlaybackDevices = true;
                        }
                    }
                }
                catch (NumberFormatException e) {
                    Slog.e(AlsaDevicesParser.TAG, "Failed to parse token " + tokenIndex + " of " + AlsaDevicesParser.kDevicesFilePath + " token: " + token);
                    return false;
                }
                ++tokenIndex;
            }
            return true;
        }

        public String textFormat() {
            StringBuilder sb = new StringBuilder();
            sb.append("[" + this.mCardNum + ":" + this.mDeviceNum + "]");
            switch (this.mDeviceType) {
                case -1: {
                    sb.append(" N/A");
                    break;
                }
                case 0: {
                    sb.append(" Audio");
                    break;
                }
                case 1: {
                    sb.append(" Control");
                    break;
                }
                case 2: {
                    sb.append(" MIDI");
                }
            }
            switch (this.mDeviceDir) {
                case -1: {
                    sb.append(" N/A");
                    break;
                }
                case 0: {
                    sb.append(" Capture");
                    break;
                }
                case 1: {
                    sb.append(" Playback");
                }
            }
            return sb.toString();
        }
    }
}

