/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.app.usage.UsageStats;
import android.app.usage.UsageStatsManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.ComponentInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Environment;
import android.os.storage.StorageManager;
import android.util.ArrayMap;
import com.android.internal.app.ResolverActivity;
import java.io.File;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

class ResolverComparator
implements Comparator<ResolverActivity.ResolvedComponentInfo> {
    private static final String TAG = "ResolverComparator";
    private static final boolean DEBUG = false;
    private static final int NUM_OF_TOP_ANNOTATIONS_TO_USE = 3;
    private static final long USAGE_STATS_PERIOD = 604800000L;
    private static final long RECENCY_TIME_PERIOD = 43200000L;
    private static final float RECENCY_MULTIPLIER = 2.0f;
    private static final String LAUNCH_SCORE = "launch";
    private static final String TIME_SPENT_SCORE = "timeSpent";
    private static final String RECENCY_SCORE = "recency";
    private static final String CHOOSER_SCORE = "chooser";
    private final Collator mCollator;
    private final boolean mHttp;
    private final PackageManager mPm;
    private final UsageStatsManager mUsm;
    private final Map<String, UsageStats> mStats;
    private final long mCurrentTime;
    private final long mSinceTime;
    private final LinkedHashMap<ComponentName, ScoredTarget> mScoredTargets = new LinkedHashMap();
    private final String mReferrerPackage;
    private String mContentType;
    private String[] mAnnotations;
    private String mAction;
    private LogisticRegressionAppRanker mRanker;

    public ResolverComparator(Context context, Intent intent, String referrerPackage) {
        this.mCollator = Collator.getInstance(context.getResources().getConfiguration().locale);
        String scheme = intent.getScheme();
        this.mHttp = "http".equals(scheme) || "https".equals(scheme);
        this.mReferrerPackage = referrerPackage;
        this.mPm = context.getPackageManager();
        this.mUsm = (UsageStatsManager)context.getSystemService("usagestats");
        this.mCurrentTime = System.currentTimeMillis();
        this.mSinceTime = this.mCurrentTime - 604800000L;
        this.mStats = this.mUsm.queryAndAggregateUsageStats(this.mSinceTime, this.mCurrentTime);
        this.mContentType = intent.getType();
        this.getContentAnnotations(intent);
        this.mAction = intent.getAction();
        this.mRanker = new LogisticRegressionAppRanker(context);
    }

    public void getContentAnnotations(Intent intent) {
        ArrayList<String> annotations = intent.getStringArrayListExtra("android.intent.extra.CONTENT_ANNOTATIONS");
        if (annotations != null) {
            int size = annotations.size();
            if (size > 3) {
                size = 3;
            }
            this.mAnnotations = new String[size];
            for (int i = 0; i < size; ++i) {
                this.mAnnotations[i] = annotations.get(i);
            }
        }
    }

    public void compute(List<ResolverActivity.ResolvedComponentInfo> targets) {
        this.mScoredTargets.clear();
        long recentSinceTime = this.mCurrentTime - 43200000L;
        long mostRecentlyUsedTime = recentSinceTime + 1L;
        long mostTimeSpent = 1L;
        int mostLaunched = 1;
        int mostSelected = 1;
        for (ResolverActivity.ResolvedComponentInfo resolvedComponentInfo : targets) {
            long timeSpent;
            ScoredTarget scoredTarget = new ScoredTarget(resolvedComponentInfo.getResolveInfoAt((int)0).activityInfo);
            this.mScoredTargets.put(resolvedComponentInfo.name, scoredTarget);
            UsageStats pkStats = this.mStats.get(resolvedComponentInfo.name.getPackageName());
            if (pkStats == null) continue;
            if (!resolvedComponentInfo.name.getPackageName().equals(this.mReferrerPackage) && !ResolverComparator.isPersistentProcess(resolvedComponentInfo)) {
                long lastTimeUsed;
                scoredTarget.lastTimeUsed = lastTimeUsed = pkStats.getLastTimeUsed();
                if (lastTimeUsed > mostRecentlyUsedTime) {
                    mostRecentlyUsedTime = lastTimeUsed;
                }
            }
            scoredTarget.timeSpent = timeSpent = pkStats.getTotalTimeInForeground();
            if (timeSpent > mostTimeSpent) {
                mostTimeSpent = timeSpent;
            }
            int launched = pkStats.mLaunchCount;
            scoredTarget.launchCount = launched;
            if (launched > mostLaunched) {
                mostLaunched = launched;
            }
            int selected = 0;
            if (pkStats.mChooserCounts != null && this.mAction != null && pkStats.mChooserCounts.get(this.mAction) != null) {
                selected = pkStats.mChooserCounts.get(this.mAction).getOrDefault(this.mContentType, 0);
                if (this.mAnnotations != null) {
                    int size = this.mAnnotations.length;
                    for (int i = 0; i < size; ++i) {
                        selected += pkStats.mChooserCounts.get(this.mAction).getOrDefault(this.mAnnotations[i], 0).intValue();
                    }
                }
            }
            scoredTarget.chooserCount = selected;
            if (selected <= mostSelected) continue;
            mostSelected = selected;
        }
        for (ScoredTarget scoredTarget : this.mScoredTargets.values()) {
            float recency = (float)Math.max(scoredTarget.lastTimeUsed - recentSinceTime, 0L) / (float)(mostRecentlyUsedTime - recentSinceTime);
            scoredTarget.setFeatures((float)scoredTarget.launchCount / (float)mostLaunched, (float)scoredTarget.timeSpent / (float)mostTimeSpent, recency * recency * 2.0f, (float)scoredTarget.chooserCount / (float)mostSelected);
            scoredTarget.selectProb = this.mRanker.predict(scoredTarget.getFeatures());
        }
    }

    static boolean isPersistentProcess(ResolverActivity.ResolvedComponentInfo rci) {
        if (rci != null && rci.getCount() > 0) {
            return (rci.getResolveInfoAt((int)0).activityInfo.applicationInfo.flags & 8) != 0;
        }
        return false;
    }

    @Override
    public int compare(ResolverActivity.ResolvedComponentInfo lhsp, ResolverActivity.ResolvedComponentInfo rhsp) {
        CharSequence sb;
        CharSequence sa;
        boolean rhsSpecific;
        boolean lhsSpecific;
        ResolveInfo lhs = lhsp.getResolveInfoAt(0);
        ResolveInfo rhs = rhsp.getResolveInfoAt(0);
        if (lhs.targetUserId != -2) {
            return rhs.targetUserId != -2 ? 0 : 1;
        }
        if (rhs.targetUserId != -2) {
            return -1;
        }
        if (this.mHttp && (lhsSpecific = ResolverActivity.isSpecificUriMatch(lhs.match)) != (rhsSpecific = ResolverActivity.isSpecificUriMatch(rhs.match))) {
            return lhsSpecific ? -1 : 1;
        }
        boolean lPinned = lhsp.isPinned();
        boolean rPinned = rhsp.isPinned();
        if (lPinned && !rPinned) {
            return -1;
        }
        if (!lPinned && rPinned) {
            return 1;
        }
        if (!lPinned && !rPinned && this.mStats != null) {
            ScoredTarget lhsTarget = this.mScoredTargets.get(new ComponentName(lhs.activityInfo.packageName, lhs.activityInfo.name));
            ScoredTarget rhsTarget = this.mScoredTargets.get(new ComponentName(rhs.activityInfo.packageName, rhs.activityInfo.name));
            int selectProbDiff = Float.compare(rhsTarget.selectProb, lhsTarget.selectProb);
            if (selectProbDiff != 0) {
                return selectProbDiff > 0 ? 1 : -1;
            }
        }
        if ((sa = lhs.loadLabel(this.mPm)) == null) {
            sa = lhs.activityInfo.name;
        }
        if ((sb = rhs.loadLabel(this.mPm)) == null) {
            sb = rhs.activityInfo.name;
        }
        return this.mCollator.compare(sa.toString().trim(), sb.toString().trim());
    }

    public float getScore(ComponentName name) {
        ScoredTarget target = this.mScoredTargets.get(name);
        if (target != null) {
            return target.selectProb;
        }
        return 0.0f;
    }

    public void updateChooserCounts(String packageName, int userId, String action) {
        if (this.mUsm != null) {
            this.mUsm.reportChooserSelection(packageName, userId, this.mContentType, this.mAnnotations, action);
        }
    }

    public void updateModel(ComponentName componentName) {
        if (this.mScoredTargets == null || componentName == null || !this.mScoredTargets.containsKey(componentName)) {
            return;
        }
        ScoredTarget selected = this.mScoredTargets.get(componentName);
        for (ComponentName targetComponent : this.mScoredTargets.keySet()) {
            if (targetComponent.equals(componentName)) continue;
            ScoredTarget target = this.mScoredTargets.get(targetComponent);
            if (!(target.selectProb >= selected.selectProb)) continue;
            this.mRanker.update(target.getFeatures(), target.selectProb, false);
            this.mRanker.update(selected.getFeatures(), selected.selectProb, true);
        }
        this.mRanker.commitUpdate();
    }

    class LogisticRegressionAppRanker {
        private static final String PARAM_SHARED_PREF_NAME = "resolver_ranker_params";
        private static final String BIAS_PREF_KEY = "bias";
        private static final String VERSION_PREF_KEY = "version";
        private static final int CURRENT_VERSION = 1;
        private static final float LEARNING_RATE = 1.0E-4f;
        private static final float REGULARIZER_PARAM = 1.0E-4f;
        private SharedPreferences mParamSharedPref;
        private ArrayMap<String, Float> mFeatureWeights;
        private float mBias;

        public LogisticRegressionAppRanker(Context context) {
            this.mParamSharedPref = this.getParamSharedPref(context);
            this.initModel();
        }

        public float predict(ArrayMap<String, Float> target) {
            if (target == null) {
                return 0.0f;
            }
            int featureSize = target.size();
            float sum = 0.0f;
            for (int i = 0; i < featureSize; ++i) {
                String featureName = target.keyAt(i);
                float weight = this.mFeatureWeights.getOrDefault(featureName, Float.valueOf(0.0f)).floatValue();
                sum += weight * target.valueAt(i).floatValue();
            }
            return (float)(1.0 / (1.0 + Math.exp(-this.mBias - sum)));
        }

        public void update(ArrayMap<String, Float> target, float predict, boolean isSelected) {
            if (target == null) {
                return;
            }
            int featureSize = target.size();
            float error = isSelected ? 1.0f - predict : -predict;
            for (int i = 0; i < featureSize; ++i) {
                String featureName = target.keyAt(i);
                float currentWeight = this.mFeatureWeights.getOrDefault(featureName, Float.valueOf(0.0f)).floatValue();
                this.mBias += 1.0E-4f * error;
                currentWeight = currentWeight - 9.999999E-9f * currentWeight + 1.0E-4f * error * target.valueAt(i).floatValue();
                this.mFeatureWeights.put(featureName, Float.valueOf(currentWeight));
            }
        }

        public void commitUpdate() {
            SharedPreferences.Editor editor = this.mParamSharedPref.edit();
            editor.putFloat(BIAS_PREF_KEY, this.mBias);
            int size = this.mFeatureWeights.size();
            for (int i = 0; i < size; ++i) {
                editor.putFloat(this.mFeatureWeights.keyAt(i), this.mFeatureWeights.valueAt(i).floatValue());
            }
            editor.putInt(VERSION_PREF_KEY, 1);
            editor.apply();
        }

        private SharedPreferences getParamSharedPref(Context context) {
            File prefsFile = new File(new File(Environment.getDataUserCePackageDirectory(StorageManager.UUID_PRIVATE_INTERNAL, context.getUserId(), context.getPackageName()), "shared_prefs"), "resolver_ranker_params.xml");
            return context.getSharedPreferences(prefsFile, 0);
        }

        private void initModel() {
            this.mFeatureWeights = new ArrayMap(4);
            if (this.mParamSharedPref == null || this.mParamSharedPref.getInt(VERSION_PREF_KEY, 0) < 1) {
                this.mBias = -1.6568f;
                this.mFeatureWeights.put(ResolverComparator.LAUNCH_SCORE, Float.valueOf(2.5543f));
                this.mFeatureWeights.put(ResolverComparator.TIME_SPENT_SCORE, Float.valueOf(2.8412f));
                this.mFeatureWeights.put(ResolverComparator.RECENCY_SCORE, Float.valueOf(0.269f));
                this.mFeatureWeights.put(ResolverComparator.CHOOSER_SCORE, Float.valueOf(4.2222f));
            } else {
                this.mBias = this.mParamSharedPref.getFloat(BIAS_PREF_KEY, 0.0f);
                this.mFeatureWeights.put(ResolverComparator.LAUNCH_SCORE, Float.valueOf(this.mParamSharedPref.getFloat(ResolverComparator.LAUNCH_SCORE, 0.0f)));
                this.mFeatureWeights.put(ResolverComparator.TIME_SPENT_SCORE, Float.valueOf(this.mParamSharedPref.getFloat(ResolverComparator.TIME_SPENT_SCORE, 0.0f)));
                this.mFeatureWeights.put(ResolverComparator.RECENCY_SCORE, Float.valueOf(this.mParamSharedPref.getFloat(ResolverComparator.RECENCY_SCORE, 0.0f)));
                this.mFeatureWeights.put(ResolverComparator.CHOOSER_SCORE, Float.valueOf(this.mParamSharedPref.getFloat(ResolverComparator.CHOOSER_SCORE, 0.0f)));
            }
        }
    }

    static class ScoredTarget {
        public final ComponentInfo componentInfo;
        public long lastTimeUsed;
        public long timeSpent;
        public long launchCount;
        public long chooserCount;
        public ArrayMap<String, Float> features;
        public float selectProb;

        public ScoredTarget(ComponentInfo ci) {
            this.componentInfo = ci;
            this.features = new ArrayMap(5);
        }

        public String toString() {
            return "ScoredTarget{" + this.componentInfo + " lastTimeUsed: " + this.lastTimeUsed + " timeSpent: " + this.timeSpent + " launchCount: " + this.launchCount + " chooserCount: " + this.chooserCount + " selectProb: " + this.selectProb + "}";
        }

        public void setFeatures(float launchCountScore, float usageTimeScore, float recencyScore, float chooserCountScore) {
            this.features.put(ResolverComparator.LAUNCH_SCORE, Float.valueOf(launchCountScore));
            this.features.put(ResolverComparator.TIME_SPENT_SCORE, Float.valueOf(usageTimeScore));
            this.features.put(ResolverComparator.RECENCY_SCORE, Float.valueOf(recencyScore));
            this.features.put(ResolverComparator.CHOOSER_SCORE, Float.valueOf(chooserCountScore));
        }

        public ArrayMap<String, Float> getFeatures() {
            return this.features;
        }
    }
}

