/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app.procstats;

import android.util.DebugUtils;
import com.android.internal.app.procstats.DumpUtils;
import com.android.internal.app.procstats.SparseMappingTable;
import java.io.PrintWriter;

public class SysMemUsageTable
extends SparseMappingTable.Table {
    public SysMemUsageTable(SparseMappingTable tableData) {
        super(tableData);
    }

    public void mergeStats(SysMemUsageTable that) {
        int N = that.getKeyCount();
        for (int i = 0; i < N; ++i) {
            int key = that.getKeyAt(i);
            byte state = SparseMappingTable.getIdFromKey(key);
            long[] addData = that.getArrayForKey(key);
            int addOff = SparseMappingTable.getIndexFromKey(key);
            this.mergeStats(state, addData, addOff);
        }
    }

    public void mergeStats(int state, long[] addData, int addOff) {
        int key = this.getOrAddKey((byte)state, 16);
        long[] dstData = this.getArrayForKey(key);
        int dstOff = SparseMappingTable.getIndexFromKey(key);
        SysMemUsageTable.mergeSysMemUsage(dstData, dstOff, addData, addOff);
    }

    public long[] getTotalMemUsage() {
        long[] total = new long[16];
        int N = this.getKeyCount();
        for (int i = 0; i < N; ++i) {
            int key = this.getKeyAt(i);
            long[] addData = this.getArrayForKey(key);
            int addOff = SparseMappingTable.getIndexFromKey(key);
            SysMemUsageTable.mergeSysMemUsage(total, 0, addData, addOff);
        }
        return total;
    }

    public static void mergeSysMemUsage(long[] dstData, int dstOff, long[] addData, int addOff) {
        block4: {
            long addCount;
            long dstCount;
            block3: {
                dstCount = dstData[dstOff + 0];
                addCount = addData[addOff + 0];
                if (dstCount != 0L) break block3;
                dstData[dstOff + 0] = addCount;
                for (int i = 1; i < 16; ++i) {
                    dstData[dstOff + i] = addData[addOff + i];
                }
                break block4;
            }
            if (addCount <= 0L) break block4;
            dstData[dstOff + 0] = dstCount + addCount;
            for (int i = 1; i < 16; i += 3) {
                if (dstData[dstOff + i] > addData[addOff + i]) {
                    dstData[dstOff + i] = addData[addOff + i];
                }
                dstData[dstOff + i + 1] = (long)(((double)dstData[dstOff + i + 1] * (double)dstCount + (double)addData[addOff + i + 1] * (double)addCount) / (double)(dstCount + addCount));
                if (dstData[dstOff + i + 2] >= addData[addOff + i + 2]) continue;
                dstData[dstOff + i + 2] = addData[addOff + i + 2];
            }
        }
    }

    public void dump(PrintWriter pw, String prefix, int[] screenStates, int[] memStates) {
        int printedScreen = -1;
        for (int is = 0; is < screenStates.length; ++is) {
            int printedMem = -1;
            for (int im = 0; im < memStates.length; ++im) {
                int iscreen = screenStates[is];
                int imem = memStates[im];
                int bucket = (iscreen + imem) * 14;
                long count = this.getValueForId((byte)bucket, 0);
                if (count <= 0L) continue;
                pw.print(prefix);
                if (screenStates.length > 1) {
                    DumpUtils.printScreenLabel(pw, printedScreen != iscreen ? iscreen : -1);
                    printedScreen = iscreen;
                }
                if (memStates.length > 1) {
                    DumpUtils.printMemLabel(pw, printedMem != imem ? imem : -1, '\u0000');
                    printedMem = imem;
                }
                pw.print(": ");
                pw.print(count);
                pw.println(" samples:");
                this.dumpCategory(pw, prefix, "  Cached", bucket, 1);
                this.dumpCategory(pw, prefix, "  Free", bucket, 4);
                this.dumpCategory(pw, prefix, "  ZRam", bucket, 7);
                this.dumpCategory(pw, prefix, "  Kernel", bucket, 10);
                this.dumpCategory(pw, prefix, "  Native", bucket, 13);
            }
        }
    }

    private void dumpCategory(PrintWriter pw, String prefix, String label, int bucket, int index) {
        pw.print(prefix);
        pw.print(label);
        pw.print(": ");
        DebugUtils.printSizeValue(pw, this.getValueForId((byte)bucket, index) * 1024L);
        pw.print(" min, ");
        DebugUtils.printSizeValue(pw, this.getValueForId((byte)bucket, index + 1) * 1024L);
        pw.print(" avg, ");
        DebugUtils.printSizeValue(pw, this.getValueForId((byte)bucket, index + 2) * 1024L);
        pw.println(" max");
    }
}

