/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.hardware;

import android.content.Context;
import android.provider.Settings;
import android.text.TextUtils;

public class AmbientDisplayConfiguration {
    private final Context mContext;

    public AmbientDisplayConfiguration(Context context) {
        this.mContext = context;
    }

    public boolean enabled(int user) {
        return this.pulseOnNotificationEnabled(user) || this.pulseOnPickupEnabled(user) || this.pulseOnDoubleTapEnabled(user);
    }

    public boolean available() {
        return this.pulseOnNotificationAvailable() || this.pulseOnPickupAvailable() || this.pulseOnDoubleTapAvailable();
    }

    public boolean pulseOnNotificationEnabled(int user) {
        return this.boolSetting("doze_enabled", user) && this.pulseOnNotificationAvailable();
    }

    public boolean pulseOnNotificationAvailable() {
        return this.ambientDisplayAvailable();
    }

    public boolean pulseOnPickupEnabled(int user) {
        return this.boolSetting("doze_pulse_on_pick_up", user) && this.pulseOnPickupAvailable();
    }

    public boolean pulseOnPickupAvailable() {
        return this.mContext.getResources().getBoolean(17956926) && this.ambientDisplayAvailable();
    }

    public boolean pulseOnDoubleTapEnabled(int user) {
        return this.boolSetting("doze_pulse_on_double_tap", user) && this.pulseOnDoubleTapAvailable();
    }

    public boolean pulseOnDoubleTapAvailable() {
        return !TextUtils.isEmpty(this.doubleTapSensorType()) && this.ambientDisplayAvailable();
    }

    public String doubleTapSensorType() {
        return this.mContext.getResources().getString(0x1040111);
    }

    public String ambientDisplayComponent() {
        return this.mContext.getResources().getString(0x1040110);
    }

    private boolean ambientDisplayAvailable() {
        return !TextUtils.isEmpty(this.ambientDisplayComponent());
    }

    private boolean boolSetting(String name, int user) {
        return Settings.Secure.getIntForUser(this.mContext.getContentResolver(), name, 1, user) != 0;
    }
}

