/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.inputmethod;

import android.icu.util.ULocale;
import android.os.LocaleList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;

public final class LocaleUtils {
    private static byte calculateMatchingSubScore(ULocale supported, ULocale desired) {
        if (supported.equals(desired)) {
            return 3;
        }
        String supportedScript = supported.getScript();
        if (supportedScript.isEmpty() || !supportedScript.equals(desired.getScript())) {
            return 1;
        }
        String supportedCountry = supported.getCountry();
        if (supportedCountry.isEmpty() || !supportedCountry.equals(desired.getCountry())) {
            return 2;
        }
        return 3;
    }

    private static boolean calculateMatchingScore(ULocale supported, LocaleList desired, byte[] out) {
        if (desired.isEmpty()) {
            return false;
        }
        boolean allZeros = true;
        int N = desired.size();
        for (int i = 0; i < N; ++i) {
            Locale locale = desired.get(i);
            if (!locale.getLanguage().equals(supported.getLanguage())) {
                out[i] = 0;
                continue;
            }
            out[i] = LocaleUtils.calculateMatchingSubScore(supported, ULocale.addLikelySubtags(ULocale.forLocale(locale)));
            if (!allZeros || out[i] == 0) continue;
            allZeros = false;
        }
        return !allZeros;
    }

    public static <T> void filterByLanguage(List<T> sources, LocaleExtractor<T> extractor, LocaleList preferredLanguages, ArrayList<T> dest) {
        HashMap<String, ScoreEntry> scoreboard = new HashMap<String, ScoreEntry>();
        byte[] score = new byte[preferredLanguages.size()];
        int sourceSize = sources.size();
        for (int i = 0; i < sourceSize; ++i) {
            Locale locale = extractor.get(sources.get(i));
            if (locale == null || !LocaleUtils.calculateMatchingScore(ULocale.addLikelySubtags(ULocale.forLocale(locale)), preferredLanguages, score)) continue;
            String lang = locale.getLanguage();
            ScoreEntry bestScore = (ScoreEntry)scoreboard.get(lang);
            if (bestScore == null) {
                scoreboard.put(lang, new ScoreEntry(score, i));
                continue;
            }
            bestScore.updateIfBetter(score, i);
        }
        Object[] result = scoreboard.values().toArray(new ScoreEntry[scoreboard.size()]);
        Arrays.sort(result);
        for (Object entry : result) {
            dest.add(sources.get(((ScoreEntry)entry).mIndex));
        }
    }

    private static final class ScoreEntry
    implements Comparable<ScoreEntry> {
        public int mIndex = -1;
        public final byte[] mScore;

        ScoreEntry(byte[] score, int index) {
            this.mScore = new byte[score.length];
            this.set(score, index);
        }

        private void set(byte[] score, int index) {
            for (int i = 0; i < this.mScore.length; ++i) {
                this.mScore[i] = score[i];
            }
            this.mIndex = index;
        }

        public void updateIfBetter(byte[] score, int index) {
            if (ScoreEntry.compare(this.mScore, score) == -1) {
                this.set(score, index);
            }
        }

        private static int compare(byte[] left, byte[] right) {
            for (int i = 0; i < left.length; ++i) {
                if (left[i] > right[i]) {
                    return 1;
                }
                if (left[i] >= right[i]) continue;
                return -1;
            }
            return 0;
        }

        @Override
        public int compareTo(ScoreEntry other) {
            return -1 * ScoreEntry.compare(this.mScore, other.mScore);
        }
    }

    public static interface LocaleExtractor<T> {
        public Locale get(T var1);
    }
}

