/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.logging;

import android.content.Context;
import android.metrics.LogMaker;
import android.os.Build;
import com.android.internal.logging.EventLogTags;

public class MetricsLogger {
    public static final int VIEW_UNKNOWN = 0;

    public static void visible(Context context, int category) throws IllegalArgumentException {
        if (Build.IS_DEBUGGABLE && category == 0) {
            throw new IllegalArgumentException("Must define metric category");
        }
        EventLogTags.writeSysuiViewVisibility(category, 100);
        EventLogTags.writeSysuiMultiAction(new LogMaker(category).setType(1).serialize());
    }

    public static void hidden(Context context, int category) throws IllegalArgumentException {
        if (Build.IS_DEBUGGABLE && category == 0) {
            throw new IllegalArgumentException("Must define metric category");
        }
        EventLogTags.writeSysuiViewVisibility(category, 0);
        EventLogTags.writeSysuiMultiAction(new LogMaker(category).setType(2).serialize());
    }

    public static void visibility(Context context, int category, boolean visibile) throws IllegalArgumentException {
        if (visibile) {
            MetricsLogger.visible(context, category);
        } else {
            MetricsLogger.hidden(context, category);
        }
    }

    public static void visibility(Context context, int category, int vis) throws IllegalArgumentException {
        MetricsLogger.visibility(context, category, vis == 0);
    }

    public static void action(Context context, int category) {
        EventLogTags.writeSysuiAction(category, "");
        EventLogTags.writeSysuiMultiAction(new LogMaker(category).setType(4).serialize());
    }

    public static void action(Context context, int category, int value) {
        EventLogTags.writeSysuiAction(category, Integer.toString(value));
        EventLogTags.writeSysuiMultiAction(new LogMaker(category).setType(4).setSubtype(value).serialize());
    }

    public static void action(Context context, int category, boolean value) {
        EventLogTags.writeSysuiAction(category, Boolean.toString(value));
        EventLogTags.writeSysuiMultiAction(new LogMaker(category).setType(4).setSubtype(value ? 1 : 0).serialize());
    }

    public static void action(LogMaker content) {
        if (content.getType() == 0) {
            content.setType(4);
        }
        EventLogTags.writeSysuiMultiAction(content.serialize());
    }

    public static void action(Context context, int category, String pkg) {
        if (Build.IS_DEBUGGABLE && category == 0) {
            throw new IllegalArgumentException("Must define metric category");
        }
        EventLogTags.writeSysuiAction(category, pkg);
        EventLogTags.writeSysuiMultiAction(new LogMaker(category).setType(4).setPackageName(pkg).serialize());
    }

    public static void count(Context context, String name, int value) {
        EventLogTags.writeSysuiCount(name, value);
        EventLogTags.writeSysuiMultiAction(new LogMaker(803).setCounterName(name).setCounterValue(value).serialize());
    }

    public static void histogram(Context context, String name, int bucket) {
        EventLogTags.writeSysuiHistogram(name, bucket);
        EventLogTags.writeSysuiMultiAction(new LogMaker(804).setCounterName(name).setCounterBucket(bucket).setCounterValue(1).serialize());
    }
}

