/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.logging.legacy;

import android.util.ArrayMap;
import android.util.EventLog;
import android.util.Log;
import com.android.internal.logging.legacy.LegacyConversionLogger;
import com.android.internal.logging.legacy.PowerScreenStateParser;
import com.android.internal.logging.legacy.SysuiMultiActionParser;
import com.android.internal.logging.legacy.TagParser;
import com.android.internal.logging.legacy.TronLogger;
import com.android.internal.logging.legacy.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;

public class EventLogCollector {
    private static final String TAG = "EventLogCollector";
    static final int TRON_HEARTBEAT = 208000;
    private static EventLogCollector sInstance;
    private final ArrayMap<Integer, TagParser> mTagParsers = new ArrayMap();
    private int[] mInterestingTags;
    private LogReader mLogReader;

    private EventLogCollector() {
        this.addParser(new PowerScreenStateParser());
        this.addParser(new SysuiMultiActionParser());
        this.mLogReader = new LogReader();
    }

    public static EventLogCollector getInstance() {
        if (sInstance == null) {
            sInstance = new EventLogCollector();
        }
        return sInstance;
    }

    public void setLogReader(LogReader logReader) {
        this.mLogReader = logReader;
    }

    private int[] getInterestingTags() {
        if (this.mInterestingTags == null) {
            this.mInterestingTags = new int[this.mTagParsers.size()];
            for (int i = 0; i < this.mTagParsers.size(); ++i) {
                this.mInterestingTags[i] = this.mTagParsers.valueAt(i).getTag();
            }
        }
        return this.mInterestingTags;
    }

    void addParser(TagParser parser) {
        this.mTagParsers.put(parser.getTag(), parser);
        this.mInterestingTags = null;
    }

    public void collect(LegacyConversionLogger logger) {
        this.collect(logger, 0L);
    }

    public long collect(TronLogger logger, long lastSeenEventMs) {
        long lastEventMs = 0L;
        boolean debug = Util.debug();
        if (debug) {
            Log.d(TAG, "Eventlog Collection");
        }
        ArrayList<Event> events = new ArrayList<Event>();
        try {
            this.mLogReader.readEvents(this.getInterestingTags(), events);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (debug) {
            Log.d(TAG, "read this many events: " + events.size());
        }
        for (Event event : events) {
            long millis = event.getTimeNanos() / 1000000L;
            if (millis > lastSeenEventMs) {
                int tag = event.getTag();
                TagParser parser = this.mTagParsers.get(tag);
                if (parser == null) {
                    if (!debug) continue;
                    Log.d(TAG, "unknown tag: " + tag);
                    continue;
                }
                if (debug) {
                    Log.d(TAG, "parsing tag: " + tag);
                }
                parser.parseEvent(logger, event);
                lastEventMs = Math.max(lastEventMs, millis);
                continue;
            }
            if (!debug) continue;
            Log.d(TAG, "old event: " + millis + " < " + lastSeenEventMs);
        }
        return lastEventMs;
    }

    static class LogReader {
        LogReader() {
        }

        public void readEvents(int[] tags, Collection<Event> events) throws IOException {
            ArrayList<EventLog.Event> nativeEvents = new ArrayList<EventLog.Event>();
            EventLog.readEventsOnWrapping(tags, 0L, nativeEvents);
            for (EventLog.Event nativeEvent : nativeEvents) {
                Event event = new Event(nativeEvent);
                events.add(event);
            }
        }
    }

    static class Event {
        long mTimeNanos;
        int mTag;
        Object mData;

        Event(long timeNanos, int tag, Object data) {
            this.mTimeNanos = timeNanos;
            this.mTag = tag;
            this.mData = data;
        }

        Event(EventLog.Event event) {
            this.mTimeNanos = event.getTimeNanos();
            this.mTag = event.getTag();
            this.mData = event.getData();
        }

        public long getTimeNanos() {
            return this.mTimeNanos;
        }

        public int getTag() {
            return this.mTag;
        }

        public Object getData() {
            return this.mData;
        }
    }
}

