/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.logging.legacy;

import android.metrics.LogMaker;
import android.util.Log;
import com.android.internal.logging.legacy.EventLogCollector;
import com.android.internal.logging.legacy.TronLogger;
import com.android.internal.logging.legacy.Util;

public abstract class TagParser {
    private static final String TAG = "TagParser";
    protected int mSinceCreationMillis;
    protected int mSinceUpdateMillis;
    protected int mSinceVisibleMillis;

    abstract int getTag();

    public abstract void parseEvent(TronLogger var1, long var2, Object[] var4);

    public void parseEvent(TronLogger logger, EventLogCollector.Event event) {
        Object[] objects;
        boolean debug = Util.debug();
        Object data = event.getData();
        if (data instanceof Object[]) {
            objects = (Object[])data;
            for (int i = 0; i < objects.length; ++i) {
                if (objects[i] != null) continue;
                if (debug) {
                    Log.d(TAG, "unexpected null value:" + event.getTag());
                }
                return;
            }
        } else {
            objects = new Object[]{data};
        }
        this.parseEvent(logger, event.getTimeNanos() / 1000000L, objects);
    }

    protected void resetTimes() {
        this.mSinceCreationMillis = 0;
        this.mSinceUpdateMillis = 0;
        this.mSinceVisibleMillis = 0;
    }

    public void parseTimes(Object[] operands, int index) {
        this.resetTimes();
        if (operands.length > index && operands[index] instanceof Integer) {
            this.mSinceCreationMillis = (Integer)operands[index];
        }
        if (operands.length > ++index && operands[index] instanceof Integer) {
            this.mSinceUpdateMillis = (Integer)operands[index];
        }
        if (operands.length > ++index && operands[index] instanceof Integer) {
            this.mSinceVisibleMillis = (Integer)operands[index];
        }
    }

    public void filltimes(LogMaker proto) {
        if (this.mSinceCreationMillis != 0) {
            proto.addTaggedData(793, this.mSinceCreationMillis);
        }
        if (this.mSinceUpdateMillis != 0) {
            proto.addTaggedData(795, this.mSinceUpdateMillis);
        }
        if (this.mSinceVisibleMillis != 0) {
            proto.addTaggedData(794, this.mSinceVisibleMillis);
        }
    }
}

