/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.os.BatteryStats;
import android.util.ArrayMap;
import com.android.internal.os.BatterySipper;
import com.android.internal.os.PowerCalculator;
import com.android.internal.os.PowerProfile;

public class CpuPowerCalculator
extends PowerCalculator {
    private static final String TAG = "CpuPowerCalculator";
    private static final boolean DEBUG = false;
    private final PowerProfile mProfile;

    public CpuPowerCalculator(PowerProfile profile) {
        this.mProfile = profile;
    }

    @Override
    public void calculateApp(BatterySipper app, BatteryStats.Uid u, long rawRealtimeUs, long rawUptimeUs, int statsType) {
        app.cpuTimeMs = (u.getUserCpuTimeUs(statsType) + u.getSystemCpuTimeUs(statsType)) / 1000L;
        long totalTime = 0L;
        int numClusters = this.mProfile.getNumCpuClusters();
        for (int cluster = 0; cluster < numClusters; ++cluster) {
            int speedsForCluster = this.mProfile.getNumSpeedStepsInCpuCluster(cluster);
            for (int speed = 0; speed < speedsForCluster; ++speed) {
                totalTime += u.getTimeAtCpuSpeed(cluster, speed, statsType);
            }
        }
        totalTime = Math.max(totalTime, 1L);
        double cpuPowerMaMs = 0.0;
        for (int cluster = 0; cluster < numClusters; ++cluster) {
            int speedsForCluster = this.mProfile.getNumSpeedStepsInCpuCluster(cluster);
            for (int speed = 0; speed < speedsForCluster; ++speed) {
                double ratio = (double)u.getTimeAtCpuSpeed(cluster, speed, statsType) / (double)totalTime;
                double cpuSpeedStepPower = ratio * (double)app.cpuTimeMs * this.mProfile.getAveragePowerForCpu(cluster, speed);
                cpuPowerMaMs += cpuSpeedStepPower;
            }
        }
        app.cpuPowerMah = cpuPowerMaMs / 3600000.0;
        double highestDrain = 0.0;
        app.cpuFgTimeMs = 0L;
        ArrayMap<String, ? extends BatteryStats.Uid.Proc> processStats = u.getProcessStats();
        int processStatsCount = processStats.size();
        for (int i = 0; i < processStatsCount; ++i) {
            BatteryStats.Uid.Proc ps = processStats.valueAt(i);
            String processName = processStats.keyAt(i);
            app.cpuFgTimeMs += ps.getForegroundTime(statsType);
            long costValue = ps.getUserTime(statsType) + ps.getSystemTime(statsType) + ps.getForegroundTime(statsType);
            if (app.packageWithHighestDrain == null || app.packageWithHighestDrain.startsWith("*")) {
                highestDrain = costValue;
                app.packageWithHighestDrain = processName;
                continue;
            }
            if (!(highestDrain < (double)costValue) || processName.startsWith("*")) continue;
            highestDrain = costValue;
            app.packageWithHighestDrain = processName;
        }
        if (app.cpuFgTimeMs > app.cpuTimeMs) {
            app.cpuTimeMs = app.cpuFgTimeMs;
        }
    }
}

