/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.os.ParcelFileDescriptor;
import android.os.ProxyFileDescriptorCallback;
import android.system.ErrnoException;
import android.system.OsConstants;
import android.util.Log;
import android.util.SparseArray;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.util.Preconditions;
import java.io.IOException;
import java.util.concurrent.ThreadFactory;

public class FuseAppLoop {
    private static final String TAG = "FuseAppLoop";
    private static final boolean DEBUG = Log.isLoggable("FuseAppLoop", 3);
    public static final int ROOT_INODE = 1;
    private static final int MIN_INODE = 2;
    private static final ThreadFactory sDefaultThreadFactory = new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, FuseAppLoop.TAG);
        }
    };
    private final Object mLock = new Object();
    private final int mMountPointId;
    private final Thread mThread;
    @GuardedBy(value="mLock")
    private final SparseArray<CallbackEntry> mCallbackMap = new SparseArray();
    @GuardedBy(value="mLock")
    private int mNextInode = 2;

    private FuseAppLoop(int mountPointId, ParcelFileDescriptor fd, ThreadFactory factory) {
        this.mMountPointId = mountPointId;
        final int rawFd = fd.detachFd();
        if (factory == null) {
            factory = sDefaultThreadFactory;
        }
        this.mThread = factory.newThread(new Runnable(){

            @Override
            public void run() {
                FuseAppLoop.this.native_start_loop(rawFd);
            }
        });
    }

    public static FuseAppLoop open(int mountPointId, ParcelFileDescriptor fd, ThreadFactory factory) {
        Preconditions.checkNotNull(fd);
        FuseAppLoop loop = new FuseAppLoop(mountPointId, fd, factory);
        loop.mThread.start();
        return loop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int registerCallback(ProxyFileDescriptorCallback callback) throws UnmountedException, IOException {
        if (this.mThread.getState() == Thread.State.TERMINATED) {
            throw new UnmountedException();
        }
        Object object = this.mLock;
        synchronized (object) {
            int id2;
            if (this.mCallbackMap.size() >= 0x7FFFFFFD) {
                throw new IOException("Too many opened files.");
            }
            do {
                id2 = this.mNextInode++;
                if (this.mNextInode >= 0) continue;
                this.mNextInode = 2;
            } while (this.mCallbackMap.get(id2) != null);
            this.mCallbackMap.put(id2, new CallbackEntry(callback));
            return id2;
        }
    }

    public void unregisterCallback(int id2) {
        this.mCallbackMap.remove(id2);
    }

    public int getMountPointId() {
        return this.mMountPointId;
    }

    private CallbackEntry getCallbackEntryOrThrowLocked(long inode) throws ErrnoException {
        CallbackEntry entry = this.mCallbackMap.get(FuseAppLoop.checkInode(inode));
        if (entry != null) {
            return entry;
        }
        throw new ErrnoException("getCallbackEntry", OsConstants.ENOENT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long onGetSize(long inode) {
        Object object = this.mLock;
        synchronized (object) {
            try {
                return this.getCallbackEntryOrThrowLocked((long)inode).callback.onGetSize();
            }
            catch (ErrnoException exp) {
                return FuseAppLoop.getError(exp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int onOpen(long inode) {
        Object object = this.mLock;
        synchronized (object) {
            try {
                CallbackEntry entry = this.getCallbackEntryOrThrowLocked(inode);
                if (entry.opened) {
                    throw new ErrnoException("onOpen", OsConstants.EMFILE);
                }
                entry.opened = true;
                return (int)inode;
            }
            catch (ErrnoException exp) {
                return FuseAppLoop.getError(exp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int onFsync(long inode) {
        Object object = this.mLock;
        synchronized (object) {
            try {
                this.getCallbackEntryOrThrowLocked((long)inode).callback.onFsync();
                return 0;
            }
            catch (ErrnoException exp) {
                return FuseAppLoop.getError(exp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int onRelease(long inode) {
        Object object = this.mLock;
        synchronized (object) {
            int n;
            try {
                this.getCallbackEntryOrThrowLocked((long)inode).callback.onRelease();
                n = 0;
                this.mCallbackMap.remove(FuseAppLoop.checkInode(inode));
            }
            catch (ErrnoException exp) {
                int n2;
                try {
                    n2 = FuseAppLoop.getError(exp);
                    this.mCallbackMap.remove(FuseAppLoop.checkInode(inode));
                }
                catch (Throwable throwable) {
                    this.mCallbackMap.remove(FuseAppLoop.checkInode(inode));
                    throw throwable;
                }
                return n2;
            }
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int onRead(long inode, long offset, int size, byte[] bytes) {
        Object object = this.mLock;
        synchronized (object) {
            try {
                return this.getCallbackEntryOrThrowLocked((long)inode).callback.onRead(offset, size, bytes);
            }
            catch (ErrnoException exp) {
                return FuseAppLoop.getError(exp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int onWrite(long inode, long offset, int size, byte[] bytes) {
        Object object = this.mLock;
        synchronized (object) {
            try {
                return this.getCallbackEntryOrThrowLocked((long)inode).callback.onWrite(offset, size, bytes);
            }
            catch (ErrnoException exp) {
                return FuseAppLoop.getError(exp);
            }
        }
    }

    private static int getError(ErrnoException exp) {
        return exp.errno != OsConstants.ENOSYS ? -exp.errno : -OsConstants.EIO;
    }

    native boolean native_start_loop(int var1);

    private static int checkInode(long inode) {
        Preconditions.checkArgumentInRange(inode, 2L, Integer.MAX_VALUE, "checkInode");
        return (int)inode;
    }

    private static class CallbackEntry {
        final ProxyFileDescriptorCallback callback;
        boolean opened;

        CallbackEntry(ProxyFileDescriptorCallback callback) {
            Preconditions.checkNotNull(callback);
            this.callback = callback;
        }
    }

    public static class UnmountedException
    extends Exception {
    }
}

