/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.os.Process;
import android.util.Slog;
import com.android.internal.os.KernelWakelockStats;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Iterator;

public class KernelWakelockReader {
    private static final String TAG = "KernelWakelockReader";
    private static int sKernelWakelockUpdateVersion = 0;
    private static final String sWakelockFile = "/proc/wakelocks";
    private static final String sWakeupSourceFile = "/d/wakeup_sources";
    private static final int[] PROC_WAKELOCKS_FORMAT = new int[]{5129, 8201, 9, 9, 9, 8201};
    private static final int[] WAKEUP_SOURCES_FORMAT = new int[]{4105, 8457, 265, 265, 265, 265, 8457};
    private final String[] mProcWakelocksName = new String[3];
    private final long[] mProcWakelocksData = new long[3];

    public final KernelWakelockStats readKernelWakelockStats(KernelWakelockStats staleStats) {
        int len;
        boolean wakeup_sources;
        byte[] buffer = new byte[32768];
        try {
            FileInputStream is;
            try {
                is = new FileInputStream(sWakelockFile);
                wakeup_sources = false;
            }
            catch (FileNotFoundException e) {
                try {
                    is = new FileInputStream(sWakeupSourceFile);
                    wakeup_sources = true;
                }
                catch (FileNotFoundException e2) {
                    Slog.wtf(TAG, "neither /proc/wakelocks nor /d/wakeup_sources exists");
                    return null;
                }
            }
            len = is.read(buffer);
            is.close();
        }
        catch (IOException e) {
            Slog.wtf(TAG, "failed to read kernel wakelocks", e);
            return null;
        }
        if (len > 0) {
            if (len >= buffer.length) {
                Slog.wtf(TAG, "Kernel wake locks exceeded buffer size " + buffer.length);
            }
            for (int i = 0; i < len; ++i) {
                if (buffer[i] != 0) continue;
                len = i;
                break;
            }
        }
        return this.parseProcWakelocks(buffer, len, wakeup_sources, staleStats);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KernelWakelockStats parseProcWakelocks(byte[] wlBuffer, int len, boolean wakeup_sources, KernelWakelockStats staleStats) {
        int endIndex;
        int i;
        for (i = 0; i < len && wlBuffer[i] != 10 && wlBuffer[i] != 0; ++i) {
        }
        int startIndex = endIndex = i + 1;
        KernelWakelockReader kernelWakelockReader = this;
        synchronized (kernelWakelockReader) {
            ++sKernelWakelockUpdateVersion;
            while (endIndex < len) {
                for (endIndex = startIndex; endIndex < len && wlBuffer[endIndex] != 10 && wlBuffer[endIndex] != 0; ++endIndex) {
                }
                if (endIndex > len - 1) break;
                String[] nameStringArray = this.mProcWakelocksName;
                long[] wlData = this.mProcWakelocksData;
                for (int j = startIndex; j < endIndex; ++j) {
                    if ((wlBuffer[j] & 0x80) == 0) continue;
                    wlBuffer[j] = 63;
                }
                boolean parsed = Process.parseProcLine(wlBuffer, startIndex, endIndex, wakeup_sources ? WAKEUP_SOURCES_FORMAT : PROC_WAKELOCKS_FORMAT, nameStringArray, wlData, null);
                String name = nameStringArray[0];
                int count = (int)wlData[1];
                long totalTime = wakeup_sources ? wlData[2] * 1000L : (wlData[2] + 500L) / 1000L;
                if (parsed && name.length() > 0) {
                    if (!staleStats.containsKey(name)) {
                        staleStats.put(name, new KernelWakelockStats.Entry(count, totalTime, sKernelWakelockUpdateVersion));
                    } else {
                        KernelWakelockStats.Entry kwlStats = (KernelWakelockStats.Entry)staleStats.get(name);
                        if (kwlStats.mVersion == sKernelWakelockUpdateVersion) {
                            kwlStats.mCount += count;
                            kwlStats.mTotalTime += totalTime;
                        } else {
                            kwlStats.mCount = count;
                            kwlStats.mTotalTime = totalTime;
                            kwlStats.mVersion = sKernelWakelockUpdateVersion;
                        }
                    }
                } else if (!parsed) {
                    try {
                        Slog.wtf(TAG, "Failed to parse proc line: " + new String(wlBuffer, startIndex, endIndex - startIndex));
                    }
                    catch (Exception e) {
                        Slog.wtf(TAG, "Failed to parse proc line!");
                    }
                }
                startIndex = endIndex + 1;
            }
            Iterator itr = staleStats.values().iterator();
            while (itr.hasNext()) {
                if (((KernelWakelockStats.Entry)itr.next()).mVersion == sKernelWakelockUpdateVersion) continue;
                itr.remove();
            }
            staleStats.kernelWakelockVersion = sKernelWakelockUpdateVersion;
            return staleStats;
        }
    }
}

