/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.app.ApplicationLoaders;
import android.net.LocalSocket;
import android.os.Build;
import android.system.ErrnoException;
import android.system.Os;
import android.text.TextUtils;
import android.util.Log;
import android.webkit.WebViewFactory;
import android.webkit.WebViewFactoryProvider;
import com.android.internal.os.Zygote;
import com.android.internal.os.ZygoteConnection;
import com.android.internal.os.ZygoteServer;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;

class WebViewZygoteInit {
    public static final String TAG = "WebViewZygoteInit";
    private static ZygoteServer sServer;

    WebViewZygoteInit() {
    }

    public static void main(String[] argv) {
        sServer = new WebViewZygoteServer();
        try {
            Os.setpgid(0, 0);
        }
        catch (ErrnoException ex) {
            throw new RuntimeException("Failed to setpgid(0,0)", ex);
        }
        try {
            sServer.registerServerSocket("webview_zygote");
            sServer.runSelectLoop(TextUtils.join((CharSequence)",", Build.SUPPORTED_ABIS));
            sServer.closeServerSocket();
        }
        catch (Zygote.MethodAndArgsCaller caller) {
            caller.run();
        }
        catch (RuntimeException e) {
            Log.e(TAG, "Fatal exception:", e);
        }
        System.exit(0);
    }

    private static class WebViewZygoteConnection
    extends ZygoteConnection {
        WebViewZygoteConnection(LocalSocket socket, String abiList) throws IOException {
            super(socket, abiList);
        }

        @Override
        protected void preload() {
        }

        @Override
        protected boolean isPreloadComplete() {
            return true;
        }

        @Override
        protected boolean handlePreloadPackage(String packagePath, String libsPath) {
            ClassLoader loader = ApplicationLoaders.getDefault().createAndCacheWebViewClassLoader(packagePath, libsPath);
            Zygote.nativeAllowFileAcrossFork(packagePath);
            try {
                Class<WebViewFactoryProvider> providerClass = WebViewFactory.getWebViewProviderClass(loader);
                Object result = providerClass.getMethod("preloadInZygote", new Class[0]).invoke(null, new Object[0]);
                if (!((Boolean)result).booleanValue()) {
                    Log.e(WebViewZygoteInit.TAG, "preloadInZygote returned false");
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                Log.e(WebViewZygoteInit.TAG, "Exception while preloading package", e);
            }
            return false;
        }
    }

    private static class WebViewZygoteServer
    extends ZygoteServer {
        private WebViewZygoteServer() {
        }

        @Override
        protected ZygoteConnection createNewConnection(LocalSocket socket, String abiList) throws IOException {
            return new WebViewZygoteConnection(socket, abiList);
        }
    }
}

