/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.policy;

import android.content.Context;
import android.graphics.Point;
import android.graphics.PointF;
import android.graphics.Rect;
import android.view.Gravity;
import android.view.ViewConfiguration;
import android.widget.Scroller;
import java.io.PrintWriter;
import java.util.ArrayList;

public class PipSnapAlgorithm {
    private static final int SNAP_MODE_CORNERS_ONLY = 0;
    private static final int SNAP_MODE_CORNERS_AND_SIDES = 1;
    private static final int SNAP_MODE_EDGE = 2;
    private static final int SNAP_MODE_CORNERS_AND_EDGES = 3;
    private static final float SCROLL_FRICTION_MULTIPLIER = 8.0f;
    private static final float CORNER_MAGNET_THRESHOLD = 0.3f;
    private final Context mContext;
    private final ArrayList<Integer> mSnapGravities = new ArrayList();
    private final int mDefaultSnapMode = 3;
    private int mSnapMode = 3;
    private Scroller mScroller;
    private int mOrientation = 0;
    private final int mMinimizedVisibleSize;
    private boolean mIsMinimized;

    public PipSnapAlgorithm(Context context) {
        this.mContext = context;
        this.mMinimizedVisibleSize = context.getResources().getDimensionPixelSize(17105171);
        this.onConfigurationChanged();
    }

    public void onConfigurationChanged() {
        this.mOrientation = this.mContext.getResources().getConfiguration().orientation;
        this.calculateSnapTargets();
    }

    public void setMinimized(boolean isMinimized) {
        this.mIsMinimized = isMinimized;
    }

    public Rect findClosestSnapBounds(Rect movementBounds, Rect stackBounds, float velocityX, float velocityY) {
        Rect finalStackBounds = new Rect(stackBounds);
        if (this.mScroller == null) {
            ViewConfiguration viewConfig = ViewConfiguration.get(this.mContext);
            this.mScroller = new Scroller(this.mContext);
            this.mScroller.setFriction(viewConfig.getScrollFriction() * 8.0f);
        }
        this.mScroller.fling(stackBounds.left, stackBounds.top, (int)velocityX, (int)velocityY, movementBounds.left, movementBounds.right, movementBounds.top, movementBounds.bottom);
        finalStackBounds.offsetTo(this.mScroller.getFinalX(), this.mScroller.getFinalY());
        this.mScroller.abortAnimation();
        return this.findClosestSnapBounds(movementBounds, finalStackBounds);
    }

    public Rect findClosestSnapBounds(Rect movementBounds, Rect stackBounds) {
        Rect pipBounds = new Rect(movementBounds.left, movementBounds.top, movementBounds.right + stackBounds.width(), movementBounds.bottom + stackBounds.height());
        Rect newBounds = new Rect(stackBounds);
        if (this.mSnapMode == 3) {
            float thresh;
            Rect tmpBounds = new Rect();
            Point[] snapTargets = new Point[this.mSnapGravities.size()];
            for (int i = 0; i < this.mSnapGravities.size(); ++i) {
                Gravity.apply(this.mSnapGravities.get(i), stackBounds.width(), stackBounds.height(), pipBounds, 0, 0, tmpBounds);
                snapTargets[i] = new Point(tmpBounds.left, tmpBounds.top);
            }
            Point snapTarget = this.findClosestPoint(stackBounds.left, stackBounds.top, snapTargets);
            float distance = this.distanceToPoint(snapTarget, stackBounds.left, stackBounds.top);
            if (distance < (thresh = (float)stackBounds.width() * 0.3f)) {
                newBounds.offsetTo(snapTarget.x, snapTarget.y);
            } else {
                this.snapRectToClosestEdge(stackBounds, movementBounds, newBounds);
            }
        } else if (this.mSnapMode == 2) {
            this.snapRectToClosestEdge(stackBounds, movementBounds, newBounds);
        } else {
            Rect tmpBounds = new Rect();
            Point[] snapTargets = new Point[this.mSnapGravities.size()];
            for (int i = 0; i < this.mSnapGravities.size(); ++i) {
                Gravity.apply(this.mSnapGravities.get(i), stackBounds.width(), stackBounds.height(), pipBounds, 0, 0, tmpBounds);
                snapTargets[i] = new Point(tmpBounds.left, tmpBounds.top);
            }
            Point snapTarget = this.findClosestPoint(stackBounds.left, stackBounds.top, snapTargets);
            newBounds.offsetTo(snapTarget.x, snapTarget.y);
        }
        return newBounds;
    }

    public void applyMinimizedOffset(Rect stackBounds, Rect movementBounds, Point displaySize, Rect stableInsets) {
        if (stackBounds.left <= movementBounds.centerX()) {
            stackBounds.offsetTo(stableInsets.left + this.mMinimizedVisibleSize - stackBounds.width(), stackBounds.top);
        } else {
            stackBounds.offsetTo(displaySize.x - stableInsets.right - this.mMinimizedVisibleSize, stackBounds.top);
        }
    }

    public float getSnapFraction(Rect stackBounds, Rect movementBounds) {
        Rect tmpBounds = new Rect();
        this.snapRectToClosestEdge(stackBounds, movementBounds, tmpBounds);
        float widthFraction = (float)(tmpBounds.left - movementBounds.left) / (float)movementBounds.width();
        float heightFraction = (float)(tmpBounds.top - movementBounds.top) / (float)movementBounds.height();
        if (tmpBounds.top == movementBounds.top) {
            return widthFraction;
        }
        if (tmpBounds.left == movementBounds.right) {
            return 1.0f + heightFraction;
        }
        if (tmpBounds.top == movementBounds.bottom) {
            return 2.0f + (1.0f - widthFraction);
        }
        return 3.0f + (1.0f - heightFraction);
    }

    public void applySnapFraction(Rect stackBounds, Rect movementBounds, float snapFraction) {
        if (snapFraction < 1.0f) {
            int offset = movementBounds.left + (int)(snapFraction * (float)movementBounds.width());
            stackBounds.offsetTo(offset, movementBounds.top);
        } else if (snapFraction < 2.0f) {
            int offset = movementBounds.top + (int)((snapFraction -= 1.0f) * (float)movementBounds.height());
            stackBounds.offsetTo(movementBounds.right, offset);
        } else if (snapFraction < 3.0f) {
            int offset = movementBounds.left + (int)((1.0f - (snapFraction -= 2.0f)) * (float)movementBounds.width());
            stackBounds.offsetTo(offset, movementBounds.bottom);
        } else {
            int offset = movementBounds.top + (int)((1.0f - (snapFraction -= 3.0f)) * (float)movementBounds.height());
            stackBounds.offsetTo(movementBounds.left, offset);
        }
    }

    public void getMovementBounds(Rect stackBounds, Rect insetBounds, Rect movementBoundsOut, int imeHeight) {
        movementBoundsOut.set(insetBounds);
        movementBoundsOut.right = Math.max(insetBounds.left, insetBounds.right - stackBounds.width());
        movementBoundsOut.bottom = Math.max(insetBounds.top, insetBounds.bottom - stackBounds.height());
        movementBoundsOut.bottom -= imeHeight;
    }

    private Point findClosestPoint(int x, int y, Point[] points) {
        Point closestPoint = null;
        float minDistance = Float.MAX_VALUE;
        for (Point p : points) {
            float distance = this.distanceToPoint(p, x, y);
            if (!(distance < minDistance)) continue;
            closestPoint = p;
            minDistance = distance;
        }
        return closestPoint;
    }

    private void snapRectToClosestEdge(Rect stackBounds, Rect movementBounds, Rect boundsOut) {
        int boundedLeft = Math.max(movementBounds.left, Math.min(movementBounds.right, stackBounds.left));
        int boundedTop = Math.max(movementBounds.top, Math.min(movementBounds.bottom, stackBounds.top));
        boundsOut.set(stackBounds);
        if (this.mIsMinimized) {
            boundsOut.offsetTo(boundedLeft, boundsOut.top);
            return;
        }
        int fromLeft = Math.abs(stackBounds.left - movementBounds.left);
        int fromTop = Math.abs(stackBounds.top - movementBounds.top);
        int fromRight = Math.abs(movementBounds.right - stackBounds.left);
        int fromBottom = Math.abs(movementBounds.bottom - stackBounds.top);
        if (fromLeft <= fromTop && fromLeft <= fromRight && fromLeft <= fromBottom) {
            boundsOut.offsetTo(movementBounds.left, boundedTop);
        } else if (fromTop <= fromLeft && fromTop <= fromRight && fromTop <= fromBottom) {
            boundsOut.offsetTo(boundedLeft, movementBounds.top);
        } else if (fromRight < fromLeft && fromRight < fromTop && fromRight < fromBottom) {
            boundsOut.offsetTo(movementBounds.right, boundedTop);
        } else {
            boundsOut.offsetTo(boundedLeft, movementBounds.bottom);
        }
    }

    private float distanceToPoint(Point p, int x, int y) {
        return PointF.length(p.x - x, p.y - y);
    }

    private void calculateSnapTargets() {
        this.mSnapGravities.clear();
        switch (this.mSnapMode) {
            case 1: {
                if (this.mOrientation == 2) {
                    this.mSnapGravities.add(49);
                    this.mSnapGravities.add(81);
                } else {
                    this.mSnapGravities.add(19);
                    this.mSnapGravities.add(21);
                }
            }
            case 0: 
            case 3: {
                this.mSnapGravities.add(51);
                this.mSnapGravities.add(53);
                this.mSnapGravities.add(83);
                this.mSnapGravities.add(85);
                break;
            }
        }
    }

    public void dump(PrintWriter pw, String prefix) {
        String innerPrefix = prefix + "  ";
        pw.println(prefix + PipSnapAlgorithm.class.getSimpleName());
        pw.println(innerPrefix + "mSnapMode=" + this.mSnapMode);
        pw.println(innerPrefix + "mOrientation=" + this.mOrientation);
        pw.println(innerPrefix + "mMinimizedVisibleSize=" + this.mMinimizedVisibleSize);
        pw.println(innerPrefix + "mIsMinimized=" + this.mIsMinimized);
    }
}

