/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.location.Country;
import android.location.CountryDetector;
import android.net.Uri;
import android.provider.ContactsContract;
import android.telephony.PhoneNumberUtils;
import android.telephony.Rlog;
import android.telephony.SubscriptionManager;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import com.android.i18n.phonenumbers.NumberParseException;
import com.android.i18n.phonenumbers.PhoneNumberUtil;
import com.android.i18n.phonenumbers.Phonenumber;
import com.android.i18n.phonenumbers.geocoding.PhoneNumberOfflineGeocoder;
import com.android.internal.telephony.CallerInfoAsyncQuery;
import java.util.Locale;

public class CallerInfo {
    private static final String TAG = "CallerInfo";
    private static final boolean VDBG = Rlog.isLoggable("CallerInfo", 2);
    public static final long USER_TYPE_CURRENT = 0L;
    public static final long USER_TYPE_WORK = 1L;
    public String name;
    public String phoneNumber;
    public String normalizedNumber;
    public String geoDescription;
    public String cnapName;
    public int numberPresentation;
    public int namePresentation;
    public boolean contactExists;
    public String phoneLabel;
    public int numberType;
    public String numberLabel;
    public int photoResource;
    public long contactIdOrZero;
    public boolean needUpdate;
    public Uri contactRefUri;
    public String lookupKey;
    public long userType = 0L;
    public Uri contactDisplayPhotoUri;
    public Uri contactRingtoneUri;
    public boolean shouldSendToVoicemail;
    public Drawable cachedPhoto;
    public Bitmap cachedPhotoIcon;
    public boolean isCachedPhotoCurrent;
    private boolean mIsEmergency = false;
    private boolean mIsVoiceMail = false;

    public static CallerInfo getCallerInfo(Context context, Uri contactRef, Cursor cursor) {
        CallerInfo info = new CallerInfo();
        info.photoResource = 0;
        info.phoneLabel = null;
        info.numberType = 0;
        info.numberLabel = null;
        info.cachedPhoto = null;
        info.isCachedPhotoCurrent = false;
        info.contactExists = false;
        info.userType = 0L;
        if (VDBG) {
            Rlog.v(TAG, "getCallerInfo() based on cursor...");
        }
        if (cursor != null) {
            if (cursor.moveToFirst()) {
                int typeColumnIndex;
                int columnIndex = cursor.getColumnIndex("display_name");
                if (columnIndex != -1) {
                    info.name = cursor.getString(columnIndex);
                }
                if ((columnIndex = cursor.getColumnIndex("number")) != -1) {
                    info.phoneNumber = cursor.getString(columnIndex);
                }
                if ((columnIndex = cursor.getColumnIndex("normalized_number")) != -1) {
                    info.normalizedNumber = cursor.getString(columnIndex);
                }
                if ((columnIndex = cursor.getColumnIndex("label")) != -1 && (typeColumnIndex = cursor.getColumnIndex("type")) != -1) {
                    info.numberType = cursor.getInt(typeColumnIndex);
                    info.numberLabel = cursor.getString(columnIndex);
                    info.phoneLabel = ContactsContract.CommonDataKinds.Phone.getDisplayLabel(context, info.numberType, info.numberLabel).toString();
                }
                if ((columnIndex = CallerInfo.getColumnIndexForPersonId(contactRef, cursor)) != -1) {
                    long contactId = cursor.getLong(columnIndex);
                    if (contactId != 0L && !ContactsContract.Contacts.isEnterpriseContactId(contactId)) {
                        info.contactIdOrZero = contactId;
                        if (VDBG) {
                            Rlog.v(TAG, "==> got info.contactIdOrZero: " + info.contactIdOrZero);
                        }
                    }
                    if (ContactsContract.Contacts.isEnterpriseContactId(contactId)) {
                        info.userType = 1L;
                    }
                } else {
                    Rlog.w(TAG, "Couldn't find contact_id column for " + contactRef);
                }
                columnIndex = cursor.getColumnIndex("lookup");
                if (columnIndex != -1) {
                    info.lookupKey = cursor.getString(columnIndex);
                }
                info.contactDisplayPhotoUri = (columnIndex = cursor.getColumnIndex("photo_uri")) != -1 && cursor.getString(columnIndex) != null ? Uri.parse(cursor.getString(columnIndex)) : null;
                columnIndex = cursor.getColumnIndex("custom_ringtone");
                info.contactRingtoneUri = columnIndex != -1 && cursor.getString(columnIndex) != null ? (TextUtils.isEmpty(cursor.getString(columnIndex)) ? Uri.EMPTY : Uri.parse(cursor.getString(columnIndex))) : null;
                columnIndex = cursor.getColumnIndex("send_to_voicemail");
                info.shouldSendToVoicemail = columnIndex != -1 && cursor.getInt(columnIndex) == 1;
                info.contactExists = true;
            }
            cursor.close();
            cursor = null;
        }
        info.needUpdate = false;
        info.name = CallerInfo.normalize(info.name);
        info.contactRefUri = contactRef;
        return info;
    }

    public static CallerInfo getCallerInfo(Context context, Uri contactRef) {
        CallerInfo info = null;
        ContentResolver cr = CallerInfoAsyncQuery.getCurrentProfileContentResolver(context);
        if (cr != null) {
            try {
                info = CallerInfo.getCallerInfo(context, contactRef, cr.query(contactRef, null, null, null, null));
            }
            catch (RuntimeException re) {
                Rlog.e(TAG, "Error getting caller info.", re);
            }
        }
        return info;
    }

    public static CallerInfo getCallerInfo(Context context, String number) {
        if (VDBG) {
            Rlog.v(TAG, "getCallerInfo() based on number...");
        }
        int subId = SubscriptionManager.getDefaultSubscriptionId();
        return CallerInfo.getCallerInfo(context, number, subId);
    }

    public static CallerInfo getCallerInfo(Context context, String number, int subId) {
        if (TextUtils.isEmpty(number)) {
            return null;
        }
        if (PhoneNumberUtils.isLocalEmergencyNumber(context, number)) {
            return new CallerInfo().markAsEmergency(context);
        }
        if (PhoneNumberUtils.isVoiceMailNumber(subId, number)) {
            return new CallerInfo().markAsVoiceMail();
        }
        Uri contactUri = Uri.withAppendedPath(ContactsContract.PhoneLookup.ENTERPRISE_CONTENT_FILTER_URI, Uri.encode(number));
        CallerInfo info = CallerInfo.getCallerInfo(context, contactUri);
        info = CallerInfo.doSecondaryLookupIfNecessary(context, number, info);
        if (TextUtils.isEmpty(info.phoneNumber)) {
            info.phoneNumber = number;
        }
        return info;
    }

    static CallerInfo doSecondaryLookupIfNecessary(Context context, String number, CallerInfo previousResult) {
        String username;
        if (!previousResult.contactExists && PhoneNumberUtils.isUriNumber(number) && PhoneNumberUtils.isGlobalPhoneNumber(username = PhoneNumberUtils.getUsernameFromUriNumber(number))) {
            previousResult = CallerInfo.getCallerInfo(context, Uri.withAppendedPath(ContactsContract.PhoneLookup.ENTERPRISE_CONTENT_FILTER_URI, Uri.encode(username)));
        }
        return previousResult;
    }

    public boolean isEmergencyNumber() {
        return this.mIsEmergency;
    }

    public boolean isVoiceMailNumber() {
        return this.mIsVoiceMail;
    }

    CallerInfo markAsEmergency(Context context) {
        this.phoneNumber = context.getString(17039776);
        this.photoResource = 17302901;
        this.mIsEmergency = true;
        return this;
    }

    CallerInfo markAsVoiceMail() {
        int subId = SubscriptionManager.getDefaultSubscriptionId();
        return this.markAsVoiceMail(subId);
    }

    CallerInfo markAsVoiceMail(int subId) {
        this.mIsVoiceMail = true;
        try {
            String voiceMailLabel;
            this.phoneNumber = voiceMailLabel = TelephonyManager.getDefault().getVoiceMailAlphaTag(subId);
        }
        catch (SecurityException se) {
            Rlog.e(TAG, "Cannot access VoiceMail.", se);
        }
        return this;
    }

    private static String normalize(String s) {
        if (s == null || s.length() > 0) {
            return s;
        }
        return null;
    }

    private static int getColumnIndexForPersonId(Uri contactRef, Cursor cursor) {
        int columnIndex;
        if (VDBG) {
            Rlog.v(TAG, "- getColumnIndexForPersonId: contactRef URI = '" + contactRef + "'...");
        }
        String url = contactRef.toString();
        String columnName = null;
        if (url.startsWith("content://com.android.contacts/data/phones")) {
            if (VDBG) {
                Rlog.v(TAG, "'data/phones' URI; using RawContacts.CONTACT_ID");
            }
            columnName = "contact_id";
        } else if (url.startsWith("content://com.android.contacts/data")) {
            if (VDBG) {
                Rlog.v(TAG, "'data' URI; using Data.CONTACT_ID");
            }
            columnName = "contact_id";
        } else if (url.startsWith("content://com.android.contacts/phone_lookup")) {
            if (VDBG) {
                Rlog.v(TAG, "'phone_lookup' URI; using PhoneLookup._ID");
            }
            columnName = "_id";
        } else {
            Rlog.w(TAG, "Unexpected prefix for contactRef '" + url + "'");
        }
        int n = columnIndex = columnName != null ? cursor.getColumnIndex(columnName) : -1;
        if (VDBG) {
            Rlog.v(TAG, "==> Using column '" + columnName + "' (columnIndex = " + columnIndex + ") for person_id lookup...");
        }
        return columnIndex;
    }

    public void updateGeoDescription(Context context, String fallbackNumber) {
        String number = TextUtils.isEmpty(this.phoneNumber) ? fallbackNumber : this.phoneNumber;
        this.geoDescription = CallerInfo.getGeoDescription(context, number);
    }

    private static String getGeoDescription(Context context, String number) {
        if (VDBG) {
            Rlog.v(TAG, "getGeoDescription('" + number + "')...");
        }
        if (TextUtils.isEmpty(number)) {
            return null;
        }
        PhoneNumberUtil util = PhoneNumberUtil.getInstance();
        PhoneNumberOfflineGeocoder geocoder = PhoneNumberOfflineGeocoder.getInstance();
        Locale locale = context.getResources().getConfiguration().locale;
        String countryIso = CallerInfo.getCurrentCountryIso(context, locale);
        Phonenumber.PhoneNumber pn = null;
        try {
            if (VDBG) {
                Rlog.v(TAG, "parsing '" + number + "' for countryIso '" + countryIso + "'...");
            }
            pn = util.parse(number, countryIso);
            if (VDBG) {
                Rlog.v(TAG, "- parsed number: " + pn);
            }
        }
        catch (NumberParseException e) {
            Rlog.w(TAG, "getGeoDescription: NumberParseException for incoming number '" + number + "'");
        }
        if (pn != null) {
            String description = geocoder.getDescriptionForNumber(pn, locale);
            if (VDBG) {
                Rlog.v(TAG, "- got description: '" + description + "'");
            }
            return description;
        }
        return null;
    }

    private static String getCurrentCountryIso(Context context, Locale locale) {
        String countryIso = null;
        CountryDetector detector = (CountryDetector)context.getSystemService("country_detector");
        if (detector != null) {
            Country country = detector.detectCountry();
            if (country != null) {
                countryIso = country.getCountryIso();
            } else {
                Rlog.e(TAG, "CountryDetector.detectCountry() returned null.");
            }
        }
        if (countryIso == null) {
            countryIso = locale.getCountry();
            Rlog.w(TAG, "No CountryDetector; falling back to countryIso based on locale: " + countryIso);
        }
        return countryIso;
    }

    protected static String getCurrentCountryIso(Context context) {
        return CallerInfo.getCurrentCountryIso(context, Locale.getDefault());
    }

    public String toString() {
        boolean VERBOSE_DEBUG = false;
        return new StringBuilder(128).append(super.toString() + " { ").append("name " + (this.name == null ? "null" : "non-null")).append(", phoneNumber " + (this.phoneNumber == null ? "null" : "non-null")).append(" }").toString();
    }
}

