/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Handler;
import android.os.Message;
import android.os.PersistableBundle;
import android.provider.Settings;
import android.telephony.CarrierConfigManager;
import android.telephony.Rlog;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.ServiceStateTracker;

public class CarrierServiceStateTracker
extends Handler {
    private static final String LOG_TAG = "CSST";
    protected static final int CARRIER_EVENT_BASE = 100;
    protected static final int CARRIER_EVENT_VOICE_REGISTRATION = 101;
    protected static final int CARRIER_EVENT_VOICE_DEREGISTRATION = 102;
    protected static final int CARRIER_EVENT_DATA_REGISTRATION = 103;
    protected static final int CARRIER_EVENT_DATA_DEREGISTRATION = 104;
    private static final int SHOW_NOTIFICATION = 200;
    private static final int NOTIFICATION_ID = 1000;
    private static final int UNINITIALIZED_DELAY_VALUE = -1;
    private int mDelay = -1;
    private Phone mPhone;
    private boolean mIsPhoneRegistered = false;
    private ServiceStateTracker mSST;
    private final BroadcastReceiver mBroadcastReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            CarrierConfigManager carrierConfigManager = (CarrierConfigManager)context.getSystemService("carrier_config");
            PersistableBundle b = carrierConfigManager.getConfig();
            CarrierServiceStateTracker.this.mDelay = b.getInt("network_notification_delay_int");
            Rlog.i(CarrierServiceStateTracker.LOG_TAG, "reading time to delay notification: " + CarrierServiceStateTracker.this.mDelay);
            CarrierServiceStateTracker.this.handleConfigChanges();
        }
    };

    public CarrierServiceStateTracker(Phone phone, ServiceStateTracker sst) {
        this.mPhone = phone;
        this.mSST = sst;
        phone.getContext().registerReceiver(this.mBroadcastReceiver, new IntentFilter("android.telephony.action.CARRIER_CONFIG_CHANGED"));
    }

    @Override
    public void handleMessage(Message msg) {
        switch (msg.what) {
            case 101: 
            case 103: {
                this.mIsPhoneRegistered = true;
                this.handleConfigChanges();
                break;
            }
            case 102: 
            case 104: {
                if (this.isGlobalModeOrRadioOffOrAirplaneMode()) break;
                this.mIsPhoneRegistered = false;
                this.handleConfigChanges();
                break;
            }
            case 200: {
                this.sendNotification();
            }
        }
    }

    private boolean isGlobalModeOrRadioOffOrAirplaneMode() {
        Context context = this.mPhone.getContext();
        int preferredNetworkSetting = -1;
        int airplaneMode = -1;
        int subId = this.mPhone.getSubId();
        try {
            preferredNetworkSetting = Settings.Global.getInt(context.getContentResolver(), "preferred_network_mode" + subId, Phone.PREFERRED_NT_MODE);
            airplaneMode = Settings.Global.getInt(context.getContentResolver(), "airplane_mode_on", 0);
        }
        catch (Exception e) {
            Rlog.e(LOG_TAG, "Unable to get PREFERRED_NETWORK_MODE.");
            return true;
        }
        return preferredNetworkSetting == 10 || !this.mSST.isRadioOn() || airplaneMode != 0;
    }

    private void handleConfigChanges() {
        if (this.mDelay == -1) {
            this.cancelNotification();
            return;
        }
        if (this.mIsPhoneRegistered) {
            this.cancelNotification();
            Rlog.i(LOG_TAG, "canceling all notifications. ");
        } else {
            Message notificationMsg = this.obtainMessage(200, null);
            Rlog.i(LOG_TAG, "starting timer for notifications. ");
            this.sendMessageDelayed(notificationMsg, this.mDelay);
        }
    }

    private void sendNotification() {
        Context context = this.mPhone.getContext();
        Rlog.i(LOG_TAG, "w/values: ," + this.mIsPhoneRegistered + "," + this.mDelay + "," + this.isGlobalModeOrRadioOffOrAirplaneMode() + "," + this.mSST.isRadioOn());
        if (this.isGlobalModeOrRadioOffOrAirplaneMode() || this.mIsPhoneRegistered) {
            return;
        }
        NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
        Intent notificationIntent = new Intent("android.settings.DATA_ROAMING_SETTINGS");
        PendingIntent settingsIntent = PendingIntent.getActivity(context, 0, notificationIntent, 0x40000000);
        CharSequence title = context.getText(17039403);
        CharSequence details = context.getText(17039402);
        Notification mNotification = new Notification.Builder(context).setWhen(System.currentTimeMillis()).setAutoCancel(true).setSmallIcon(17301642).setContentTitle(title).setColor(context.getResources().getColor(17170762)).setStyle(new Notification.BigTextStyle().bigText(details)).setContentText(details).setContentIntent(settingsIntent).build();
        notificationManager.notify(1000, mNotification);
    }

    private void cancelNotification() {
        Context context = this.mPhone.getContext();
        this.mIsPhoneRegistered = true;
        NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
        notificationManager.cancel(1000);
    }
}

