/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.PersistableBundle;
import android.telephony.CarrierConfigManager;
import android.telephony.Rlog;
import com.android.internal.telephony.Phone;
import java.util.List;

public class CarrierSmsUtils {
    protected static final boolean VDBG = false;
    protected static final String TAG = CarrierSmsUtils.class.getSimpleName();
    private static final String CARRIER_IMS_PACKAGE_KEY = "config_ims_package_override_string";

    public static String getCarrierImsPackageForIntent(Context context, Phone phone, Intent intent) {
        String carrierImsPackage = CarrierSmsUtils.getCarrierImsPackage(context, phone);
        if (carrierImsPackage == null) {
            return null;
        }
        PackageManager packageManager = context.getPackageManager();
        List<ResolveInfo> receivers = packageManager.queryIntentServices(intent, 0);
        for (ResolveInfo info : receivers) {
            if (info.serviceInfo == null) {
                Rlog.e(TAG, "Can't get service information from " + info);
                continue;
            }
            if (!carrierImsPackage.equals(info.serviceInfo.packageName)) continue;
            return carrierImsPackage;
        }
        return null;
    }

    private static String getCarrierImsPackage(Context context, Phone phone) {
        CarrierConfigManager cm = (CarrierConfigManager)context.getSystemService("carrier_config");
        if (cm == null) {
            Rlog.e(TAG, "Failed to retrieve CarrierConfigManager");
            return null;
        }
        PersistableBundle config = cm.getConfigForSubId(phone.getSubId());
        if (config == null) {
            return null;
        }
        return config.getString(CARRIER_IMS_PACKAGE_KEY, null);
    }

    private CarrierSmsUtils() {
    }
}

