/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Message;
import android.os.UserHandle;
import android.telephony.SmsCbMessage;
import android.telephony.SubscriptionManager;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.WakeLockStateMachine;

public class CellBroadcastHandler
extends WakeLockStateMachine {
    private CellBroadcastHandler(Context context, Phone phone) {
        this("CellBroadcastHandler", context, phone);
    }

    protected CellBroadcastHandler(String debugTag, Context context, Phone phone) {
        super(debugTag, context, phone);
    }

    public static CellBroadcastHandler makeCellBroadcastHandler(Context context, Phone phone) {
        CellBroadcastHandler handler = new CellBroadcastHandler(context, phone);
        handler.start();
        return handler;
    }

    @Override
    protected boolean handleSmsMessage(Message message) {
        if (message.obj instanceof SmsCbMessage) {
            this.handleBroadcastSms((SmsCbMessage)message.obj);
            return true;
        }
        this.loge("handleMessage got object of type: " + message.obj.getClass().getName());
        return false;
    }

    protected void handleBroadcastSms(SmsCbMessage message) {
        int appOp;
        String receiverPermission;
        Intent intent;
        if (message.isEmergencyMessage()) {
            this.log("Dispatching emergency SMS CB, SmsCbMessage is: " + message);
            intent = new Intent("android.provider.Telephony.SMS_EMERGENCY_CB_RECEIVED");
            receiverPermission = "android.permission.RECEIVE_EMERGENCY_BROADCAST";
            appOp = 17;
        } else {
            this.log("Dispatching SMS CB, SmsCbMessage is: " + message);
            intent = new Intent("android.provider.Telephony.SMS_CB_RECEIVED");
            receiverPermission = "android.permission.RECEIVE_SMS";
            appOp = 16;
        }
        intent.setComponent(CellBroadcastHandler.getDefaultCellBroadcastReceiverApp(this.mContext));
        intent.putExtra("message", message);
        SubscriptionManager.putPhoneIdAndSubIdExtra(intent, this.mPhone.getPhoneId());
        this.mContext.sendOrderedBroadcastAsUser(intent, UserHandle.ALL, receiverPermission, appOp, this.mReceiver, this.getHandler(), -1, null, null);
    }

    public static ComponentName getDefaultCellBroadcastReceiverApp(Context context) {
        String defaultCellBroadcastReceiver = context.getResources().getString(17039621);
        return ComponentName.unflattenFromString(defaultCellBroadcastReceiver);
    }
}

