/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.os.SystemClock;
import android.telephony.ClientRequestStats;
import android.telephony.Rlog;
import com.android.internal.telephony.ClientWakelockAccountant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ClientWakelockTracker {
    public static final String LOG_TAG = "ClientWakelockTracker";
    public HashMap<String, ClientWakelockAccountant> mClients = new HashMap();
    public ArrayList<ClientWakelockAccountant> mActiveClients = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startTracking(String clientId, int requestId, int token, int numRequestsInQueue) {
        ClientWakelockAccountant client = this.getClientWakelockAccountant(clientId);
        long uptime = SystemClock.uptimeMillis();
        client.startAttributingWakelock(requestId, token, numRequestsInQueue, uptime);
        this.updateConcurrentRequests(numRequestsInQueue, uptime);
        ArrayList<ClientWakelockAccountant> arrayList = this.mActiveClients;
        synchronized (arrayList) {
            if (!this.mActiveClients.contains(client)) {
                this.mActiveClients.add(client);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopTracking(String clientId, int requestId, int token, int numRequestsInQueue) {
        ClientWakelockAccountant client = this.getClientWakelockAccountant(clientId);
        long uptime = SystemClock.uptimeMillis();
        client.stopAttributingWakelock(requestId, token, uptime);
        if (client.getPendingRequestCount() == 0) {
            ArrayList<ClientWakelockAccountant> arrayList = this.mActiveClients;
            synchronized (arrayList) {
                this.mActiveClients.remove(client);
            }
        }
        this.updateConcurrentRequests(numRequestsInQueue, uptime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopTrackingAll() {
        long uptime = SystemClock.uptimeMillis();
        ArrayList<ClientWakelockAccountant> arrayList = this.mActiveClients;
        synchronized (arrayList) {
            for (ClientWakelockAccountant client : this.mActiveClients) {
                client.stopAllPendingRequests(uptime);
            }
            this.mActiveClients.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<ClientRequestStats> getClientRequestStats() {
        ArrayList<ClientRequestStats> list;
        long uptime = SystemClock.uptimeMillis();
        HashMap<String, ClientWakelockAccountant> hashMap = this.mClients;
        synchronized (hashMap) {
            list = new ArrayList<ClientRequestStats>(this.mClients.size());
            for (String key : this.mClients.keySet()) {
                ClientWakelockAccountant client = this.mClients.get(key);
                client.updatePendingRequestWakelockTime(uptime);
                list.add(new ClientRequestStats(client.mRequestStats));
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClientWakelockAccountant getClientWakelockAccountant(String clientId) {
        ClientWakelockAccountant client;
        HashMap<String, ClientWakelockAccountant> hashMap = this.mClients;
        synchronized (hashMap) {
            if (this.mClients.containsKey(clientId)) {
                client = this.mClients.get(clientId);
            } else {
                client = new ClientWakelockAccountant(clientId);
                this.mClients.put(clientId, client);
            }
        }
        return client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateConcurrentRequests(int numRequestsInQueue, long time) {
        if (numRequestsInQueue != 0) {
            ArrayList<ClientWakelockAccountant> arrayList = this.mActiveClients;
            synchronized (arrayList) {
                for (ClientWakelockAccountant cI : this.mActiveClients) {
                    cI.changeConcurrentRequests(numRequestsInQueue, time);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClientActive(String clientId) {
        ClientWakelockAccountant client = this.getClientWakelockAccountant(clientId);
        ArrayList<ClientWakelockAccountant> arrayList = this.mActiveClients;
        synchronized (arrayList) {
            if (this.mActiveClients.contains(client)) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dumpClientRequestTracker() {
        Rlog.d("RILJ", "-------mClients---------------");
        HashMap<String, ClientWakelockAccountant> hashMap = this.mClients;
        synchronized (hashMap) {
            for (String key : this.mClients.keySet()) {
                Rlog.d("RILJ", "Client : " + key);
                Rlog.d("RILJ", this.mClients.get(key).toString());
            }
        }
    }
}

