/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.ComponentName;
import android.content.Context;
import android.net.LocalServerSocket;
import android.os.Looper;
import android.os.ServiceManager;
import android.provider.Settings;
import android.telephony.Rlog;
import android.telephony.TelephonyManager;
import android.util.LocalLog;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.DefaultPhoneNotifier;
import com.android.internal.telephony.GsmCdmaPhone;
import com.android.internal.telephony.ITelephonyRegistry;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.PhoneNotifier;
import com.android.internal.telephony.PhoneSwitcher;
import com.android.internal.telephony.ProxyController;
import com.android.internal.telephony.RIL;
import com.android.internal.telephony.RILConstants;
import com.android.internal.telephony.SmsApplication;
import com.android.internal.telephony.SubscriptionController;
import com.android.internal.telephony.SubscriptionInfoUpdater;
import com.android.internal.telephony.SubscriptionMonitor;
import com.android.internal.telephony.TelephonyComponentFactory;
import com.android.internal.telephony.TelephonyDevController;
import com.android.internal.telephony.cdma.CdmaSubscriptionSourceManager;
import com.android.internal.telephony.dataconnection.TelephonyNetworkFactory;
import com.android.internal.telephony.ims.ImsResolver;
import com.android.internal.telephony.imsphone.ImsPhoneFactory;
import com.android.internal.telephony.sip.SipPhone;
import com.android.internal.telephony.sip.SipPhoneFactory;
import com.android.internal.telephony.uicc.IccCardProxy;
import com.android.internal.telephony.uicc.UiccController;
import com.android.internal.util.IndentingPrintWriter;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;

public class PhoneFactory {
    static final String LOG_TAG = "PhoneFactory";
    static final int SOCKET_OPEN_RETRY_MILLIS = 2000;
    static final int SOCKET_OPEN_MAX_RETRY = 3;
    static final boolean DBG = false;
    static final Object sLockProxyPhones = new Object();
    private static Phone[] sPhones = null;
    private static Phone sPhone = null;
    private static CommandsInterface[] sCommandsInterfaces = null;
    private static ProxyController sProxyController;
    private static UiccController sUiccController;
    private static CommandsInterface sCommandsInterface;
    private static SubscriptionInfoUpdater sSubInfoRecordUpdater;
    private static boolean sMadeDefaults;
    private static PhoneNotifier sPhoneNotifier;
    private static Context sContext;
    private static PhoneSwitcher sPhoneSwitcher;
    private static SubscriptionMonitor sSubscriptionMonitor;
    private static TelephonyNetworkFactory[] sTelephonyNetworkFactories;
    private static ImsResolver sImsResolver;
    private static final HashMap<String, LocalLog> sLocalLogs;
    public static final int MAX_ACTIVE_PHONES = 1;

    public static void makeDefaultPhones(Context context) {
        PhoneFactory.makeDefaultPhone(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void makeDefaultPhone(Context context) {
        Object object = sLockProxyPhones;
        synchronized (object) {
            if (!sMadeDefaults) {
                int i;
                sContext = context;
                TelephonyDevController.create();
                int retryCount = 0;
                while (true) {
                    boolean hasException = false;
                    ++retryCount;
                    try {
                        new LocalServerSocket("com.android.internal.telephony");
                    }
                    catch (IOException ex) {
                        hasException = true;
                    }
                    if (!hasException) break;
                    if (retryCount > 3) {
                        throw new RuntimeException("PhoneFactory probably already running");
                    }
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException ex) {}
                }
                sPhoneNotifier = new DefaultPhoneNotifier();
                int cdmaSubscription = CdmaSubscriptionSourceManager.getDefault(context);
                Rlog.i(LOG_TAG, "Cdma Subscription set to " + cdmaSubscription);
                int numPhones = TelephonyManager.getDefault().getPhoneCount();
                String defaultImsPackage = sContext.getResources().getString(17039645);
                Rlog.i(LOG_TAG, "ImsResolver: defaultImsPackage: " + defaultImsPackage);
                sImsResolver = new ImsResolver(sContext, defaultImsPackage, numPhones);
                sImsResolver.populateCacheAndStartBind();
                int[] networkModes = new int[numPhones];
                sPhones = new Phone[numPhones];
                sCommandsInterfaces = new RIL[numPhones];
                sTelephonyNetworkFactories = new TelephonyNetworkFactory[numPhones];
                for (i = 0; i < numPhones; ++i) {
                    networkModes[i] = RILConstants.PREFERRED_NETWORK_MODE;
                    Rlog.i(LOG_TAG, "Network Mode set to " + Integer.toString(networkModes[i]));
                    PhoneFactory.sCommandsInterfaces[i] = new RIL(context, networkModes[i], cdmaSubscription, i);
                }
                Rlog.i(LOG_TAG, "Creating SubscriptionController");
                SubscriptionController.init(context, sCommandsInterfaces);
                sUiccController = UiccController.make(context, sCommandsInterfaces);
                for (i = 0; i < numPhones; ++i) {
                    GsmCdmaPhone phone = null;
                    int phoneType = TelephonyManager.getPhoneType(networkModes[i]);
                    if (phoneType == 1) {
                        phone = new GsmCdmaPhone(context, sCommandsInterfaces[i], sPhoneNotifier, i, 1, TelephonyComponentFactory.getInstance());
                    } else if (phoneType == 2) {
                        phone = new GsmCdmaPhone(context, sCommandsInterfaces[i], sPhoneNotifier, i, 6, TelephonyComponentFactory.getInstance());
                    }
                    Rlog.i(LOG_TAG, "Creating Phone with type = " + phoneType + " sub = " + i);
                    PhoneFactory.sPhones[i] = phone;
                }
                sPhone = sPhones[0];
                sCommandsInterface = sCommandsInterfaces[0];
                ComponentName componentName = SmsApplication.getDefaultSmsApplication(context, true);
                String packageName = "NONE";
                if (componentName != null) {
                    packageName = componentName.getPackageName();
                }
                Rlog.i(LOG_TAG, "defaultSmsApplication: " + packageName);
                SmsApplication.initSmsPackageMonitor(context);
                sMadeDefaults = true;
                Rlog.i(LOG_TAG, "Creating SubInfoRecordUpdater ");
                sSubInfoRecordUpdater = new SubscriptionInfoUpdater(context, sPhones, sCommandsInterfaces);
                SubscriptionController.getInstance().updatePhonesAvailability(sPhones);
                for (int i2 = 0; i2 < numPhones; ++i2) {
                    sPhones[i2].startMonitoringImsService();
                }
                ITelephonyRegistry tr = ITelephonyRegistry.Stub.asInterface(ServiceManager.getService("telephony.registry"));
                SubscriptionController sc = SubscriptionController.getInstance();
                sSubscriptionMonitor = new SubscriptionMonitor(tr, sContext, sc, numPhones);
                sPhoneSwitcher = new PhoneSwitcher(1, numPhones, sContext, sc, Looper.myLooper(), tr, sCommandsInterfaces, sPhones);
                sProxyController = ProxyController.getInstance(context, sPhones, sUiccController, sCommandsInterfaces, sPhoneSwitcher);
                sTelephonyNetworkFactories = new TelephonyNetworkFactory[numPhones];
                for (int i3 = 0; i3 < numPhones; ++i3) {
                    PhoneFactory.sTelephonyNetworkFactories[i3] = new TelephonyNetworkFactory(sPhoneSwitcher, sc, sSubscriptionMonitor, Looper.myLooper(), sContext, i3, PhoneFactory.sPhones[i3].mDcTracker);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Phone getDefaultPhone() {
        Object object = sLockProxyPhones;
        synchronized (object) {
            if (!sMadeDefaults) {
                throw new IllegalStateException("Default phones haven't been made yet!");
            }
            return sPhone;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Phone getPhone(int phoneId) {
        String dbgInfo = "";
        Object object = sLockProxyPhones;
        synchronized (object) {
            if (!sMadeDefaults) {
                throw new IllegalStateException("Default phones haven't been made yet!");
            }
            Phone phone = phoneId == Integer.MAX_VALUE ? sPhone : (phoneId >= 0 && phoneId < TelephonyManager.getDefault().getPhoneCount() ? sPhones[phoneId] : null);
            return phone;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Phone[] getPhones() {
        Object object = sLockProxyPhones;
        synchronized (object) {
            if (!sMadeDefaults) {
                throw new IllegalStateException("Default phones haven't been made yet!");
            }
            return sPhones;
        }
    }

    public static ImsResolver getImsResolver() {
        return sImsResolver;
    }

    public static SipPhone makeSipPhone(String sipUri) {
        return SipPhoneFactory.makePhone(sipUri, sContext, sPhoneNotifier);
    }

    public static int calculatePreferredNetworkType(Context context, int phoneSubId) {
        int networkType = Settings.Global.getInt(context.getContentResolver(), "preferred_network_mode" + phoneSubId, RILConstants.PREFERRED_NETWORK_MODE);
        Rlog.d(LOG_TAG, "calculatePreferredNetworkType: phoneSubId = " + phoneSubId + " networkType = " + networkType);
        return networkType;
    }

    public static int getDefaultSubscription() {
        return SubscriptionController.getInstance().getDefaultSubId();
    }

    public static boolean isSMSPromptEnabled() {
        boolean prompt = false;
        int value = 0;
        try {
            value = Settings.Global.getInt(sContext.getContentResolver(), "multi_sim_sms_prompt");
        }
        catch (Settings.SettingNotFoundException snfe) {
            Rlog.e(LOG_TAG, "Settings Exception Reading Dual Sim SMS Prompt Values");
        }
        prompt = value != 0;
        Rlog.d(LOG_TAG, "SMS Prompt option:" + prompt);
        return prompt;
    }

    public static Phone makeImsPhone(PhoneNotifier phoneNotifier, Phone defaultPhone) {
        return ImsPhoneFactory.makePhone(sContext, phoneNotifier, defaultPhone);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addLocalLog(String key, int size) {
        HashMap<String, LocalLog> hashMap = sLocalLogs;
        synchronized (hashMap) {
            if (sLocalLogs.containsKey(key)) {
                throw new IllegalArgumentException("key " + key + " already present");
            }
            sLocalLogs.put(key, new LocalLog(size));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void localLog(String key, String log) {
        HashMap<String, LocalLog> hashMap = sLocalLogs;
        synchronized (hashMap) {
            if (!sLocalLogs.containsKey(key)) {
                throw new IllegalArgumentException("key " + key + " not found");
            }
            sLocalLogs.get(key).log(log);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dump(FileDescriptor fd, PrintWriter printwriter, String[] args) {
        IndentingPrintWriter pw = new IndentingPrintWriter((Writer)printwriter, "  ");
        pw.println("PhoneFactory:");
        pw.println(" sMadeDefaults=" + sMadeDefaults);
        sPhoneSwitcher.dump(fd, pw, args);
        pw.println();
        Phone[] phones = PhoneFactory.getPhones();
        for (int i = 0; i < phones.length; ++i) {
            pw.increaseIndent();
            Phone phone = phones[i];
            try {
                phone.dump(fd, pw, args);
            }
            catch (Exception e) {
                pw.println("Telephony DebugService: Could not get Phone[" + i + "] e=" + e);
                continue;
            }
            pw.flush();
            pw.println("++++++++++++++++++++++++++++++++");
            sTelephonyNetworkFactories[i].dump(fd, pw, args);
            pw.flush();
            pw.println("++++++++++++++++++++++++++++++++");
            try {
                ((IccCardProxy)phone.getIccCard()).dump(fd, pw, args);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            pw.flush();
            pw.decreaseIndent();
            pw.println("++++++++++++++++++++++++++++++++");
        }
        pw.println("SubscriptionMonitor:");
        pw.increaseIndent();
        try {
            sSubscriptionMonitor.dump(fd, pw, args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        pw.decreaseIndent();
        pw.println("++++++++++++++++++++++++++++++++");
        pw.println("UiccController:");
        pw.increaseIndent();
        try {
            sUiccController.dump(fd, pw, args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        pw.flush();
        pw.decreaseIndent();
        pw.println("++++++++++++++++++++++++++++++++");
        pw.println("SubscriptionController:");
        pw.increaseIndent();
        try {
            SubscriptionController.getInstance().dump(fd, pw, args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        pw.flush();
        pw.decreaseIndent();
        pw.println("++++++++++++++++++++++++++++++++");
        pw.println("SubInfoRecordUpdater:");
        pw.increaseIndent();
        try {
            sSubInfoRecordUpdater.dump(fd, pw, args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        pw.flush();
        pw.decreaseIndent();
        pw.println("++++++++++++++++++++++++++++++++");
        pw.println("LocalLogs:");
        pw.increaseIndent();
        HashMap<String, LocalLog> hashMap = sLocalLogs;
        synchronized (hashMap) {
            for (String key : sLocalLogs.keySet()) {
                pw.println(key);
                pw.increaseIndent();
                sLocalLogs.get(key).dump(fd, pw, args);
                pw.decreaseIndent();
            }
            pw.flush();
        }
        pw.decreaseIndent();
    }

    static {
        sCommandsInterface = null;
        sSubInfoRecordUpdater = null;
        sMadeDefaults = false;
        sLocalLogs = new HashMap();
    }
}

