/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.PersistableBundle;
import android.os.UserHandle;
import android.telephony.CarrierConfigManager;
import android.telephony.Rlog;
import android.telephony.ServiceState;
import android.util.SparseArray;
import android.util.SparseIntArray;
import com.android.internal.telephony.Phone;

public class RatRatcheter {
    private static final String LOG_TAG = "RilRatcheter";
    private final SparseArray<SparseIntArray> mRatFamilyMap = new SparseArray();
    private final Phone mPhone;
    private BroadcastReceiver mConfigChangedReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if ("android.telephony.action.CARRIER_CONFIG_CHANGED".equals(action)) {
                RatRatcheter.this.resetRatFamilyMap();
            }
        }
    };

    public RatRatcheter(Phone phone) {
        this.mPhone = phone;
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.telephony.action.CARRIER_CONFIG_CHANGED");
        phone.getContext().registerReceiverAsUser(this.mConfigChangedReceiver, UserHandle.ALL, intentFilter, null, null);
        this.resetRatFamilyMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int ratchetRat(int oldRat, int newRat) {
        SparseArray<SparseIntArray> sparseArray = this.mRatFamilyMap;
        synchronized (sparseArray) {
            int newRatRank;
            SparseIntArray oldFamily = this.mRatFamilyMap.get(oldRat);
            if (oldFamily == null) {
                return newRat;
            }
            SparseIntArray newFamily = this.mRatFamilyMap.get(newRat);
            if (newFamily != oldFamily) {
                return newRat;
            }
            int oldRatRank = newFamily.get(oldRat, -1);
            int n = oldRatRank > (newRatRank = newFamily.get(newRat, -1)) ? oldRat : newRat;
            return n;
        }
    }

    public void ratchetRat(ServiceState oldSS, ServiceState newSS) {
        int newVoiceRat = this.ratchetRat(oldSS.getRilVoiceRadioTechnology(), newSS.getRilVoiceRadioTechnology());
        int newDataRat = this.ratchetRat(oldSS.getRilDataRadioTechnology(), newSS.getRilDataRadioTechnology());
        boolean newUsingCA = oldSS.isUsingCarrierAggregation() || newSS.isUsingCarrierAggregation();
        newSS.setRilVoiceRadioTechnology(newVoiceRat);
        newSS.setRilDataRadioTechnology(newDataRat);
        newSS.setIsUsingCarrierAggregation(newUsingCA);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetRatFamilyMap() {
        SparseArray<SparseIntArray> sparseArray = this.mRatFamilyMap;
        synchronized (sparseArray) {
            this.mRatFamilyMap.clear();
            CarrierConfigManager configManager = (CarrierConfigManager)this.mPhone.getContext().getSystemService("carrier_config");
            if (configManager == null) {
                return;
            }
            PersistableBundle b = configManager.getConfig();
            if (b == null) {
                return;
            }
            String[] ratFamilies = b.getStringArray("ratchet_rat_families");
            if (ratFamilies == null) {
                return;
            }
            block5: for (String ratFamily : ratFamilies) {
                String[] rats = ratFamily.split(",");
                if (rats.length < 2) continue;
                SparseIntArray currentFamily = new SparseIntArray(rats.length);
                int pos = 0;
                for (String ratString : rats) {
                    int ratInt;
                    try {
                        ratInt = Integer.parseInt(ratString.trim());
                    }
                    catch (NumberFormatException e) {
                        Rlog.e(LOG_TAG, "NumberFormatException on " + ratString);
                        continue block5;
                    }
                    if (this.mRatFamilyMap.get(ratInt) != null) {
                        Rlog.e(LOG_TAG, "RAT listed twice: " + ratString);
                        continue block5;
                    }
                    currentFamily.put(ratInt, pos++);
                    this.mRatFamilyMap.put(ratInt, currentFamily);
                }
            }
        }
    }
}

