/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony;

import android.app.AppOpsManager;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.Binder;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.UserHandle;
import android.provider.Settings;
import android.telephony.RadioAccessFamily;
import android.telephony.Rlog;
import android.telephony.SubscriptionInfo;
import android.telephony.SubscriptionManager;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.text.format.Time;
import android.util.Log;
import com.android.internal.telephony.CallManager;
import com.android.internal.telephony.CommandsInterface;
import com.android.internal.telephony.ISub;
import com.android.internal.telephony.ITelephonyRegistry;
import com.android.internal.telephony.IccCard;
import com.android.internal.telephony.IccCardConstants;
import com.android.internal.telephony.MccTable;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.PhoneFactory;
import com.android.internal.telephony.ProxyController;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class SubscriptionController
extends ISub.Stub {
    static final String LOG_TAG = "SubscriptionController";
    static final boolean DBG = true;
    static final boolean VDBG = false;
    static final int MAX_LOCAL_LOG_LINES = 500;
    private ScLocalLog mLocalLog = new ScLocalLog(500);
    protected final Object mLock = new Object();
    private static SubscriptionController sInstance = null;
    protected static Phone[] sPhones;
    protected Context mContext;
    protected TelephonyManager mTelephonyManager;
    protected CallManager mCM;
    private AppOpsManager mAppOps;
    private static Map<Integer, Integer> sSlotIdxToSubId;
    private static int mDefaultFallbackSubId;
    private static int mDefaultPhoneId;
    private int[] colorArr;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SubscriptionController init(Phone phone) {
        Class<SubscriptionController> clazz = SubscriptionController.class;
        synchronized (SubscriptionController.class) {
            if (sInstance == null) {
                sInstance = new SubscriptionController(phone);
            } else {
                Log.wtf(LOG_TAG, "init() called multiple times!  sInstance = " + sInstance);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return sInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SubscriptionController init(Context c, CommandsInterface[] ci) {
        Class<SubscriptionController> clazz = SubscriptionController.class;
        synchronized (SubscriptionController.class) {
            if (sInstance == null) {
                sInstance = new SubscriptionController(c);
            } else {
                Log.wtf(LOG_TAG, "init() called multiple times!  sInstance = " + sInstance);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return sInstance;
        }
    }

    public static SubscriptionController getInstance() {
        if (sInstance == null) {
            Log.wtf(LOG_TAG, "getInstance null");
        }
        return sInstance;
    }

    protected SubscriptionController(Context c) {
        this.init(c);
    }

    protected void init(Context c) {
        this.mContext = c;
        this.mCM = CallManager.getInstance();
        this.mTelephonyManager = TelephonyManager.from(this.mContext);
        this.mAppOps = (AppOpsManager)this.mContext.getSystemService("appops");
        if (ServiceManager.getService("isub") == null) {
            ServiceManager.addService("isub", this);
        }
        this.logdl("[SubscriptionController] init by Context");
    }

    private boolean isSubInfoReady() {
        return sSlotIdxToSubId.size() > 0;
    }

    private SubscriptionController(Phone phone) {
        this.mContext = phone.getContext();
        this.mCM = CallManager.getInstance();
        this.mAppOps = this.mContext.getSystemService(AppOpsManager.class);
        if (ServiceManager.getService("isub") == null) {
            ServiceManager.addService("isub", this);
        }
        this.logdl("[SubscriptionController] init by Phone");
    }

    private boolean canReadPhoneState(String callingPackage, String message) {
        try {
            this.mContext.enforceCallingOrSelfPermission("android.permission.READ_PRIVILEGED_PHONE_STATE", message);
            return true;
        }
        catch (SecurityException e) {
            this.mContext.enforceCallingOrSelfPermission("android.permission.READ_PHONE_STATE", message);
            return this.mAppOps.noteOp(51, Binder.getCallingUid(), callingPackage) == 0;
        }
    }

    private void enforceModifyPhoneState(String message) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.MODIFY_PHONE_STATE", message);
    }

    private void broadcastSimInfoContentChanged() {
        Intent intent = new Intent("android.intent.action.ACTION_SUBINFO_CONTENT_CHANGE");
        this.mContext.sendBroadcast(intent);
        intent = new Intent("android.intent.action.ACTION_SUBINFO_RECORD_UPDATED");
        this.mContext.sendBroadcast(intent);
    }

    public void notifySubscriptionInfoChanged() {
        ITelephonyRegistry tr = ITelephonyRegistry.Stub.asInterface(ServiceManager.getService("telephony.registry"));
        try {
            this.logd("notifySubscriptionInfoChanged:");
            tr.notifySubscriptionInfoChanged();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        this.broadcastSimInfoContentChanged();
    }

    private SubscriptionInfo getSubInfoRecord(Cursor cursor) {
        int id2 = cursor.getInt(cursor.getColumnIndexOrThrow("_id"));
        String iccId = cursor.getString(cursor.getColumnIndexOrThrow("icc_id"));
        int simSlotIndex = cursor.getInt(cursor.getColumnIndexOrThrow("sim_id"));
        String displayName = cursor.getString(cursor.getColumnIndexOrThrow("display_name"));
        String carrierName = cursor.getString(cursor.getColumnIndexOrThrow("carrier_name"));
        int nameSource = cursor.getInt(cursor.getColumnIndexOrThrow("name_source"));
        int iconTint = cursor.getInt(cursor.getColumnIndexOrThrow("color"));
        String number = cursor.getString(cursor.getColumnIndexOrThrow("number"));
        int dataRoaming = cursor.getInt(cursor.getColumnIndexOrThrow("data_roaming"));
        Bitmap iconBitmap = BitmapFactory.decodeResource(this.mContext.getResources(), 17302605);
        int mcc = cursor.getInt(cursor.getColumnIndexOrThrow("mcc"));
        int mnc = cursor.getInt(cursor.getColumnIndexOrThrow("mnc"));
        String countryIso = this.getSubscriptionCountryIso(id2);
        String line1Number = this.mTelephonyManager.getLine1Number(id2);
        if (!TextUtils.isEmpty(line1Number) && !line1Number.equals(number)) {
            number = line1Number;
        }
        return new SubscriptionInfo(id2, iccId, simSlotIndex, displayName, carrierName, nameSource, iconTint, number, dataRoaming, iconBitmap, mcc, mnc, countryIso);
    }

    private String getSubscriptionCountryIso(int subId) {
        int phoneId = this.getPhoneId(subId);
        if (phoneId < 0) {
            return "";
        }
        return this.mTelephonyManager.getSimCountryIsoForPhone(phoneId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<SubscriptionInfo> getSubInfo(String selection, Object queryKey) {
        String[] selectionArgs = null;
        if (queryKey != null) {
            selectionArgs = new String[]{queryKey.toString()};
        }
        ArrayList<SubscriptionInfo> subList = null;
        try (Cursor cursor = this.mContext.getContentResolver().query(SubscriptionManager.CONTENT_URI, null, selection, selectionArgs, null);){
            if (cursor != null) {
                while (cursor.moveToNext()) {
                    SubscriptionInfo subInfo = this.getSubInfoRecord(cursor);
                    if (subInfo == null) continue;
                    if (subList == null) {
                        subList = new ArrayList<SubscriptionInfo>();
                    }
                    subList.add(subInfo);
                }
            } else {
                this.logd("Query fail");
            }
        }
        return subList;
    }

    private int getUnusedColor(String callingPackage) {
        List<SubscriptionInfo> availableSubInfos = this.getActiveSubscriptionInfoList(callingPackage);
        this.colorArr = this.mContext.getResources().getIntArray(17236055);
        int colorIdx = 0;
        if (availableSubInfos != null) {
            for (int i = 0; i < this.colorArr.length; ++i) {
                int j;
                for (j = 0; j < availableSubInfos.size() && this.colorArr[i] != availableSubInfos.get(j).getIconTint(); ++j) {
                }
                if (j != availableSubInfos.size()) continue;
                return this.colorArr[i];
            }
            colorIdx = availableSubInfos.size() % this.colorArr.length;
        }
        return this.colorArr[colorIdx];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SubscriptionInfo getActiveSubscriptionInfo(int subId, String callingPackage) {
        if (!this.canReadPhoneState(callingPackage, "getActiveSubscriptionInfo")) {
            return null;
        }
        long identity = Binder.clearCallingIdentity();
        try {
            List<SubscriptionInfo> subList = this.getActiveSubscriptionInfoList(this.mContext.getOpPackageName());
            if (subList != null) {
                for (SubscriptionInfo si : subList) {
                    if (si.getSubscriptionId() != subId) continue;
                    this.logd("[getActiveSubscriptionInfo]+ subId=" + subId + " subInfo=" + si);
                    SubscriptionInfo subscriptionInfo = si;
                    return subscriptionInfo;
                }
            }
            this.logd("[getActiveSubInfoForSubscriber]- subId=" + subId + " subList=" + subList + " subInfo=null");
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SubscriptionInfo getActiveSubscriptionInfoForIccId(String iccId, String callingPackage) {
        if (!this.canReadPhoneState(callingPackage, "getActiveSubscriptionInfoForIccId") || iccId == null) {
            return null;
        }
        long identity = Binder.clearCallingIdentity();
        try {
            List<SubscriptionInfo> subList = this.getActiveSubscriptionInfoList(this.mContext.getOpPackageName());
            if (subList != null) {
                for (SubscriptionInfo si : subList) {
                    if (!iccId.equals(si.getIccId())) continue;
                    this.logd("[getActiveSubInfoUsingIccId]+ iccId=" + iccId + " subInfo=" + si);
                    SubscriptionInfo subscriptionInfo = si;
                    return subscriptionInfo;
                }
            }
            this.logd("[getActiveSubInfoUsingIccId]+ iccId=" + iccId + " subList=" + subList + " subInfo=null");
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SubscriptionInfo getActiveSubscriptionInfoForSimSlotIndex(int slotIdx, String callingPackage) {
        block7: {
            if (!this.canReadPhoneState(callingPackage, "getActiveSubscriptionInfoForSimSlotIndex")) {
                return null;
            }
            long identity = Binder.clearCallingIdentity();
            try {
                List<SubscriptionInfo> subList = this.getActiveSubscriptionInfoList(this.mContext.getOpPackageName());
                if (subList != null) {
                    for (SubscriptionInfo si : subList) {
                        if (si.getSimSlotIndex() != slotIdx) continue;
                        this.logd("[getActiveSubscriptionInfoForSimSlotIndex]+ slotIdx=" + slotIdx + " subId=" + si);
                        SubscriptionInfo subscriptionInfo = si;
                        return subscriptionInfo;
                    }
                    this.logd("[getActiveSubscriptionInfoForSimSlotIndex]+ slotIdx=" + slotIdx + " subId=null");
                    break block7;
                }
                this.logd("[getActiveSubscriptionInfoForSimSlotIndex]+ subList=null");
            }
            finally {
                Binder.restoreCallingIdentity(identity);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SubscriptionInfo> getAllSubInfoList(String callingPackage) {
        this.logd("[getAllSubInfoList]+");
        if (!this.canReadPhoneState(callingPackage, "getAllSubInfoList")) {
            return null;
        }
        long identity = Binder.clearCallingIdentity();
        try {
            List<SubscriptionInfo> subList = null;
            subList = this.getSubInfo(null, null);
            if (subList != null) {
                this.logd("[getAllSubInfoList]- " + subList.size() + " infos return");
            } else {
                this.logd("[getAllSubInfoList]- no info return");
            }
            List<SubscriptionInfo> list = subList;
            return list;
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SubscriptionInfo> getActiveSubscriptionInfoList(String callingPackage) {
        if (!this.canReadPhoneState(callingPackage, "getActiveSubscriptionInfoList")) {
            return null;
        }
        long identity = Binder.clearCallingIdentity();
        try {
            if (!this.isSubInfoReady()) {
                this.logdl("[getActiveSubInfoList] Sub Controller not ready");
                List<SubscriptionInfo> list = null;
                return list;
            }
            List<SubscriptionInfo> subList = this.getSubInfo("sim_id>=0", null);
            if (subList != null) {
                Collections.sort(subList, new Comparator<SubscriptionInfo>(){

                    @Override
                    public int compare(SubscriptionInfo arg0, SubscriptionInfo arg1) {
                        int flag = arg0.getSimSlotIndex() - arg1.getSimSlotIndex();
                        if (flag == 0) {
                            return arg0.getSubscriptionId() - arg1.getSubscriptionId();
                        }
                        return flag;
                    }
                });
            } else {
                this.logdl("[getActiveSubInfoList]- no info return");
            }
            List<SubscriptionInfo> list = subList;
            return list;
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getActiveSubInfoCount(String callingPackage) {
        this.logd("[getActiveSubInfoCount]+");
        if (!this.canReadPhoneState(callingPackage, "getActiveSubInfoCount")) {
            return 0;
        }
        long identity = Binder.clearCallingIdentity();
        try {
            List<SubscriptionInfo> records = this.getActiveSubscriptionInfoList(this.mContext.getOpPackageName());
            if (records == null) {
                this.logd("[getActiveSubInfoCount] records null");
                int n = 0;
                return n;
            }
            this.logd("[getActiveSubInfoCount]- count: " + records.size());
            int n = records.size();
            return n;
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getAllSubInfoCount(String callingPackage) {
        this.logd("[getAllSubInfoCount]+");
        if (!this.canReadPhoneState(callingPackage, "getAllSubInfoCount")) {
            return 0;
        }
        long identity = Binder.clearCallingIdentity();
        try {
            try (Cursor cursor = this.mContext.getContentResolver().query(SubscriptionManager.CONTENT_URI, null, null, null, null);){
                if (cursor != null) {
                    int count = cursor.getCount();
                    this.logd("[getAllSubInfoCount]- " + count + " SUB(s) in DB");
                    int n = count;
                    return n;
                }
            }
            this.logd("[getAllSubInfoCount]- no SUB in DB");
            int n = 0;
            return n;
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    @Override
    public int getActiveSubInfoCountMax() {
        return this.mTelephonyManager.getSimCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int addSubInfoRecord(String iccId, int slotId) {
        this.logdl("[addSubInfoRecord]+ iccId:" + SubscriptionInfo.givePrintableIccid(iccId) + " slotId:" + slotId);
        this.enforceModifyPhoneState("addSubInfoRecord");
        long identity = Binder.clearCallingIdentity();
        try {
            if (iccId == null) {
                this.logdl("[addSubInfoRecord]- null iccId");
                int n = -1;
                return n;
            }
            ContentResolver resolver = this.mContext.getContentResolver();
            Cursor cursor = resolver.query(SubscriptionManager.CONTENT_URI, new String[]{"_id", "sim_id", "name_source"}, "icc_id=?", new String[]{iccId}, null);
            int color2 = this.getUnusedColor(this.mContext.getOpPackageName());
            boolean setDisplayName = false;
            try {
                if (cursor == null || !cursor.moveToFirst()) {
                    setDisplayName = true;
                    ContentValues value = new ContentValues();
                    value.put("icc_id", iccId);
                    value.put("color", color2);
                    value.put("sim_id", slotId);
                    value.put("carrier_name", "");
                    Uri uri = resolver.insert(SubscriptionManager.CONTENT_URI, value);
                    this.logdl("[addSubInfoRecord] New record created: " + uri);
                } else {
                    int subId = cursor.getInt(0);
                    int oldSimInfoId = cursor.getInt(1);
                    int nameSource = cursor.getInt(2);
                    ContentValues value = new ContentValues();
                    if (slotId != oldSimInfoId) {
                        value.put("sim_id", slotId);
                    }
                    if (nameSource != 2) {
                        setDisplayName = true;
                    }
                    if (value.size() > 0) {
                        resolver.update(SubscriptionManager.CONTENT_URI, value, "_id=" + Long.toString(subId), null);
                    }
                    this.logdl("[addSubInfoRecord] Record already exists");
                }
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            cursor = resolver.query(SubscriptionManager.CONTENT_URI, null, "sim_id=?", new String[]{String.valueOf(slotId)}, null);
            try {
                if (cursor != null && cursor.moveToFirst()) {
                    do {
                        int subId = cursor.getInt(cursor.getColumnIndexOrThrow("_id"));
                        Integer currentSubId = sSlotIdxToSubId.get(slotId);
                        if (currentSubId == null || !SubscriptionManager.isValidSubscriptionId(currentSubId)) {
                            sSlotIdxToSubId.put(slotId, subId);
                            int subIdCountMax = this.getActiveSubInfoCountMax();
                            int defaultSubId = this.getDefaultSubId();
                            this.logdl("[addSubInfoRecord] sSlotIdxToSubId.size=" + sSlotIdxToSubId.size() + " slotId=" + slotId + " subId=" + subId + " defaultSubId=" + defaultSubId + " simCount=" + subIdCountMax);
                            if (!SubscriptionManager.isValidSubscriptionId(defaultSubId) || subIdCountMax == 1) {
                                this.setDefaultFallbackSubId(subId);
                            }
                            if (subIdCountMax == 1) {
                                this.logdl("[addSubInfoRecord] one sim set defaults to subId=" + subId);
                                this.setDefaultDataSubId(subId);
                                this.setDefaultSmsSubId(subId);
                                this.setDefaultVoiceSubId(subId);
                            }
                        } else {
                            this.logdl("[addSubInfoRecord] currentSubId != null && currentSubId is valid, IGNORE");
                        }
                        this.logdl("[addSubInfoRecord] hashmap(" + slotId + "," + subId + ")");
                    } while (cursor.moveToNext());
                }
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
            int subId = this.getSubIdUsingPhoneId(slotId);
            if (!SubscriptionManager.isValidSubscriptionId(subId)) {
                this.logdl("[addSubInfoRecord]- getSubId failed invalid subId = " + subId);
                int currentSubId = -1;
                return currentSubId;
            }
            if (setDisplayName) {
                String simCarrierName = this.mTelephonyManager.getSimOperatorName(subId);
                String nameToSet = !TextUtils.isEmpty(simCarrierName) ? simCarrierName : "CARD " + Integer.toString(slotId + 1);
                ContentValues value = new ContentValues();
                value.put("display_name", nameToSet);
                resolver.update(SubscriptionManager.CONTENT_URI, value, "_id=" + Long.toString(subId), null);
                this.logdl("[addSubInfoRecord] sim name = " + nameToSet);
            }
            sPhones[slotId].updateDataConnectionTracker();
            this.logdl("[addSubInfoRecord]- info size=" + sSlotIdxToSubId.size());
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setPlmnSpn(int slotId, boolean showPlmn, String plmn, boolean showSpn, String spn) {
        Object object = this.mLock;
        synchronized (object) {
            int subId = this.getSubIdUsingPhoneId(slotId);
            if (this.mContext.getPackageManager().resolveContentProvider(SubscriptionManager.CONTENT_URI.getAuthority(), 0) == null || !SubscriptionManager.isValidSubscriptionId(subId)) {
                this.logd("[setPlmnSpn] No valid subscription to store info");
                this.notifySubscriptionInfoChanged();
                return false;
            }
            String carrierText = "";
            if (showPlmn) {
                carrierText = plmn;
                if (showSpn && !Objects.equals(spn, plmn)) {
                    String separator = this.mContext.getString(17040031).toString();
                    carrierText = carrierText + separator + spn;
                }
            } else if (showSpn) {
                carrierText = spn;
            }
            this.setCarrierText(carrierText, subId);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int setCarrierText(String text, int subId) {
        this.logd("[setCarrierText]+ text:" + text + " subId:" + subId);
        this.enforceModifyPhoneState("setCarrierText");
        long identity = Binder.clearCallingIdentity();
        try {
            ContentValues value = new ContentValues(1);
            value.put("carrier_name", text);
            int result = this.mContext.getContentResolver().update(SubscriptionManager.CONTENT_URI, value, "_id=" + Long.toString(subId), null);
            this.notifySubscriptionInfoChanged();
            int n = result;
            return n;
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setIconTint(int tint, int subId) {
        this.logd("[setIconTint]+ tint:" + tint + " subId:" + subId);
        this.enforceModifyPhoneState("setIconTint");
        long identity = Binder.clearCallingIdentity();
        try {
            this.validateSubId(subId);
            ContentValues value = new ContentValues(1);
            value.put("color", tint);
            this.logd("[setIconTint]- tint:" + tint + " set");
            int result = this.mContext.getContentResolver().update(SubscriptionManager.CONTENT_URI, value, "_id=" + Long.toString(subId), null);
            this.notifySubscriptionInfoChanged();
            int n = result;
            return n;
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    @Override
    public int setDisplayName(String displayName, int subId) {
        return this.setDisplayNameUsingSrc(displayName, subId, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setDisplayNameUsingSrc(String displayName, int subId, long nameSource) {
        this.logd("[setDisplayName]+  displayName:" + displayName + " subId:" + subId + " nameSource:" + nameSource);
        this.enforceModifyPhoneState("setDisplayNameUsingSrc");
        long identity = Binder.clearCallingIdentity();
        try {
            this.validateSubId(subId);
            String nameToSet = displayName == null ? this.mContext.getString(17039374) : displayName;
            ContentValues value = new ContentValues(1);
            value.put("display_name", nameToSet);
            if (nameSource >= 0L) {
                this.logd("Set nameSource=" + nameSource);
                value.put("name_source", nameSource);
            }
            this.logd("[setDisplayName]- mDisplayName:" + nameToSet + " set");
            int result = this.mContext.getContentResolver().update(SubscriptionManager.CONTENT_URI, value, "_id=" + Long.toString(subId), null);
            this.notifySubscriptionInfoChanged();
            int n = result;
            return n;
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setDisplayNumber(String number, int subId) {
        this.logd("[setDisplayNumber]+ subId:" + subId);
        this.enforceModifyPhoneState("setDisplayNumber");
        long identity = Binder.clearCallingIdentity();
        try {
            this.validateSubId(subId);
            int phoneId = this.getPhoneId(subId);
            if (number == null || phoneId < 0 || phoneId >= this.mTelephonyManager.getPhoneCount()) {
                this.logd("[setDispalyNumber]- fail");
                int n = -1;
                return n;
            }
            ContentValues value = new ContentValues(1);
            value.put("number", number);
            int result = this.mContext.getContentResolver().update(SubscriptionManager.CONTENT_URI, value, "_id=" + Long.toString(subId), null);
            this.logd("[setDisplayNumber]- update result :" + result);
            this.notifySubscriptionInfoChanged();
            int n = result;
            return n;
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setDataRoaming(int roaming, int subId) {
        this.logd("[setDataRoaming]+ roaming:" + roaming + " subId:" + subId);
        this.enforceModifyPhoneState("setDataRoaming");
        long identity = Binder.clearCallingIdentity();
        try {
            this.validateSubId(subId);
            if (roaming < 0) {
                this.logd("[setDataRoaming]- fail");
                int n = -1;
                return n;
            }
            ContentValues value = new ContentValues(1);
            value.put("data_roaming", roaming);
            this.logd("[setDataRoaming]- roaming:" + roaming + " set");
            int result = this.mContext.getContentResolver().update(SubscriptionManager.CONTENT_URI, value, "_id=" + Long.toString(subId), null);
            this.notifySubscriptionInfoChanged();
            int n = result;
            return n;
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    public int setMccMnc(String mccMnc, int subId) {
        int mcc = 0;
        int mnc = 0;
        try {
            mcc = Integer.parseInt(mccMnc.substring(0, 3));
            mnc = Integer.parseInt(mccMnc.substring(3));
        }
        catch (NumberFormatException e) {
            this.loge("[setMccMnc] - couldn't parse mcc/mnc: " + mccMnc);
        }
        this.logd("[setMccMnc]+ mcc/mnc:" + mcc + "/" + mnc + " subId:" + subId);
        ContentValues value = new ContentValues(2);
        value.put("mcc", mcc);
        value.put("mnc", mnc);
        int result = this.mContext.getContentResolver().update(SubscriptionManager.CONTENT_URI, value, "_id=" + Long.toString(subId), null);
        this.notifySubscriptionInfoChanged();
        return result;
    }

    @Override
    public int getSlotId(int subId) {
        if (subId == Integer.MAX_VALUE) {
            subId = this.getDefaultSubId();
        }
        if (!SubscriptionManager.isValidSubscriptionId(subId)) {
            this.logd("[getSlotId]- subId invalid");
            return -1;
        }
        int size = sSlotIdxToSubId.size();
        if (size == 0) {
            this.logd("[getSlotId]- size == 0, return SIM_NOT_INSERTED instead");
            return -1;
        }
        for (Map.Entry<Integer, Integer> entry : sSlotIdxToSubId.entrySet()) {
            int sim = entry.getKey();
            int sub = entry.getValue();
            if (subId != sub) continue;
            return sim;
        }
        this.logd("[getSlotId]- return fail");
        return -1;
    }

    @Override
    @Deprecated
    public int[] getSubId(int slotIdx) {
        if (slotIdx == Integer.MAX_VALUE) {
            slotIdx = this.getSlotId(this.getDefaultSubId());
        }
        if (!SubscriptionManager.isValidSlotId(slotIdx)) {
            this.logd("[getSubId]- invalid slotIdx=" + slotIdx);
            return null;
        }
        int size = sSlotIdxToSubId.size();
        if (size == 0) {
            return this.getDummySubIds(slotIdx);
        }
        ArrayList<Integer> subIds = new ArrayList<Integer>();
        for (Map.Entry<Integer, Integer> entry : sSlotIdxToSubId.entrySet()) {
            int slot = entry.getKey();
            int sub = entry.getValue();
            if (slotIdx != slot) continue;
            subIds.add(sub);
        }
        int numSubIds = subIds.size();
        if (numSubIds > 0) {
            int[] subIdArr = new int[numSubIds];
            for (int i = 0; i < numSubIds; ++i) {
                subIdArr[i] = (Integer)subIds.get(i);
            }
            return subIdArr;
        }
        this.logd("[getSubId]- numSubIds == 0, return DummySubIds slotIdx=" + slotIdx);
        return this.getDummySubIds(slotIdx);
    }

    @Override
    public int getPhoneId(int subId) {
        if (subId == Integer.MAX_VALUE) {
            subId = this.getDefaultSubId();
            this.logdl("[getPhoneId] asked for default subId=" + subId);
        }
        if (!SubscriptionManager.isValidSubscriptionId(subId)) {
            return -1;
        }
        int size = sSlotIdxToSubId.size();
        if (size == 0) {
            int phoneId = mDefaultPhoneId;
            this.logdl("[getPhoneId]- no sims, returning default phoneId=" + phoneId);
            return phoneId;
        }
        for (Map.Entry<Integer, Integer> entry : sSlotIdxToSubId.entrySet()) {
            int sim = entry.getKey();
            int sub = entry.getValue();
            if (subId != sub) continue;
            return sim;
        }
        int phoneId = mDefaultPhoneId;
        this.logdl("[getPhoneId]- subId=" + subId + " not found return default phoneId=" + phoneId);
        return phoneId;
    }

    private int[] getDummySubIds(int slotIdx) {
        int numSubs = this.getActiveSubInfoCountMax();
        if (numSubs > 0) {
            int[] dummyValues = new int[numSubs];
            for (int i = 0; i < numSubs; ++i) {
                dummyValues[i] = -2 - slotIdx;
            }
            return dummyValues;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int clearSubInfo() {
        this.enforceModifyPhoneState("clearSubInfo");
        long identity = Binder.clearCallingIdentity();
        try {
            int size = sSlotIdxToSubId.size();
            if (size == 0) {
                this.logdl("[clearSubInfo]- no simInfo size=" + size);
                int n = 0;
                return n;
            }
            sSlotIdxToSubId.clear();
            this.logdl("[clearSubInfo]- clear size=" + size);
            int n = size;
            return n;
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    private void logvl(String msg) {
        this.logv(msg);
        this.mLocalLog.log(msg);
    }

    private void logv(String msg) {
        Rlog.v(LOG_TAG, msg);
    }

    private void logdl(String msg) {
        this.logd(msg);
        this.mLocalLog.log(msg);
    }

    private static void slogd(String msg) {
        Rlog.d(LOG_TAG, msg);
    }

    private void logd(String msg) {
        Rlog.d(LOG_TAG, msg);
    }

    private void logel(String msg) {
        this.loge(msg);
        this.mLocalLog.log(msg);
    }

    private void loge(String msg) {
        Rlog.e(LOG_TAG, msg);
    }

    @Override
    public int getDefaultSubId() {
        boolean isVoiceCapable = this.mContext.getResources().getBoolean(17957029);
        int subId = isVoiceCapable ? this.getDefaultVoiceSubId() : this.getDefaultDataSubId();
        if (!this.isActiveSubId(subId)) {
            subId = mDefaultFallbackSubId;
        }
        return subId;
    }

    @Override
    public void setDefaultSmsSubId(int subId) {
        this.enforceModifyPhoneState("setDefaultSmsSubId");
        if (subId == Integer.MAX_VALUE) {
            throw new RuntimeException("setDefaultSmsSubId called with DEFAULT_SUB_ID");
        }
        this.logdl("[setDefaultSmsSubId] subId=" + subId);
        Settings.Global.putInt(this.mContext.getContentResolver(), "multi_sim_sms", subId);
        this.broadcastDefaultSmsSubIdChanged(subId);
    }

    private void broadcastDefaultSmsSubIdChanged(int subId) {
        this.logdl("[broadcastDefaultSmsSubIdChanged] subId=" + subId);
        Intent intent = new Intent("android.intent.action.ACTION_DEFAULT_SMS_SUBSCRIPTION_CHANGED");
        intent.addFlags(0x21000000);
        intent.putExtra("subscription", subId);
        this.mContext.sendStickyBroadcastAsUser(intent, UserHandle.ALL);
    }

    @Override
    public int getDefaultSmsSubId() {
        int subId = Settings.Global.getInt(this.mContext.getContentResolver(), "multi_sim_sms", -1);
        return subId;
    }

    @Override
    public void setDefaultVoiceSubId(int subId) {
        this.enforceModifyPhoneState("setDefaultVoiceSubId");
        if (subId == Integer.MAX_VALUE) {
            throw new RuntimeException("setDefaultVoiceSubId called with DEFAULT_SUB_ID");
        }
        this.logdl("[setDefaultVoiceSubId] subId=" + subId);
        Settings.Global.putInt(this.mContext.getContentResolver(), "multi_sim_voice_call", subId);
        this.broadcastDefaultVoiceSubIdChanged(subId);
    }

    private void broadcastDefaultVoiceSubIdChanged(int subId) {
        this.logdl("[broadcastDefaultVoiceSubIdChanged] subId=" + subId);
        Intent intent = new Intent("android.intent.action.ACTION_DEFAULT_VOICE_SUBSCRIPTION_CHANGED");
        intent.addFlags(0x21000000);
        intent.putExtra("subscription", subId);
        this.mContext.sendStickyBroadcastAsUser(intent, UserHandle.ALL);
    }

    @Override
    public int getDefaultVoiceSubId() {
        int subId = Settings.Global.getInt(this.mContext.getContentResolver(), "multi_sim_voice_call", -1);
        return subId;
    }

    @Override
    public int getDefaultDataSubId() {
        int subId = Settings.Global.getInt(this.mContext.getContentResolver(), "multi_sim_data_call", -1);
        return subId;
    }

    @Override
    public void setDefaultDataSubId(int subId) {
        this.enforceModifyPhoneState("setDefaultDataSubId");
        if (subId == Integer.MAX_VALUE) {
            throw new RuntimeException("setDefaultDataSubId called with DEFAULT_SUB_ID");
        }
        ProxyController proxyController = ProxyController.getInstance();
        int len = sPhones.length;
        this.logdl("[setDefaultDataSubId] num phones=" + len + ", subId=" + subId);
        if (SubscriptionManager.isValidSubscriptionId(subId)) {
            RadioAccessFamily[] rafs = new RadioAccessFamily[len];
            boolean atLeastOneMatch = false;
            for (int phoneId = 0; phoneId < len; ++phoneId) {
                int raf;
                Phone phone = sPhones[phoneId];
                int id2 = phone.getSubId();
                if (id2 == subId) {
                    raf = proxyController.getMaxRafSupported();
                    atLeastOneMatch = true;
                } else {
                    raf = proxyController.getMinRafSupported();
                }
                this.logdl("[setDefaultDataSubId] phoneId=" + phoneId + " subId=" + id2 + " RAF=" + raf);
                rafs[phoneId] = new RadioAccessFamily(phoneId, raf);
            }
            if (atLeastOneMatch) {
                proxyController.setRadioCapability(rafs);
            } else {
                this.logdl("[setDefaultDataSubId] no valid subId's found - not updating.");
            }
        }
        this.updateAllDataConnectionTrackers();
        Settings.Global.putInt(this.mContext.getContentResolver(), "multi_sim_data_call", subId);
        this.broadcastDefaultDataSubIdChanged(subId);
    }

    private void updateAllDataConnectionTrackers() {
        int len = sPhones.length;
        this.logdl("[updateAllDataConnectionTrackers] sPhones.length=" + len);
        for (int phoneId = 0; phoneId < len; ++phoneId) {
            this.logdl("[updateAllDataConnectionTrackers] phoneId=" + phoneId);
            sPhones[phoneId].updateDataConnectionTracker();
        }
    }

    private void broadcastDefaultDataSubIdChanged(int subId) {
        this.logdl("[broadcastDefaultDataSubIdChanged] subId=" + subId);
        Intent intent = new Intent("android.intent.action.ACTION_DEFAULT_DATA_SUBSCRIPTION_CHANGED");
        intent.addFlags(0x21000000);
        intent.putExtra("subscription", subId);
        this.mContext.sendStickyBroadcastAsUser(intent, UserHandle.ALL);
    }

    private void setDefaultFallbackSubId(int subId) {
        if (subId == Integer.MAX_VALUE) {
            throw new RuntimeException("setDefaultSubId called with DEFAULT_SUB_ID");
        }
        this.logdl("[setDefaultFallbackSubId] subId=" + subId);
        if (SubscriptionManager.isValidSubscriptionId(subId)) {
            int phoneId = this.getPhoneId(subId);
            if (phoneId >= 0 && (phoneId < this.mTelephonyManager.getPhoneCount() || this.mTelephonyManager.getSimCount() == 1)) {
                this.logdl("[setDefaultFallbackSubId] set mDefaultFallbackSubId=" + subId);
                mDefaultFallbackSubId = subId;
                String defaultMccMnc = this.mTelephonyManager.getSimOperatorNumericForPhone(phoneId);
                MccTable.updateMccMncConfiguration(this.mContext, defaultMccMnc, false);
                Intent intent = new Intent("android.intent.action.ACTION_DEFAULT_SUBSCRIPTION_CHANGED");
                intent.addFlags(0x21000000);
                SubscriptionManager.putPhoneIdAndSubIdExtra(intent, phoneId, subId);
                this.logdl("[setDefaultFallbackSubId] broadcast default subId changed phoneId=" + phoneId + " subId=" + subId);
                this.mContext.sendStickyBroadcastAsUser(intent, UserHandle.ALL);
            } else {
                this.logdl("[setDefaultFallbackSubId] not set invalid phoneId=" + phoneId + " subId=" + subId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearDefaultsForInactiveSubIds() {
        this.enforceModifyPhoneState("clearDefaultsForInactiveSubIds");
        long identity = Binder.clearCallingIdentity();
        try {
            List<SubscriptionInfo> records = this.getActiveSubscriptionInfoList(this.mContext.getOpPackageName());
            this.logdl("[clearDefaultsForInactiveSubIds] records: " + records);
            if (this.shouldDefaultBeCleared(records, this.getDefaultDataSubId())) {
                this.logd("[clearDefaultsForInactiveSubIds] clearing default data sub id");
                this.setDefaultDataSubId(-1);
            }
            if (this.shouldDefaultBeCleared(records, this.getDefaultSmsSubId())) {
                this.logdl("[clearDefaultsForInactiveSubIds] clearing default sms sub id");
                this.setDefaultSmsSubId(-1);
            }
            if (this.shouldDefaultBeCleared(records, this.getDefaultVoiceSubId())) {
                this.logdl("[clearDefaultsForInactiveSubIds] clearing default voice sub id");
                this.setDefaultVoiceSubId(-1);
            }
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    private boolean shouldDefaultBeCleared(List<SubscriptionInfo> records, int subId) {
        this.logdl("[shouldDefaultBeCleared: subId] " + subId);
        if (records == null) {
            this.logdl("[shouldDefaultBeCleared] return true no records subId=" + subId);
            return true;
        }
        if (!SubscriptionManager.isValidSubscriptionId(subId)) {
            this.logdl("[shouldDefaultBeCleared] return false only one subId, subId=" + subId);
            return false;
        }
        for (SubscriptionInfo record : records) {
            int id2 = record.getSubscriptionId();
            this.logdl("[shouldDefaultBeCleared] Record.id: " + id2);
            if (id2 != subId) continue;
            this.logdl("[shouldDefaultBeCleared] return false subId is active, subId=" + subId);
            return false;
        }
        this.logdl("[shouldDefaultBeCleared] return true not active subId=" + subId);
        return true;
    }

    public int getSubIdUsingPhoneId(int phoneId) {
        int[] subIds = this.getSubId(phoneId);
        if (subIds == null || subIds.length == 0) {
            return -1;
        }
        return subIds[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SubscriptionInfo> getSubInfoUsingSlotIdWithCheck(int slotId, boolean needCheck, String callingPackage) {
        this.logd("[getSubInfoUsingSlotIdWithCheck]+ slotId:" + slotId);
        if (!this.canReadPhoneState(callingPackage, "getSubInfoUsingSlotIdWithCheck")) {
            return null;
        }
        long identity = Binder.clearCallingIdentity();
        try {
            if (slotId == Integer.MAX_VALUE) {
                slotId = this.getSlotId(this.getDefaultSubId());
            }
            if (!SubscriptionManager.isValidSlotId(slotId)) {
                this.logd("[getSubInfoUsingSlotIdWithCheck]- invalid slotId");
                List<SubscriptionInfo> list = null;
                return list;
            }
            if (needCheck && !this.isSubInfoReady()) {
                this.logd("[getSubInfoUsingSlotIdWithCheck]- not ready");
                List<SubscriptionInfo> list = null;
                return list;
            }
            ArrayList<SubscriptionInfo> subList = null;
            try (Cursor cursor = this.mContext.getContentResolver().query(SubscriptionManager.CONTENT_URI, null, "sim_id=?", new String[]{String.valueOf(slotId)}, null);){
                if (cursor != null) {
                    while (cursor.moveToNext()) {
                        SubscriptionInfo subInfo = this.getSubInfoRecord(cursor);
                        if (subInfo == null) continue;
                        if (subList == null) {
                            subList = new ArrayList<SubscriptionInfo>();
                        }
                        subList.add(subInfo);
                    }
                }
            }
            this.logd("[getSubInfoUsingSlotId]- null info return");
            ArrayList<SubscriptionInfo> arrayList = subList;
            return arrayList;
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
    }

    private void validateSubId(int subId) {
        this.logd("validateSubId subId: " + subId);
        if (!SubscriptionManager.isValidSubscriptionId(subId)) {
            throw new RuntimeException("Invalid sub id passed as parameter");
        }
        if (subId == Integer.MAX_VALUE) {
            throw new RuntimeException("Default sub id passed as parameter");
        }
    }

    public void updatePhonesAvailability(Phone[] phones) {
        sPhones = phones;
    }

    @Override
    public int[] getActiveSubIdList() {
        Set<Map.Entry<Integer, Integer>> simInfoSet = sSlotIdxToSubId.entrySet();
        int[] subIdArr = new int[simInfoSet.size()];
        int i = 0;
        for (Map.Entry<Integer, Integer> entry : simInfoSet) {
            int sub;
            subIdArr[i] = sub = entry.getValue().intValue();
            ++i;
        }
        return subIdArr;
    }

    @Override
    public boolean isActiveSubId(int subId) {
        boolean retVal = SubscriptionManager.isValidSubscriptionId(subId) && sSlotIdxToSubId.containsValue(subId);
        return retVal;
    }

    @Override
    public int getSimStateForSlotIdx(int slotIdx) {
        IccCardConstants.State simState;
        if (slotIdx < 0) {
            simState = IccCardConstants.State.UNKNOWN;
            String err = "invalid slotIdx";
        } else {
            Phone phone = PhoneFactory.getPhone(slotIdx);
            if (phone == null) {
                simState = IccCardConstants.State.UNKNOWN;
                String err = "phone == null";
            } else {
                IccCard icc = phone.getIccCard();
                if (icc == null) {
                    simState = IccCardConstants.State.UNKNOWN;
                    String err = "icc == null";
                } else {
                    simState = icc.getState();
                    String err = "";
                }
            }
        }
        return simState.ordinal();
    }

    @Override
    public void setSubscriptionProperty(int subId, String propKey, String propValue) {
        this.enforceModifyPhoneState("setSubscriptionProperty");
        long token = Binder.clearCallingIdentity();
        ContentResolver resolver = this.mContext.getContentResolver();
        ContentValues value = new ContentValues();
        switch (propKey) {
            case "enable_cmas_extreme_threat_alerts": 
            case "enable_cmas_severe_threat_alerts": 
            case "enable_cmas_amber_alerts": 
            case "enable_emergency_alerts": 
            case "alert_sound_duration": 
            case "alert_reminder_interval": 
            case "enable_alert_vibrate": 
            case "enable_alert_speech": 
            case "enable_etws_test_alerts": 
            case "enable_channel_50_alerts": 
            case "enable_cmas_test_alerts": 
            case "show_cmas_opt_out_dialog": {
                value.put(propKey, Integer.parseInt(propValue));
                break;
            }
            default: {
                this.logd("Invalid column name");
            }
        }
        resolver.update(SubscriptionManager.CONTENT_URI, value, "_id=" + Integer.toString(subId), null);
        Binder.restoreCallingIdentity(token);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSubscriptionProperty(int subId, String propKey, String callingPackage) {
        if (!this.canReadPhoneState(callingPackage, "getSubInfoUsingSlotIdWithCheck")) {
            return null;
        }
        String resultValue = null;
        ContentResolver resolver = this.mContext.getContentResolver();
        try (Cursor cursor = resolver.query(SubscriptionManager.CONTENT_URI, new String[]{propKey}, "_id=?", new String[]{subId + ""}, null);){
            if (cursor != null) {
                if (cursor.moveToFirst()) {
                    switch (propKey) {
                        case "enable_cmas_extreme_threat_alerts": 
                        case "enable_cmas_severe_threat_alerts": 
                        case "enable_cmas_amber_alerts": 
                        case "enable_emergency_alerts": 
                        case "alert_sound_duration": 
                        case "alert_reminder_interval": 
                        case "enable_alert_vibrate": 
                        case "enable_alert_speech": 
                        case "enable_etws_test_alerts": 
                        case "enable_channel_50_alerts": 
                        case "enable_cmas_test_alerts": 
                        case "show_cmas_opt_out_dialog": {
                            resultValue = cursor.getInt(0) + "";
                            break;
                        }
                        default: {
                            this.logd("Invalid column name");
                            break;
                        }
                    }
                } else {
                    this.logd("Valid row not present in db");
                }
            } else {
                this.logd("Query failed");
            }
        }
        this.logd("getSubscriptionProperty Query value = " + resultValue);
        return resultValue;
    }

    private static void printStackTrace(String msg) {
        RuntimeException re = new RuntimeException();
        SubscriptionController.slogd("StackTrace - " + msg);
        StackTraceElement[] st = re.getStackTrace();
        boolean first = true;
        for (StackTraceElement ste : st) {
            if (first) {
                first = false;
                continue;
            }
            SubscriptionController.slogd(ste.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.DUMP", "Requires DUMP");
        long token = Binder.clearCallingIdentity();
        try {
            pw.println("SubscriptionController:");
            pw.println(" defaultSubId=" + this.getDefaultSubId());
            pw.println(" defaultDataSubId=" + this.getDefaultDataSubId());
            pw.println(" defaultVoiceSubId=" + this.getDefaultVoiceSubId());
            pw.println(" defaultSmsSubId=" + this.getDefaultSmsSubId());
            pw.println(" defaultDataPhoneId=" + SubscriptionManager.from(this.mContext).getDefaultDataPhoneId());
            pw.println(" defaultVoicePhoneId=" + SubscriptionManager.getDefaultVoicePhoneId());
            pw.println(" defaultSmsPhoneId=" + SubscriptionManager.from(this.mContext).getDefaultSmsPhoneId());
            pw.flush();
            for (Map.Entry<Integer, Integer> entry : sSlotIdxToSubId.entrySet()) {
                pw.println(" sSlotIdxToSubId[" + entry.getKey() + "]: subId=" + entry.getValue());
            }
            pw.flush();
            pw.println("++++++++++++++++++++++++++++++++");
            List<SubscriptionInfo> sirl = this.getActiveSubscriptionInfoList(this.mContext.getOpPackageName());
            if (sirl != null) {
                pw.println(" ActiveSubInfoList:");
                for (SubscriptionInfo entry : sirl) {
                    pw.println("  " + entry.toString());
                }
            } else {
                pw.println(" ActiveSubInfoList: is null");
            }
            pw.flush();
            pw.println("++++++++++++++++++++++++++++++++");
            sirl = this.getAllSubInfoList(this.mContext.getOpPackageName());
            if (sirl != null) {
                pw.println(" AllSubInfoList:");
                for (SubscriptionInfo entry : sirl) {
                    pw.println("  " + entry.toString());
                }
            } else {
                pw.println(" AllSubInfoList: is null");
            }
            pw.flush();
            pw.println("++++++++++++++++++++++++++++++++");
            this.mLocalLog.dump(fd, pw, args);
            pw.flush();
            pw.println("++++++++++++++++++++++++++++++++");
            pw.flush();
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    static {
        sSlotIdxToSubId = new ConcurrentHashMap<Integer, Integer>();
        mDefaultFallbackSubId = -1;
        mDefaultPhoneId = Integer.MAX_VALUE;
    }

    static class ScLocalLog {
        private LinkedList<String> mLog = new LinkedList();
        private int mMaxLines;
        private Time mNow;

        public ScLocalLog(int maxLines) {
            this.mMaxLines = maxLines;
            this.mNow = new Time();
        }

        public synchronized void log(String msg) {
            if (this.mMaxLines > 0) {
                int pid = Process.myPid();
                int tid = Process.myTid();
                this.mNow.setToNow();
                this.mLog.add(this.mNow.format("%m-%d %H:%M:%S") + " pid=" + pid + " tid=" + tid + " " + msg);
                while (this.mLog.size() > this.mMaxLines) {
                    this.mLog.remove();
                }
            }
        }

        public synchronized void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
            int LOOPS_PER_FLUSH = 10;
            ListIterator<String> itr = this.mLog.listIterator(0);
            int i = 0;
            while (itr.hasNext()) {
                pw.println(Integer.toString(i++) + ": " + (String)itr.next());
                if (i % 10 != 0) continue;
                pw.flush();
            }
        }
    }
}

