/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.imsphone;

import android.content.Context;
import android.net.Uri;
import android.telephony.PhoneNumberUtils;
import com.android.internal.telephony.Call;
import com.android.internal.telephony.CallStateException;
import com.android.internal.telephony.Connection;
import com.android.internal.telephony.Phone;
import com.android.internal.telephony.UUSInfo;
import com.android.internal.telephony.imsphone.ImsExternalCall;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class ImsExternalConnection
extends Connection {
    private static final String CONFERENCE_PREFIX = "conf";
    private final Context mContext;
    private final Set<Listener> mListeners = Collections.newSetFromMap(new ConcurrentHashMap(8, 0.9f, 1));
    private int mCallId;
    private ImsExternalCall mCall;
    private Uri mOriginalAddress;
    private boolean mIsPullable;

    protected ImsExternalConnection(Phone phone, int callId, Uri address, boolean isPullable) {
        super(phone.getPhoneType());
        this.mContext = phone.getContext();
        this.mCall = new ImsExternalCall(phone, this);
        this.mCallId = callId;
        this.setExternalConnectionAddress(address);
        this.mNumberPresentation = 1;
        this.mIsPullable = isPullable;
        this.rebuildCapabilities();
        this.setActive();
    }

    public int getCallId() {
        return this.mCallId;
    }

    @Override
    public Call getCall() {
        return this.mCall;
    }

    @Override
    public long getDisconnectTime() {
        return 0L;
    }

    @Override
    public long getHoldDurationMillis() {
        return 0L;
    }

    @Override
    public String getVendorDisconnectCause() {
        return null;
    }

    @Override
    public void hangup() throws CallStateException {
    }

    @Override
    public void separate() throws CallStateException {
    }

    @Override
    public void proceedAfterWaitChar() {
    }

    @Override
    public void proceedAfterWildChar(String str) {
    }

    @Override
    public void cancelPostDial() {
    }

    @Override
    public int getNumberPresentation() {
        return this.mNumberPresentation;
    }

    @Override
    public UUSInfo getUUSInfo() {
        return null;
    }

    @Override
    public int getPreciseDisconnectCause() {
        return 0;
    }

    @Override
    public boolean isMultiparty() {
        return false;
    }

    @Override
    public void pullExternalCall() {
        for (Listener listener : this.mListeners) {
            listener.onPullExternalCall(this);
        }
    }

    public void setActive() {
        if (this.mCall == null) {
            return;
        }
        this.mCall.setActive();
    }

    public void setTerminated() {
        if (this.mCall == null) {
            return;
        }
        this.mCall.setTerminated();
    }

    public void setIsPullable(boolean isPullable) {
        this.mIsPullable = isPullable;
        this.rebuildCapabilities();
    }

    public void setExternalConnectionAddress(Uri address) {
        this.mOriginalAddress = address;
        if ("sip".equals(address.getScheme()) && address.getSchemeSpecificPart().startsWith(CONFERENCE_PREFIX)) {
            this.mCnapName = this.mContext.getString(17039603);
            this.mCnapNamePresentation = 1;
            this.mAddress = "";
            this.mNumberPresentation = 2;
            return;
        }
        Uri telUri = PhoneNumberUtils.convertSipUriToTelUri(address);
        this.mAddress = telUri.getSchemeSpecificPart();
    }

    public void addListener(Listener listener) {
        this.mListeners.add(listener);
    }

    public void removeListener(Listener listener) {
        this.mListeners.remove(listener);
    }

    @Override
    public String toString() {
        StringBuilder str = new StringBuilder(128);
        str.append("[ImsExternalConnection dialogCallId:");
        str.append(this.mCallId);
        str.append(" state:");
        if (this.mCall.getState() == Call.State.ACTIVE) {
            str.append("Active");
        } else if (this.mCall.getState() == Call.State.DISCONNECTED) {
            str.append("Disconnected");
        }
        str.append("]");
        return str.toString();
    }

    private void rebuildCapabilities() {
        int capabilities = 16;
        if (this.mIsPullable) {
            capabilities |= 0x20;
        }
        this.setConnectionCapabilities(capabilities);
    }

    public static interface Listener {
        public void onPullExternalCall(ImsExternalConnection var1);
    }
}

