/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.telephony.metrics;

import android.os.SystemClock;
import com.android.internal.telephony.metrics.CallSessionEventBuilder;
import com.android.internal.telephony.metrics.TelephonyMetrics;
import com.android.internal.telephony.nano.TelephonyProto;
import java.util.ArrayDeque;
import java.util.Deque;

public class InProgressCallSession {
    private static final int MAX_EVENTS = 300;
    public final int phoneId;
    public final Deque<TelephonyProto.TelephonyCallSession.Event> events;
    public final int startSystemTimeMin;
    public final long startElapsedTimeMs;
    private long mLastElapsedTimeMs;
    private boolean mEventsDropped = false;

    public boolean isEventsDropped() {
        return this.mEventsDropped;
    }

    public InProgressCallSession(int phoneId) {
        this.phoneId = phoneId;
        this.events = new ArrayDeque<TelephonyProto.TelephonyCallSession.Event>();
        this.startSystemTimeMin = TelephonyMetrics.roundSessionStart(System.currentTimeMillis());
        this.mLastElapsedTimeMs = this.startElapsedTimeMs = SystemClock.elapsedRealtime();
    }

    public void addEvent(CallSessionEventBuilder builder) {
        this.addEvent(SystemClock.elapsedRealtime(), builder);
    }

    public synchronized void addEvent(long timestamp, CallSessionEventBuilder builder) {
        if (this.events.size() >= 300) {
            this.events.removeFirst();
            this.mEventsDropped = true;
        }
        builder.setDelay(TelephonyMetrics.toPrivacyFuzzedTimeInterval(this.mLastElapsedTimeMs, timestamp));
        this.events.add(builder.build());
        this.mLastElapsedTimeMs = timestamp;
    }
}

