/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.content.Context;
import android.text.BoringLayout;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.RemotableViewMethod;
import android.view.View;
import android.widget.RemoteViews;
import android.widget.TextView;

@RemoteViews.RemoteView
public class ImageFloatingTextView
extends TextView {
    private int mIndentLines;
    private int mResolvedDirection = -1;
    private int mMaxLinesForHeight = -1;
    private boolean mFirstMeasure = true;
    private int mLayoutMaxLines = -1;
    private boolean mBlockLayouts;

    public ImageFloatingTextView(Context context) {
        this(context, null);
    }

    public ImageFloatingTextView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ImageFloatingTextView(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public ImageFloatingTextView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    @Override
    protected Layout makeSingleLayout(int wantWidth, BoringLayout.Metrics boring, int ellipsisWidth, Layout.Alignment alignment, boolean shouldEllipsize, TextUtils.TruncateAt effectiveEllipsize, boolean useSaved) {
        CharSequence text = this.getText() == null ? "" : this.getText();
        StaticLayout.Builder builder = StaticLayout.Builder.obtain(text, 0, text.length(), this.getPaint(), wantWidth).setAlignment(alignment).setTextDirection(this.getTextDirectionHeuristic()).setLineSpacing(this.getLineSpacingExtra(), this.getLineSpacingMultiplier()).setIncludePad(this.getIncludeFontPadding()).setBreakStrategy(1).setHyphenationFrequency(2);
        int maxLines = this.mMaxLinesForHeight > 0 ? this.mMaxLinesForHeight : (this.getMaxLines() >= 0 ? this.getMaxLines() : Integer.MAX_VALUE);
        builder.setMaxLines(maxLines);
        this.mLayoutMaxLines = maxLines;
        if (shouldEllipsize) {
            builder.setEllipsize(effectiveEllipsize).setEllipsizedWidth(ellipsisWidth);
        }
        int endMargin = this.getContext().getResources().getDimensionPixelSize(17105146);
        int[] margins = null;
        if (this.mIndentLines > 0) {
            margins = new int[this.mIndentLines + 1];
            for (int i = 0; i < this.mIndentLines; ++i) {
                margins[i] = endMargin;
            }
        }
        if (this.mResolvedDirection == 1) {
            builder.setIndents(margins, null);
        } else {
            builder.setIndents(null, margins);
        }
        return builder.build();
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int height = View.MeasureSpec.getSize(heightMeasureSpec);
        int availableHeight = height - this.mPaddingTop - this.mPaddingBottom;
        int maxLines = availableHeight / this.getLineHeight();
        if (this.getMaxLines() > 0) {
            maxLines = Math.min(this.getMaxLines(), maxLines);
        }
        if (maxLines != this.mMaxLinesForHeight) {
            this.mMaxLinesForHeight = maxLines;
            if (this.getLayout() != null && this.mMaxLinesForHeight != this.mLayoutMaxLines) {
                this.mBlockLayouts = true;
                this.setHint(this.getHint());
                this.mBlockLayouts = false;
            }
        }
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    @Override
    public void requestLayout() {
        if (!this.mBlockLayouts) {
            super.requestLayout();
        }
    }

    @Override
    public void onRtlPropertiesChanged(int layoutDirection) {
        super.onRtlPropertiesChanged(layoutDirection);
        if (layoutDirection != this.mResolvedDirection && this.isLayoutDirectionResolved()) {
            this.mResolvedDirection = layoutDirection;
            if (this.mIndentLines > 0) {
                this.setHint(this.getHint());
            }
        }
    }

    @RemotableViewMethod
    public void setHasImage(boolean hasImage) {
        this.setNumIndentLines(hasImage ? 2 : 0);
    }

    public boolean setNumIndentLines(int lines) {
        if (this.mIndentLines != lines) {
            this.mIndentLines = lines;
            this.setHint(this.getHint());
            return true;
        }
        return false;
    }
}

