/*
 * Decompiled with CFR 0.152.
 */
package com.android.okhttp;

import com.android.okhttp.ConnectionPool;
import libcore.net.event.NetworkEventDispatcher;
import libcore.net.event.NetworkEventListener;

public class ConfigAwareConnectionPool {
    private static final long CONNECTION_POOL_DEFAULT_KEEP_ALIVE_DURATION_MS = 300000L;
    private static final int CONNECTION_POOL_MAX_IDLE_CONNECTIONS;
    private static final long CONNECTION_POOL_KEEP_ALIVE_DURATION_MS;
    private static final ConfigAwareConnectionPool instance;
    private final NetworkEventDispatcher networkEventDispatcher;
    private boolean networkEventListenerRegistered;
    private ConnectionPool connectionPool;

    protected ConfigAwareConnectionPool(NetworkEventDispatcher networkEventDispatcher) {
        this.networkEventDispatcher = networkEventDispatcher;
    }

    private ConfigAwareConnectionPool() {
        this.networkEventDispatcher = NetworkEventDispatcher.getInstance();
    }

    public static ConfigAwareConnectionPool getInstance() {
        return instance;
    }

    public synchronized ConnectionPool get() {
        if (this.connectionPool == null) {
            if (!this.networkEventListenerRegistered) {
                this.networkEventDispatcher.addListener(new NetworkEventListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void onNetworkConfigurationChanged() {
                        ConfigAwareConnectionPool configAwareConnectionPool = ConfigAwareConnectionPool.this;
                        synchronized (configAwareConnectionPool) {
                            ConfigAwareConnectionPool.this.connectionPool = null;
                        }
                    }
                });
                this.networkEventListenerRegistered = true;
            }
            this.connectionPool = new ConnectionPool(CONNECTION_POOL_MAX_IDLE_CONNECTIONS, CONNECTION_POOL_KEEP_ALIVE_DURATION_MS);
        }
        return this.connectionPool;
    }

    static {
        String keepAliveProperty = System.getProperty("http.keepAlive");
        String keepAliveDurationProperty = System.getProperty("http.keepAliveDuration");
        String maxIdleConnectionsProperty = System.getProperty("http.maxConnections");
        long l = CONNECTION_POOL_KEEP_ALIVE_DURATION_MS = keepAliveDurationProperty != null ? Long.parseLong(keepAliveDurationProperty) : 300000L;
        CONNECTION_POOL_MAX_IDLE_CONNECTIONS = keepAliveProperty != null && !Boolean.parseBoolean(keepAliveProperty) ? 0 : (maxIdleConnectionsProperty != null ? Integer.parseInt(maxIdleConnectionsProperty) : 5);
        instance = new ConfigAwareConnectionPool();
    }
}

