/*
 * Decompiled with CFR 0.152.
 */
package com.android.okhttp;

import com.android.okhttp.Headers;
import com.android.okhttp.MediaType;
import com.android.okhttp.RequestBody;
import com.android.okhttp.internal.Util;
import com.android.okhttp.okio.Buffer;
import com.android.okhttp.okio.BufferedSink;
import com.android.okhttp.okio.ByteString;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public final class MultipartBuilder {
    public static final MediaType MIXED = MediaType.parse("multipart/mixed");
    public static final MediaType ALTERNATIVE = MediaType.parse("multipart/alternative");
    public static final MediaType DIGEST = MediaType.parse("multipart/digest");
    public static final MediaType PARALLEL = MediaType.parse("multipart/parallel");
    public static final MediaType FORM = MediaType.parse("multipart/form-data");
    private static final byte[] COLONSPACE = new byte[]{58, 32};
    private static final byte[] CRLF = new byte[]{13, 10};
    private static final byte[] DASHDASH = new byte[]{45, 45};
    private final ByteString boundary;
    private MediaType type = MIXED;
    private final List<Headers> partHeaders = new ArrayList<Headers>();
    private final List<RequestBody> partBodies = new ArrayList<RequestBody>();

    public MultipartBuilder() {
        this(UUID.randomUUID().toString());
    }

    public MultipartBuilder(String boundary) {
        this.boundary = ByteString.encodeUtf8(boundary);
    }

    public MultipartBuilder type(MediaType type) {
        if (type == null) {
            throw new NullPointerException("type == null");
        }
        if (!type.type().equals("multipart")) {
            throw new IllegalArgumentException("multipart != " + type);
        }
        this.type = type;
        return this;
    }

    public MultipartBuilder addPart(RequestBody body) {
        return this.addPart(null, body);
    }

    public MultipartBuilder addPart(Headers headers, RequestBody body) {
        if (body == null) {
            throw new NullPointerException("body == null");
        }
        if (headers != null && headers.get("Content-Type") != null) {
            throw new IllegalArgumentException("Unexpected header: Content-Type");
        }
        if (headers != null && headers.get("Content-Length") != null) {
            throw new IllegalArgumentException("Unexpected header: Content-Length");
        }
        this.partHeaders.add(headers);
        this.partBodies.add(body);
        return this;
    }

    private static StringBuilder appendQuotedString(StringBuilder target, String key) {
        target.append('\"');
        int len = key.length();
        block5: for (int i = 0; i < len; ++i) {
            char ch = key.charAt(i);
            switch (ch) {
                case '\n': {
                    target.append("%0A");
                    continue block5;
                }
                case '\r': {
                    target.append("%0D");
                    continue block5;
                }
                case '\"': {
                    target.append("%22");
                    continue block5;
                }
                default: {
                    target.append(ch);
                }
            }
        }
        target.append('\"');
        return target;
    }

    public MultipartBuilder addFormDataPart(String name, String value) {
        return this.addFormDataPart(name, null, RequestBody.create(null, value));
    }

    public MultipartBuilder addFormDataPart(String name, String filename, RequestBody value) {
        if (name == null) {
            throw new NullPointerException("name == null");
        }
        StringBuilder disposition = new StringBuilder("form-data; name=");
        MultipartBuilder.appendQuotedString(disposition, name);
        if (filename != null) {
            disposition.append("; filename=");
            MultipartBuilder.appendQuotedString(disposition, filename);
        }
        return this.addPart(Headers.of("Content-Disposition", disposition.toString()), value);
    }

    public RequestBody build() {
        if (this.partHeaders.isEmpty()) {
            throw new IllegalStateException("Multipart body must have at least one part.");
        }
        return new MultipartRequestBody(this.type, this.boundary, this.partHeaders, this.partBodies);
    }

    private static final class MultipartRequestBody
    extends RequestBody {
        private final ByteString boundary;
        private final MediaType contentType;
        private final List<Headers> partHeaders;
        private final List<RequestBody> partBodies;
        private long contentLength = -1L;

        public MultipartRequestBody(MediaType type, ByteString boundary, List<Headers> partHeaders, List<RequestBody> partBodies) {
            if (type == null) {
                throw new NullPointerException("type == null");
            }
            this.boundary = boundary;
            this.contentType = MediaType.parse(type + "; boundary=" + boundary.utf8());
            this.partHeaders = Util.immutableList(partHeaders);
            this.partBodies = Util.immutableList(partBodies);
        }

        @Override
        public MediaType contentType() {
            return this.contentType;
        }

        @Override
        public long contentLength() throws IOException {
            long result = this.contentLength;
            if (result != -1L) {
                return result;
            }
            this.contentLength = this.writeOrCountBytes(null, true);
            return this.contentLength;
        }

        private long writeOrCountBytes(BufferedSink sink, boolean countBytes) throws IOException {
            long byteCount = 0L;
            Buffer byteCountBuffer = null;
            if (countBytes) {
                byteCountBuffer = new Buffer();
                sink = byteCountBuffer;
            }
            int partCount = this.partHeaders.size();
            for (int p = 0; p < partCount; ++p) {
                long contentLength;
                MediaType contentType;
                Headers headers = this.partHeaders.get(p);
                RequestBody body = this.partBodies.get(p);
                sink.write(DASHDASH);
                sink.write(this.boundary);
                sink.write(CRLF);
                if (headers != null) {
                    int headerCount = headers.size();
                    for (int h = 0; h < headerCount; ++h) {
                        sink.writeUtf8(headers.name(h)).write(COLONSPACE).writeUtf8(headers.value(h)).write(CRLF);
                    }
                }
                if ((contentType = body.contentType()) != null) {
                    sink.writeUtf8("Content-Type: ").writeUtf8(contentType.toString()).write(CRLF);
                }
                if ((contentLength = body.contentLength()) != -1L) {
                    sink.writeUtf8("Content-Length: ").writeDecimalLong(contentLength).write(CRLF);
                } else if (countBytes) {
                    byteCountBuffer.clear();
                    return -1L;
                }
                sink.write(CRLF);
                if (countBytes) {
                    byteCount += contentLength;
                } else {
                    this.partBodies.get(p).writeTo(sink);
                }
                sink.write(CRLF);
            }
            sink.write(DASHDASH);
            sink.write(this.boundary);
            sink.write(DASHDASH);
            sink.write(CRLF);
            if (countBytes) {
                byteCount += byteCountBuffer.size();
                byteCountBuffer.clear();
            }
            return byteCount;
        }

        @Override
        public void writeTo(BufferedSink sink) throws IOException {
            this.writeOrCountBytes(sink, false);
        }
    }
}

