/*
 * Decompiled with CFR 0.152.
 */
package com.android.org.conscrypt;

import com.android.org.conscrypt.OpenSSLEngineImpl;
import com.android.org.conscrypt.OpenSSLSocketImplWrapper;
import com.android.org.conscrypt.PSKKeyManager;
import com.android.org.conscrypt.SSLParametersImpl;
import com.android.org.conscrypt.util.EmptyArray;
import java.io.EOFException;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import javax.crypto.SecretKey;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.X509KeyManager;
import javax.security.auth.x500.X500Principal;

public final class OpenSSLEngineSocketImpl
extends OpenSSLSocketImplWrapper {
    private static final ByteBuffer EMPTY_BUFFER = ByteBuffer.allocate(0);
    private final OpenSSLEngineImpl engine;
    private final Socket socket;
    private final OutputStreamWrapper outputStreamWrapper;
    private final InputStreamWrapper inputStreamWrapper;
    private boolean handshakeComplete;

    public OpenSSLEngineSocketImpl(Socket socket, String hostname, int port, boolean autoClose, SSLParametersImpl sslParameters) throws IOException {
        super(socket, hostname, port, autoClose, sslParameters);
        this.socket = socket;
        this.engine = new OpenSSLEngineImpl(hostname, port, sslParameters);
        this.outputStreamWrapper = new OutputStreamWrapper();
        this.inputStreamWrapper = new InputStreamWrapper();
        this.engine.setUseClientMode(sslParameters.getUseClientMode());
    }

    @Override
    public void startHandshake() throws IOException {
        boolean beginHandshakeCalled = false;
        block7: while (!this.handshakeComplete) {
            switch (this.engine.getHandshakeStatus()) {
                case NOT_HANDSHAKING: {
                    if (!beginHandshakeCalled) {
                        beginHandshakeCalled = true;
                        this.engine.beginHandshake();
                        continue block7;
                    }
                }
                case FINISHED: {
                    this.completeHandshake();
                    return;
                }
                case NEED_WRAP: {
                    this.outputStreamWrapper.write(OpenSSLEngineSocketImpl.EMPTY_BUFFER);
                    continue block7;
                }
                case NEED_UNWRAP: {
                    if (this.inputStreamWrapper.read(EmptyArray.BYTE) != -1) continue block7;
                    throw new EOFException();
                }
                case NEED_TASK: {
                    throw new IllegalStateException("OpenSSLEngineImpl returned NEED_TASK");
                }
            }
        }
    }

    @Override
    public void onSSLStateChange(int type, int val) {
        throw new AssertionError((Object)"Should be handled by engine");
    }

    @Override
    public void verifyCertificateChain(long[] certRefs, String authMethod) throws CertificateException {
        throw new AssertionError((Object)"Should be handled by engine");
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.inputStreamWrapper;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.outputStreamWrapper;
    }

    @Override
    public SSLSession getSession() {
        return this.engine.getSession();
    }

    @Override
    public boolean getEnableSessionCreation() {
        return super.getEnableSessionCreation();
    }

    @Override
    public void setEnableSessionCreation(boolean flag) {
        super.setEnableSessionCreation(flag);
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return super.getSupportedCipherSuites();
    }

    @Override
    public String[] getEnabledCipherSuites() {
        return super.getEnabledCipherSuites();
    }

    @Override
    public void setEnabledCipherSuites(String[] suites) {
        super.setEnabledCipherSuites(suites);
    }

    @Override
    public String[] getSupportedProtocols() {
        return super.getSupportedProtocols();
    }

    @Override
    public String[] getEnabledProtocols() {
        return super.getEnabledProtocols();
    }

    @Override
    public void setEnabledProtocols(String[] protocols) {
        super.setEnabledProtocols(protocols);
    }

    @Override
    public void setUseSessionTickets(boolean useSessionTickets) {
        super.setUseSessionTickets(useSessionTickets);
    }

    @Override
    public void setHostname(String hostname) {
        super.setHostname(hostname);
    }

    @Override
    public void setChannelIdEnabled(boolean enabled) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public byte[] getChannelId() throws SSLException {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public void setChannelIdPrivateKey(PrivateKey privateKey) {
        throw new UnsupportedOperationException("FIXME");
    }

    @Override
    public boolean getUseClientMode() {
        return super.getUseClientMode();
    }

    @Override
    public void setUseClientMode(boolean mode) {
        this.engine.setUseClientMode(mode);
    }

    @Override
    public boolean getWantClientAuth() {
        return super.getWantClientAuth();
    }

    @Override
    public boolean getNeedClientAuth() {
        return super.getNeedClientAuth();
    }

    @Override
    public void setNeedClientAuth(boolean need) {
        super.setNeedClientAuth(need);
    }

    @Override
    public void setWantClientAuth(boolean want) {
        super.setWantClientAuth(want);
    }

    @Override
    public void sendUrgentData(int data) throws IOException {
        super.sendUrgentData(data);
    }

    @Override
    public void setOOBInline(boolean on) throws SocketException {
        super.setOOBInline(on);
    }

    @Override
    public void setSoWriteTimeout(int writeTimeoutMilliseconds) throws SocketException {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public int getSoWriteTimeout() throws SocketException {
        return 0;
    }

    @Override
    public void setHandshakeTimeout(int handshakeTimeoutMilliseconds) throws SocketException {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public synchronized void close() throws IOException {
        this.engine.closeInbound();
        this.engine.closeOutbound();
        this.socket.close();
    }

    @Override
    protected void finalize() throws Throwable {
        super.finalize();
    }

    @Override
    public SocketChannel getChannel() {
        return super.getChannel();
    }

    @Override
    public FileDescriptor getFileDescriptor$() {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public byte[] getNpnSelectedProtocol() {
        return this.engine.getNpnSelectedProtocol();
    }

    @Override
    public byte[] getAlpnSelectedProtocol() {
        return this.engine.getAlpnSelectedProtocol();
    }

    @Override
    public void setNpnProtocols(byte[] npnProtocols) {
        super.setNpnProtocols(npnProtocols);
    }

    @Override
    public void setAlpnProtocols(byte[] alpnProtocols) {
        super.setAlpnProtocols(alpnProtocols);
    }

    @Override
    public String chooseServerAlias(X509KeyManager keyManager, String keyType) {
        return this.engine.chooseServerAlias(keyManager, keyType);
    }

    @Override
    public String chooseClientAlias(X509KeyManager keyManager, X500Principal[] issuers, String[] keyTypes) {
        return this.engine.chooseClientAlias(keyManager, issuers, keyTypes);
    }

    @Override
    public String chooseServerPSKIdentityHint(PSKKeyManager keyManager) {
        return this.engine.chooseServerPSKIdentityHint(keyManager);
    }

    @Override
    public String chooseClientPSKIdentity(PSKKeyManager keyManager, String identityHint) {
        return this.engine.chooseClientPSKIdentity(keyManager, identityHint);
    }

    @Override
    public SecretKey getPSKKey(PSKKeyManager keyManager, String identityHint, String identity) {
        return this.engine.getPSKKey(keyManager, identityHint, identity);
    }

    private void completeHandshake() {
        if (!this.handshakeComplete) {
            this.handshakeComplete = true;
            super.notifyHandshakeCompletedListeners();
        }
    }

    private final class InputStreamWrapper
    extends InputStream {
        private final Object stateLock = new Object();
        private final byte[] singleByte = new byte[1];
        private final ByteBuffer fromEngine;
        private ByteBuffer fromSocket;
        private InputStream socketInputStream;
        private SocketChannel socketChannel;

        InputStreamWrapper() {
            this.fromEngine = ByteBuffer.allocateDirect(OpenSSLEngineSocketImpl.this.engine.getSession().getApplicationBufferSize());
            this.fromEngine.flip();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read() throws IOException {
            Object object = this.stateLock;
            synchronized (object) {
                int count = this.read(this.singleByte, 0, 1);
                if (count == -1) {
                    return -1;
                }
                if (count != 1) {
                    throw new SSLException("read incorrect number of bytes " + count);
                }
                return this.singleByte[0];
            }
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            Object object = this.stateLock;
            synchronized (object) {
                try {
                    boolean needMoreData;
                    this.init();
                    do {
                        if (this.fromEngine.remaining() > 0) {
                            int readFromEngine = Math.min(this.fromEngine.remaining(), len);
                            this.fromEngine.get(b, off, readFromEngine);
                            return readFromEngine;
                        }
                        needMoreData = true;
                        if (this.fromSocket.position() <= 0) continue;
                        this.fromSocket.flip();
                        this.fromEngine.clear();
                        SSLEngineResult engineResult = OpenSSLEngineSocketImpl.this.engine.unwrap(this.fromSocket, this.fromEngine);
                        this.fromSocket.compact();
                        this.fromEngine.flip();
                        switch (engineResult.getStatus()) {
                            case BUFFER_UNDERFLOW: {
                                if (engineResult.bytesProduced() == 0) break;
                            }
                            case OK: {
                                needMoreData = false;
                                break;
                            }
                            default: {
                                throw new SSLException("Unexpected engine result " + (Object)((Object)engineResult.getStatus()));
                            }
                        }
                        if (engineResult.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.FINISHED) {
                            OpenSSLEngineSocketImpl.this.completeHandshake();
                        }
                        if (needMoreData || engineResult.bytesProduced() != 0) continue;
                        return 0;
                    } while (!needMoreData || this.readFromSocket() != -1);
                    return -1;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw e;
                }
                catch (RuntimeException e) {
                    e.printStackTrace();
                    throw e;
                }
            }
        }

        private void init() throws IOException {
            if (this.socketInputStream == null) {
                this.socketInputStream = OpenSSLEngineSocketImpl.this.socket.getInputStream();
                this.socketChannel = OpenSSLEngineSocketImpl.this.socket.getChannel();
                this.fromSocket = this.socketChannel != null ? ByteBuffer.allocateDirect(OpenSSLEngineSocketImpl.this.engine.getSession().getPacketBufferSize()) : ByteBuffer.allocate(OpenSSLEngineSocketImpl.this.engine.getSession().getPacketBufferSize());
            }
        }

        private int readFromSocket() throws IOException {
            if (this.socketChannel != null) {
                return this.socketChannel.read(this.fromSocket);
            }
            int read = this.socketInputStream.read(this.fromSocket.array(), this.fromSocket.position(), this.fromSocket.remaining());
            if (read > 0) {
                this.fromSocket.position(this.fromSocket.position() + read);
            }
            return read;
        }
    }

    private final class OutputStreamWrapper
    extends OutputStream {
        private final Object stateLock = new Object();
        private ByteBuffer target;
        private OutputStream socketOutputStream;
        private SocketChannel socketChannel;

        OutputStreamWrapper() {
        }

        @Override
        public void write(int b) throws IOException {
            this.write(new byte[]{(byte)b});
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.write(ByteBuffer.wrap(b));
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.write(ByteBuffer.wrap(b, off, len));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void write(ByteBuffer buffer) throws IOException {
            Object object = this.stateLock;
            synchronized (object) {
                try {
                    this.init();
                    int len = buffer.remaining();
                    do {
                        this.target.clear();
                        SSLEngineResult engineResult = OpenSSLEngineSocketImpl.this.engine.wrap(buffer, this.target);
                        if (engineResult.getStatus() != SSLEngineResult.Status.OK) {
                            throw new SSLException("Unexpected engine result " + (Object)((Object)engineResult.getStatus()));
                        }
                        if (this.target.position() != engineResult.bytesProduced()) {
                            throw new SSLException("Engine bytesProduced " + engineResult.bytesProduced() + " does not match bytes written " + this.target.position());
                        }
                        if ((len -= engineResult.bytesConsumed()) != buffer.remaining()) {
                            throw new SSLException("Engine did not read the correct number of bytes");
                        }
                        this.target.flip();
                        if (this.socketChannel != null) {
                            while (this.target.hasRemaining()) {
                                this.socketChannel.write(this.target);
                            }
                        } else {
                            this.socketOutputStream.write(this.target.array(), 0, this.target.limit());
                        }
                        if (engineResult.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.FINISHED) continue;
                        OpenSSLEngineSocketImpl.this.completeHandshake();
                    } while (len > 0);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw e;
                }
                catch (RuntimeException e) {
                    e.printStackTrace();
                    throw e;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void flush() throws IOException {
            Object object = this.stateLock;
            synchronized (object) {
                this.init();
                this.socketOutputStream.flush();
            }
        }

        @Override
        public void close() throws IOException {
            OpenSSLEngineSocketImpl.this.socket.close();
        }

        private void init() throws IOException {
            if (this.socketOutputStream == null) {
                this.socketOutputStream = OpenSSLEngineSocketImpl.this.socket.getOutputStream();
                this.socketChannel = OpenSSLEngineSocketImpl.this.socket.getChannel();
                this.target = this.socketChannel != null ? ByteBuffer.allocateDirect(OpenSSLEngineSocketImpl.this.engine.getSession().getPacketBufferSize()) : ByteBuffer.allocate(OpenSSLEngineSocketImpl.this.engine.getSession().getPacketBufferSize());
            }
        }
    }
}

