/*
 * Decompiled with CFR 0.152.
 */
package com.android.org.conscrypt;

import com.android.org.conscrypt.NativeCrypto;
import com.android.org.conscrypt.OpenSSLEngineSocketImpl;
import com.android.org.conscrypt.OpenSSLSocketImpl;
import com.android.org.conscrypt.OpenSSLSocketImplWrapper;
import com.android.org.conscrypt.Platform;
import com.android.org.conscrypt.SSLParametersImpl;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import javax.net.ssl.SSLSocketFactory;

public class OpenSSLSocketFactoryImpl
extends SSLSocketFactory {
    private static boolean alwaysUseSocketEngine = Boolean.parseBoolean(System.getProperty("com.android.org.conscrypt.alwaysUseEngineSocket"));
    private final SSLParametersImpl sslParameters;
    private final IOException instantiationException;

    public OpenSSLSocketFactoryImpl() {
        SSLParametersImpl sslParametersLocal = null;
        IOException instantiationExceptionLocal = null;
        try {
            sslParametersLocal = SSLParametersImpl.getDefault();
        }
        catch (KeyManagementException e) {
            instantiationExceptionLocal = new IOException("Delayed instantiation exception:");
            instantiationExceptionLocal.initCause(e);
        }
        this.sslParameters = sslParametersLocal;
        this.instantiationException = instantiationExceptionLocal;
    }

    public OpenSSLSocketFactoryImpl(SSLParametersImpl sslParameters) {
        this.sslParameters = sslParameters;
        this.instantiationException = null;
    }

    public static void setAlwaysUseEngineSocket(boolean enable) {
        alwaysUseSocketEngine = enable;
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.sslParameters.getEnabledCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return NativeCrypto.getSupportedCipherSuites();
    }

    @Override
    public Socket createSocket() throws IOException {
        if (this.instantiationException != null) {
            throw this.instantiationException;
        }
        return new OpenSSLSocketImpl((SSLParametersImpl)this.sslParameters.clone());
    }

    @Override
    public Socket createSocket(String hostname, int port) throws IOException, UnknownHostException {
        return new OpenSSLSocketImpl(hostname, port, (SSLParametersImpl)this.sslParameters.clone());
    }

    @Override
    public Socket createSocket(String hostname, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
        return new OpenSSLSocketImpl(hostname, port, localHost, localPort, (SSLParametersImpl)this.sslParameters.clone());
    }

    @Override
    public Socket createSocket(InetAddress address, int port) throws IOException {
        return new OpenSSLSocketImpl(address, port, (SSLParametersImpl)this.sslParameters.clone());
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        return new OpenSSLSocketImpl(address, port, localAddress, localPort, (SSLParametersImpl)this.sslParameters.clone());
    }

    @Override
    public Socket createSocket(Socket s, String hostname, int port, boolean autoClose) throws IOException {
        boolean socketHasFd = false;
        try {
            socketHasFd = Platform.getFileDescriptor(s) != null;
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        if (socketHasFd && !alwaysUseSocketEngine) {
            return new OpenSSLSocketImplWrapper(s, hostname, port, autoClose, (SSLParametersImpl)this.sslParameters.clone());
        }
        return new OpenSSLEngineSocketImpl(s, hostname, port, autoClose, (SSLParametersImpl)this.sslParameters.clone());
    }
}

