/*
 * Decompiled with CFR 0.152.
 */
package com.android.org.conscrypt;

import java.nio.ByteBuffer;

final class SSLUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int getEncryptedPacketLength(ByteBuffer[] buffers, int offset) {
        ByteBuffer buffer = buffers[offset];
        if (buffer.remaining() >= 5) {
            return SSLUtils.getEncryptedPacketLength(buffer);
        }
        ByteBuffer tmp = ByteBuffer.allocate(5);
        do {
            buffer = buffers[offset++];
            int pos = buffer.position();
            int limit = buffer.limit();
            if (buffer.remaining() > tmp.remaining()) {
                buffer.limit(pos + tmp.remaining());
            }
            try {
                tmp.put(buffer);
            }
            finally {
                buffer.limit(limit);
                buffer.position(pos);
            }
        } while (tmp.hasRemaining());
        tmp.flip();
        return SSLUtils.getEncryptedPacketLength(tmp);
    }

    private static int getEncryptedPacketLength(ByteBuffer buffer) {
        int packetLength = 0;
        int pos = buffer.position();
        switch (SSLUtils.unsignedByte(buffer.get(pos))) {
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                break;
            }
            default: {
                return -1;
            }
        }
        short majorVersion = SSLUtils.unsignedByte(buffer.get(pos + 1));
        if (majorVersion != 3) {
            return -1;
        }
        packetLength = SSLUtils.unsignedShort(buffer.getShort(pos + 3)) + 5;
        if (packetLength <= 5) {
            return -1;
        }
        return packetLength;
    }

    private static short unsignedByte(byte b) {
        return (short)(b & 0xFF);
    }

    private static int unsignedShort(short s) {
        return s & 0xFFFF;
    }

    private SSLUtils() {
    }
}

