/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.app.job.JobInfo;
import android.app.job.JobParameters;
import android.app.job.JobScheduler;
import android.app.job.JobService;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Environment;
import android.os.ServiceManager;
import android.os.storage.StorageManager;
import android.util.ArraySet;
import android.util.Log;
import com.android.server.pm.PackageManagerService;
import java.io.File;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class BackgroundDexOptJobService
extends JobService {
    private static final String TAG = "BackgroundDexOptJobService";
    private static final boolean DEBUG = false;
    private static final int JOB_IDLE_OPTIMIZE = 800;
    private static final int JOB_POST_BOOT_UPDATE = 801;
    private static final long IDLE_OPTIMIZATION_PERIOD = TimeUnit.DAYS.toMillis(1L);
    private static ComponentName sDexoptServiceName = new ComponentName("android", BackgroundDexOptJobService.class.getName());
    static final ArraySet<String> sFailedPackageNames = new ArraySet();
    final AtomicBoolean mAbortPostBootUpdate = new AtomicBoolean(false);
    final AtomicBoolean mAbortIdleOptimization = new AtomicBoolean(false);
    final AtomicBoolean mExitPostBootUpdate = new AtomicBoolean(false);
    private final File mDataDir = Environment.getDataDirectory();

    public static void schedule(Context context) {
        JobScheduler js = (JobScheduler)context.getSystemService("jobscheduler");
        js.schedule(new JobInfo.Builder(801, sDexoptServiceName).setMinimumLatency(TimeUnit.MINUTES.toMillis(1L)).setOverrideDeadline(TimeUnit.MINUTES.toMillis(1L)).build());
        js.schedule(new JobInfo.Builder(800, sDexoptServiceName).setRequiresDeviceIdle(true).setRequiresCharging(true).setPeriodic(IDLE_OPTIMIZATION_PERIOD).build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void notifyPackageChanged(String packageName) {
        ArraySet<String> arraySet = sFailedPackageNames;
        synchronized (arraySet) {
            sFailedPackageNames.remove(packageName);
        }
    }

    private int getBatteryLevel() {
        IntentFilter filter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
        Intent intent = this.registerReceiver(null, filter);
        int level = intent.getIntExtra("level", -1);
        int scale = intent.getIntExtra("scale", -1);
        if (level < 0 || scale <= 0) {
            return 0;
        }
        return 100 * level / scale;
    }

    private long getLowStorageThreshold() {
        long lowThreshold = StorageManager.from(this).getStorageLowBytes(this.mDataDir);
        if (lowThreshold == 0L) {
            Log.e(TAG, "Invalid low storage threshold");
        }
        return lowThreshold;
    }

    private boolean runPostBootUpdate(final JobParameters jobParams, final PackageManagerService pm, final ArraySet<String> pkgs) {
        if (this.mExitPostBootUpdate.get()) {
            return false;
        }
        new Thread("BackgroundDexOptService_PostBootUpdate"){

            @Override
            public void run() {
                BackgroundDexOptJobService.this.postBootUpdate(jobParams, pm, pkgs);
            }
        }.start();
        return true;
    }

    private void postBootUpdate(JobParameters jobParams, PackageManagerService pm, ArraySet<String> pkgs) {
        int lowBatteryThreshold = this.getResources().getInteger(17694798);
        long lowThreshold = this.getLowStorageThreshold();
        this.mAbortPostBootUpdate.set(false);
        for (String pkg : pkgs) {
            if (this.mAbortPostBootUpdate.get()) {
                return;
            }
            if (this.mExitPostBootUpdate.get() || this.getBatteryLevel() < lowBatteryThreshold) break;
            long usableSpace = this.mDataDir.getUsableSpace();
            if (usableSpace < lowThreshold) {
                Log.w(TAG, "Aborting background dex opt job due to low storage: " + usableSpace);
                break;
            }
            pm.performDexOpt(pkg, false, 1, false);
        }
        this.jobFinished(jobParams, false);
    }

    private boolean runIdleOptimization(final JobParameters jobParams, final PackageManagerService pm, final ArraySet<String> pkgs) {
        new Thread("BackgroundDexOptService_IdleOptimization"){

            @Override
            public void run() {
                BackgroundDexOptJobService.this.idleOptimization(jobParams, pm, pkgs);
            }
        }.start();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void idleOptimization(JobParameters jobParams, PackageManagerService pm, ArraySet<String> pkgs) {
        Log.i(TAG, "Performing idle optimizations");
        this.mExitPostBootUpdate.set(true);
        this.mAbortIdleOptimization.set(false);
        long lowThreshold = this.getLowStorageThreshold();
        for (String pkg : pkgs) {
            if (this.mAbortIdleOptimization.get()) {
                return;
            }
            ArraySet<String> arraySet = sFailedPackageNames;
            synchronized (arraySet) {
                if (sFailedPackageNames.contains(pkg)) {
                    continue;
                }
            }
            long usableSpace = this.mDataDir.getUsableSpace();
            if (usableSpace < lowThreshold) {
                Log.w(TAG, "Aborting background dex opt job due to low storage: " + usableSpace);
                break;
            }
            ArraySet<String> arraySet2 = sFailedPackageNames;
            synchronized (arraySet2) {
                sFailedPackageNames.add(pkg);
            }
            if (!pm.performDexOpt(pkg, true, 3, false)) continue;
            arraySet2 = sFailedPackageNames;
            synchronized (arraySet2) {
                sFailedPackageNames.remove(pkg);
            }
        }
        this.jobFinished(jobParams, false);
    }

    @Override
    public boolean onStartJob(JobParameters params) {
        PackageManagerService pm = (PackageManagerService)ServiceManager.getService("package");
        if (pm.isStorageLow()) {
            return false;
        }
        ArraySet<String> pkgs = pm.getOptimizablePackages();
        if (pkgs == null || pkgs.isEmpty()) {
            return false;
        }
        if (params.getJobId() == 801) {
            return this.runPostBootUpdate(params, pm, pkgs);
        }
        return this.runIdleOptimization(params, pm, pkgs);
    }

    @Override
    public boolean onStopJob(JobParameters params) {
        if (params.getJobId() == 801) {
            this.mAbortPostBootUpdate.set(true);
        } else {
            this.mAbortIdleOptimization.set(true);
        }
        return false;
    }
}

