/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.IPackageManager;
import android.os.Build;
import android.os.DropBoxManager;
import android.os.Environment;
import android.os.FileObserver;
import android.os.FileUtils;
import android.os.RecoverySystem;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemProperties;
import android.os.storage.StorageManager;
import android.provider.Downloads;
import android.util.AtomicFile;
import android.util.Slog;
import android.util.Xml;
import com.android.internal.util.FastXmlSerializer;
import com.android.internal.util.XmlUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class BootReceiver
extends BroadcastReceiver {
    private static final String TAG = "BootReceiver";
    private static final int LOG_SIZE = SystemProperties.getInt("ro.debuggable", 0) == 1 ? 98304 : 65536;
    private static final File TOMBSTONE_DIR = new File("/data/tombstones");
    private static final String OLD_UPDATER_PACKAGE = "com.google.android.systemupdater";
    private static final String OLD_UPDATER_CLASS = "com.google.android.systemupdater.SystemUpdateReceiver";
    private static FileObserver sTombstoneObserver = null;
    private static final String LOG_FILES_FILE = "log-files.xml";
    private static final AtomicFile sFile = new AtomicFile(new File(Environment.getDataSystemDirectory(), "log-files.xml"));
    private static final String LAST_HEADER_FILE = "last-header.txt";
    private static final File lastHeaderFile = new File(Environment.getDataSystemDirectory(), "last-header.txt");

    @Override
    public void onReceive(final Context context, Intent intent) {
        new Thread(){

            @Override
            public void run() {
                try {
                    BootReceiver.this.logBootEvents(context);
                }
                catch (Exception e) {
                    Slog.e(BootReceiver.TAG, "Can't log boot events", e);
                }
                try {
                    boolean onlyCore = false;
                    try {
                        onlyCore = IPackageManager.Stub.asInterface(ServiceManager.getService("package")).isOnlyCoreApps();
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                    if (!onlyCore) {
                        BootReceiver.this.removeOldUpdatePackages(context);
                    }
                }
                catch (Exception e) {
                    Slog.e(BootReceiver.TAG, "Can't remove old update packages", e);
                }
            }
        }.start();
    }

    private void removeOldUpdatePackages(Context context) {
        Downloads.removeAllDownloadsByPackage(context, OLD_UPDATER_PACKAGE, OLD_UPDATER_CLASS);
    }

    private String getPreviousBootHeaders() {
        try {
            return FileUtils.readTextFile(lastHeaderFile, 0, null);
        }
        catch (IOException e) {
            Slog.e(TAG, "Error reading " + lastHeaderFile, e);
            return null;
        }
    }

    private String getCurrentBootHeaders() throws IOException {
        return new StringBuilder(512).append("Build: ").append(Build.FINGERPRINT).append("\n").append("Hardware: ").append(Build.BOARD).append("\n").append("Revision: ").append(SystemProperties.get("ro.revision", "")).append("\n").append("Bootloader: ").append(Build.BOOTLOADER).append("\n").append("Radio: ").append(Build.RADIO).append("\n").append("Kernel: ").append(FileUtils.readTextFile(new File("/proc/version"), 1024, "...\n")).append("\n").toString();
    }

    private String getBootHeadersToLogAndUpdate() throws IOException {
        String oldHeaders = this.getPreviousBootHeaders();
        String newHeaders = this.getCurrentBootHeaders();
        try {
            FileUtils.stringToFile(lastHeaderFile, newHeaders);
        }
        catch (IOException e) {
            Slog.e(TAG, "Error writing " + lastHeaderFile, e);
        }
        if (oldHeaders == null) {
            return "isPrevious: false\n" + newHeaders;
        }
        return "isPrevious: true\n" + oldHeaders;
    }

    private void logBootEvents(Context ctx) throws IOException {
        final DropBoxManager db = (DropBoxManager)ctx.getSystemService("dropbox");
        final String headers = this.getBootHeadersToLogAndUpdate();
        String bootReason = SystemProperties.get("ro.boot.bootreason", null);
        String recovery = RecoverySystem.handleAftermath(ctx);
        if (recovery != null && db != null) {
            db.addText("SYSTEM_RECOVERY_LOG", headers + recovery);
        }
        String lastKmsgFooter = "";
        if (bootReason != null) {
            lastKmsgFooter = new StringBuilder(512).append("\n").append("Boot info:\n").append("Last boot reason: ").append(bootReason).append("\n").toString();
        }
        HashMap<String, Long> timestamps = BootReceiver.readTimestamps();
        if (SystemProperties.getLong("ro.runtime.firstboot", 0L) == 0L) {
            if (!StorageManager.inCryptKeeperBounce()) {
                String now = Long.toString(System.currentTimeMillis());
                SystemProperties.set("ro.runtime.firstboot", now);
            }
            if (db != null) {
                db.addText("SYSTEM_BOOT", headers);
            }
            BootReceiver.addFileWithFootersToDropBox(db, timestamps, headers, lastKmsgFooter, "/proc/last_kmsg", -LOG_SIZE, "SYSTEM_LAST_KMSG");
            BootReceiver.addFileWithFootersToDropBox(db, timestamps, headers, lastKmsgFooter, "/sys/fs/pstore/console-ramoops", -LOG_SIZE, "SYSTEM_LAST_KMSG");
            BootReceiver.addFileToDropBox(db, timestamps, headers, "/cache/recovery/log", -LOG_SIZE, "SYSTEM_RECOVERY_LOG");
            BootReceiver.addFileToDropBox(db, timestamps, headers, "/cache/recovery/last_kmsg", -LOG_SIZE, "SYSTEM_RECOVERY_KMSG");
            BootReceiver.addAuditErrorsToDropBox(db, timestamps, headers, -LOG_SIZE, "SYSTEM_AUDIT");
            BootReceiver.addFsckErrorsToDropBox(db, timestamps, headers, -LOG_SIZE, "SYSTEM_FSCK");
        } else if (db != null) {
            db.addText("SYSTEM_RESTART", headers);
        }
        File[] tombstoneFiles = TOMBSTONE_DIR.listFiles();
        for (int i = 0; tombstoneFiles != null && i < tombstoneFiles.length; ++i) {
            if (!tombstoneFiles[i].isFile()) continue;
            BootReceiver.addFileToDropBox(db, timestamps, headers, tombstoneFiles[i].getPath(), LOG_SIZE, "SYSTEM_TOMBSTONE");
        }
        this.writeTimestamps(timestamps);
        sTombstoneObserver = new FileObserver(TOMBSTONE_DIR.getPath(), 8){

            @Override
            public void onEvent(int event, String path) {
                HashMap timestamps = BootReceiver.readTimestamps();
                try {
                    File file = new File(TOMBSTONE_DIR, path);
                    if (file.isFile()) {
                        BootReceiver.addFileToDropBox(db, timestamps, headers, file.getPath(), LOG_SIZE, "SYSTEM_TOMBSTONE");
                    }
                }
                catch (IOException e) {
                    Slog.e(BootReceiver.TAG, "Can't log tombstone", e);
                }
                BootReceiver.this.writeTimestamps(timestamps);
            }
        };
        sTombstoneObserver.startWatching();
    }

    private static void addFileToDropBox(DropBoxManager db, HashMap<String, Long> timestamps, String headers, String filename, int maxSize, String tag) throws IOException {
        BootReceiver.addFileWithFootersToDropBox(db, timestamps, headers, "", filename, maxSize, tag);
    }

    private static void addFileWithFootersToDropBox(DropBoxManager db, HashMap<String, Long> timestamps, String headers, String footers, String filename, int maxSize, String tag) throws IOException {
        if (db == null || !db.isTagEnabled(tag)) {
            return;
        }
        File file = new File(filename);
        long fileTime = file.lastModified();
        if (fileTime <= 0L) {
            return;
        }
        if (timestamps.containsKey(filename) && timestamps.get(filename) == fileTime) {
            return;
        }
        timestamps.put(filename, fileTime);
        Slog.i(TAG, "Copying " + filename + " to DropBox (" + tag + ")");
        db.addText(tag, headers + FileUtils.readTextFile(file, maxSize, "[[TRUNCATED]]\n") + footers);
    }

    private static void addAuditErrorsToDropBox(DropBoxManager db, HashMap<String, Long> timestamps, String headers, int maxSize, String tag) throws IOException {
        if (db == null || !db.isTagEnabled(tag)) {
            return;
        }
        Slog.i(TAG, "Copying audit failures to DropBox");
        File file = new File("/proc/last_kmsg");
        long fileTime = file.lastModified();
        if (fileTime <= 0L) {
            file = new File("/sys/fs/pstore/console-ramoops");
            fileTime = file.lastModified();
        }
        if (fileTime <= 0L) {
            return;
        }
        if (timestamps.containsKey(tag) && timestamps.get(tag) == fileTime) {
            return;
        }
        timestamps.put(tag, fileTime);
        String log = FileUtils.readTextFile(file, maxSize, "[[TRUNCATED]]\n");
        StringBuilder sb = new StringBuilder();
        for (String line : log.split("\n")) {
            if (!line.contains("audit")) continue;
            sb.append(line + "\n");
        }
        Slog.i(TAG, "Copied " + sb.toString().length() + " worth of audits to DropBox");
        db.addText(tag, headers + sb.toString());
    }

    private static void addFsckErrorsToDropBox(DropBoxManager db, HashMap<String, Long> timestamps, String headers, int maxSize, String tag) throws IOException {
        boolean upload_needed = false;
        if (db == null || !db.isTagEnabled(tag)) {
            return;
        }
        Slog.i(TAG, "Checking for fsck errors");
        File file = new File("/dev/fscklogs/log");
        long fileTime = file.lastModified();
        if (fileTime <= 0L) {
            return;
        }
        String log = FileUtils.readTextFile(file, maxSize, "[[TRUNCATED]]\n");
        StringBuilder sb = new StringBuilder();
        for (String line : log.split("\n")) {
            if (!line.contains("FILE SYSTEM WAS MODIFIED")) continue;
            upload_needed = true;
            break;
        }
        if (upload_needed) {
            BootReceiver.addFileToDropBox(db, timestamps, headers, "/dev/fscklogs/log", maxSize, tag);
        }
        file.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HashMap<String, Long> readTimestamps() {
        AtomicFile atomicFile = sFile;
        synchronized (atomicFile) {
            HashMap<String, Long> timestamps = new HashMap<String, Long>();
            boolean success = false;
            try (FileInputStream stream = sFile.openRead();){
                int type;
                XmlPullParser parser = Xml.newPullParser();
                parser.setInput(stream, StandardCharsets.UTF_8.name());
                while ((type = parser.next()) != 2 && type != 1) {
                }
                if (type != 2) {
                    throw new IllegalStateException("no start tag found");
                }
                int outerDepth = parser.getDepth();
                while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
                    if (type == 3 || type == 4) continue;
                    String tagName = parser.getName();
                    if (tagName.equals("log")) {
                        String filename = parser.getAttributeValue(null, "filename");
                        long timestamp = Long.valueOf(parser.getAttributeValue(null, "timestamp"));
                        timestamps.put(filename, timestamp);
                        continue;
                    }
                    Slog.w(TAG, "Unknown tag: " + parser.getName());
                    XmlUtils.skipCurrentTag(parser);
                }
                success = true;
            }
            catch (FileNotFoundException e) {
                Slog.i(TAG, "No existing last log timestamp file " + sFile.getBaseFile() + "; starting empty");
            }
            catch (IOException e) {
                Slog.w(TAG, "Failed parsing " + e);
            }
            catch (IllegalStateException e) {
                Slog.w(TAG, "Failed parsing " + e);
            }
            catch (NullPointerException e) {
                Slog.w(TAG, "Failed parsing " + e);
            }
            catch (XmlPullParserException e) {
                Slog.w(TAG, "Failed parsing " + e);
            }
            finally {
                if (!success) {
                    timestamps.clear();
                }
            }
            return timestamps;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeTimestamps(HashMap<String, Long> timestamps) {
        AtomicFile atomicFile = sFile;
        synchronized (atomicFile) {
            FileOutputStream stream;
            try {
                stream = sFile.startWrite();
            }
            catch (IOException e) {
                Slog.w(TAG, "Failed to write timestamp file: " + e);
                return;
            }
            try {
                FastXmlSerializer out = new FastXmlSerializer();
                out.setOutput(stream, StandardCharsets.UTF_8.name());
                out.startDocument(null, true);
                out.startTag(null, "log-files");
                for (String filename : timestamps.keySet()) {
                    out.startTag(null, "log");
                    out.attribute(null, "filename", filename);
                    out.attribute(null, "timestamp", timestamps.get(filename).toString());
                    out.endTag(null, "log");
                }
                out.endTag(null, "log-files");
                out.endDocument();
                sFile.finishWrite(stream);
            }
            catch (IOException e) {
                Slog.w(TAG, "Failed to write timestamp file, using the backup: " + e);
                sFile.failWrite(stream);
            }
        }
    }
}

