/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.content.Context;
import android.graphics.FontListParser;
import android.os.ParcelFileDescriptor;
import android.text.FontConfig;
import android.util.Slog;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.font.IFontManager;
import com.android.server.SystemService;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParserException;

public class FontManagerService
extends IFontManager.Stub {
    private static final String TAG = "FontManagerService";
    private static final String FONTS_CONFIG = "/system/etc/fonts.xml";
    @GuardedBy(value="mLock")
    private FontConfig mConfig;
    private final Object mLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FontConfig getSystemFonts() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mConfig != null) {
                return new FontConfig(this.mConfig);
            }
            FontConfig config = this.loadFromSystem();
            if (config == null) {
                return null;
            }
            int size = config.getFamilies().size();
            for (int i = 0; i < size; ++i) {
                FontConfig.Family family = config.getFamilies().get(i);
                for (int j = 0; j < family.getFonts().size(); ++j) {
                    FontConfig.Font font = family.getFonts().get(j);
                    File fontFile = new File(font.getFontName());
                    try {
                        font.setFd(ParcelFileDescriptor.open(fontFile, 0x10000000));
                        continue;
                    }
                    catch (IOException e) {
                        Slog.e(TAG, "Error opening font file " + font.getFontName(), e);
                    }
                }
            }
            this.mConfig = config;
            return new FontConfig(this.mConfig);
        }
    }

    private FontConfig loadFromSystem() {
        File configFilename = new File(FONTS_CONFIG);
        try {
            FileInputStream fontsIn = new FileInputStream(configFilename);
            return FontListParser.parse(fontsIn);
        }
        catch (IOException | XmlPullParserException e) {
            Slog.e(TAG, "Error opening " + configFilename, e);
            return null;
        }
    }

    public static final class Lifecycle
    extends SystemService {
        private final FontManagerService mService = new FontManagerService();

        public Lifecycle(Context context) {
            super(context);
        }

        @Override
        public void onStart() {
            try {
                this.publishBinderService("font", this.mService);
            }
            catch (Throwable t) {
                Slog.e(FontManagerService.TAG, "Could not start the FontManagerService.", t);
            }
        }
    }
}

