/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.content.ContentValues;
import android.content.Context;
import android.content.pm.UserInfo;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.os.Environment;
import android.os.UserManager;
import android.util.ArrayMap;
import android.util.Log;
import android.util.Slog;
import com.android.internal.util.ArrayUtils;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

class LockSettingsStorage {
    private static final String TAG = "LockSettingsStorage";
    private static final String TABLE = "locksettings";
    private static final boolean DEBUG = false;
    private static final String COLUMN_KEY = "name";
    private static final String COLUMN_USERID = "user";
    private static final String COLUMN_VALUE = "value";
    private static final String[] COLUMNS_FOR_QUERY = new String[]{"value"};
    private static final String[] COLUMNS_FOR_PREFETCH = new String[]{"name", "value"};
    private static final String SYSTEM_DIRECTORY = "/system/";
    private static final String LOCK_PATTERN_FILE = "gatekeeper.pattern.key";
    private static final String BASE_ZERO_LOCK_PATTERN_FILE = "gatekeeper.gesture.key";
    private static final String LEGACY_LOCK_PATTERN_FILE = "gesture.key";
    private static final String LOCK_PASSWORD_FILE = "gatekeeper.password.key";
    private static final String LEGACY_LOCK_PASSWORD_FILE = "password.key";
    private static final String CHILD_PROFILE_LOCK_FILE = "gatekeeper.profile.key";
    private static final String SYNTHETIC_PASSWORD_DIRECTORY = "spblob/";
    private static final Object DEFAULT = new Object();
    private final DatabaseHelper mOpenHelper;
    private final Context mContext;
    private final Cache mCache = new Cache();
    private final Object mFileWriteLock = new Object();

    public LockSettingsStorage(Context context) {
        this.mContext = context;
        this.mOpenHelper = new DatabaseHelper(context);
    }

    public void setDatabaseOnCreateCallback(Callback callback) {
        this.mOpenHelper.setCallback(callback);
    }

    public void writeKeyValue(String key, String value, int userId) {
        this.writeKeyValue(this.mOpenHelper.getWritableDatabase(), key, value, userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeKeyValue(SQLiteDatabase db, String key, String value, int userId) {
        ContentValues cv = new ContentValues();
        cv.put(COLUMN_KEY, key);
        cv.put(COLUMN_USERID, userId);
        cv.put(COLUMN_VALUE, value);
        db.beginTransaction();
        try {
            db.delete(TABLE, "name=? AND user=?", new String[]{key, Integer.toString(userId)});
            db.insert(TABLE, null, cv);
            db.setTransactionSuccessful();
            this.mCache.putKeyValue(key, value, userId);
        }
        finally {
            db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readKeyValue(String key, String defaultValue, int userId) {
        int version;
        Cache cache = this.mCache;
        synchronized (cache) {
            if (this.mCache.hasKeyValue(key, userId)) {
                return this.mCache.peekKeyValue(key, defaultValue, userId);
            }
            version = this.mCache.getVersion();
        }
        Object result = DEFAULT;
        SQLiteDatabase db = this.mOpenHelper.getReadableDatabase();
        Cursor cursor = db.query(TABLE, COLUMNS_FOR_QUERY, "user=? AND name=?", new String[]{Integer.toString(userId), key}, null, null, null);
        if (cursor != null) {
            if (cursor.moveToFirst()) {
                result = cursor.getString(0);
            }
            cursor.close();
        }
        this.mCache.putKeyValueIfUnchanged(key, result, userId, version);
        return result == DEFAULT ? defaultValue : (String)result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prefetchUser(int userId) {
        int version;
        Cache cache = this.mCache;
        synchronized (cache) {
            if (this.mCache.isFetched(userId)) {
                return;
            }
            this.mCache.setFetched(userId);
            version = this.mCache.getVersion();
        }
        SQLiteDatabase db = this.mOpenHelper.getReadableDatabase();
        Cursor cursor = db.query(TABLE, COLUMNS_FOR_PREFETCH, "user=?", new String[]{Integer.toString(userId)}, null, null, null);
        if (cursor != null) {
            while (cursor.moveToNext()) {
                String key = cursor.getString(0);
                String value = cursor.getString(1);
                this.mCache.putKeyValueIfUnchanged(key, value, userId, version);
            }
            cursor.close();
        }
        this.readCredentialHash(userId);
    }

    private CredentialHash readPasswordHashIfExists(int userId) {
        byte[] stored = this.readFile(this.getLockPasswordFilename(userId));
        if (!ArrayUtils.isEmpty(stored)) {
            return new CredentialHash(stored, 2, 1);
        }
        stored = this.readFile(this.getLegacyLockPasswordFilename(userId));
        if (!ArrayUtils.isEmpty(stored)) {
            return new CredentialHash(stored, 2, 0);
        }
        return null;
    }

    private CredentialHash readPatternHashIfExists(int userId) {
        byte[] stored = this.readFile(this.getLockPatternFilename(userId));
        if (!ArrayUtils.isEmpty(stored)) {
            return new CredentialHash(stored, 1, 1);
        }
        stored = this.readFile(this.getBaseZeroLockPatternFilename(userId));
        if (!ArrayUtils.isEmpty(stored)) {
            return new CredentialHash(stored, true);
        }
        stored = this.readFile(this.getLegacyLockPatternFilename(userId));
        if (!ArrayUtils.isEmpty(stored)) {
            return new CredentialHash(stored, 1, 0);
        }
        return null;
    }

    public CredentialHash readCredentialHash(int userId) {
        CredentialHash passwordHash = this.readPasswordHashIfExists(userId);
        CredentialHash patternHash = this.readPatternHashIfExists(userId);
        if (passwordHash != null && patternHash != null) {
            if (passwordHash.version == 1) {
                return passwordHash;
            }
            return patternHash;
        }
        if (passwordHash != null) {
            return passwordHash;
        }
        if (patternHash != null) {
            return patternHash;
        }
        return CredentialHash.createEmptyHash();
    }

    public void removeChildProfileLock(int userId) {
        try {
            this.deleteFile(this.getChildProfileLockFile(userId));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void writeChildProfileLock(int userId, byte[] lock) {
        this.writeFile(this.getChildProfileLockFile(userId), lock);
    }

    public byte[] readChildProfileLock(int userId) {
        return this.readFile(this.getChildProfileLockFile(userId));
    }

    public boolean hasChildProfileLock(int userId) {
        return this.hasFile(this.getChildProfileLockFile(userId));
    }

    public boolean hasPassword(int userId) {
        return this.hasFile(this.getLockPasswordFilename(userId)) || this.hasFile(this.getLegacyLockPasswordFilename(userId));
    }

    public boolean hasPattern(int userId) {
        return this.hasFile(this.getLockPatternFilename(userId)) || this.hasFile(this.getBaseZeroLockPatternFilename(userId)) || this.hasFile(this.getLegacyLockPatternFilename(userId));
    }

    public boolean hasCredential(int userId) {
        return this.hasPassword(userId) || this.hasPattern(userId);
    }

    private boolean hasFile(String name) {
        byte[] contents = this.readFile(name);
        return contents != null && contents.length > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readFile(String name) {
        int version;
        Cache cache = this.mCache;
        synchronized (cache) {
            if (this.mCache.hasFile(name)) {
                return this.mCache.peekFile(name);
            }
            version = this.mCache.getVersion();
        }
        RandomAccessFile raf = null;
        byte[] stored = null;
        try {
            raf = new RandomAccessFile(name, "r");
            stored = new byte[(int)raf.length()];
            raf.readFully(stored, 0, stored.length);
            raf.close();
        }
        catch (IOException e) {
            Slog.e(TAG, "Cannot read file " + e);
        }
        finally {
            if (raf != null) {
                try {
                    raf.close();
                }
                catch (IOException e) {
                    Slog.e(TAG, "Error closing file " + e);
                }
            }
        }
        this.mCache.putFileIfUnchanged(name, stored, version);
        return stored;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFile(String name, byte[] hash) {
        Object object = this.mFileWriteLock;
        synchronized (object) {
            RandomAccessFile raf = null;
            try {
                raf = new RandomAccessFile(name, "rw");
                if (hash == null || hash.length == 0) {
                    raf.setLength(0L);
                } else {
                    raf.write(hash, 0, hash.length);
                }
                raf.close();
            }
            catch (IOException e) {
                Slog.e(TAG, "Error writing to file " + e);
            }
            finally {
                if (raf != null) {
                    try {
                        raf.close();
                    }
                    catch (IOException e) {
                        Slog.e(TAG, "Error closing file " + e);
                    }
                }
            }
            this.mCache.putFile(name, hash);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteFile(String name) {
        Object object = this.mFileWriteLock;
        synchronized (object) {
            File file = new File(name);
            if (file.exists()) {
                file.delete();
                this.mCache.putFile(name, null);
            }
        }
    }

    public void writeCredentialHash(CredentialHash hash, int userId) {
        byte[] patternHash = null;
        byte[] passwordHash = null;
        if (hash.type == 2) {
            passwordHash = hash.hash;
        } else if (hash.type == 1) {
            patternHash = hash.hash;
        }
        this.writeFile(this.getLockPasswordFilename(userId), passwordHash);
        this.writeFile(this.getLockPatternFilename(userId), patternHash);
    }

    String getLockPatternFilename(int userId) {
        return this.getLockCredentialFilePathForUser(userId, LOCK_PATTERN_FILE);
    }

    String getLockPasswordFilename(int userId) {
        return this.getLockCredentialFilePathForUser(userId, LOCK_PASSWORD_FILE);
    }

    String getLegacyLockPatternFilename(int userId) {
        return this.getLockCredentialFilePathForUser(userId, LEGACY_LOCK_PATTERN_FILE);
    }

    String getLegacyLockPasswordFilename(int userId) {
        return this.getLockCredentialFilePathForUser(userId, LEGACY_LOCK_PASSWORD_FILE);
    }

    private String getBaseZeroLockPatternFilename(int userId) {
        return this.getLockCredentialFilePathForUser(userId, BASE_ZERO_LOCK_PATTERN_FILE);
    }

    String getChildProfileLockFile(int userId) {
        return this.getLockCredentialFilePathForUser(userId, CHILD_PROFILE_LOCK_FILE);
    }

    private String getLockCredentialFilePathForUser(int userId, String basename) {
        String dataSystemDirectory = Environment.getDataDirectory().getAbsolutePath() + SYSTEM_DIRECTORY;
        if (userId == 0) {
            return dataSystemDirectory + basename;
        }
        return new File(Environment.getUserSystemDirectory(userId), basename).getAbsolutePath();
    }

    public void writeSyntheticPasswordState(int userId, long handle, String name, byte[] data) {
        this.writeFile(this.getSynthenticPasswordStateFilePathForUser(userId, handle, name), data);
    }

    public byte[] readSyntheticPasswordState(int userId, long handle, String name) {
        return this.readFile(this.getSynthenticPasswordStateFilePathForUser(userId, handle, name));
    }

    public void deleteSyntheticPasswordState(int userId, long handle, String name, boolean secure) {
        String path = this.getSynthenticPasswordStateFilePathForUser(userId, handle, name);
        File file = new File(path);
        if (file.exists()) {
            file.delete();
            this.mCache.putFile(path, null);
        }
    }

    protected File getSyntheticPasswordDirectoryForUser(int userId) {
        return new File(Environment.getDataSystemDeDirectory(userId), SYNTHETIC_PASSWORD_DIRECTORY);
    }

    protected String getSynthenticPasswordStateFilePathForUser(int userId, long handle, String name) {
        File baseDir = this.getSyntheticPasswordDirectoryForUser(userId);
        String baseName = String.format("%016x.%s", handle, name);
        if (!baseDir.exists()) {
            baseDir.mkdir();
        }
        return new File(baseDir, baseName).getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUser(int userId) {
        SQLiteDatabase db = this.mOpenHelper.getWritableDatabase();
        UserManager um = (UserManager)this.mContext.getSystemService(COLUMN_USERID);
        UserInfo parentInfo = um.getProfileParent(userId);
        if (parentInfo == null) {
            Object object = this.mFileWriteLock;
            synchronized (object) {
                String name = this.getLockPasswordFilename(userId);
                File file = new File(name);
                if (file.exists()) {
                    file.delete();
                    this.mCache.putFile(name, null);
                }
                if ((file = new File(name = this.getLockPatternFilename(userId))).exists()) {
                    file.delete();
                    this.mCache.putFile(name, null);
                }
            }
        } else {
            this.removeChildProfileLock(userId);
        }
        File spStateDir = this.getSyntheticPasswordDirectoryForUser(userId);
        try {
            db.beginTransaction();
            db.delete(TABLE, "user='" + userId + "'", null);
            db.setTransactionSuccessful();
            this.mCache.removeUser(userId);
            this.mCache.purgePath(spStateDir.getAbsolutePath());
        }
        finally {
            db.endTransaction();
        }
    }

    void closeDatabase() {
        this.mOpenHelper.close();
    }

    void clearCache() {
        this.mCache.clear();
    }

    private static class Cache {
        private final ArrayMap<CacheKey, Object> mCache = new ArrayMap();
        private final CacheKey mCacheKey = new CacheKey();
        private int mVersion = 0;

        private Cache() {
        }

        String peekKeyValue(String key, String defaultValue, int userId) {
            Object cached = this.peek(0, key, userId);
            return cached == DEFAULT ? defaultValue : (String)cached;
        }

        boolean hasKeyValue(String key, int userId) {
            return this.contains(0, key, userId);
        }

        void putKeyValue(String key, String value, int userId) {
            this.put(0, key, value, userId);
        }

        void putKeyValueIfUnchanged(String key, Object value, int userId, int version) {
            this.putIfUnchanged(0, key, value, userId, version);
        }

        byte[] peekFile(String fileName) {
            return (byte[])this.peek(1, fileName, -1);
        }

        boolean hasFile(String fileName) {
            return this.contains(1, fileName, -1);
        }

        void putFile(String key, byte[] value) {
            this.put(1, key, value, -1);
        }

        void putFileIfUnchanged(String key, byte[] value, int version) {
            this.putIfUnchanged(1, key, value, -1, version);
        }

        void setFetched(int userId) {
            this.put(2, "isFetched", "true", userId);
        }

        boolean isFetched(int userId) {
            return this.contains(2, "", userId);
        }

        private synchronized void put(int type, String key, Object value, int userId) {
            this.mCache.put(new CacheKey().set(type, key, userId), value);
            ++this.mVersion;
        }

        private synchronized void putIfUnchanged(int type, String key, Object value, int userId, int version) {
            if (!this.contains(type, key, userId) && this.mVersion == version) {
                this.put(type, key, value, userId);
            }
        }

        private synchronized boolean contains(int type, String key, int userId) {
            return this.mCache.containsKey(this.mCacheKey.set(type, key, userId));
        }

        private synchronized Object peek(int type, String key, int userId) {
            return this.mCache.get(this.mCacheKey.set(type, key, userId));
        }

        private synchronized int getVersion() {
            return this.mVersion;
        }

        synchronized void removeUser(int userId) {
            for (int i = this.mCache.size() - 1; i >= 0; --i) {
                if (this.mCache.keyAt((int)i).userId != userId) continue;
                this.mCache.removeAt(i);
            }
            ++this.mVersion;
        }

        synchronized void purgePath(String path) {
            for (int i = this.mCache.size() - 1; i >= 0; --i) {
                CacheKey entry = this.mCache.keyAt(i);
                if (entry.type != 1 || !entry.key.startsWith(path)) continue;
                this.mCache.removeAt(i);
            }
            ++this.mVersion;
        }

        synchronized void clear() {
            this.mCache.clear();
            ++this.mVersion;
        }

        private static final class CacheKey {
            static final int TYPE_KEY_VALUE = 0;
            static final int TYPE_FILE = 1;
            static final int TYPE_FETCHED = 2;
            String key;
            int userId;
            int type;

            private CacheKey() {
            }

            public CacheKey set(int type, String key, int userId) {
                this.type = type;
                this.key = key;
                this.userId = userId;
                return this;
            }

            public boolean equals(Object obj) {
                if (!(obj instanceof CacheKey)) {
                    return false;
                }
                CacheKey o = (CacheKey)obj;
                return this.userId == o.userId && this.type == o.type && this.key.equals(o.key);
            }

            public int hashCode() {
                return this.key.hashCode() ^ this.userId ^ this.type;
            }
        }
    }

    class DatabaseHelper
    extends SQLiteOpenHelper {
        private static final String TAG = "LockSettingsDB";
        private static final String DATABASE_NAME = "locksettings.db";
        private static final int DATABASE_VERSION = 2;
        private Callback mCallback;

        public DatabaseHelper(Context context) {
            super(context, DATABASE_NAME, null, 2);
            this.setWriteAheadLoggingEnabled(true);
        }

        public void setCallback(Callback callback) {
            this.mCallback = callback;
        }

        private void createTable(SQLiteDatabase db) {
            db.execSQL("CREATE TABLE locksettings (_id INTEGER PRIMARY KEY AUTOINCREMENT,name TEXT,user INTEGER,value TEXT);");
        }

        @Override
        public void onCreate(SQLiteDatabase db) {
            this.createTable(db);
            if (this.mCallback != null) {
                this.mCallback.initialize(db);
            }
        }

        @Override
        public void onUpgrade(SQLiteDatabase db, int oldVersion, int currentVersion) {
            int upgradeVersion = oldVersion;
            if (upgradeVersion == 1) {
                upgradeVersion = 2;
            }
            if (upgradeVersion != 2) {
                Log.w(TAG, "Failed to upgrade database!");
            }
        }
    }

    public static interface Callback {
        public void initialize(SQLiteDatabase var1);
    }

    public static class CredentialHash {
        static final int VERSION_LEGACY = 0;
        static final int VERSION_GATEKEEPER = 1;
        byte[] hash;
        int type;
        int version;
        boolean isBaseZeroPattern;

        private CredentialHash(byte[] hash, int type, int version) {
            if (type != -1) {
                if (hash == null) {
                    throw new RuntimeException("Empty hash for CredentialHash");
                }
            } else if (hash != null) {
                throw new RuntimeException("None type CredentialHash should not have hash");
            }
            this.hash = hash;
            this.type = type;
            this.version = version;
            this.isBaseZeroPattern = false;
        }

        private CredentialHash(byte[] hash, boolean isBaseZeroPattern) {
            this.hash = hash;
            this.type = 1;
            this.version = 1;
            this.isBaseZeroPattern = isBaseZeroPattern;
        }

        static CredentialHash create(byte[] hash, int type) {
            if (type == -1) {
                throw new RuntimeException("Bad type for CredentialHash");
            }
            return new CredentialHash(hash, type, 1);
        }

        static CredentialHash createEmptyHash() {
            return new CredentialHash(null, -1, 1);
        }
    }
}

