/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.database.ContentObserver;
import android.net.INetworkRecommendationProvider;
import android.net.INetworkScoreCache;
import android.net.INetworkScoreService;
import android.net.NetworkKey;
import android.net.NetworkScorerAppManager;
import android.net.RecommendationRequest;
import android.net.RecommendationResult;
import android.net.ScoredNetwork;
import android.net.Uri;
import android.net.wifi.ScanResult;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.net.wifi.WifiScanner;
import android.os.Binder;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.IRemoteCallback;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteCallback;
import android.os.RemoteCallbackList;
import android.os.RemoteException;
import android.os.UserHandle;
import android.provider.Settings;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.Log;
import android.util.Pair;
import android.util.TimedRemoteCaller;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.content.PackageMonitor;
import com.android.internal.os.TransferPipe;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;

public class NetworkScoreService
extends INetworkScoreService.Stub {
    private static final String TAG = "NetworkScoreService";
    private static final boolean DBG = Build.IS_DEBUGGABLE && Log.isLoggable("NetworkScoreService", 3);
    private static final boolean VERBOSE = Build.IS_DEBUGGABLE && Log.isLoggable("NetworkScoreService", 2);
    private final Context mContext;
    private final NetworkScorerAppManager mNetworkScorerAppManager;
    private final AtomicReference<RequestRecommendationCaller> mReqRecommendationCallerRef;
    @GuardedBy(value="mScoreCaches")
    private final Map<Integer, RemoteCallbackList<INetworkScoreCache>> mScoreCaches;
    private final Object mPackageMonitorLock = new Object();
    private final Object mServiceConnectionLock = new Object();
    private final Handler mHandler;
    private final DispatchingContentObserver mContentObserver;
    @GuardedBy(value="mPackageMonitorLock")
    private NetworkScorerPackageMonitor mPackageMonitor;
    @GuardedBy(value="mServiceConnectionLock")
    private ScoringServiceConnection mServiceConnection;
    private volatile long mRecommendationRequestTimeoutMs;
    private BroadcastReceiver mUserIntentReceiver = new BroadcastReceiver(){

        @Override
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            int userId = intent.getIntExtra("android.intent.extra.user_handle", -10000);
            if (DBG) {
                Log.d(NetworkScoreService.TAG, "Received " + action + " for userId " + userId);
            }
            if (userId == -10000) {
                return;
            }
            if ("android.intent.action.USER_UNLOCKED".equals(action)) {
                NetworkScoreService.this.onUserUnlocked(userId);
            }
        }
    };

    public NetworkScoreService(Context context) {
        this(context, new NetworkScorerAppManager(context), Looper.myLooper());
    }

    NetworkScoreService(Context context, NetworkScorerAppManager networkScoreAppManager, Looper looper) {
        this.mContext = context;
        this.mNetworkScorerAppManager = networkScoreAppManager;
        this.mScoreCaches = new ArrayMap<Integer, RemoteCallbackList<INetworkScoreCache>>();
        IntentFilter filter = new IntentFilter("android.intent.action.USER_UNLOCKED");
        this.mContext.registerReceiverAsUser(this.mUserIntentReceiver, UserHandle.SYSTEM, filter, null, null);
        this.mReqRecommendationCallerRef = new AtomicReference<RequestRecommendationCaller>(new RequestRecommendationCaller(5000L));
        this.mRecommendationRequestTimeoutMs = 5000L;
        this.mHandler = new ServiceHandler(looper);
        this.mContentObserver = new DispatchingContentObserver(context, this.mHandler);
    }

    void systemReady() {
        if (DBG) {
            Log.d(TAG, "systemReady");
        }
        this.registerPackageMonitorIfNeeded();
        this.registerRecommendationSettingsObserver();
        this.refreshRecommendationRequestTimeoutMs();
    }

    void systemRunning() {
        if (DBG) {
            Log.d(TAG, "systemRunning");
        }
        this.bindToScoringServiceIfNeeded();
    }

    private void onUserUnlocked(int userId) {
        this.registerPackageMonitorIfNeeded();
        this.bindToScoringServiceIfNeeded();
    }

    private void registerRecommendationSettingsObserver() {
        List<String> providerPackages = this.mNetworkScorerAppManager.getPotentialRecommendationProviderPackages();
        if (!providerPackages.isEmpty()) {
            Uri enabledUri = Settings.Global.getUriFor("network_recommendations_enabled");
            this.mContentObserver.observe(enabledUri, 2);
        }
        Uri timeoutUri = Settings.Global.getUriFor("network_recommendation_request_timeout_ms");
        this.mContentObserver.observe(timeoutUri, 3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerPackageMonitorIfNeeded() {
        if (DBG) {
            Log.d(TAG, "registerPackageMonitorIfNeeded");
        }
        List<String> providerPackages = this.mNetworkScorerAppManager.getPotentialRecommendationProviderPackages();
        Object object = this.mPackageMonitorLock;
        synchronized (object) {
            if (this.mPackageMonitor != null) {
                if (DBG) {
                    Log.d(TAG, "Unregistering package monitor for " + this.mPackageMonitor.mPackagesToWatch);
                }
                this.mPackageMonitor.unregister();
                this.mPackageMonitor = null;
            }
            if (!providerPackages.isEmpty()) {
                this.mPackageMonitor = new NetworkScorerPackageMonitor(providerPackages);
                this.mPackageMonitor.register(this.mContext, null, UserHandle.SYSTEM, false);
                if (DBG) {
                    Log.d(TAG, "Registered package monitor for " + this.mPackageMonitor.mPackagesToWatch);
                }
            }
        }
    }

    private void bindToScoringServiceIfNeeded() {
        if (DBG) {
            Log.d(TAG, "bindToScoringServiceIfNeeded");
        }
        NetworkScorerAppManager.NetworkScorerAppData scorerData = this.mNetworkScorerAppManager.getActiveScorer();
        this.bindToScoringServiceIfNeeded(scorerData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bindToScoringServiceIfNeeded(NetworkScorerAppManager.NetworkScorerAppData appData) {
        if (DBG) {
            Log.d(TAG, "bindToScoringServiceIfNeeded(" + appData + ")");
        }
        if (appData != null) {
            Object object = this.mServiceConnectionLock;
            synchronized (object) {
                if (this.mServiceConnection != null && !this.mServiceConnection.mAppData.equals(appData)) {
                    this.unbindFromScoringServiceIfNeeded();
                }
                if (this.mServiceConnection == null) {
                    this.mServiceConnection = new ScoringServiceConnection(appData);
                }
                this.mServiceConnection.connect(this.mContext);
            }
        } else {
            this.unbindFromScoringServiceIfNeeded();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unbindFromScoringServiceIfNeeded() {
        if (DBG) {
            Log.d(TAG, "unbindFromScoringServiceIfNeeded");
        }
        Object object = this.mServiceConnectionLock;
        synchronized (object) {
            if (this.mServiceConnection != null) {
                this.mServiceConnection.disconnect(this.mContext);
            }
            this.mServiceConnection = null;
        }
        this.clearInternal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateScores(ScoredNetwork[] networks) {
        if (!this.isCallerActiveScorer(NetworkScoreService.getCallingUid())) {
            throw new SecurityException("Caller with UID " + NetworkScoreService.getCallingUid() + " is not the active scorer.");
        }
        long token = Binder.clearCallingIdentity();
        try {
            List networkList;
            ArrayMap networksByType = new ArrayMap();
            for (ScoredNetwork network : networks) {
                networkList = (List)networksByType.get(network.networkKey.type);
                if (networkList == null) {
                    networkList = new ArrayList();
                    networksByType.put(network.networkKey.type, networkList);
                }
                networkList.add(network);
            }
            for (Map.Entry entry : networksByType.entrySet()) {
                boolean isEmpty;
                RemoteCallbackList<INetworkScoreCache> callbackList;
                networkList = this.mScoreCaches;
                synchronized (networkList) {
                    callbackList = this.mScoreCaches.get(entry.getKey());
                    isEmpty = callbackList == null || callbackList.getRegisteredCallbackCount() == 0;
                }
                if (isEmpty) {
                    if (!Log.isLoggable(TAG, 2)) continue;
                    Log.v(TAG, "No scorer registered for type " + entry.getKey() + ", discarding");
                    continue;
                }
                FilteringCacheUpdatingConsumer consumer = FilteringCacheUpdatingConsumer.create(this.mContext, (List)entry.getValue(), (Integer)entry.getKey());
                this.sendCacheUpdateCallback(consumer, Collections.singleton(callbackList));
            }
            boolean bl = true;
            return bl;
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    private boolean callerCanRequestScores() {
        return this.mContext.checkCallingOrSelfPermission("android.permission.REQUEST_NETWORK_SCORES") == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean clearScores() {
        if (this.isCallerActiveScorer(NetworkScoreService.getCallingUid()) || this.callerCanRequestScores()) {
            long token = Binder.clearCallingIdentity();
            try {
                this.clearInternal();
                boolean bl = true;
                return bl;
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }
        throw new SecurityException("Caller is neither the active scorer nor the scorer manager.");
    }

    @Override
    public boolean setActiveScorer(String packageName) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.SCORE_NETWORKS", TAG);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCallerActiveScorer(int callingUid) {
        Object object = this.mServiceConnectionLock;
        synchronized (object) {
            return this.mServiceConnection != null && ((ScoringServiceConnection)this.mServiceConnection).mAppData.packageUid == callingUid;
        }
    }

    private boolean isCallerSystemProcess(int callingUid) {
        return callingUid == 1000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getActiveScorerPackage() {
        Object object = this.mServiceConnectionLock;
        synchronized (object) {
            if (this.mServiceConnection != null) {
                return this.mServiceConnection.getPackageName();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NetworkScorerAppManager.NetworkScorerAppData getActiveScorer() {
        if (this.isCallerSystemProcess(NetworkScoreService.getCallingUid()) || this.callerCanRequestScores()) {
            Object object = this.mServiceConnectionLock;
            synchronized (object) {
                if (this.mServiceConnection != null) {
                    return this.mServiceConnection.mAppData;
                }
            }
        } else {
            throw new SecurityException("Caller is neither the system process nor a score requester.");
        }
        return null;
    }

    @Override
    public List<NetworkScorerAppManager.NetworkScorerAppData> getAllValidScorers() {
        return this.mNetworkScorerAppManager.getAllValidScorers();
    }

    @Override
    public void disableScoring() {
        if (!this.isCallerActiveScorer(NetworkScoreService.getCallingUid()) && !this.callerCanRequestScores()) {
            throw new SecurityException("Caller is neither the active scorer nor the scorer manager.");
        }
    }

    private void clearInternal() {
        this.sendCacheUpdateCallback(new BiConsumer<INetworkScoreCache, Object>(){

            @Override
            public void accept(INetworkScoreCache networkScoreCache, Object cookie) {
                block2: {
                    try {
                        networkScoreCache.clearScores();
                    }
                    catch (RemoteException e) {
                        if (!Log.isLoggable(NetworkScoreService.TAG, 2)) break block2;
                        Log.v(NetworkScoreService.TAG, "Unable to clear scores", e);
                    }
                }
            }
        }, this.getScoreCacheLists());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerNetworkScoreCache(int networkType, INetworkScoreCache scoreCache, int filterType) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.REQUEST_NETWORK_SCORES", TAG);
        long token = Binder.clearCallingIdentity();
        try {
            Map<Integer, RemoteCallbackList<INetworkScoreCache>> map = this.mScoreCaches;
            synchronized (map) {
                RemoteCallbackList<INetworkScoreCache> callbackList = this.mScoreCaches.get(networkType);
                if (callbackList == null) {
                    callbackList = new RemoteCallbackList();
                    this.mScoreCaches.put(networkType, callbackList);
                }
                if (!callbackList.register(scoreCache, filterType)) {
                    if (callbackList.getRegisteredCallbackCount() == 0) {
                        this.mScoreCaches.remove(networkType);
                    }
                    if (Log.isLoggable(TAG, 2)) {
                        Log.v(TAG, "Unable to register NetworkScoreCache for type " + networkType);
                    }
                }
            }
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterNetworkScoreCache(int networkType, INetworkScoreCache scoreCache) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.REQUEST_NETWORK_SCORES", TAG);
        long token = Binder.clearCallingIdentity();
        try {
            Map<Integer, RemoteCallbackList<INetworkScoreCache>> map = this.mScoreCaches;
            synchronized (map) {
                RemoteCallbackList<INetworkScoreCache> callbackList = this.mScoreCaches.get(networkType);
                if (callbackList == null || !callbackList.unregister(scoreCache)) {
                    if (Log.isLoggable(TAG, 2)) {
                        Log.v(TAG, "Unable to unregister NetworkScoreCache for type " + networkType);
                    }
                } else if (callbackList.getRegisteredCallbackCount() == 0) {
                    this.mScoreCaches.remove(networkType);
                }
            }
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public RecommendationResult requestRecommendation(RecommendationRequest request) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestRecommendationAsync(RecommendationRequest request, RemoteCallback remoteCallback) {
        OneTimeCallback oneTimeCallback;
        block6: {
            this.mContext.enforceCallingOrSelfPermission("android.permission.REQUEST_NETWORK_SCORES", TAG);
            oneTimeCallback = new OneTimeCallback(remoteCallback);
            final Pair<RecommendationRequest, OneTimeCallback> pair = Pair.create(request, oneTimeCallback);
            final Message timeoutMsg = this.mHandler.obtainMessage(1, pair);
            INetworkRecommendationProvider provider = this.getRecommendationProvider();
            long token = Binder.clearCallingIdentity();
            try {
                if (provider == null) break block6;
                try {
                    this.mHandler.sendMessageDelayed(timeoutMsg, this.mRecommendationRequestTimeoutMs);
                    provider.requestRecommendation(request, new IRemoteCallback.Stub(){

                        @Override
                        public void sendResult(Bundle data) throws RemoteException {
                            NetworkScoreService.this.mHandler.removeMessages(timeoutMsg.what, pair);
                            oneTimeCallback.sendResult(data);
                        }
                    }, 0);
                    return;
                }
                catch (RemoteException e) {
                    Log.w(TAG, "Failed to request a recommendation.", e);
                    this.mHandler.removeMessages(timeoutMsg.what, pair);
                }
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }
        NetworkScoreService.sendDefaultRecommendationResponse(request, oneTimeCallback);
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean requestScores(NetworkKey[] networks) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dump(final FileDescriptor fd, final PrintWriter writer, final String[] args) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.DUMP", TAG);
        long token = Binder.clearCallingIdentity();
        try {
            NetworkScorerAppManager.NetworkScorerAppData currentScorer = this.mNetworkScorerAppManager.getActiveScorer();
            if (currentScorer == null) {
                writer.println("Scoring is disabled.");
                return;
            }
            writer.println("Current scorer: " + currentScorer);
            writer.println("RecommendationRequestTimeoutMs: " + this.mRecommendationRequestTimeoutMs);
            this.sendCacheUpdateCallback(new BiConsumer<INetworkScoreCache, Object>(){

                @Override
                public void accept(INetworkScoreCache networkScoreCache, Object cookie) {
                    try {
                        TransferPipe.dumpAsync(networkScoreCache.asBinder(), fd, args);
                    }
                    catch (RemoteException | IOException e) {
                        writer.println("Failed to dump score cache: " + e);
                    }
                }
            }, this.getScoreCacheLists());
            Object object = this.mServiceConnectionLock;
            synchronized (object) {
                if (this.mServiceConnection != null) {
                    this.mServiceConnection.dump(fd, writer, args);
                } else {
                    writer.println("ScoringServiceConnection: null");
                }
            }
            writer.flush();
        }
        finally {
            Binder.restoreCallingIdentity(token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<RemoteCallbackList<INetworkScoreCache>> getScoreCacheLists() {
        Map<Integer, RemoteCallbackList<INetworkScoreCache>> map = this.mScoreCaches;
        synchronized (map) {
            return new ArrayList<RemoteCallbackList<INetworkScoreCache>>(this.mScoreCaches.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendCacheUpdateCallback(BiConsumer<INetworkScoreCache, Object> consumer, Collection<RemoteCallbackList<INetworkScoreCache>> remoteCallbackLists) {
        Iterator<RemoteCallbackList<INetworkScoreCache>> iterator = remoteCallbackLists.iterator();
        while (iterator.hasNext()) {
            RemoteCallbackList<INetworkScoreCache> callbackList;
            RemoteCallbackList<INetworkScoreCache> remoteCallbackList = callbackList = iterator.next();
            synchronized (remoteCallbackList) {
                int count = callbackList.beginBroadcast();
                try {
                    for (int i = 0; i < count; ++i) {
                        consumer.accept(callbackList.getBroadcastItem(i), callbackList.getBroadcastCookie(i));
                    }
                }
                finally {
                    callbackList.finishBroadcast();
                }
            }
        }
    }

    private void throwIfCalledOnMainThread() {
        if (Thread.currentThread() == this.mContext.getMainLooper().getThread()) {
            throw new RuntimeException("Cannot invoke on the main thread");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private INetworkRecommendationProvider getRecommendationProvider() {
        Object object = this.mServiceConnectionLock;
        synchronized (object) {
            if (this.mServiceConnection != null) {
                return this.mServiceConnection.getRecommendationProvider();
            }
        }
        return null;
    }

    public void refreshRecommendationRequestTimeoutMs() {
        ContentResolver cr = this.mContext.getContentResolver();
        long timeoutMs = Settings.Global.getLong(cr, "network_recommendation_request_timeout_ms", -1L);
        if (timeoutMs < 0L) {
            timeoutMs = 5000L;
        }
        if (DBG) {
            Log.d(TAG, "Updating the recommendation request timeout to " + timeoutMs + " ms");
        }
        this.mRecommendationRequestTimeoutMs = timeoutMs;
        this.mReqRecommendationCallerRef.set(new RequestRecommendationCaller(timeoutMs));
    }

    private static void sendDefaultRecommendationResponse(RecommendationRequest request, OneTimeCallback remoteCallback) {
        if (DBG) {
            Log.d(TAG, "Returning the default network recommendation.");
        }
        RecommendationResult result = request != null && request.getDefaultWifiConfig() != null ? RecommendationResult.createConnectRecommendation(request.getDefaultWifiConfig()) : RecommendationResult.createDoNotConnectRecommendation();
        Bundle data = new Bundle();
        data.putParcelable("android.net.extra.RECOMMENDATION_RESULT", result);
        remoteCallback.sendResult(data);
    }

    public final class ServiceHandler
    extends Handler {
        public static final int MSG_RECOMMENDATION_REQUEST_TIMEOUT = 1;
        public static final int MSG_RECOMMENDATIONS_ENABLED_CHANGED = 2;
        public static final int MSG_RECOMMENDATION_REQUEST_TIMEOUT_CHANGED = 3;

        public ServiceHandler(Looper looper) {
            super(looper);
        }

        @Override
        public void handleMessage(Message msg) {
            int what = msg.what;
            switch (what) {
                case 1: {
                    if (DBG) {
                        Log.d(NetworkScoreService.TAG, "Network recommendation request timed out.");
                    }
                    Pair pair = (Pair)msg.obj;
                    RecommendationRequest request = (RecommendationRequest)pair.first;
                    OneTimeCallback remoteCallback = (OneTimeCallback)pair.second;
                    NetworkScoreService.sendDefaultRecommendationResponse(request, remoteCallback);
                    break;
                }
                case 2: {
                    NetworkScoreService.this.bindToScoringServiceIfNeeded();
                    break;
                }
                case 3: {
                    NetworkScoreService.this.refreshRecommendationRequestTimeoutMs();
                    break;
                }
                default: {
                    Log.w(NetworkScoreService.TAG, "Unknown message: " + what);
                }
            }
        }
    }

    public static final class OneTimeCallback {
        private final RemoteCallback mRemoteCallback;
        private final AtomicBoolean mCallbackRun;

        public OneTimeCallback(RemoteCallback remoteCallback) {
            this.mRemoteCallback = remoteCallback;
            this.mCallbackRun = new AtomicBoolean(false);
        }

        public void sendResult(Bundle data) {
            if (this.mCallbackRun.compareAndSet(false, true)) {
                this.mRemoteCallback.sendResult(data);
            }
        }
    }

    private static final class RequestRecommendationCaller
    extends TimedRemoteCaller<RecommendationResult> {
        private final IRemoteCallback mCallback = new IRemoteCallback.Stub(){

            @Override
            public void sendResult(Bundle data) throws RemoteException {
                RecommendationResult result = (RecommendationResult)data.getParcelable("android.net.extra.RECOMMENDATION_RESULT");
                int sequence = data.getInt("android.net.extra.SEQUENCE", -1);
                if (VERBOSE) {
                    Log.v(NetworkScoreService.TAG, "callback received for sequence " + sequence);
                }
                this.onRemoteMethodResult(result, sequence);
            }
        };

        RequestRecommendationCaller(long callTimeoutMillis) {
            super(callTimeoutMillis);
        }

        RecommendationResult getRecommendationResult(INetworkRecommendationProvider target, RecommendationRequest request) throws RemoteException, TimeoutException {
            int sequence = this.onBeforeRemoteCall();
            if (VERBOSE) {
                Log.v(NetworkScoreService.TAG, "getRecommendationResult() seq=" + sequence);
            }
            target.requestRecommendation(request, this.mCallback, sequence);
            return (RecommendationResult)this.getResultTimed(sequence);
        }
    }

    private static class ScoringServiceConnection
    implements ServiceConnection {
        private final NetworkScorerAppManager.NetworkScorerAppData mAppData;
        private volatile boolean mBound = false;
        private volatile boolean mConnected = false;
        private volatile INetworkRecommendationProvider mRecommendationProvider;

        ScoringServiceConnection(NetworkScorerAppManager.NetworkScorerAppData appData) {
            this.mAppData = appData;
        }

        void connect(Context context) {
            if (!this.mBound) {
                Intent service = new Intent("android.net.action.RECOMMEND_NETWORKS");
                service.setComponent(this.mAppData.getRecommendationServiceComponent());
                this.mBound = context.bindServiceAsUser(service, this, 0x4000001, UserHandle.SYSTEM);
                if (!this.mBound) {
                    Log.w(NetworkScoreService.TAG, "Bind call failed for " + service);
                } else if (DBG) {
                    Log.d(NetworkScoreService.TAG, "ScoringServiceConnection bound.");
                }
            }
        }

        void disconnect(Context context) {
            try {
                if (this.mBound) {
                    this.mBound = false;
                    context.unbindService(this);
                    if (DBG) {
                        Log.d(NetworkScoreService.TAG, "ScoringServiceConnection unbound.");
                    }
                }
            }
            catch (RuntimeException e) {
                Log.e(NetworkScoreService.TAG, "Unbind failed.", e);
            }
            this.mRecommendationProvider = null;
        }

        INetworkRecommendationProvider getRecommendationProvider() {
            return this.mRecommendationProvider;
        }

        String getPackageName() {
            return this.mAppData.getRecommendationServiceComponent().getPackageName();
        }

        @Override
        public void onServiceConnected(ComponentName name, IBinder service) {
            if (DBG) {
                Log.d(NetworkScoreService.TAG, "ScoringServiceConnection: " + name.flattenToString());
            }
            this.mConnected = true;
            this.mRecommendationProvider = INetworkRecommendationProvider.Stub.asInterface(service);
        }

        @Override
        public void onServiceDisconnected(ComponentName name) {
            if (DBG) {
                Log.d(NetworkScoreService.TAG, "ScoringServiceConnection, disconnected: " + name.flattenToString());
            }
            this.mConnected = false;
            this.mRecommendationProvider = null;
        }

        public void dump(FileDescriptor fd, PrintWriter writer, String[] args) {
            writer.println("ScoringServiceConnection: " + this.mAppData.getRecommendationServiceComponent() + ", bound: " + this.mBound + ", connected: " + this.mConnected);
        }
    }

    static class ScanResultsScoreCacheFilter
    implements UnaryOperator<List<ScoredNetwork>> {
        private final Set<NetworkKey> mScanResultKeys;

        ScanResultsScoreCacheFilter(Supplier<List<ScanResult>> resultsSupplier) {
            List<ScanResult> scanResults = resultsSupplier.get();
            int size = scanResults.size();
            this.mScanResultKeys = new ArraySet<NetworkKey>(size);
            for (int i = 0; i < size; ++i) {
                ScanResult scanResult = scanResults.get(i);
                NetworkKey key = NetworkKey.createFromScanResult(scanResult);
                if (key == null) continue;
                this.mScanResultKeys.add(key);
            }
        }

        @Override
        public List<ScoredNetwork> apply(List<ScoredNetwork> scoredNetworks) {
            if (this.mScanResultKeys.isEmpty() || scoredNetworks.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<ScoredNetwork> filteredScores = new ArrayList<ScoredNetwork>();
            for (int i = 0; i < scoredNetworks.size(); ++i) {
                ScoredNetwork scoredNetwork = scoredNetworks.get(i);
                if (!this.mScanResultKeys.contains(scoredNetwork.networkKey)) continue;
                filteredScores.add(scoredNetwork);
            }
            return filteredScores;
        }
    }

    static class CurrentNetworkScoreCacheFilter
    implements UnaryOperator<List<ScoredNetwork>> {
        private final NetworkKey mCurrentNetwork;

        CurrentNetworkScoreCacheFilter(Supplier<WifiInfo> wifiInfoSupplier) {
            this.mCurrentNetwork = NetworkKey.createFromWifiInfo(wifiInfoSupplier.get());
        }

        @Override
        public List<ScoredNetwork> apply(List<ScoredNetwork> scoredNetworks) {
            if (this.mCurrentNetwork == null || scoredNetworks.isEmpty()) {
                return Collections.emptyList();
            }
            for (int i = 0; i < scoredNetworks.size(); ++i) {
                ScoredNetwork scoredNetwork = scoredNetworks.get(i);
                if (!scoredNetwork.networkKey.equals(this.mCurrentNetwork)) continue;
                return Collections.singletonList(scoredNetwork);
            }
            return Collections.emptyList();
        }
    }

    private static class ScanResultsSupplier
    implements Supplier<List<ScanResult>> {
        private final Context mContext;

        ScanResultsSupplier(Context context) {
            this.mContext = context;
        }

        @Override
        public List<ScanResult> get() {
            WifiScanner wifiScanner = this.mContext.getSystemService(WifiScanner.class);
            if (wifiScanner != null) {
                return wifiScanner.getSingleScanResults();
            }
            Log.w(NetworkScoreService.TAG, "WifiScanner is null, failed to return scan results.");
            return Collections.emptyList();
        }
    }

    private static class WifiInfoSupplier
    implements Supplier<WifiInfo> {
        private final Context mContext;

        WifiInfoSupplier(Context context) {
            this.mContext = context;
        }

        @Override
        public WifiInfo get() {
            WifiManager wifiManager = this.mContext.getSystemService(WifiManager.class);
            if (wifiManager != null) {
                return wifiManager.getConnectionInfo();
            }
            Log.w(NetworkScoreService.TAG, "WifiManager is null, failed to return the WifiInfo.");
            return null;
        }
    }

    static class FilteringCacheUpdatingConsumer
    implements BiConsumer<INetworkScoreCache, Object> {
        private final Context mContext;
        private final List<ScoredNetwork> mScoredNetworkList;
        private final int mNetworkType;
        private UnaryOperator<List<ScoredNetwork>> mCurrentNetworkFilter;
        private UnaryOperator<List<ScoredNetwork>> mScanResultsFilter;

        static FilteringCacheUpdatingConsumer create(Context context, List<ScoredNetwork> scoredNetworkList, int networkType) {
            return new FilteringCacheUpdatingConsumer(context, scoredNetworkList, networkType, null, null);
        }

        FilteringCacheUpdatingConsumer(Context context, List<ScoredNetwork> scoredNetworkList, int networkType, UnaryOperator<List<ScoredNetwork>> currentNetworkFilter, UnaryOperator<List<ScoredNetwork>> scanResultsFilter) {
            this.mContext = context;
            this.mScoredNetworkList = scoredNetworkList;
            this.mNetworkType = networkType;
            this.mCurrentNetworkFilter = currentNetworkFilter;
            this.mScanResultsFilter = scanResultsFilter;
        }

        @Override
        public void accept(INetworkScoreCache networkScoreCache, Object cookie) {
            block4: {
                int filterType = 0;
                if (cookie instanceof Integer) {
                    filterType = (Integer)cookie;
                }
                try {
                    List<ScoredNetwork> filteredNetworkList = this.filterScores(this.mScoredNetworkList, filterType);
                    if (!filteredNetworkList.isEmpty()) {
                        networkScoreCache.updateScores(filteredNetworkList);
                    }
                }
                catch (RemoteException e) {
                    if (!VERBOSE) break block4;
                    Log.v(NetworkScoreService.TAG, "Unable to update scores of type " + this.mNetworkType, e);
                }
            }
        }

        private List<ScoredNetwork> filterScores(List<ScoredNetwork> scoredNetworkList, int filterType) {
            switch (filterType) {
                case 0: {
                    return scoredNetworkList;
                }
                case 1: {
                    if (this.mCurrentNetworkFilter == null) {
                        this.mCurrentNetworkFilter = new CurrentNetworkScoreCacheFilter(new WifiInfoSupplier(this.mContext));
                    }
                    return (List)this.mCurrentNetworkFilter.apply(scoredNetworkList);
                }
                case 2: {
                    if (this.mScanResultsFilter == null) {
                        this.mScanResultsFilter = new ScanResultsScoreCacheFilter(new ScanResultsSupplier(this.mContext));
                    }
                    return (List)this.mScanResultsFilter.apply(scoredNetworkList);
                }
            }
            Log.w(NetworkScoreService.TAG, "Unknown filter type: " + filterType);
            return scoredNetworkList;
        }
    }

    public static class DispatchingContentObserver
    extends ContentObserver {
        private final Map<Uri, Integer> mUriEventMap;
        private final Context mContext;
        private final Handler mHandler;

        public DispatchingContentObserver(Context context, Handler handler) {
            super(handler);
            this.mContext = context;
            this.mHandler = handler;
            this.mUriEventMap = new ArrayMap<Uri, Integer>();
        }

        void observe(Uri uri, int what) {
            this.mUriEventMap.put(uri, what);
            ContentResolver resolver = this.mContext.getContentResolver();
            resolver.registerContentObserver(uri, false, this);
        }

        @Override
        public void onChange(boolean selfChange) {
            this.onChange(selfChange, null);
        }

        @Override
        public void onChange(boolean selfChange, Uri uri) {
            Integer what;
            if (DBG) {
                Log.d(NetworkScoreService.TAG, String.format("onChange(%s, %s)", selfChange, uri));
            }
            if ((what = this.mUriEventMap.get(uri)) != null) {
                this.mHandler.obtainMessage(what).sendToTarget();
            } else {
                Log.w(NetworkScoreService.TAG, "No matching event to send for URI = " + uri);
            }
        }
    }

    private class NetworkScorerPackageMonitor
    extends PackageMonitor {
        final List<String> mPackagesToWatch;

        private NetworkScorerPackageMonitor(List<String> packagesToWatch) {
            this.mPackagesToWatch = packagesToWatch;
        }

        @Override
        public void onPackageAdded(String packageName, int uid) {
            this.evaluateBinding(packageName, true);
        }

        @Override
        public void onPackageRemoved(String packageName, int uid) {
            this.evaluateBinding(packageName, true);
        }

        @Override
        public void onPackageModified(String packageName) {
            this.evaluateBinding(packageName, false);
        }

        @Override
        public boolean onHandleForceStop(Intent intent, String[] packages, int uid, boolean doit) {
            if (doit) {
                for (String packageName : packages) {
                    this.evaluateBinding(packageName, true);
                }
            }
            return super.onHandleForceStop(intent, packages, uid, doit);
        }

        @Override
        public void onPackageUpdateFinished(String packageName, int uid) {
            this.evaluateBinding(packageName, true);
        }

        private void evaluateBinding(String scorerPackageName, boolean forceUnbind) {
            NetworkScorerAppManager.NetworkScorerAppData activeScorer;
            if (!this.mPackagesToWatch.contains(scorerPackageName)) {
                return;
            }
            if (DBG) {
                Log.d(NetworkScoreService.TAG, "Evaluating binding for: " + scorerPackageName + ", forceUnbind=" + forceUnbind);
            }
            if ((activeScorer = NetworkScoreService.this.mNetworkScorerAppManager.getActiveScorer()) == null) {
                if (DBG) {
                    Log.d(NetworkScoreService.TAG, "No active scorers available.");
                }
                NetworkScoreService.this.unbindFromScoringServiceIfNeeded();
            } else if (activeScorer.getRecommendationServicePackageName().equals(scorerPackageName)) {
                if (DBG) {
                    Log.d(NetworkScoreService.TAG, "Possible change to the active scorer: " + activeScorer.getRecommendationServicePackageName());
                }
                if (forceUnbind) {
                    NetworkScoreService.this.unbindFromScoringServiceIfNeeded();
                }
                NetworkScoreService.this.bindToScoringServiceIfNeeded(activeScorer);
            } else {
                if (DBG) {
                    Log.d(NetworkScoreService.TAG, "Binding to " + activeScorer.getRecommendationServiceComponent() + " if needed.");
                }
                NetworkScoreService.this.bindToScoringServiceIfNeeded(activeScorer);
            }
        }
    }
}

