/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.os.RemoteException;
import android.service.gatekeeper.GateKeeperResponse;
import android.service.gatekeeper.IGateKeeperService;
import android.util.ArrayMap;
import android.util.Log;
import com.android.internal.util.ArrayUtils;
import com.android.internal.widget.VerifyCredentialResponse;
import com.android.server.LockSettingsStorage;
import com.android.server.SyntheticPasswordCrypto;
import java.nio.ByteBuffer;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import libcore.util.HexEncoding;

public class SyntheticPasswordManager {
    private static final String SP_BLOB_NAME = "spblob";
    private static final String SP_E0_NAME = "e0";
    private static final String SP_P1_NAME = "p1";
    private static final String SP_HANDLE_NAME = "handle";
    private static final String SECDISCARDABLE_NAME = "secdis";
    private static final int SECDISCARDABLE_LENGTH = 16384;
    private static final String PASSWORD_DATA_NAME = "pwd";
    public static final long DEFAULT_HANDLE = 0L;
    private static final String DEFAULT_PASSWORD = "default-password";
    private static final byte SYNTHETIC_PASSWORD_VERSION = 1;
    private static final byte SYNTHETIC_PASSWORD_PASSWORD_BASED = 0;
    private static final byte SYNTHETIC_PASSWORD_TOKEN_BASED = 1;
    private static final byte SYNTHETIC_PASSWORD_LENGTH = 32;
    private static final int PASSWORD_SCRYPT_N = 13;
    private static final int PASSWORD_SCRYPT_R = 3;
    private static final int PASSWORD_SCRYPT_P = 1;
    private static final int PASSWORD_SALT_LENGTH = 16;
    private static final int PASSWORD_TOKEN_LENGTH = 32;
    private static final String TAG = "SyntheticPasswordManager";
    private static final byte[] PERSONALISATION_SECDISCARDABLE = "secdiscardable-transform".getBytes();
    private static final byte[] PERSONALIZATION_KEY_STORE_PASSWORD = "keystore-password".getBytes();
    private static final byte[] PERSONALIZATION_USER_GK_AUTH = "user-gk-authentication".getBytes();
    private static final byte[] PERSONALIZATION_SP_GK_AUTH = "sp-gk-authentication".getBytes();
    private static final byte[] PERSONALIZATION_FBE_KEY = "fbe-key".getBytes();
    private static final byte[] PERSONALIZATION_SP_SPLIT = "sp-split".getBytes();
    private static final byte[] PERSONALIZATION_E0 = "e0-encryption".getBytes();
    private LockSettingsStorage mStorage;
    private ArrayMap<Integer, ArrayMap<Long, byte[]>> tokenMap = new ArrayMap();
    protected static final char[] hexArray = "0123456789ABCDEF".toCharArray();

    public SyntheticPasswordManager(LockSettingsStorage storage) {
        this.mStorage = storage;
    }

    public int getCredentialType(long handle, int userId) {
        byte[] passwordData = this.loadState(PASSWORD_DATA_NAME, handle, userId);
        if (passwordData == null) {
            Log.w(TAG, "getCredentialType: encountered empty password data for user " + userId);
            return -1;
        }
        return PasswordData.fromBytes((byte[])passwordData).passwordType;
    }

    public AuthenticationToken newSyntheticPasswordAndSid(IGateKeeperService gatekeeper, byte[] hash, String credential, int userId) throws RemoteException {
        AuthenticationToken result = AuthenticationToken.create();
        if (hash != null) {
            GateKeeperResponse response = gatekeeper.enroll(userId, hash, credential.getBytes(), result.deriveGkPassword());
            if (response.getResponseCode() != 0) {
                Log.w(TAG, "Fail to migrate SID, assuming no SID, user " + userId);
                this.clearSidForUser(userId);
            } else {
                this.saveSyntheticPasswordHandle(response.getPayload(), userId);
            }
        } else {
            this.clearSidForUser(userId);
        }
        this.saveEscrowData(result, userId);
        return result;
    }

    public void newSidForUser(IGateKeeperService gatekeeper, AuthenticationToken authToken, int userId) throws RemoteException {
        GateKeeperResponse response = gatekeeper.enroll(userId, null, null, authToken.deriveGkPassword());
        if (response.getResponseCode() != 0) {
            Log.e(TAG, "Fail to create new SID for user " + userId);
            return;
        }
        this.saveSyntheticPasswordHandle(response.getPayload(), userId);
    }

    public void clearSidForUser(int userId) {
        this.destroyState(SP_HANDLE_NAME, true, 0L, userId);
    }

    public boolean hasSidForUser(int userId) {
        return this.hasState(SP_HANDLE_NAME, 0L, userId);
    }

    private byte[] loadSyntheticPasswordHandle(int userId) {
        return this.loadState(SP_HANDLE_NAME, 0L, userId);
    }

    private void saveSyntheticPasswordHandle(byte[] spHandle, int userId) {
        this.saveState(SP_HANDLE_NAME, spHandle, 0L, userId);
    }

    private boolean loadEscrowData(AuthenticationToken authToken, int userId) {
        AuthenticationToken.access$502(authToken, this.loadState(SP_E0_NAME, 0L, userId));
        AuthenticationToken.access$602(authToken, this.loadState(SP_P1_NAME, 0L, userId));
        return authToken.E0 != null && authToken.P1 != null;
    }

    private void saveEscrowData(AuthenticationToken authToken, int userId) {
        this.saveState(SP_E0_NAME, authToken.E0, 0L, userId);
        this.saveState(SP_P1_NAME, authToken.P1, 0L, userId);
    }

    public boolean hasEscrowData(int userId) {
        return this.hasState(SP_E0_NAME, 0L, userId) && this.hasState(SP_P1_NAME, 0L, userId);
    }

    public void destroyEscrowData(int userId) {
        this.destroyState(SP_E0_NAME, true, 0L, userId);
        this.destroyState(SP_P1_NAME, true, 0L, userId);
    }

    public long createPasswordBasedSyntheticPassword(IGateKeeperService gatekeeper, String credential, int credentialType, AuthenticationToken authToken, int userId) throws RemoteException {
        if (credential == null || credentialType == -1) {
            credentialType = -1;
            credential = DEFAULT_PASSWORD;
        }
        long handle = SyntheticPasswordManager.generateHandle();
        PasswordData pwd = PasswordData.create(credentialType);
        byte[] pwdToken = this.computePasswordToken(credential, pwd);
        GateKeeperResponse response = gatekeeper.enroll(this.fakeUid(userId), null, null, this.passwordTokenToGkInput(pwdToken));
        if (response.getResponseCode() != 0) {
            Log.e(TAG, "Fail to enroll user password when creating SP for user " + userId);
            return 0L;
        }
        pwd.passwordHandle = response.getPayload();
        long sid = this.sidFromPasswordHandle(pwd.passwordHandle);
        this.saveState(PASSWORD_DATA_NAME, pwd.toBytes(), handle, userId);
        byte[] applicationId = this.transformUnderSecdiscardable(pwdToken, this.createSecdiscardable(handle, userId));
        this.createSyntheticPasswordBlob(handle, (byte)0, authToken, applicationId, sid, userId);
        return handle;
    }

    public long createTokenBasedSyntheticPassword(byte[] token, int userId) {
        long handle = SyntheticPasswordManager.generateHandle();
        byte[] applicationId = this.transformUnderSecdiscardable(token, this.createSecdiscardable(handle, userId));
        if (!this.tokenMap.containsKey(userId)) {
            this.tokenMap.put(userId, new ArrayMap());
        }
        this.tokenMap.get(userId).put(handle, applicationId);
        return handle;
    }

    public Set<Long> getPendingTokensForUser(int userId) {
        if (!this.tokenMap.containsKey(userId)) {
            return Collections.emptySet();
        }
        return this.tokenMap.get(userId).keySet();
    }

    public boolean removePendingToken(long handle, int userId) {
        if (!this.tokenMap.containsKey(userId)) {
            return false;
        }
        return this.tokenMap.get(userId).remove(handle) != null;
    }

    public boolean activateTokenBasedSyntheticPassword(long handle, AuthenticationToken authToken, int userId) {
        if (!this.tokenMap.containsKey(userId)) {
            return false;
        }
        byte[] applicationId = this.tokenMap.get(userId).get(handle);
        if (applicationId == null) {
            return false;
        }
        if (!this.loadEscrowData(authToken, userId)) {
            Log.w(TAG, "User is not escrowable");
            return false;
        }
        this.createSyntheticPasswordBlob(handle, (byte)1, authToken, applicationId, 0L, userId);
        this.tokenMap.get(userId).remove(handle);
        return true;
    }

    private void createSyntheticPasswordBlob(long handle, byte type, AuthenticationToken authToken, byte[] applicationId, long sid, int userId) {
        byte[] secret = type == 1 ? authToken.computeP0() : authToken.syntheticPassword.getBytes();
        byte[] content = this.createSPBlob(this.getHandleName(handle), secret, applicationId, sid);
        byte[] blob = new byte[content.length + 1 + 1];
        blob[0] = 1;
        blob[1] = type;
        System.arraycopy((byte[])content, (int)0, (byte[])blob, (int)2, (int)content.length);
        this.saveState(SP_BLOB_NAME, blob, handle, userId);
    }

    public AuthenticationResult unwrapPasswordBasedSyntheticPassword(IGateKeeperService gatekeeper, long handle, String credential, int userId) throws RemoteException {
        if (credential == null) {
            credential = DEFAULT_PASSWORD;
        }
        AuthenticationResult result = new AuthenticationResult();
        PasswordData pwd = PasswordData.fromBytes(this.loadState(PASSWORD_DATA_NAME, handle, userId));
        byte[] pwdToken = this.computePasswordToken(credential, pwd);
        byte[] gkPwdToken = this.passwordTokenToGkInput(pwdToken);
        GateKeeperResponse response = gatekeeper.verifyChallenge(this.fakeUid(userId), 0L, pwd.passwordHandle, gkPwdToken);
        int responseCode = response.getResponseCode();
        if (responseCode == 0) {
            result.gkResponse = VerifyCredentialResponse.OK;
            if (response.getShouldReEnroll()) {
                GateKeeperResponse reenrollResponse = gatekeeper.enroll(this.fakeUid(userId), pwd.passwordHandle, gkPwdToken, gkPwdToken);
                if (reenrollResponse.getResponseCode() == 0) {
                    pwd.passwordHandle = reenrollResponse.getPayload();
                    this.saveState(PASSWORD_DATA_NAME, pwd.toBytes(), handle, userId);
                } else {
                    Log.w(TAG, "Fail to re-enroll user password for user " + userId);
                }
            }
        } else {
            if (responseCode == 1) {
                result.gkResponse = new VerifyCredentialResponse(response.getTimeout());
                return result;
            }
            result.gkResponse = VerifyCredentialResponse.ERROR;
            return result;
        }
        byte[] applicationId = this.transformUnderSecdiscardable(pwdToken, this.loadSecdiscardable(handle, userId));
        result.authToken = this.unwrapSyntheticPasswordBlob(handle, (byte)0, applicationId, userId);
        result.gkResponse = this.verifyChallenge(gatekeeper, result.authToken, 0L, userId);
        return result;
    }

    public AuthenticationResult unwrapTokenBasedSyntheticPassword(IGateKeeperService gatekeeper, long handle, byte[] token, int userId) throws RemoteException {
        AuthenticationResult result = new AuthenticationResult();
        byte[] applicationId = this.transformUnderSecdiscardable(token, this.loadSecdiscardable(handle, userId));
        result.authToken = this.unwrapSyntheticPasswordBlob(handle, (byte)1, applicationId, userId);
        if (result.authToken != null) {
            result.gkResponse = this.verifyChallenge(gatekeeper, result.authToken, 0L, userId);
            if (result.gkResponse == null) {
                result.gkResponse = VerifyCredentialResponse.OK;
            }
        } else {
            result.gkResponse = VerifyCredentialResponse.ERROR;
        }
        return result;
    }

    private AuthenticationToken unwrapSyntheticPasswordBlob(long handle, byte type, byte[] applicationId, int userId) {
        byte[] blob = this.loadState(SP_BLOB_NAME, handle, userId);
        if (blob == null) {
            return null;
        }
        if (blob[0] != 1) {
            throw new RuntimeException("Unknown blob version");
        }
        if (blob[1] != type) {
            throw new RuntimeException("Invalid blob type");
        }
        byte[] secret = this.decryptSPBlob(this.getHandleName(handle), Arrays.copyOfRange(blob, 2, blob.length), applicationId);
        if (secret == null) {
            Log.e(TAG, "Fail to decrypt SP for user " + userId);
            return null;
        }
        AuthenticationToken result = new AuthenticationToken();
        if (type == 1) {
            if (!this.loadEscrowData(result, userId)) {
                Log.e(TAG, "User is not escrowable: " + userId);
                return null;
            }
            result.recreate(secret);
        } else {
            result.syntheticPassword = new String(secret);
        }
        return result;
    }

    public VerifyCredentialResponse verifyChallenge(IGateKeeperService gatekeeper, AuthenticationToken auth, long challenge, int userId) throws RemoteException {
        VerifyCredentialResponse result;
        byte[] spHandle = this.loadSyntheticPasswordHandle(userId);
        if (spHandle == null) {
            return null;
        }
        GateKeeperResponse response = gatekeeper.verifyChallenge(userId, challenge, spHandle, auth.deriveGkPassword());
        int responseCode = response.getResponseCode();
        if (responseCode == 0) {
            result = new VerifyCredentialResponse(response.getPayload());
            if (response.getShouldReEnroll()) {
                response = gatekeeper.enroll(userId, spHandle, spHandle, auth.deriveGkPassword());
                if (response.getResponseCode() == 0) {
                    spHandle = response.getPayload();
                    this.saveSyntheticPasswordHandle(spHandle, userId);
                    return this.verifyChallenge(gatekeeper, auth, challenge, userId);
                }
                Log.w(TAG, "Fail to re-enroll SP handle for user " + userId);
            }
        } else {
            result = responseCode == 1 ? new VerifyCredentialResponse(response.getTimeout()) : VerifyCredentialResponse.ERROR;
        }
        return result;
    }

    public boolean existsHandle(long handle, int userId) {
        return this.hasState(SP_BLOB_NAME, handle, userId);
    }

    public void destroyTokenBasedSyntheticPassword(long handle, int userId) {
        this.destroySyntheticPassword(handle, userId);
        this.destroyState(SECDISCARDABLE_NAME, true, handle, userId);
    }

    public void destroyPasswordBasedSyntheticPassword(long handle, int userId) {
        this.destroySyntheticPassword(handle, userId);
        this.destroyState(SECDISCARDABLE_NAME, true, handle, userId);
        this.destroyState(PASSWORD_DATA_NAME, true, handle, userId);
    }

    private void destroySyntheticPassword(long handle, int userId) {
        this.destroyState(SP_BLOB_NAME, true, handle, userId);
        this.destroyState(SP_E0_NAME, true, handle, userId);
        this.destroyState(SP_P1_NAME, true, handle, userId);
        this.destroySPBlobKey(this.getHandleName(handle));
    }

    private byte[] transformUnderSecdiscardable(byte[] data, byte[] rawSecdiscardable) {
        byte[] secdiscardable = SyntheticPasswordCrypto.personalisedHash(PERSONALISATION_SECDISCARDABLE, new byte[][]{rawSecdiscardable});
        byte[] result = new byte[data.length + secdiscardable.length];
        System.arraycopy((byte[])data, (int)0, (byte[])result, (int)0, (int)data.length);
        System.arraycopy((byte[])secdiscardable, (int)0, (byte[])result, (int)data.length, (int)secdiscardable.length);
        return result;
    }

    private byte[] createSecdiscardable(long handle, int userId) {
        byte[] data = SyntheticPasswordManager.secureRandom(16384);
        this.saveState(SECDISCARDABLE_NAME, data, handle, userId);
        return data;
    }

    private byte[] loadSecdiscardable(long handle, int userId) {
        return this.loadState(SECDISCARDABLE_NAME, handle, userId);
    }

    private boolean hasState(String stateName, long handle, int userId) {
        return !ArrayUtils.isEmpty(this.loadState(stateName, handle, userId));
    }

    private byte[] loadState(String stateName, long handle, int userId) {
        return this.mStorage.readSyntheticPasswordState(userId, handle, stateName);
    }

    private void saveState(String stateName, byte[] data, long handle, int userId) {
        this.mStorage.writeSyntheticPasswordState(userId, handle, stateName, data);
    }

    private void destroyState(String stateName, boolean secure, long handle, int userId) {
        this.mStorage.deleteSyntheticPasswordState(userId, handle, stateName, secure);
    }

    protected byte[] decryptSPBlob(String blobKeyName, byte[] blob, byte[] applicationId) {
        return SyntheticPasswordCrypto.decryptBlob(blobKeyName, blob, applicationId);
    }

    protected byte[] createSPBlob(String blobKeyName, byte[] data, byte[] applicationId, long sid) {
        return SyntheticPasswordCrypto.createBlob(blobKeyName, data, applicationId, sid);
    }

    protected void destroySPBlobKey(String keyAlias) {
        SyntheticPasswordCrypto.destroyBlobKey(keyAlias);
    }

    public static long generateHandle() {
        long result;
        SecureRandom rng = new SecureRandom();
        while ((result = rng.nextLong()) == 0L) {
        }
        return result;
    }

    private int fakeUid(int uid) {
        return 100000 + uid;
    }

    protected static byte[] secureRandom(int length) {
        try {
            return SecureRandom.getInstance("SHA1PRNG").generateSeed(length);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }

    private String getHandleName(long handle) {
        return String.format("%s%x", "synthetic_password_", handle);
    }

    private byte[] computePasswordToken(String password, PasswordData data) {
        return this.scrypt(password, data.salt, 1 << data.scryptN, 1 << data.scryptR, 1 << data.scryptP, 32);
    }

    private byte[] passwordTokenToGkInput(byte[] token) {
        return SyntheticPasswordCrypto.personalisedHash(PERSONALIZATION_USER_GK_AUTH, new byte[][]{token});
    }

    protected long sidFromPasswordHandle(byte[] handle) {
        return this.nativeSidFromPasswordHandle(handle);
    }

    protected byte[] scrypt(String password, byte[] salt, int N, int r, int p, int outLen) {
        return this.nativeScrypt(password.getBytes(), salt, N, r, p, outLen);
    }

    native long nativeSidFromPasswordHandle(byte[] var1);

    native byte[] nativeScrypt(byte[] var1, byte[] var2, int var3, int var4, int var5, int var6);

    public static String bytesToHex(byte[] bytes) {
        if (bytes == null) {
            return "null";
        }
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }

    static class PasswordData {
        byte scryptN;
        byte scryptR;
        byte scryptP;
        public int passwordType;
        byte[] salt;
        public byte[] passwordHandle;

        PasswordData() {
        }

        public static PasswordData create(int passwordType) {
            PasswordData result = new PasswordData();
            result.scryptN = (byte)13;
            result.scryptR = (byte)3;
            result.scryptP = 1;
            result.passwordType = passwordType;
            result.salt = SyntheticPasswordManager.secureRandom(16);
            return result;
        }

        public static PasswordData fromBytes(byte[] data) {
            PasswordData result = new PasswordData();
            ByteBuffer buffer = ByteBuffer.allocate(data.length);
            buffer.put(data, 0, data.length);
            buffer.flip();
            result.passwordType = buffer.getInt();
            result.scryptN = buffer.get();
            result.scryptR = buffer.get();
            result.scryptP = buffer.get();
            int saltLen = buffer.getInt();
            result.salt = new byte[saltLen];
            buffer.get(result.salt);
            int handleLen = buffer.getInt();
            result.passwordHandle = new byte[handleLen];
            buffer.get(result.passwordHandle);
            return result;
        }

        public byte[] toBytes() {
            ByteBuffer buffer = ByteBuffer.allocate(11 + this.salt.length + 4 + this.passwordHandle.length);
            buffer.putInt(this.passwordType);
            buffer.put(this.scryptN);
            buffer.put(this.scryptR);
            buffer.put(this.scryptP);
            buffer.putInt(this.salt.length);
            buffer.put(this.salt);
            buffer.putInt(this.passwordHandle.length);
            buffer.put(this.passwordHandle);
            return buffer.array();
        }
    }

    static class AuthenticationToken {
        private byte[] E0;
        private byte[] P1;
        private String syntheticPassword;

        AuthenticationToken() {
        }

        public String deriveKeyStorePassword() {
            return SyntheticPasswordManager.bytesToHex(SyntheticPasswordCrypto.personalisedHash(PERSONALIZATION_KEY_STORE_PASSWORD, new byte[][]{this.syntheticPassword.getBytes()}));
        }

        public byte[] deriveGkPassword() {
            return SyntheticPasswordCrypto.personalisedHash(PERSONALIZATION_SP_GK_AUTH, new byte[][]{this.syntheticPassword.getBytes()});
        }

        public byte[] deriveDiskEncryptionKey() {
            return SyntheticPasswordCrypto.personalisedHash(PERSONALIZATION_FBE_KEY, new byte[][]{this.syntheticPassword.getBytes()});
        }

        private void initialize(byte[] P0, byte[] P1) {
            this.P1 = P1;
            this.syntheticPassword = String.valueOf(HexEncoding.encode(SyntheticPasswordCrypto.personalisedHash(PERSONALIZATION_SP_SPLIT, P0, P1)));
            this.E0 = SyntheticPasswordCrypto.encrypt(this.syntheticPassword.getBytes(), PERSONALIZATION_E0, P0);
        }

        public void recreate(byte[] secret) {
            this.initialize(secret, this.P1);
        }

        protected static AuthenticationToken create() {
            AuthenticationToken result = new AuthenticationToken();
            result.initialize(SyntheticPasswordManager.secureRandom(32), SyntheticPasswordManager.secureRandom(32));
            return result;
        }

        public byte[] computeP0() {
            if (this.E0 == null) {
                return null;
            }
            return SyntheticPasswordCrypto.decrypt(this.syntheticPassword.getBytes(), PERSONALIZATION_E0, this.E0);
        }

        static /* synthetic */ byte[] access$502(AuthenticationToken x0, byte[] x1) {
            x0.E0 = x1;
            return x1;
        }

        static /* synthetic */ byte[] access$602(AuthenticationToken x0, byte[] x1) {
            x0.P1 = x1;
            return x1;
        }
    }

    static class AuthenticationResult {
        public AuthenticationToken authToken;
        public VerifyCredentialResponse gkResponse;

        AuthenticationResult() {
        }
    }
}

