/*
 * Decompiled with CFR 0.152.
 */
package com.android.server;

import android.content.Context;
import android.content.Intent;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.os.IUpdateLock;
import android.os.RemoteException;
import android.os.TokenWatcher;
import android.os.UserHandle;
import java.io.FileDescriptor;
import java.io.PrintWriter;

public class UpdateLockService
extends IUpdateLock.Stub {
    static final boolean DEBUG = false;
    static final String TAG = "UpdateLockService";
    static final String PERMISSION = "android.permission.UPDATE_LOCK";
    Context mContext;
    LockWatcher mLocks;

    UpdateLockService(Context context) {
        this.mContext = context;
        this.mLocks = new LockWatcher(new Handler(), "UpdateLocks");
        this.sendLockChangedBroadcast(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendLockChangedBroadcast(boolean state) {
        long oldIdent = Binder.clearCallingIdentity();
        try {
            Intent intent = new Intent("android.os.UpdateLock.UPDATE_LOCK_CHANGED").putExtra("nowisconvenient", state).putExtra("timestamp", System.currentTimeMillis()).addFlags(0x4000000);
            this.mContext.sendStickyBroadcastAsUser(intent, UserHandle.ALL);
        }
        finally {
            Binder.restoreCallingIdentity(oldIdent);
        }
    }

    @Override
    public void acquireUpdateLock(IBinder token, String tag) throws RemoteException {
        this.mContext.enforceCallingOrSelfPermission(PERMISSION, "acquireUpdateLock");
        this.mLocks.acquire(token, this.makeTag(tag));
    }

    @Override
    public void releaseUpdateLock(IBinder token) throws RemoteException {
        this.mContext.enforceCallingOrSelfPermission(PERMISSION, "releaseUpdateLock");
        this.mLocks.release(token);
    }

    private String makeTag(String tag) {
        return "{tag=" + tag + " uid=" + Binder.getCallingUid() + " pid=" + Binder.getCallingPid() + '}';
    }

    @Override
    public void dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        if (this.mContext.checkCallingOrSelfPermission("android.permission.DUMP") != 0) {
            pw.println("Permission Denial: can't dump update lock service from from pid=" + Binder.getCallingPid() + ", uid=" + Binder.getCallingUid());
            return;
        }
        this.mLocks.dump(pw);
    }

    class LockWatcher
    extends TokenWatcher {
        LockWatcher(Handler h, String tag) {
            super(h, tag);
        }

        @Override
        public void acquired() {
            UpdateLockService.this.sendLockChangedBroadcast(false);
        }

        @Override
        public void released() {
            UpdateLockService.this.sendLockChangedBroadcast(true);
        }
    }
}

