/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.content.ContentResolver;
import android.database.ContentObserver;
import android.net.Uri;
import android.os.Handler;
import android.os.SystemProperties;
import android.provider.Settings;
import android.util.KeyValueListParser;
import android.util.Slog;
import com.android.server.am.ActivityManagerService;
import java.io.PrintWriter;

final class ActivityManagerConstants
extends ContentObserver {
    private static final String KEY_ENFORCE_BG_CHECK = "enforce_bg_check";
    private static final String KEY_MAX_CACHED_PROCESSES = "max_cached_processes";
    private static final boolean DEFAULT_ENFORCE_BG_CHECK = SystemProperties.getBoolean("debug.bgcheck", true);
    private static final int DEFAULT_MAX_CACHED_PROCESSES = 32;
    public boolean ENFORCE_BG_CHECK = DEFAULT_ENFORCE_BG_CHECK;
    public int MAX_CACHED_PROCESSES = 32;
    private final ActivityManagerService mService;
    private ContentResolver mResolver;
    private final KeyValueListParser mParser = new KeyValueListParser(',');
    private int mOverrideMaxCachedProcesses = -1;
    public int CUR_MAX_CACHED_PROCESSES;
    public int CUR_MAX_EMPTY_PROCESSES;
    public int CUR_TRIM_EMPTY_PROCESSES;
    public int CUR_TRIM_CACHED_PROCESSES;

    public ActivityManagerConstants(ActivityManagerService service, Handler handler) {
        super(handler);
        this.mService = service;
        this.updateMaxCachedProcesses();
    }

    public void start(ContentResolver resolver) {
        this.mResolver = resolver;
        this.mResolver.registerContentObserver(Settings.Global.getUriFor("activity_manager_constants"), false, this);
        this.updateConstants();
    }

    public void setOverrideMaxCachedProcesses(int value) {
        this.mOverrideMaxCachedProcesses = value;
        this.updateMaxCachedProcesses();
    }

    public int getOverrideMaxCachedProcesses() {
        return this.mOverrideMaxCachedProcesses;
    }

    public static int computeEmptyProcessLimit(int totalProcessLimit) {
        return totalProcessLimit / 2;
    }

    @Override
    public void onChange(boolean selfChange, Uri uri) {
        this.updateConstants();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateConstants() {
        ActivityManagerService activityManagerService = this.mService;
        synchronized (activityManagerService) {
            try {
                this.mParser.setString(Settings.Global.getString(this.mResolver, "activity_manager_constants"));
            }
            catch (IllegalArgumentException e) {
                Slog.e("ActivityManagerConstants", "Bad activity manager config settings", e);
            }
            this.ENFORCE_BG_CHECK = this.mParser.getBoolean(KEY_ENFORCE_BG_CHECK, DEFAULT_ENFORCE_BG_CHECK);
            this.MAX_CACHED_PROCESSES = this.mParser.getInt(KEY_MAX_CACHED_PROCESSES, 32);
            this.updateMaxCachedProcesses();
        }
    }

    private void updateMaxCachedProcesses() {
        this.CUR_MAX_CACHED_PROCESSES = this.mOverrideMaxCachedProcesses < 0 ? this.MAX_CACHED_PROCESSES : this.mOverrideMaxCachedProcesses;
        this.CUR_MAX_EMPTY_PROCESSES = ActivityManagerConstants.computeEmptyProcessLimit(this.CUR_MAX_CACHED_PROCESSES);
        int rawMaxEmptyProcesses = ActivityManagerConstants.computeEmptyProcessLimit(this.MAX_CACHED_PROCESSES);
        this.CUR_TRIM_EMPTY_PROCESSES = rawMaxEmptyProcesses / 2;
        this.CUR_TRIM_CACHED_PROCESSES = (this.MAX_CACHED_PROCESSES - rawMaxEmptyProcesses) / 3;
    }

    void dump(PrintWriter pw) {
        pw.println("ACTIVITY MANAGER SETTINGS (dumpsys activity settings) activity_manager_constants:");
        pw.print("  ");
        pw.print(KEY_ENFORCE_BG_CHECK);
        pw.print("=");
        pw.println(this.ENFORCE_BG_CHECK);
        pw.print("  ");
        pw.print(KEY_MAX_CACHED_PROCESSES);
        pw.print("=");
        pw.println(this.MAX_CACHED_PROCESSES);
        pw.println();
        if (this.mOverrideMaxCachedProcesses >= 0) {
            pw.print("  mOverrideMaxCachedProcesses=");
            pw.println(this.mOverrideMaxCachedProcesses);
        }
        pw.print("  CUR_MAX_CACHED_PROCESSES=");
        pw.println(this.CUR_MAX_CACHED_PROCESSES);
        pw.print("  CUR_MAX_EMPTY_PROCESSES=");
        pw.println(this.CUR_MAX_EMPTY_PROCESSES);
        pw.print("  CUR_TRIM_EMPTY_PROCESSES=");
        pw.println(this.CUR_TRIM_EMPTY_PROCESSES);
        pw.print("  CUR_TRIM_CACHED_PROCESSES=");
        pw.println(this.CUR_TRIM_CACHED_PROCESSES);
    }
}

