/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.app.ActivityManager;
import android.app.ActivityOptions;
import android.app.AppGlobals;
import android.app.IActivityContainer;
import android.app.IActivityController;
import android.app.IActivityManager;
import android.app.IStopUserCallback;
import android.app.ProfilerInfo;
import android.app.WaitResult;
import android.app.usage.ConfigurationStats;
import android.app.usage.IUsageStatsManager;
import android.content.ComponentName;
import android.content.IIntentReceiver;
import android.content.Intent;
import android.content.pm.IPackageManager;
import android.content.pm.ParceledListSlice;
import android.content.pm.ResolveInfo;
import android.content.pm.UserInfo;
import android.content.res.AssetManager;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.graphics.Rect;
import android.os.Binder;
import android.os.Build;
import android.os.Bundle;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.ShellCommand;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.UserHandle;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.DebugUtils;
import android.util.DisplayMetrics;
import com.android.internal.util.HexDump;
import com.android.internal.util.Preconditions;
import com.android.server.am.ActivityManagerService;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

final class ActivityManagerShellCommand
extends ShellCommand {
    public static final String NO_CLASS_ERROR_CODE = "Error type 3";
    private static final String SHELL_PACKAGE_NAME = "com.android.shell";
    private static final boolean MOVING_FORWARD = true;
    private static final boolean MOVING_HORIZONTALLY = true;
    private static final boolean GREATER_THAN_TARGET = true;
    private static final int STACK_BOUNDS_INSET = 10;
    final IActivityManager mInterface;
    final ActivityManagerService mInternal;
    final IPackageManager mPm;
    private int mStartFlags = 0;
    private boolean mWaitOption = false;
    private boolean mStopOption = false;
    private int mRepeat = 0;
    private int mUserId;
    private String mReceiverPermission;
    private String mProfileFile;
    private int mSamplingInterval;
    private boolean mAutoStop;
    private boolean mStreaming;
    private int mDisplayId;
    private int mStackId;
    final boolean mDumping;

    ActivityManagerShellCommand(ActivityManagerService service, boolean dumping) {
        this.mInterface = service;
        this.mInternal = service;
        this.mPm = AppGlobals.getPackageManager();
        this.mDumping = dumping;
    }

    @Override
    public int onCommand(String cmd) {
        if (cmd == null) {
            return this.handleDefaultCommands(cmd);
        }
        PrintWriter pw = this.getOutPrintWriter();
        try {
            switch (cmd) {
                case "start": 
                case "start-activity": {
                    return this.runStartActivity(pw);
                }
                case "startservice": 
                case "start-service": {
                    return this.runStartService(pw);
                }
                case "stopservice": 
                case "stop-service": {
                    return this.runStopService(pw);
                }
                case "broadcast": {
                    return this.runSendBroadcast(pw);
                }
                case "instrument": {
                    this.getOutPrintWriter().println("Error: must be invoked through 'am instrument'.");
                    return -1;
                }
                case "trace-ipc": {
                    return this.runTraceIpc(pw);
                }
                case "profile": {
                    return this.runProfile(pw);
                }
                case "dumpheap": {
                    return this.runDumpHeap(pw);
                }
                case "set-debug-app": {
                    return this.runSetDebugApp(pw);
                }
                case "clear-debug-app": {
                    return this.runClearDebugApp(pw);
                }
                case "set-watch-heap": {
                    return this.runSetWatchHeap(pw);
                }
                case "clear-watch-heap": {
                    return this.runClearWatchHeap(pw);
                }
                case "bug-report": {
                    return this.runBugReport(pw);
                }
                case "force-stop": {
                    return this.runForceStop(pw);
                }
                case "crash": {
                    return this.runCrash(pw);
                }
                case "kill": {
                    return this.runKill(pw);
                }
                case "kill-all": {
                    return this.runKillAll(pw);
                }
                case "make-uid-idle": {
                    return this.runMakeIdle(pw);
                }
                case "monitor": {
                    return this.runMonitor(pw);
                }
                case "hang": {
                    return this.runHang(pw);
                }
                case "restart": {
                    return this.runRestart(pw);
                }
                case "idle-maintenance": {
                    return this.runIdleMaintenance(pw);
                }
                case "screen-compat": {
                    return this.runScreenCompat(pw);
                }
                case "package-importance": {
                    return this.runPackageImportance(pw);
                }
                case "to-uri": {
                    return this.runToUri(pw, 0);
                }
                case "to-intent-uri": {
                    return this.runToUri(pw, 1);
                }
                case "to-app-uri": {
                    return this.runToUri(pw, 2);
                }
                case "switch-user": {
                    return this.runSwitchUser(pw);
                }
                case "get-current-user": {
                    return this.runGetCurrentUser(pw);
                }
                case "start-user": {
                    return this.runStartUser(pw);
                }
                case "unlock-user": {
                    return this.runUnlockUser(pw);
                }
                case "stop-user": {
                    return this.runStopUser(pw);
                }
                case "is-user-stopped": {
                    return this.runIsUserStopped(pw);
                }
                case "get-started-user-state": {
                    return this.runGetStartedUserState(pw);
                }
                case "track-associations": {
                    return this.runTrackAssociations(pw);
                }
                case "untrack-associations": {
                    return this.runUntrackAssociations(pw);
                }
                case "get-uid-state": {
                    return this.getUidState(pw);
                }
                case "get-config": {
                    return this.runGetConfig(pw);
                }
                case "suppress-resize-config-changes": {
                    return this.runSuppressResizeConfigChanges(pw);
                }
                case "set-inactive": {
                    return this.runSetInactive(pw);
                }
                case "get-inactive": {
                    return this.runGetInactive(pw);
                }
                case "send-trim-memory": {
                    return this.runSendTrimMemory(pw);
                }
                case "display": {
                    return this.runDisplay(pw);
                }
                case "stack": {
                    return this.runStack(pw);
                }
                case "task": {
                    return this.runTask(pw);
                }
                case "write": {
                    return this.runWrite(pw);
                }
                case "attach-agent": {
                    return this.runAttachAgent(pw);
                }
                case "supports-multiwindow": {
                    return this.runSupportsMultiwindow(pw);
                }
                case "supports-split-screen-multi-window": {
                    return this.runSupportsSplitScreenMultiwindow(pw);
                }
                case "update-appinfo": {
                    return this.runUpdateApplicationInfo(pw);
                }
                case "no-home-screen": {
                    return this.runNoHomeScreen(pw);
                }
            }
            return this.handleDefaultCommands(cmd);
        }
        catch (RemoteException e) {
            pw.println("Remote exception: " + e);
            return -1;
        }
    }

    private Intent makeIntent(int defUser) throws URISyntaxException {
        this.mStartFlags = 0;
        this.mWaitOption = false;
        this.mStopOption = false;
        this.mRepeat = 0;
        this.mProfileFile = null;
        this.mSamplingInterval = 0;
        this.mAutoStop = false;
        this.mStreaming = false;
        this.mUserId = defUser;
        this.mDisplayId = -1;
        this.mStackId = -1;
        return Intent.parseCommandArgs(this, new Intent.CommandOptionHandler(){

            @Override
            public boolean handleOption(String opt, ShellCommand cmd) {
                if (opt.equals("-D")) {
                    ActivityManagerShellCommand.this.mStartFlags = ActivityManagerShellCommand.this.mStartFlags | 2;
                } else if (opt.equals("-N")) {
                    ActivityManagerShellCommand.this.mStartFlags = ActivityManagerShellCommand.this.mStartFlags | 8;
                } else if (opt.equals("-W")) {
                    ActivityManagerShellCommand.this.mWaitOption = true;
                } else if (opt.equals("-P")) {
                    ActivityManagerShellCommand.this.mProfileFile = ActivityManagerShellCommand.this.getNextArgRequired();
                    ActivityManagerShellCommand.this.mAutoStop = true;
                } else if (opt.equals("--start-profiler")) {
                    ActivityManagerShellCommand.this.mProfileFile = ActivityManagerShellCommand.this.getNextArgRequired();
                    ActivityManagerShellCommand.this.mAutoStop = false;
                } else if (opt.equals("--sampling")) {
                    ActivityManagerShellCommand.this.mSamplingInterval = Integer.parseInt(ActivityManagerShellCommand.this.getNextArgRequired());
                } else if (opt.equals("--streaming")) {
                    ActivityManagerShellCommand.this.mStreaming = true;
                } else if (opt.equals("-R")) {
                    ActivityManagerShellCommand.this.mRepeat = Integer.parseInt(ActivityManagerShellCommand.this.getNextArgRequired());
                } else if (opt.equals("-S")) {
                    ActivityManagerShellCommand.this.mStopOption = true;
                } else if (opt.equals("--track-allocation")) {
                    ActivityManagerShellCommand.this.mStartFlags = ActivityManagerShellCommand.this.mStartFlags | 4;
                } else if (opt.equals("--user")) {
                    ActivityManagerShellCommand.this.mUserId = UserHandle.parseUserArg(ActivityManagerShellCommand.this.getNextArgRequired());
                } else if (opt.equals("--receiver-permission")) {
                    ActivityManagerShellCommand.this.mReceiverPermission = ActivityManagerShellCommand.this.getNextArgRequired();
                } else if (opt.equals("--display")) {
                    ActivityManagerShellCommand.this.mDisplayId = Integer.parseInt(ActivityManagerShellCommand.this.getNextArgRequired());
                } else if (opt.equals("--stack")) {
                    ActivityManagerShellCommand.this.mStackId = Integer.parseInt(ActivityManagerShellCommand.this.getNextArgRequired());
                } else {
                    return false;
                }
                return true;
            }
        });
    }

    int runStartActivity(PrintWriter pw) throws RemoteException {
        Intent intent;
        try {
            intent = this.makeIntent(-2);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        if (this.mUserId == -1) {
            this.getErrPrintWriter().println("Error: Can't start service with user 'all'");
            return 1;
        }
        String mimeType = intent.getType();
        if (mimeType == null && intent.getData() != null && "content".equals(intent.getData().getScheme())) {
            mimeType = this.mInterface.getProviderMimeType(intent.getData(), this.mUserId);
        }
        do {
            int res;
            if (this.mStopOption) {
                String packageName;
                if (intent.getComponent() != null) {
                    packageName = intent.getComponent().getPackageName();
                } else {
                    List activities = this.mPm.queryIntentActivities(intent, mimeType, 0, this.mUserId).getList();
                    if (activities == null || activities.size() <= 0) {
                        this.getErrPrintWriter().println("Error: Intent does not match any activities: " + intent);
                        return 1;
                    }
                    if (activities.size() > 1) {
                        this.getErrPrintWriter().println("Error: Intent matches multiple activities; can't stop: " + intent);
                        return 1;
                    }
                    packageName = ((ResolveInfo)activities.get((int)0)).activityInfo.packageName;
                }
                pw.println("Stopping: " + packageName);
                pw.flush();
                this.mInterface.forceStopPackage(packageName, this.mUserId);
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException activities) {
                    // empty catch block
                }
            }
            ProfilerInfo profilerInfo = null;
            if (this.mProfileFile != null) {
                ParcelFileDescriptor fd = this.openOutputFileForSystem(this.mProfileFile);
                if (fd == null) {
                    return 1;
                }
                profilerInfo = new ProfilerInfo(this.mProfileFile, fd, this.mSamplingInterval, this.mAutoStop, this.mStreaming);
            }
            pw.println("Starting: " + intent);
            pw.flush();
            intent.addFlags(0x10000000);
            WaitResult result = null;
            long startTime = SystemClock.uptimeMillis();
            ActivityOptions options = null;
            if (this.mDisplayId != -1) {
                options = ActivityOptions.makeBasic();
                options.setLaunchDisplayId(this.mDisplayId);
            }
            if (this.mStackId != -1) {
                options = ActivityOptions.makeBasic();
                options.setLaunchStackId(this.mStackId);
            }
            if (this.mWaitOption) {
                result = this.mInterface.startActivityAndWait(null, null, intent, mimeType, null, null, 0, this.mStartFlags, profilerInfo, options != null ? options.toBundle() : null, this.mUserId);
                res = result.result;
            } else {
                res = this.mInterface.startActivityAsUser(null, null, intent, mimeType, null, null, 0, this.mStartFlags, profilerInfo, options != null ? options.toBundle() : null, this.mUserId);
            }
            long endTime = SystemClock.uptimeMillis();
            PrintWriter out = this.mWaitOption ? pw : this.getErrPrintWriter();
            boolean launched = false;
            switch (res) {
                case 0: {
                    launched = true;
                    break;
                }
                case 4: {
                    launched = true;
                    out.println("Warning: Activity not started because the  current activity is being kept for the user.");
                    break;
                }
                case 3: {
                    launched = true;
                    out.println("Warning: Activity not started, intent has been delivered to currently running top-most instance.");
                    break;
                }
                case 1: {
                    launched = true;
                    out.println("Warning: Activity not started because intent should be handled by the caller");
                    break;
                }
                case 2: {
                    launched = true;
                    out.println("Warning: Activity not started, its current task has been brought to the front");
                    break;
                }
                case -1: {
                    out.println("Error: Activity not started, unable to resolve " + intent.toString());
                    break;
                }
                case -2: {
                    out.println(NO_CLASS_ERROR_CODE);
                    out.println("Error: Activity class " + intent.getComponent().toShortString() + " does not exist.");
                    break;
                }
                case -3: {
                    out.println("Error: Activity not started, you requested to both forward and receive its result");
                    break;
                }
                case -4: {
                    out.println("Error: Activity not started, you do not have permission to access it.");
                    break;
                }
                case -7: {
                    out.println("Error: Activity not started, voice control not allowed for: " + intent);
                    break;
                }
                case -8: {
                    out.println("Error: Not allowed to start background user activity that shouldn't be displayed for all users.");
                    break;
                }
                default: {
                    out.println("Error: Activity not started, unknown error code " + res);
                }
            }
            out.flush();
            if (this.mWaitOption && launched) {
                if (result == null) {
                    result = new WaitResult();
                    result.who = intent.getComponent();
                }
                pw.println("Status: " + (result.timeout ? "timeout" : "ok"));
                if (result.who != null) {
                    pw.println("Activity: " + result.who.flattenToShortString());
                }
                if (result.thisTime >= 0L) {
                    pw.println("ThisTime: " + result.thisTime);
                }
                if (result.totalTime >= 0L) {
                    pw.println("TotalTime: " + result.totalTime);
                }
                pw.println("WaitTime: " + (endTime - startTime));
                pw.println("Complete");
                pw.flush();
            }
            --this.mRepeat;
            if (this.mRepeat <= 0) continue;
            this.mInterface.unhandledBack();
        } while (this.mRepeat > 0);
        return 0;
    }

    int runStartService(PrintWriter pw) throws RemoteException {
        Intent intent;
        PrintWriter err = this.getErrPrintWriter();
        try {
            intent = this.makeIntent(-2);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        if (this.mUserId == -1) {
            err.println("Error: Can't start activity with user 'all'");
            return -1;
        }
        pw.println("Starting service: " + intent);
        pw.flush();
        ComponentName cn = this.mInterface.startService(null, intent, intent.getType(), -1, null, SHELL_PACKAGE_NAME, this.mUserId);
        if (cn == null) {
            err.println("Error: Not found; no service started.");
            return -1;
        }
        if (cn.getPackageName().equals("!")) {
            err.println("Error: Requires permission " + cn.getClassName());
            return -1;
        }
        if (cn.getPackageName().equals("!!")) {
            err.println("Error: " + cn.getClassName());
            return -1;
        }
        if (cn.getPackageName().equals("?")) {
            err.println("Error: " + cn.getClassName());
            return -1;
        }
        return 0;
    }

    int runStopService(PrintWriter pw) throws RemoteException {
        Intent intent;
        PrintWriter err = this.getErrPrintWriter();
        try {
            intent = this.makeIntent(-2);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        if (this.mUserId == -1) {
            err.println("Error: Can't stop activity with user 'all'");
            return -1;
        }
        pw.println("Stopping service: " + intent);
        pw.flush();
        int result = this.mInterface.stopService(null, intent, intent.getType(), this.mUserId);
        if (result == 0) {
            err.println("Service not stopped: was not running.");
            return -1;
        }
        if (result == 1) {
            err.println("Service stopped");
            return -1;
        }
        if (result == -1) {
            err.println("Error stopping service");
            return -1;
        }
        return 0;
    }

    int runSendBroadcast(PrintWriter pw) throws RemoteException {
        String[] stringArray;
        Intent intent;
        try {
            intent = this.makeIntent(-2);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        intent.addFlags(0x400000);
        IntentReceiver receiver = new IntentReceiver(pw);
        if (this.mReceiverPermission == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = this.mReceiverPermission;
        }
        String[] requiredPermissions = stringArray;
        pw.println("Broadcasting: " + intent);
        pw.flush();
        this.mInterface.broadcastIntent(null, intent, null, receiver, 0, null, null, requiredPermissions, -1, null, true, false, this.mUserId);
        receiver.waitForFinish();
        return 0;
    }

    int runTraceIpc(PrintWriter pw) throws RemoteException {
        String op = this.getNextArgRequired();
        if (op.equals("start")) {
            return this.runTraceIpcStart(pw);
        }
        if (op.equals("stop")) {
            return this.runTraceIpcStop(pw);
        }
        this.getErrPrintWriter().println("Error: unknown trace ipc command '" + op + "'");
        return -1;
    }

    int runTraceIpcStart(PrintWriter pw) throws RemoteException {
        pw.println("Starting IPC tracing.");
        pw.flush();
        this.mInterface.startBinderTracking();
        return 0;
    }

    int runTraceIpcStop(PrintWriter pw) throws RemoteException {
        String opt;
        PrintWriter err = this.getErrPrintWriter();
        String filename = null;
        while ((opt = this.getNextOption()) != null) {
            if (opt.equals("--dump-file")) {
                filename = this.getNextArgRequired();
                continue;
            }
            err.println("Error: Unknown option: " + opt);
            return -1;
        }
        if (filename == null) {
            err.println("Error: Specify filename to dump logs to.");
            return -1;
        }
        File file = new File(filename);
        file.delete();
        ParcelFileDescriptor fd = this.openOutputFileForSystem(filename);
        if (fd == null) {
            return -1;
        }
        if (!this.mInterface.stopBinderTrackingAndDump(fd)) {
            err.println("STOP TRACE FAILED.");
            return -1;
        }
        pw.println("Stopped IPC tracing. Dumping logs to: " + filename);
        return 0;
    }

    static void removeWallOption() {
        String props = SystemProperties.get("dalvik.vm.extra-opts");
        if (props != null && props.contains("-Xprofile:wallclock")) {
            props = props.replace("-Xprofile:wallclock", "");
            props = props.trim();
            SystemProperties.set("dalvik.vm.extra-opts", props);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int runProfile(PrintWriter pw) throws RemoteException {
        String opt;
        PrintWriter err = this.getErrPrintWriter();
        String profileFile = null;
        boolean start = false;
        boolean wall = false;
        int userId = -2;
        int profileType = 0;
        this.mSamplingInterval = 0;
        this.mStreaming = false;
        String process = null;
        String cmd = this.getNextArgRequired();
        if ("start".equals(cmd)) {
            start = true;
            while ((opt = this.getNextOption()) != null) {
                if (opt.equals("--user")) {
                    userId = UserHandle.parseUserArg(this.getNextArgRequired());
                    continue;
                }
                if (opt.equals("--wall")) {
                    wall = true;
                    continue;
                }
                if (opt.equals("--streaming")) {
                    this.mStreaming = true;
                    continue;
                }
                if (opt.equals("--sampling")) {
                    this.mSamplingInterval = Integer.parseInt(this.getNextArgRequired());
                    continue;
                }
                err.println("Error: Unknown option: " + opt);
                return -1;
            }
            process = this.getNextArgRequired();
        } else if ("stop".equals(cmd)) {
            while ((opt = this.getNextOption()) != null) {
                if (opt.equals("--user")) {
                    userId = UserHandle.parseUserArg(this.getNextArgRequired());
                    continue;
                }
                err.println("Error: Unknown option: " + opt);
                return -1;
            }
            process = this.getNextArg();
        } else {
            process = cmd;
            cmd = this.getNextArgRequired();
            if ("start".equals(cmd)) {
                start = true;
            } else if (!"stop".equals(cmd)) {
                throw new IllegalArgumentException("Profile command " + process + " not valid");
            }
        }
        if (userId == -1) {
            err.println("Error: Can't profile with user 'all'");
            return -1;
        }
        ParcelFileDescriptor fd = null;
        ProfilerInfo profilerInfo = null;
        if (start) {
            profileFile = this.getNextArgRequired();
            fd = this.openOutputFileForSystem(profileFile);
            if (fd == null) {
                return -1;
            }
            profilerInfo = new ProfilerInfo(profileFile, fd, this.mSamplingInterval, false, this.mStreaming);
        }
        try {
            if (wall) {
                String props = SystemProperties.get("dalvik.vm.extra-opts");
                if (props == null || !props.contains("-Xprofile:wallclock")) {
                    props = props + " -Xprofile:wallclock";
                }
            } else if (start) {
                // empty if block
            }
            if (!this.mInterface.profileControl(process, userId, start, profilerInfo, profileType)) {
                wall = false;
                err.println("PROFILE FAILED on process " + process);
                int n = -1;
                return n;
            }
        }
        finally {
            if (!wall) {
                // empty if block
            }
        }
        return 0;
    }

    int runDumpHeap(PrintWriter pw) throws RemoteException {
        String opt;
        PrintWriter err = this.getErrPrintWriter();
        boolean managed = true;
        int userId = -2;
        while ((opt = this.getNextOption()) != null) {
            if (opt.equals("--user")) {
                userId = UserHandle.parseUserArg(this.getNextArgRequired());
                if (userId != -1) continue;
                err.println("Error: Can't dump heap with user 'all'");
                return -1;
            }
            if (opt.equals("-n")) {
                managed = false;
                continue;
            }
            err.println("Error: Unknown option: " + opt);
            return -1;
        }
        String process = this.getNextArgRequired();
        String heapFile = this.getNextArgRequired();
        File file = new File(heapFile);
        file.delete();
        ParcelFileDescriptor fd = this.openOutputFileForSystem(heapFile);
        if (fd == null) {
            return -1;
        }
        if (!this.mInterface.dumpHeap(process, userId, managed, heapFile, fd)) {
            err.println("HEAP DUMP FAILED on process " + process);
            return -1;
        }
        return 0;
    }

    int runSetDebugApp(PrintWriter pw) throws RemoteException {
        String opt;
        boolean wait = false;
        boolean persistent = false;
        while ((opt = this.getNextOption()) != null) {
            if (opt.equals("-w")) {
                wait = true;
                continue;
            }
            if (opt.equals("--persistent")) {
                persistent = true;
                continue;
            }
            this.getErrPrintWriter().println("Error: Unknown option: " + opt);
            return -1;
        }
        String pkg = this.getNextArgRequired();
        this.mInterface.setDebugApp(pkg, wait, persistent);
        return 0;
    }

    int runClearDebugApp(PrintWriter pw) throws RemoteException {
        this.mInterface.setDebugApp(null, false, true);
        return 0;
    }

    int runSetWatchHeap(PrintWriter pw) throws RemoteException {
        String proc = this.getNextArgRequired();
        String limit = this.getNextArgRequired();
        this.mInterface.setDumpHeapDebugLimit(proc, 0, Long.parseLong(limit), null);
        return 0;
    }

    int runClearWatchHeap(PrintWriter pw) throws RemoteException {
        String proc = this.getNextArgRequired();
        this.mInterface.setDumpHeapDebugLimit(proc, 0, -1L, null);
        return 0;
    }

    int runBugReport(PrintWriter pw) throws RemoteException {
        String opt;
        int bugreportType = 0;
        while ((opt = this.getNextOption()) != null) {
            if (opt.equals("--progress")) {
                bugreportType = 1;
                continue;
            }
            if (opt.equals("--telephony")) {
                bugreportType = 4;
                continue;
            }
            this.getErrPrintWriter().println("Error: Unknown option: " + opt);
            return -1;
        }
        this.mInterface.requestBugReport(bugreportType);
        pw.println("Your lovely bug report is being created; please be patient.");
        return 0;
    }

    int runForceStop(PrintWriter pw) throws RemoteException {
        String opt;
        int userId = -1;
        while ((opt = this.getNextOption()) != null) {
            if (opt.equals("--user")) {
                userId = UserHandle.parseUserArg(this.getNextArgRequired());
                continue;
            }
            this.getErrPrintWriter().println("Error: Unknown option: " + opt);
            return -1;
        }
        this.mInterface.forceStopPackage(this.getNextArgRequired(), userId);
        return 0;
    }

    int runCrash(PrintWriter pw) throws RemoteException {
        String opt;
        int userId = -1;
        while ((opt = this.getNextOption()) != null) {
            if (opt.equals("--user")) {
                userId = UserHandle.parseUserArg(this.getNextArgRequired());
                continue;
            }
            this.getErrPrintWriter().println("Error: Unknown option: " + opt);
            return -1;
        }
        int pid = -1;
        String packageName = null;
        String arg = this.getNextArgRequired();
        try {
            pid = Integer.parseInt(arg);
        }
        catch (NumberFormatException e) {
            packageName = arg;
        }
        this.mInterface.crashApplication(-1, pid, packageName, userId, "shell-induced crash");
        return 0;
    }

    int runKill(PrintWriter pw) throws RemoteException {
        String opt;
        int userId = -1;
        while ((opt = this.getNextOption()) != null) {
            if (opt.equals("--user")) {
                userId = UserHandle.parseUserArg(this.getNextArgRequired());
                continue;
            }
            this.getErrPrintWriter().println("Error: Unknown option: " + opt);
            return -1;
        }
        this.mInterface.killBackgroundProcesses(this.getNextArgRequired(), userId);
        return 0;
    }

    int runKillAll(PrintWriter pw) throws RemoteException {
        this.mInterface.killAllBackgroundProcesses();
        return 0;
    }

    int runMakeIdle(PrintWriter pw) throws RemoteException {
        String opt;
        int userId = -1;
        while ((opt = this.getNextOption()) != null) {
            if (opt.equals("--user")) {
                userId = UserHandle.parseUserArg(this.getNextArgRequired());
                continue;
            }
            this.getErrPrintWriter().println("Error: Unknown option: " + opt);
            return -1;
        }
        this.mInterface.makePackageIdle(this.getNextArgRequired(), userId);
        return 0;
    }

    int runMonitor(PrintWriter pw) throws RemoteException {
        String opt;
        String gdbPort = null;
        boolean monkey = false;
        while ((opt = this.getNextOption()) != null) {
            if (opt.equals("--gdb")) {
                gdbPort = this.getNextArgRequired();
                continue;
            }
            if (opt.equals("-m")) {
                monkey = true;
                continue;
            }
            this.getErrPrintWriter().println("Error: Unknown option: " + opt);
            return -1;
        }
        MyActivityController controller = new MyActivityController(this.mInterface, pw, this.getRawInputStream(), gdbPort, monkey);
        controller.run();
        return 0;
    }

    int runHang(PrintWriter pw) throws RemoteException {
        String opt;
        boolean allowRestart = false;
        while ((opt = this.getNextOption()) != null) {
            if (opt.equals("--allow-restart")) {
                allowRestart = true;
                continue;
            }
            this.getErrPrintWriter().println("Error: Unknown option: " + opt);
            return -1;
        }
        pw.println("Hanging the system...");
        pw.flush();
        this.mInterface.hang(new Binder(), allowRestart);
        return 0;
    }

    int runRestart(PrintWriter pw) throws RemoteException {
        String opt = this.getNextOption();
        if (opt != null) {
            this.getErrPrintWriter().println("Error: Unknown option: " + opt);
            return -1;
        }
        pw.println("Restart the system...");
        pw.flush();
        this.mInterface.restart();
        return 0;
    }

    int runIdleMaintenance(PrintWriter pw) throws RemoteException {
        String opt = this.getNextOption();
        if (opt != null) {
            this.getErrPrintWriter().println("Error: Unknown option: " + opt);
            return -1;
        }
        pw.println("Performing idle maintenance...");
        this.mInterface.sendIdleJobTrigger();
        return 0;
    }

    int runScreenCompat(PrintWriter pw) throws RemoteException {
        boolean enabled;
        String mode = this.getNextArgRequired();
        if ("on".equals(mode)) {
            enabled = true;
        } else if ("off".equals(mode)) {
            enabled = false;
        } else {
            this.getErrPrintWriter().println("Error: enabled mode must be 'on' or 'off' at " + mode);
            return -1;
        }
        String packageName = this.getNextArgRequired();
        do {
            try {
                this.mInterface.setPackageScreenCompatMode(packageName, enabled ? 1 : 0);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        } while ((packageName = this.getNextArg()) != null);
        return 0;
    }

    int runPackageImportance(PrintWriter pw) throws RemoteException {
        String packageName = this.getNextArgRequired();
        int procState = this.mInterface.getPackageProcessState(packageName, SHELL_PACKAGE_NAME);
        pw.println(ActivityManager.RunningAppProcessInfo.procStateToImportance(procState));
        return 0;
    }

    int runToUri(PrintWriter pw, int flags) throws RemoteException {
        Intent intent;
        try {
            intent = this.makeIntent(-2);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        pw.println(intent.toUri(flags));
        return 0;
    }

    int runSwitchUser(PrintWriter pw) throws RemoteException {
        String user = this.getNextArgRequired();
        this.mInterface.switchUser(Integer.parseInt(user));
        return 0;
    }

    int runGetCurrentUser(PrintWriter pw) throws RemoteException {
        UserInfo currentUser = Preconditions.checkNotNull(this.mInterface.getCurrentUser(), "Current user not set");
        pw.println(currentUser.id);
        return 0;
    }

    int runStartUser(PrintWriter pw) throws RemoteException {
        String user = this.getNextArgRequired();
        boolean success = this.mInterface.startUserInBackground(Integer.parseInt(user));
        if (success) {
            pw.println("Success: user started");
        } else {
            this.getErrPrintWriter().println("Error: could not start user");
        }
        return 0;
    }

    private static byte[] argToBytes(String arg) {
        if (arg.equals("!")) {
            return null;
        }
        return HexDump.hexStringToByteArray(arg);
    }

    int runUnlockUser(PrintWriter pw) throws RemoteException {
        byte[] secret;
        byte[] token;
        int userId = Integer.parseInt(this.getNextArgRequired());
        boolean success = this.mInterface.unlockUser(userId, token = ActivityManagerShellCommand.argToBytes(this.getNextArgRequired()), secret = ActivityManagerShellCommand.argToBytes(this.getNextArgRequired()), null);
        if (success) {
            pw.println("Success: user unlocked");
        } else {
            this.getErrPrintWriter().println("Error: could not unlock user");
        }
        return 0;
    }

    int runStopUser(PrintWriter pw) throws RemoteException {
        StopUserCallback callback;
        String opt;
        boolean wait = false;
        boolean force = false;
        while ((opt = this.getNextOption()) != null) {
            if ("-w".equals(opt)) {
                wait = true;
                continue;
            }
            if ("-f".equals(opt)) {
                force = true;
                continue;
            }
            this.getErrPrintWriter().println("Error: unknown option: " + opt);
            return -1;
        }
        int user = Integer.parseInt(this.getNextArgRequired());
        int res = this.mInterface.stopUser(user, force, callback = wait ? new StopUserCallback() : null);
        if (res != 0) {
            String txt = "";
            switch (res) {
                case -2: {
                    txt = " (Can't stop current user)";
                    break;
                }
                case -1: {
                    txt = " (Unknown user " + user + ")";
                    break;
                }
                case -3: {
                    txt = " (System user cannot be stopped)";
                    break;
                }
                case -4: {
                    txt = " (Can't stop user " + user + " - one of its related users can't be stopped)";
                }
            }
            this.getErrPrintWriter().println("Switch failed: " + res + txt);
            return -1;
        }
        if (callback != null) {
            callback.waitForFinish();
        }
        return 0;
    }

    int runIsUserStopped(PrintWriter pw) {
        int userId = UserHandle.parseUserArg(this.getNextArgRequired());
        boolean stopped = this.mInternal.isUserStopped(userId);
        pw.println(stopped);
        return 0;
    }

    int runGetStartedUserState(PrintWriter pw) throws RemoteException {
        this.mInternal.enforceCallingPermission("android.permission.DUMP", "runGetStartedUserState()");
        int userId = Integer.parseInt(this.getNextArgRequired());
        try {
            pw.println(this.mInternal.getStartedUserState(userId));
        }
        catch (NullPointerException e) {
            pw.println("User is not started: " + userId);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int runTrackAssociations(PrintWriter pw) {
        this.mInternal.enforceCallingPermission("android.permission.SET_ACTIVITY_WATCHER", "registerUidObserver()");
        ActivityManagerService activityManagerService = this.mInternal;
        synchronized (activityManagerService) {
            if (!this.mInternal.mTrackingAssociations) {
                this.mInternal.mTrackingAssociations = true;
                pw.println("Association tracking started.");
            } else {
                pw.println("Association tracking already enabled.");
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int runUntrackAssociations(PrintWriter pw) {
        this.mInternal.enforceCallingPermission("android.permission.SET_ACTIVITY_WATCHER", "registerUidObserver()");
        ActivityManagerService activityManagerService = this.mInternal;
        synchronized (activityManagerService) {
            if (this.mInternal.mTrackingAssociations) {
                this.mInternal.mTrackingAssociations = false;
                this.mInternal.mAssociations.clear();
                pw.println("Association tracking stopped.");
            } else {
                pw.println("Association tracking not running.");
            }
        }
        return 0;
    }

    int getUidState(PrintWriter pw) throws RemoteException {
        this.mInternal.enforceCallingPermission("android.permission.DUMP", "getUidState()");
        int state = this.mInternal.getUidState(Integer.parseInt(this.getNextArgRequired()));
        pw.print(state);
        pw.print(" (");
        pw.printf(DebugUtils.valueToString(ActivityManager.class, "PROCESS_STATE_", state), new Object[0]);
        pw.println(")");
        return 0;
    }

    private List<Configuration> getRecentConfigurations(int days) {
        IUsageStatsManager usm = IUsageStatsManager.Stub.asInterface(ServiceManager.getService("usagestats"));
        long now = System.currentTimeMillis();
        long nDaysAgo = now - (long)(days * 24 * 60 * 60 * 1000);
        try {
            ParceledListSlice configStatsSlice = usm.queryConfigurationStats(4, nDaysAgo, now, SHELL_PACKAGE_NAME);
            if (configStatsSlice == null) {
                return Collections.emptyList();
            }
            final ArrayMap<Configuration, Integer> recentConfigs = new ArrayMap<Configuration, Integer>();
            List configStatsList = configStatsSlice.getList();
            int configStatsListSize = configStatsList.size();
            for (int i = 0; i < configStatsListSize; ++i) {
                ConfigurationStats stats = (ConfigurationStats)configStatsList.get(i);
                int indexOfKey = recentConfigs.indexOfKey(stats.getConfiguration());
                if (indexOfKey < 0) {
                    recentConfigs.put(stats.getConfiguration(), stats.getActivationCount());
                    continue;
                }
                recentConfigs.setValueAt(indexOfKey, (Integer)recentConfigs.valueAt(indexOfKey) + stats.getActivationCount());
            }
            Comparator<Configuration> comparator = new Comparator<Configuration>(){

                @Override
                public int compare(Configuration a, Configuration b) {
                    return ((Integer)recentConfigs.get(b)).compareTo((Integer)recentConfigs.get(a));
                }
            };
            ArrayList<Configuration> configs = new ArrayList<Configuration>(recentConfigs.size());
            configs.addAll(recentConfigs.keySet());
            Collections.sort(configs, comparator);
            return configs;
        }
        catch (RemoteException e) {
            return Collections.emptyList();
        }
    }

    int runGetConfig(PrintWriter pw) throws RemoteException {
        Configuration config;
        int days = 14;
        String option = this.getNextOption();
        if (option != null) {
            if (!option.equals("--days")) {
                throw new IllegalArgumentException("unrecognized option " + option);
            }
            days = Integer.parseInt(this.getNextArgRequired());
            if (days <= 0) {
                throw new IllegalArgumentException("--days must be a positive integer");
            }
        }
        if ((config = this.mInterface.getConfiguration()) == null) {
            this.getErrPrintWriter().println("Activity manager has no configuration");
            return -1;
        }
        pw.println("config: " + Configuration.resourceQualifierString(config));
        pw.println("abi: " + TextUtils.join((CharSequence)",", Build.SUPPORTED_ABIS));
        List<Configuration> recentConfigs = this.getRecentConfigurations(days);
        int recentConfigSize = recentConfigs.size();
        if (recentConfigSize > 0) {
            pw.println("recentConfigs:");
        }
        for (int i = 0; i < recentConfigSize; ++i) {
            pw.println("  config: " + Configuration.resourceQualifierString(recentConfigs.get(i)));
        }
        return 0;
    }

    int runSuppressResizeConfigChanges(PrintWriter pw) throws RemoteException {
        boolean suppress = Boolean.valueOf(this.getNextArgRequired());
        this.mInterface.suppressResizeConfigChanges(suppress);
        return 0;
    }

    int runSetInactive(PrintWriter pw) throws RemoteException {
        String opt;
        int userId = -2;
        while ((opt = this.getNextOption()) != null) {
            if (opt.equals("--user")) {
                userId = UserHandle.parseUserArg(this.getNextArgRequired());
                continue;
            }
            this.getErrPrintWriter().println("Error: Unknown option: " + opt);
            return -1;
        }
        String packageName = this.getNextArgRequired();
        String value = this.getNextArgRequired();
        IUsageStatsManager usm = IUsageStatsManager.Stub.asInterface(ServiceManager.getService("usagestats"));
        usm.setAppInactive(packageName, Boolean.parseBoolean(value), userId);
        return 0;
    }

    int runGetInactive(PrintWriter pw) throws RemoteException {
        String opt;
        int userId = -2;
        while ((opt = this.getNextOption()) != null) {
            if (opt.equals("--user")) {
                userId = UserHandle.parseUserArg(this.getNextArgRequired());
                continue;
            }
            this.getErrPrintWriter().println("Error: Unknown option: " + opt);
            return -1;
        }
        String packageName = this.getNextArgRequired();
        IUsageStatsManager usm = IUsageStatsManager.Stub.asInterface(ServiceManager.getService("usagestats"));
        boolean isIdle = usm.isAppInactive(packageName, userId);
        pw.println("Idle=" + isIdle);
        return 0;
    }

    int runSendTrimMemory(PrintWriter pw) throws RemoteException {
        int level;
        String levelArg;
        String opt;
        int userId = -2;
        while ((opt = this.getNextOption()) != null) {
            if (opt.equals("--user")) {
                userId = UserHandle.parseUserArg(this.getNextArgRequired());
                if (userId != -1) continue;
                this.getErrPrintWriter().println("Error: Can't use user 'all'");
                return -1;
            }
            this.getErrPrintWriter().println("Error: Unknown option: " + opt);
            return -1;
        }
        String proc = this.getNextArgRequired();
        switch (levelArg = this.getNextArgRequired()) {
            case "HIDDEN": {
                level = 20;
                break;
            }
            case "RUNNING_MODERATE": {
                level = 5;
                break;
            }
            case "BACKGROUND": {
                level = 40;
                break;
            }
            case "RUNNING_LOW": {
                level = 10;
                break;
            }
            case "MODERATE": {
                level = 60;
                break;
            }
            case "RUNNING_CRITICAL": {
                level = 15;
                break;
            }
            case "COMPLETE": {
                level = 80;
                break;
            }
            default: {
                this.getErrPrintWriter().println("Error: Unknown level option: " + levelArg);
                return -1;
            }
        }
        if (!this.mInterface.setProcessMemoryTrimLevel(proc, userId, level)) {
            this.getErrPrintWriter().println("Unknown error: failed to set trim level");
            return -1;
        }
        return 0;
    }

    int runDisplay(PrintWriter pw) throws RemoteException {
        String op;
        switch (op = this.getNextArgRequired()) {
            case "move-stack": {
                return this.runDisplayMoveStack(pw);
            }
        }
        this.getErrPrintWriter().println("Error: unknown command '" + op + "'");
        return -1;
    }

    int runStack(PrintWriter pw) throws RemoteException {
        String op;
        switch (op = this.getNextArgRequired()) {
            case "start": {
                return this.runStackStart(pw);
            }
            case "move-task": {
                return this.runStackMoveTask(pw);
            }
            case "resize": {
                return this.runStackResize(pw);
            }
            case "resize-animated": {
                return this.runStackResizeAnimated(pw);
            }
            case "resize-docked-stack": {
                return this.runStackResizeDocked(pw);
            }
            case "positiontask": {
                return this.runStackPositionTask(pw);
            }
            case "list": {
                return this.runStackList(pw);
            }
            case "info": {
                return this.runStackInfo(pw);
            }
            case "move-top-activity-to-pinned-stack": {
                return this.runMoveTopActivityToPinnedStack(pw);
            }
            case "size-docked-stack-test": {
                return this.runStackSizeDockedStackTest(pw);
            }
            case "remove": {
                return this.runStackRemove(pw);
            }
        }
        this.getErrPrintWriter().println("Error: unknown command '" + op + "'");
        return -1;
    }

    private Rect getBounds() {
        String leftStr = this.getNextArgRequired();
        int left = Integer.parseInt(leftStr);
        String topStr = this.getNextArgRequired();
        int top = Integer.parseInt(topStr);
        String rightStr = this.getNextArgRequired();
        int right = Integer.parseInt(rightStr);
        String bottomStr = this.getNextArgRequired();
        int bottom = Integer.parseInt(bottomStr);
        if (left < 0) {
            this.getErrPrintWriter().println("Error: bad left arg: " + leftStr);
            return null;
        }
        if (top < 0) {
            this.getErrPrintWriter().println("Error: bad top arg: " + topStr);
            return null;
        }
        if (right <= 0) {
            this.getErrPrintWriter().println("Error: bad right arg: " + rightStr);
            return null;
        }
        if (bottom <= 0) {
            this.getErrPrintWriter().println("Error: bad bottom arg: " + bottomStr);
            return null;
        }
        return new Rect(left, top, right, bottom);
    }

    int runDisplayMoveStack(PrintWriter pw) throws RemoteException {
        String stackIdStr = this.getNextArgRequired();
        int stackId = Integer.parseInt(stackIdStr);
        String displayIdStr = this.getNextArgRequired();
        int displayId = Integer.parseInt(displayIdStr);
        this.mInterface.moveStackToDisplay(stackId, displayId);
        return 0;
    }

    int runStackStart(PrintWriter pw) throws RemoteException {
        Intent intent;
        String displayIdStr = this.getNextArgRequired();
        int displayId = Integer.parseInt(displayIdStr);
        try {
            intent = this.makeIntent(-2);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        IActivityContainer container = this.mInterface.createStackOnDisplay(displayId);
        if (container != null) {
            container.startActivity(intent);
        }
        return 0;
    }

    int runStackMoveTask(PrintWriter pw) throws RemoteException {
        boolean toTop;
        String taskIdStr = this.getNextArgRequired();
        int taskId = Integer.parseInt(taskIdStr);
        String stackIdStr = this.getNextArgRequired();
        int stackId = Integer.parseInt(stackIdStr);
        String toTopStr = this.getNextArgRequired();
        if ("true".equals(toTopStr)) {
            toTop = true;
        } else if ("false".equals(toTopStr)) {
            toTop = false;
        } else {
            this.getErrPrintWriter().println("Error: bad toTop arg: " + toTopStr);
            return -1;
        }
        this.mInterface.moveTaskToStack(taskId, stackId, toTop);
        return 0;
    }

    int runStackResize(PrintWriter pw) throws RemoteException {
        String stackIdStr = this.getNextArgRequired();
        int stackId = Integer.parseInt(stackIdStr);
        Rect bounds = this.getBounds();
        if (bounds == null) {
            this.getErrPrintWriter().println("Error: invalid input bounds");
            return -1;
        }
        return this.resizeStack(stackId, bounds, 0);
    }

    int runStackResizeAnimated(PrintWriter pw) throws RemoteException {
        Rect bounds;
        String stackIdStr = this.getNextArgRequired();
        int stackId = Integer.parseInt(stackIdStr);
        if ("null".equals(this.peekNextArg())) {
            bounds = null;
        } else {
            bounds = this.getBounds();
            if (bounds == null) {
                this.getErrPrintWriter().println("Error: invalid input bounds");
                return -1;
            }
        }
        return this.resizeStackUnchecked(stackId, bounds, 0, true);
    }

    int resizeStackUnchecked(int stackId, Rect bounds, int delayMs, boolean animate) throws RemoteException {
        try {
            this.mInterface.resizeStack(stackId, bounds, false, false, animate, -1);
            Thread.sleep(delayMs);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return 0;
    }

    int runStackResizeDocked(PrintWriter pw) throws RemoteException {
        Rect bounds = this.getBounds();
        Rect taskBounds = this.getBounds();
        if (bounds == null || taskBounds == null) {
            this.getErrPrintWriter().println("Error: invalid input bounds");
            return -1;
        }
        this.mInterface.resizeDockedStack(bounds, taskBounds, null, null, null);
        return 0;
    }

    int resizeStack(int stackId, Rect bounds, int delayMs) throws RemoteException {
        if (bounds == null) {
            this.getErrPrintWriter().println("Error: invalid input bounds");
            return -1;
        }
        return this.resizeStackUnchecked(stackId, bounds, delayMs, false);
    }

    int runStackPositionTask(PrintWriter pw) throws RemoteException {
        String taskIdStr = this.getNextArgRequired();
        int taskId = Integer.parseInt(taskIdStr);
        String stackIdStr = this.getNextArgRequired();
        int stackId = Integer.parseInt(stackIdStr);
        String positionStr = this.getNextArgRequired();
        int position = Integer.parseInt(positionStr);
        this.mInterface.positionTaskInStack(taskId, stackId, position);
        return 0;
    }

    int runStackList(PrintWriter pw) throws RemoteException {
        List<ActivityManager.StackInfo> stacks = this.mInterface.getAllStackInfos();
        for (ActivityManager.StackInfo info : stacks) {
            pw.println(info);
        }
        return 0;
    }

    int runStackInfo(PrintWriter pw) throws RemoteException {
        String stackIdStr = this.getNextArgRequired();
        int stackId = Integer.parseInt(stackIdStr);
        ActivityManager.StackInfo info = this.mInterface.getStackInfo(stackId);
        pw.println(info);
        return 0;
    }

    int runStackRemove(PrintWriter pw) throws RemoteException {
        String stackIdStr = this.getNextArgRequired();
        int stackId = Integer.parseInt(stackIdStr);
        this.mInterface.removeStack(stackId);
        return 0;
    }

    int runMoveTopActivityToPinnedStack(PrintWriter pw) throws RemoteException {
        int stackId = Integer.parseInt(this.getNextArgRequired());
        Rect bounds = this.getBounds();
        if (bounds == null) {
            this.getErrPrintWriter().println("Error: invalid input bounds");
            return -1;
        }
        if (!this.mInterface.moveTopActivityToPinnedStack(stackId, bounds)) {
            this.getErrPrintWriter().println("Didn't move top activity to pinned stack.");
            return -1;
        }
        return 0;
    }

    int runStackSizeDockedStackTest(PrintWriter pw) throws RemoteException {
        int res;
        int maxChange;
        int currentPoint;
        PrintWriter err = this.getErrPrintWriter();
        int stepSize = Integer.parseInt(this.getNextArgRequired());
        String side = this.getNextArgRequired();
        String delayStr = this.getNextArg();
        int delayMs = delayStr != null ? Integer.parseInt(delayStr) : 0;
        ActivityManager.StackInfo info = this.mInterface.getStackInfo(3);
        if (info == null) {
            err.println("Docked stack doesn't exist");
            return -1;
        }
        if (info.bounds == null) {
            err.println("Docked stack doesn't have a bounds");
            return -1;
        }
        Rect bounds = info.bounds;
        boolean horizontalGrowth = "l".equals(side) || "r".equals(side);
        int changeSize = (horizontalGrowth ? bounds.width() : bounds.height()) / 2;
        switch (side) {
            case "l": {
                currentPoint = bounds.left;
                break;
            }
            case "r": {
                currentPoint = bounds.right;
                break;
            }
            case "t": {
                currentPoint = bounds.top;
                break;
            }
            case "b": {
                currentPoint = bounds.bottom;
                break;
            }
            default: {
                err.println("Unknown growth side: " + side);
                return -1;
            }
        }
        int startPoint = currentPoint;
        int minPoint = currentPoint - changeSize;
        int maxPoint = currentPoint + changeSize;
        pw.println("Shrinking docked stack side=" + side);
        pw.flush();
        while (currentPoint > minPoint) {
            maxChange = Math.min(stepSize, currentPoint - minPoint);
            this.setBoundsSide(bounds, side, currentPoint -= maxChange);
            res = this.resizeStack(3, bounds, delayMs);
            if (res >= 0) continue;
            return res;
        }
        pw.println("Growing docked stack side=" + side);
        pw.flush();
        while (currentPoint < maxPoint) {
            maxChange = Math.min(stepSize, maxPoint - currentPoint);
            this.setBoundsSide(bounds, side, currentPoint += maxChange);
            res = this.resizeStack(3, bounds, delayMs);
            if (res >= 0) continue;
            return res;
        }
        pw.println("Back to Original size side=" + side);
        pw.flush();
        while (currentPoint > startPoint) {
            maxChange = Math.min(stepSize, currentPoint - startPoint);
            this.setBoundsSide(bounds, side, currentPoint -= maxChange);
            res = this.resizeStack(3, bounds, delayMs);
            if (res >= 0) continue;
            return res;
        }
        return 0;
    }

    void setBoundsSide(Rect bounds, String side, int value) {
        switch (side) {
            case "l": {
                bounds.left = value;
                break;
            }
            case "r": {
                bounds.right = value;
                break;
            }
            case "t": {
                bounds.top = value;
                break;
            }
            case "b": {
                bounds.bottom = value;
                break;
            }
            default: {
                this.getErrPrintWriter().println("Unknown set side: " + side);
            }
        }
    }

    int runTask(PrintWriter pw) throws RemoteException {
        String op = this.getNextArgRequired();
        if (op.equals("lock")) {
            return this.runTaskLock(pw);
        }
        if (op.equals("resizeable")) {
            return this.runTaskResizeable(pw);
        }
        if (op.equals("resize")) {
            return this.runTaskResize(pw);
        }
        if (op.equals("drag-task-test")) {
            return this.runTaskDragTaskTest(pw);
        }
        if (op.equals("size-task-test")) {
            return this.runTaskSizeTaskTest(pw);
        }
        if (op.equals("focus")) {
            return this.runTaskFocus(pw);
        }
        this.getErrPrintWriter().println("Error: unknown command '" + op + "'");
        return -1;
    }

    int runTaskLock(PrintWriter pw) throws RemoteException {
        String taskIdStr = this.getNextArgRequired();
        if (taskIdStr.equals("stop")) {
            this.mInterface.stopLockTaskMode();
        } else {
            int taskId = Integer.parseInt(taskIdStr);
            this.mInterface.startSystemLockTaskMode(taskId);
        }
        pw.println("Activity manager is " + (this.mInterface.isInLockTaskMode() ? "" : "not ") + "in lockTaskMode");
        return 0;
    }

    int runTaskResizeable(PrintWriter pw) throws RemoteException {
        String taskIdStr = this.getNextArgRequired();
        int taskId = Integer.parseInt(taskIdStr);
        String resizeableStr = this.getNextArgRequired();
        int resizeableMode = Integer.parseInt(resizeableStr);
        this.mInterface.setTaskResizeable(taskId, resizeableMode);
        return 0;
    }

    int runTaskResize(PrintWriter pw) throws RemoteException {
        String taskIdStr = this.getNextArgRequired();
        int taskId = Integer.parseInt(taskIdStr);
        Rect bounds = this.getBounds();
        if (bounds == null) {
            this.getErrPrintWriter().println("Error: invalid input bounds");
            return -1;
        }
        this.taskResize(taskId, bounds, 0, false);
        return 0;
    }

    void taskResize(int taskId, Rect bounds, int delay_ms, boolean pretendUserResize) throws RemoteException {
        int resizeMode = pretendUserResize ? 1 : 0;
        this.mInterface.resizeTask(taskId, bounds, resizeMode);
        try {
            Thread.sleep(delay_ms);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    int runTaskDragTaskTest(PrintWriter pw) throws RemoteException {
        int taskId = Integer.parseInt(this.getNextArgRequired());
        int stepSize = Integer.parseInt(this.getNextArgRequired());
        String delayStr = this.getNextArg();
        int delay_ms = delayStr != null ? Integer.parseInt(delayStr) : 0;
        ActivityManager.StackInfo stackInfo = this.mInterface.getStackInfo(this.mInterface.getFocusedStackId());
        Rect taskBounds = this.mInterface.getTaskBounds(taskId);
        Rect stackBounds = stackInfo.bounds;
        int travelRight = stackBounds.width() - taskBounds.width();
        int travelLeft = -travelRight;
        int travelDown = stackBounds.height() - taskBounds.height();
        int travelUp = -travelDown;
        for (int passes = 0; passes < 2; ++passes) {
            pw.println("Moving right...");
            pw.flush();
            travelRight = this.moveTask(taskId, taskBounds, stackBounds, stepSize, travelRight, true, true, delay_ms);
            pw.println("Still need to travel right by " + travelRight);
            pw.println("Moving down...");
            pw.flush();
            travelDown = this.moveTask(taskId, taskBounds, stackBounds, stepSize, travelDown, true, false, delay_ms);
            pw.println("Still need to travel down by " + travelDown);
            pw.println("Moving left...");
            pw.flush();
            travelLeft = this.moveTask(taskId, taskBounds, stackBounds, stepSize, travelLeft, false, true, delay_ms);
            pw.println("Still need to travel left by " + travelLeft);
            pw.println("Moving up...");
            pw.flush();
            travelUp = this.moveTask(taskId, taskBounds, stackBounds, stepSize, travelUp, false, false, delay_ms);
            pw.println("Still need to travel up by " + travelUp);
            taskBounds = this.mInterface.getTaskBounds(taskId);
        }
        return 0;
    }

    int moveTask(int taskId, Rect taskRect, Rect stackRect, int stepSize, int maxToTravel, boolean movingForward, boolean horizontal, int delay_ms) throws RemoteException {
        if (movingForward) {
            while (maxToTravel > 0 && (horizontal && taskRect.right < stackRect.right || !horizontal && taskRect.bottom < stackRect.bottom)) {
                int maxMove;
                if (horizontal) {
                    maxMove = Math.min(stepSize, stackRect.right - taskRect.right);
                    maxToTravel -= maxMove;
                    taskRect.right += maxMove;
                    taskRect.left += maxMove;
                } else {
                    maxMove = Math.min(stepSize, stackRect.bottom - taskRect.bottom);
                    maxToTravel -= maxMove;
                    taskRect.top += maxMove;
                    taskRect.bottom += maxMove;
                }
                this.taskResize(taskId, taskRect, delay_ms, false);
            }
        } else {
            while (maxToTravel < 0 && (horizontal && taskRect.left > stackRect.left || !horizontal && taskRect.top > stackRect.top)) {
                int maxMove;
                if (horizontal) {
                    maxMove = Math.min(stepSize, taskRect.left - stackRect.left);
                    maxToTravel -= maxMove;
                    taskRect.right -= maxMove;
                    taskRect.left -= maxMove;
                } else {
                    maxMove = Math.min(stepSize, taskRect.top - stackRect.top);
                    maxToTravel -= maxMove;
                    taskRect.top -= maxMove;
                    taskRect.bottom -= maxMove;
                }
                this.taskResize(taskId, taskRect, delay_ms, false);
            }
        }
        return maxToTravel;
    }

    int getStepSize(int current, int target, int inStepSize, boolean greaterThanTarget) {
        int stepSize = 0;
        if (greaterThanTarget && target < current) {
            stepSize = inStepSize;
            if (target > (current -= inStepSize)) {
                stepSize -= target - current;
            }
        }
        if (!greaterThanTarget && target > current) {
            stepSize = inStepSize;
            if (target < (current += inStepSize)) {
                stepSize += current - target;
            }
        }
        return stepSize;
    }

    int runTaskSizeTaskTest(PrintWriter pw) throws RemoteException {
        int taskId = Integer.parseInt(this.getNextArgRequired());
        int stepSize = Integer.parseInt(this.getNextArgRequired());
        String delayStr = this.getNextArg();
        int delay_ms = delayStr != null ? Integer.parseInt(delayStr) : 0;
        ActivityManager.StackInfo stackInfo = this.mInterface.getStackInfo(this.mInterface.getFocusedStackId());
        Rect initialTaskBounds = this.mInterface.getTaskBounds(taskId);
        Rect stackBounds = stackInfo.bounds;
        stackBounds.inset(10, 10);
        Rect currentTaskBounds = new Rect(initialTaskBounds);
        pw.println("Growing top-left");
        pw.flush();
        do {
            currentTaskBounds.top -= this.getStepSize(currentTaskBounds.top, stackBounds.top, stepSize, true);
            currentTaskBounds.left -= this.getStepSize(currentTaskBounds.left, stackBounds.left, stepSize, true);
            this.taskResize(taskId, currentTaskBounds, delay_ms, true);
        } while (stackBounds.top < currentTaskBounds.top || stackBounds.left < currentTaskBounds.left);
        pw.println("Shrinking top-left");
        pw.flush();
        do {
            currentTaskBounds.top += this.getStepSize(currentTaskBounds.top, initialTaskBounds.top, stepSize, false);
            currentTaskBounds.left += this.getStepSize(currentTaskBounds.left, initialTaskBounds.left, stepSize, false);
            this.taskResize(taskId, currentTaskBounds, delay_ms, true);
        } while (initialTaskBounds.top > currentTaskBounds.top || initialTaskBounds.left > currentTaskBounds.left);
        pw.println("Growing top-right");
        pw.flush();
        do {
            currentTaskBounds.top -= this.getStepSize(currentTaskBounds.top, stackBounds.top, stepSize, true);
            currentTaskBounds.right += this.getStepSize(currentTaskBounds.right, stackBounds.right, stepSize, false);
            this.taskResize(taskId, currentTaskBounds, delay_ms, true);
        } while (stackBounds.top < currentTaskBounds.top || stackBounds.right > currentTaskBounds.right);
        pw.println("Shrinking top-right");
        pw.flush();
        do {
            currentTaskBounds.top += this.getStepSize(currentTaskBounds.top, initialTaskBounds.top, stepSize, false);
            currentTaskBounds.right -= this.getStepSize(currentTaskBounds.right, initialTaskBounds.right, stepSize, true);
            this.taskResize(taskId, currentTaskBounds, delay_ms, true);
        } while (initialTaskBounds.top > currentTaskBounds.top || initialTaskBounds.right < currentTaskBounds.right);
        pw.println("Growing bottom-left");
        pw.flush();
        do {
            currentTaskBounds.bottom += this.getStepSize(currentTaskBounds.bottom, stackBounds.bottom, stepSize, false);
            currentTaskBounds.left -= this.getStepSize(currentTaskBounds.left, stackBounds.left, stepSize, true);
            this.taskResize(taskId, currentTaskBounds, delay_ms, true);
        } while (stackBounds.bottom > currentTaskBounds.bottom || stackBounds.left < currentTaskBounds.left);
        pw.println("Shrinking bottom-left");
        pw.flush();
        do {
            currentTaskBounds.bottom -= this.getStepSize(currentTaskBounds.bottom, initialTaskBounds.bottom, stepSize, true);
            currentTaskBounds.left += this.getStepSize(currentTaskBounds.left, initialTaskBounds.left, stepSize, false);
            this.taskResize(taskId, currentTaskBounds, delay_ms, true);
        } while (initialTaskBounds.bottom < currentTaskBounds.bottom || initialTaskBounds.left > currentTaskBounds.left);
        pw.println("Growing bottom-right");
        pw.flush();
        do {
            currentTaskBounds.bottom += this.getStepSize(currentTaskBounds.bottom, stackBounds.bottom, stepSize, false);
            currentTaskBounds.right += this.getStepSize(currentTaskBounds.right, stackBounds.right, stepSize, false);
            this.taskResize(taskId, currentTaskBounds, delay_ms, true);
        } while (stackBounds.bottom > currentTaskBounds.bottom || stackBounds.right > currentTaskBounds.right);
        pw.println("Shrinking bottom-right");
        pw.flush();
        do {
            currentTaskBounds.bottom -= this.getStepSize(currentTaskBounds.bottom, initialTaskBounds.bottom, stepSize, true);
            currentTaskBounds.right -= this.getStepSize(currentTaskBounds.right, initialTaskBounds.right, stepSize, true);
            this.taskResize(taskId, currentTaskBounds, delay_ms, true);
        } while (initialTaskBounds.bottom < currentTaskBounds.bottom || initialTaskBounds.right < currentTaskBounds.right);
        return 0;
    }

    int runTaskFocus(PrintWriter pw) throws RemoteException {
        int taskId = Integer.parseInt(this.getNextArgRequired());
        pw.println("Setting focus to task " + taskId);
        this.mInterface.setFocusedTask(taskId);
        return 0;
    }

    int runWrite(PrintWriter pw) {
        this.mInternal.enforceCallingPermission("android.permission.SET_ACTIVITY_WATCHER", "registerUidObserver()");
        this.mInternal.mRecentTasks.flush();
        pw.println("All tasks persisted.");
        return 0;
    }

    int runAttachAgent(PrintWriter pw) {
        this.mInternal.enforceCallingPermission("android.permission.SET_ACTIVITY_WATCHER", "attach-agent");
        String process = this.getNextArgRequired();
        String agent = this.getNextArgRequired();
        String opt = this.getNextArg();
        if (opt != null) {
            pw.println("Error: Unknown option: " + opt);
            return -1;
        }
        this.mInternal.attachAgent(process, agent);
        return 0;
    }

    int runSupportsMultiwindow(PrintWriter pw) throws RemoteException {
        Resources res = this.getResources(pw);
        if (res == null) {
            return -1;
        }
        pw.println(res.getBoolean(17957009));
        return 0;
    }

    int runSupportsSplitScreenMultiwindow(PrintWriter pw) throws RemoteException {
        Resources res = this.getResources(pw);
        if (res == null) {
            return -1;
        }
        pw.println(res.getBoolean(17957010));
        return 0;
    }

    int runUpdateApplicationInfo(PrintWriter pw) throws RemoteException {
        String packageName;
        int userid = UserHandle.parseUserArg(this.getNextArgRequired());
        ArrayList<String> packages = new ArrayList<String>();
        packages.add(this.getNextArgRequired());
        while ((packageName = this.getNextArg()) != null) {
            packages.add(packageName);
        }
        this.mInternal.scheduleApplicationInfoChanged(packages, userid);
        pw.println("Packages updated with most recent ApplicationInfos.");
        return 0;
    }

    int runNoHomeScreen(PrintWriter pw) throws RemoteException {
        Resources res = this.getResources(pw);
        if (res == null) {
            return -1;
        }
        pw.println(res.getBoolean(17956974));
        return 0;
    }

    private Resources getResources(PrintWriter pw) throws RemoteException {
        Configuration config = this.mInterface.getConfiguration();
        if (config == null) {
            pw.println("Error: Activity manager has no configuration");
            return null;
        }
        DisplayMetrics metrics = new DisplayMetrics();
        metrics.setToDefaults();
        return new Resources(AssetManager.getSystem(), metrics, config);
    }

    @Override
    public void onHelp() {
        PrintWriter pw = this.getOutPrintWriter();
        ActivityManagerShellCommand.dumpHelp(pw, this.mDumping);
    }

    static void dumpHelp(PrintWriter pw, boolean dumping) {
        if (dumping) {
            pw.println("Activity manager dump options:");
            pw.println("  [-a] [-c] [-p PACKAGE] [-h] [WHAT] ...");
            pw.println("  WHAT may be one of:");
            pw.println("    a[ctivities]: activity stack state");
            pw.println("    r[recents]: recent activities state");
            pw.println("    b[roadcasts] [PACKAGE_NAME] [history [-s]]: broadcast state");
            pw.println("    broadcast-stats [PACKAGE_NAME]: aggregated broadcast statistics");
            pw.println("    i[ntents] [PACKAGE_NAME]: pending intent state");
            pw.println("    p[rocesses] [PACKAGE_NAME]: process state");
            pw.println("    o[om]: out of memory management");
            pw.println("    perm[issions]: URI permission grant state");
            pw.println("    prov[iders] [COMP_SPEC ...]: content provider state");
            pw.println("    provider [COMP_SPEC]: provider client-side state");
            pw.println("    s[ervices] [COMP_SPEC ...]: service state");
            pw.println("    as[sociations]: tracked app associations");
            pw.println("    settings: currently applied config settings");
            pw.println("    service [COMP_SPEC]: service client-side state");
            pw.println("    package [PACKAGE_NAME]: all state related to given package");
            pw.println("    all: dump all activities");
            pw.println("    top: dump the top activity");
            pw.println("  WHAT may also be a COMP_SPEC to dump activities.");
            pw.println("  COMP_SPEC may be a component name (com.foo/.myApp),");
            pw.println("    a partial substring in a component name, a");
            pw.println("    hex object identifier.");
            pw.println("  -a: include all available server state.");
            pw.println("  -c: include client state.");
            pw.println("  -p: limit output to given package.");
            pw.println("  --checkin: output checkin format, resetting data.");
            pw.println("  --C: output checkin format, not resetting data.");
        } else {
            pw.println("Activity manager (activity) commands:");
            pw.println("  help");
            pw.println("      Print this help text.");
            pw.println("  start-activity [-D] [-N] [-W] [-P <FILE>] [--start-profiler <FILE>]");
            pw.println("          [--sampling INTERVAL] [--streaming] [-R COUNT] [-S]");
            pw.println("          [--track-allocation] [--user <USER_ID> | current] <INTENT>");
            pw.println("      Start an Activity.  Options are:");
            pw.println("      -D: enable debugging");
            pw.println("      -N: enable native debugging");
            pw.println("      -W: wait for launch to complete");
            pw.println("      --start-profiler <FILE>: start profiler and send results to <FILE>");
            pw.println("      --sampling INTERVAL: use sample profiling with INTERVAL microseconds");
            pw.println("          between samples (use with --start-profiler)");
            pw.println("      --streaming: stream the profiling output to the specified file");
            pw.println("          (use with --start-profiler)");
            pw.println("      -P <FILE>: like above, but profiling stops when app goes idle");
            pw.println("      -R: repeat the activity launch <COUNT> times.  Prior to each repeat,");
            pw.println("          the top activity will be finished.");
            pw.println("      -S: force stop the target app before starting the activity");
            pw.println("      --track-allocation: enable tracking of object allocations");
            pw.println("      --user <USER_ID> | current: Specify which user to run as; if not");
            pw.println("          specified then run as the current user.");
            pw.println("      --stack <STACK_ID>: Specify into which stack should the activity be put.");
            pw.println("  start-service [--user <USER_ID> | current] <INTENT>");
            pw.println("      Start a Service.  Options are:");
            pw.println("      --user <USER_ID> | current: Specify which user to run as; if not");
            pw.println("          specified then run as the current user.");
            pw.println("  stop-service [--user <USER_ID> | current] <INTENT>");
            pw.println("      Stop a Service.  Options are:");
            pw.println("      --user <USER_ID> | current: Specify which user to run as; if not");
            pw.println("          specified then run as the current user.");
            pw.println("  broadcast [--user <USER_ID> | all | current] <INTENT>");
            pw.println("      Send a broadcast Intent.  Options are:");
            pw.println("      --user <USER_ID> | all | current: Specify which user to send to; if not");
            pw.println("          specified then send to all users.");
            pw.println("      --receiver-permission <PERMISSION>: Require receiver to hold permission.");
            pw.println("  instrument [-r] [-e <NAME> <VALUE>] [-p <FILE>] [-w]");
            pw.println("          [--user <USER_ID> | current]");
            pw.println("          [--no-window-animation] [--abi <ABI>] <COMPONENT>");
            pw.println("      Start an Instrumentation.  Typically this target <COMPONENT> is in the");
            pw.println("      form <TEST_PACKAGE>/<RUNNER_CLASS> or only <TEST_PACKAGE> if there");
            pw.println("      is only one instrumentation.  Options are:");
            pw.println("      -r: print raw results (otherwise decode REPORT_KEY_STREAMRESULT).  Use with");
            pw.println("          [-e perf true] to generate raw output for performance measurements.");
            pw.println("      -e <NAME> <VALUE>: set argument <NAME> to <VALUE>.  For test runners a");
            pw.println("          common form is [-e <testrunner_flag> <value>[,<value>...]].");
            pw.println("      -p <FILE>: write profiling data to <FILE>");
            pw.println("      -m: Write output as protobuf (machine readable)");
            pw.println("      -w: wait for instrumentation to finish before returning.  Required for");
            pw.println("          test runners.");
            pw.println("      --user <USER_ID> | current: Specify user instrumentation runs in;");
            pw.println("          current user if not specified.");
            pw.println("      --no-window-animation: turn off window animations while running.");
            pw.println("      --abi <ABI>: Launch the instrumented process with the selected ABI.");
            pw.println("          This assumes that the process supports the selected ABI.");
            pw.println("  trace-ipc [start|stop] [--dump-file <FILE>]");
            pw.println("      Trace IPC transactions.");
            pw.println("      start: start tracing IPC transactions.");
            pw.println("      stop: stop tracing IPC transactions and dump the results to file.");
            pw.println("      --dump-file <FILE>: Specify the file the trace should be dumped to.");
            pw.println("  profile [start|stop] [--user <USER_ID> current] [--sampling INTERVAL]");
            pw.println("          [--streaming] <PROCESS> <FILE>");
            pw.println("      Start and stop profiler on a process.  The given <PROCESS> argument");
            pw.println("        may be either a process name or pid.  Options are:");
            pw.println("      --user <USER_ID> | current: When supplying a process name,");
            pw.println("          specify user of process to profile; uses current user if not specified.");
            pw.println("      --sampling INTERVAL: use sample profiling with INTERVAL microseconds");
            pw.println("          between samples");
            pw.println("      --streaming: stream the profiling output to the specified file");
            pw.println("  dumpheap [--user <USER_ID> current] [-n] <PROCESS> <FILE>");
            pw.println("      Dump the heap of a process.  The given <PROCESS> argument may");
            pw.println("        be either a process name or pid.  Options are:");
            pw.println("      -n: dump native heap instead of managed heap");
            pw.println("      --user <USER_ID> | current: When supplying a process name,");
            pw.println("          specify user of process to dump; uses current user if not specified.");
            pw.println("  set-debug-app [-w] [--persistent] <PACKAGE>");
            pw.println("      Set application <PACKAGE> to debug.  Options are:");
            pw.println("      -w: wait for debugger when application starts");
            pw.println("      --persistent: retain this value");
            pw.println("  clear-debug-app");
            pw.println("      Clear the previously set-debug-app.");
            pw.println("  set-watch-heap <PROCESS> <MEM-LIMIT>");
            pw.println("      Start monitoring pss size of <PROCESS>, if it is at or");
            pw.println("      above <HEAP-LIMIT> then a heap dump is collected for the user to report.");
            pw.println("  clear-watch-heap");
            pw.println("      Clear the previously set-watch-heap.");
            pw.println("  bug-report [--progress | --telephony]");
            pw.println("      Request bug report generation; will launch a notification");
            pw.println("        when done to select where it should be delivered. Options are:");
            pw.println("     --progress: will launch a notification right away to show its progress.");
            pw.println("     --telephony: will dump only telephony sections.");
            pw.println("  force-stop [--user <USER_ID> | all | current] <PACKAGE>");
            pw.println("      Completely stop the given application package.");
            pw.println("  crash [--user <USER_ID>] <PACKAGE|PID>");
            pw.println("      Induce a VM crash in the specified package or process");
            pw.println("  kill [--user <USER_ID> | all | current] <PACKAGE>");
            pw.println("      Kill all processes associated with the given application.");
            pw.println("  kill-all");
            pw.println("      Kill all processes that are safe to kill (cached, etc).");
            pw.println("  make-uid-idle [--user <USER_ID> | all | current] <PACKAGE>");
            pw.println("      If the given application's uid is in the background and waiting to");
            pw.println("      become idle (not allowing background services), do that now.");
            pw.println("  monitor [--gdb <port>]");
            pw.println("      Start monitoring for crashes or ANRs.");
            pw.println("      --gdb: start gdbserv on the given port at crash/ANR");
            pw.println("  hang [--allow-restart]");
            pw.println("      Hang the system.");
            pw.println("      --allow-restart: allow watchdog to perform normal system restart");
            pw.println("  restart");
            pw.println("      Restart the user-space system.");
            pw.println("  idle-maintenance");
            pw.println("      Perform idle maintenance now.");
            pw.println("  screen-compat [on|off] <PACKAGE>");
            pw.println("      Control screen compatibility mode of <PACKAGE>.");
            pw.println("  package-importance <PACKAGE>");
            pw.println("      Print current importance of <PACKAGE>.");
            pw.println("  to-uri [INTENT]");
            pw.println("      Print the given Intent specification as a URI.");
            pw.println("  to-intent-uri [INTENT]");
            pw.println("      Print the given Intent specification as an intent: URI.");
            pw.println("  to-app-uri [INTENT]");
            pw.println("      Print the given Intent specification as an android-app: URI.");
            pw.println("  switch-user <USER_ID>");
            pw.println("      Switch to put USER_ID in the foreground, starting");
            pw.println("      execution of that user if it is currently stopped.");
            pw.println("  get-current-user");
            pw.println("      Returns id of the current foreground user.");
            pw.println("  start-user <USER_ID>");
            pw.println("      Start USER_ID in background if it is currently stopped;");
            pw.println("      use switch-user if you want to start the user in foreground");
            pw.println("  unlock-user <USER_ID> [TOKEN_HEX]");
            pw.println("      Attempt to unlock the given user using the given authorization token.");
            pw.println("  stop-user [-w] [-f] <USER_ID>");
            pw.println("      Stop execution of USER_ID, not allowing it to run any");
            pw.println("      code until a later explicit start or switch to it.");
            pw.println("      -w: wait for stop-user to complete.");
            pw.println("      -f: force stop even if there are related users that cannot be stopped.");
            pw.println("  is-user-stopped <USER_ID>");
            pw.println("      Returns whether <USER_ID> has been stopped or not.");
            pw.println("  get-started-user-state <USER_ID>");
            pw.println("      Gets the current state of the given started user.");
            pw.println("  track-associations");
            pw.println("      Enable association tracking.");
            pw.println("  untrack-associations");
            pw.println("      Disable and clear association tracking.");
            pw.println("  get-uid-state <UID>");
            pw.println("      Gets the process state of an app given its <UID>.");
            pw.println("  attach-agent <PROCESS> <FILE>");
            pw.println("    Attach an agent to the specified <PROCESS>, which may be either a process name or a PID.");
            pw.println("  get-config");
            pw.println("      Rtrieve the configuration and any recent configurations of the device.");
            pw.println("  supports-multiwindow");
            pw.println("      Returns true if the device supports multiwindow.");
            pw.println("  supports-split-screen-multi-window");
            pw.println("      Returns true if the device supports split screen multiwindow.");
            pw.println("  suppress-resize-config-changes <true|false>");
            pw.println("      Suppresses configuration changes due to user resizing an activity/task.");
            pw.println("  set-inactive [--user <USER_ID>] <PACKAGE> true|false");
            pw.println("      Sets the inactive state of an app.");
            pw.println("  get-inactive [--user <USER_ID>] <PACKAGE>");
            pw.println("      Returns the inactive state of an app.");
            pw.println("  send-trim-memory [--user <USER_ID>] <PROCESS>");
            pw.println("          [HIDDEN|RUNNING_MODERATE|BACKGROUND|RUNNING_LOW|MODERATE|RUNNING_CRITICAL|COMPLETE]");
            pw.println("      Send a memory trim event to a <PROCESS>.");
            pw.println("  display [COMMAND] [...]: sub-commands for operating on displays.");
            pw.println("       move-stack <STACK_ID> <DISPLAY_ID>");
            pw.println("           Move <STACK_ID> from its current display to <DISPLAY_ID>.");
            pw.println("  stack [COMMAND] [...]: sub-commands for operating on activity stacks.");
            pw.println("       start <DISPLAY_ID> <INTENT>");
            pw.println("           Start a new activity on <DISPLAY_ID> using <INTENT>");
            pw.println("       move-task <TASK_ID> <STACK_ID> [true|false]");
            pw.println("           Move <TASK_ID> from its current stack to the top (true) or");
            pw.println("           bottom (false) of <STACK_ID>.");
            pw.println("       resize <STACK_ID> <LEFT,TOP,RIGHT,BOTTOM>");
            pw.println("           Change <STACK_ID> size and position to <LEFT,TOP,RIGHT,BOTTOM>.");
            pw.println("       resize-animated <STACK_ID> <LEFT,TOP,RIGHT,BOTTOM>");
            pw.println("           Same as resize, but allow animation.");
            pw.println("       resize-docked-stack <LEFT,TOP,RIGHT,BOTTOM> [<TASK_LEFT,TASK_TOP,TASK_RIGHT,TASK_BOTTOM>]");
            pw.println("           Change docked stack to <LEFT,TOP,RIGHT,BOTTOM>");
            pw.println("           and supplying temporary different task bounds indicated by");
            pw.println("           <TASK_LEFT,TOP,RIGHT,BOTTOM>");
            pw.println("       size-docked-stack-test: <STEP_SIZE> <l|t|r|b> [DELAY_MS]");
            pw.println("           Test command for sizing docked stack by");
            pw.println("           <STEP_SIZE> increments from the side <l>eft, <t>op, <r>ight, or <b>ottom");
            pw.println("           applying the optional [DELAY_MS] between each step.");
            pw.println("       move-top-activity-to-pinned-stack: <STACK_ID> <LEFT,TOP,RIGHT,BOTTOM>");
            pw.println("           Moves the top activity from");
            pw.println("           <STACK_ID> to the pinned stack using <LEFT,TOP,RIGHT,BOTTOM> for the");
            pw.println("           bounds of the pinned stack.");
            pw.println("       positiontask <TASK_ID> <STACK_ID> <POSITION>");
            pw.println("           Place <TASK_ID> in <STACK_ID> at <POSITION>");
            pw.println("       list");
            pw.println("           List all of the activity stacks and their sizes.");
            pw.println("       info <STACK_ID>");
            pw.println("           Display the information about activity stack <STACK_ID>.");
            pw.println("       remove <STACK_ID>");
            pw.println("           Remove stack <STACK_ID>.");
            pw.println("  task [COMMAND] [...]: sub-commands for operating on activity tasks.");
            pw.println("       lock <TASK_ID>");
            pw.println("           Bring <TASK_ID> to the front and don't allow other tasks to run.");
            pw.println("       lock stop");
            pw.println("           End the current task lock.");
            pw.println("       resizeable <TASK_ID> [0|1|2|3]");
            pw.println("           Change resizeable mode of <TASK_ID> to one of the following:");
            pw.println("           0: unresizeable");
            pw.println("           1: crop_windows");
            pw.println("           2: resizeable");
            pw.println("           3: resizeable_and_pipable");
            pw.println("       resize <TASK_ID> <LEFT,TOP,RIGHT,BOTTOM>");
            pw.println("           Makes sure <TASK_ID> is in a stack with the specified bounds.");
            pw.println("           Forces the task to be resizeable and creates a stack if no existing stack");
            pw.println("           has the specified bounds.");
            pw.println("       drag-task-test <TASK_ID> <STEP_SIZE> [DELAY_MS]");
            pw.println("           Test command for dragging/moving <TASK_ID> by");
            pw.println("           <STEP_SIZE> increments around the screen applying the optional [DELAY_MS]");
            pw.println("           between each step.");
            pw.println("       size-task-test <TASK_ID> <STEP_SIZE> [DELAY_MS]");
            pw.println("           Test command for sizing <TASK_ID> by <STEP_SIZE>");
            pw.println("           increments within the screen applying the optional [DELAY_MS] between");
            pw.println("           each step.");
            pw.println("  update-appinfo <USER_ID> <PACKAGE_NAME> [<PACKAGE_NAME>...]");
            pw.println("      Update the ApplicationInfo objects of the listed packages for <USER_ID>");
            pw.println("      without restarting any processes.");
            pw.println("  write");
            pw.println("      Write all pending state to storage.");
            pw.println();
            Intent.printIntentArgsHelp(pw, "");
        }
    }

    static final class StopUserCallback
    extends IStopUserCallback.Stub {
        private boolean mFinished = false;

        StopUserCallback() {
        }

        public synchronized void waitForFinish() {
            try {
                while (!this.mFinished) {
                    this.wait();
                }
            }
            catch (InterruptedException e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        public synchronized void userStopped(int userId) {
            this.mFinished = true;
            this.notifyAll();
        }

        @Override
        public synchronized void userStopAborted(int userId) {
            this.mFinished = true;
            this.notifyAll();
        }
    }

    static final class MyActivityController
    extends IActivityController.Stub {
        final IActivityManager mInterface;
        final PrintWriter mPw;
        final InputStream mInput;
        final String mGdbPort;
        final boolean mMonkey;
        static final int STATE_NORMAL = 0;
        static final int STATE_CRASHED = 1;
        static final int STATE_EARLY_ANR = 2;
        static final int STATE_ANR = 3;
        int mState;
        static final int RESULT_DEFAULT = 0;
        static final int RESULT_CRASH_DIALOG = 0;
        static final int RESULT_CRASH_KILL = 1;
        static final int RESULT_EARLY_ANR_CONTINUE = 0;
        static final int RESULT_EARLY_ANR_KILL = 1;
        static final int RESULT_ANR_DIALOG = 0;
        static final int RESULT_ANR_KILL = 1;
        static final int RESULT_ANR_WAIT = 1;
        int mResult;
        Process mGdbProcess;
        Thread mGdbThread;
        boolean mGotGdbPrint;

        MyActivityController(IActivityManager iam, PrintWriter pw, InputStream input, String gdbPort, boolean monkey) {
            this.mInterface = iam;
            this.mPw = pw;
            this.mInput = input;
            this.mGdbPort = gdbPort;
            this.mMonkey = monkey;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean activityResuming(String pkg) {
            MyActivityController myActivityController = this;
            synchronized (myActivityController) {
                this.mPw.println("** Activity resuming: " + pkg);
                this.mPw.flush();
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean activityStarting(Intent intent, String pkg) {
            MyActivityController myActivityController = this;
            synchronized (myActivityController) {
                this.mPw.println("** Activity starting: " + pkg);
                this.mPw.flush();
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean appCrashed(String processName, int pid, String shortMsg, String longMsg, long timeMillis, String stackTrace) {
            MyActivityController myActivityController = this;
            synchronized (myActivityController) {
                this.mPw.println("** ERROR: PROCESS CRASHED");
                this.mPw.println("processName: " + processName);
                this.mPw.println("processPid: " + pid);
                this.mPw.println("shortMsg: " + shortMsg);
                this.mPw.println("longMsg: " + longMsg);
                this.mPw.println("timeMillis: " + timeMillis);
                this.mPw.println("stack:");
                this.mPw.print(stackTrace);
                this.mPw.println("#");
                this.mPw.flush();
                int result = this.waitControllerLocked(pid, 1);
                return result != 1;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int appEarlyNotResponding(String processName, int pid, String annotation) {
            MyActivityController myActivityController = this;
            synchronized (myActivityController) {
                this.mPw.println("** ERROR: EARLY PROCESS NOT RESPONDING");
                this.mPw.println("processName: " + processName);
                this.mPw.println("processPid: " + pid);
                this.mPw.println("annotation: " + annotation);
                this.mPw.flush();
                int result = this.waitControllerLocked(pid, 2);
                if (result == 1) {
                    return -1;
                }
                return 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int appNotResponding(String processName, int pid, String processStats) {
            MyActivityController myActivityController = this;
            synchronized (myActivityController) {
                this.mPw.println("** ERROR: PROCESS NOT RESPONDING");
                this.mPw.println("processName: " + processName);
                this.mPw.println("processPid: " + pid);
                this.mPw.println("processStats:");
                this.mPw.print(processStats);
                this.mPw.println("#");
                this.mPw.flush();
                int result = this.waitControllerLocked(pid, 3);
                if (result == 1) {
                    return -1;
                }
                if (result == 1) {
                    return 1;
                }
                return 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int systemNotResponding(String message) {
            MyActivityController myActivityController = this;
            synchronized (myActivityController) {
                this.mPw.println("** ERROR: PROCESS NOT RESPONDING");
                this.mPw.println("message: " + message);
                this.mPw.println("#");
                this.mPw.println("Allowing system to die.");
                this.mPw.flush();
                return -1;
            }
        }

        void killGdbLocked() {
            this.mGotGdbPrint = false;
            if (this.mGdbProcess != null) {
                this.mPw.println("Stopping gdbserver");
                this.mPw.flush();
                this.mGdbProcess.destroy();
                this.mGdbProcess = null;
            }
            if (this.mGdbThread != null) {
                this.mGdbThread.interrupt();
                this.mGdbThread = null;
            }
        }

        int waitControllerLocked(int pid, int state) {
            if (this.mGdbPort != null) {
                this.killGdbLocked();
                try {
                    this.mPw.println("Starting gdbserver on port " + this.mGdbPort);
                    this.mPw.println("Do the following:");
                    this.mPw.println("  adb forward tcp:" + this.mGdbPort + " tcp:" + this.mGdbPort);
                    this.mPw.println("  gdbclient app_process :" + this.mGdbPort);
                    this.mPw.flush();
                    this.mGdbProcess = Runtime.getRuntime().exec(new String[]{"gdbserver", ":" + this.mGdbPort, "--attach", Integer.toString(pid)});
                    final InputStreamReader converter = new InputStreamReader(this.mGdbProcess.getInputStream());
                    this.mGdbThread = new Thread(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            BufferedReader in = new BufferedReader(converter);
                            int count = 0;
                            while (true) {
                                MyActivityController myActivityController = this;
                                synchronized (myActivityController) {
                                    if (mGdbThread == null) {
                                        return;
                                    }
                                    if (count == 2) {
                                        mGotGdbPrint = true;
                                        this.notifyAll();
                                    }
                                }
                                try {
                                    String line = in.readLine();
                                    if (line == null) {
                                        return;
                                    }
                                    mPw.println("GDB: " + line);
                                    mPw.flush();
                                    ++count;
                                }
                                catch (IOException e) {
                                    return;
                                }
                            }
                        }
                    };
                    this.mGdbThread.start();
                    try {
                        this.wait(500L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                catch (IOException e) {
                    this.mPw.println("Failure starting gdbserver: " + e);
                    this.mPw.flush();
                    this.killGdbLocked();
                }
            }
            this.mState = state;
            this.mPw.println("");
            this.printMessageForState();
            this.mPw.flush();
            while (this.mState != 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.killGdbLocked();
            return this.mResult;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void resumeController(int result) {
            MyActivityController myActivityController = this;
            synchronized (myActivityController) {
                this.mState = 0;
                this.mResult = result;
                this.notifyAll();
            }
        }

        void printMessageForState() {
            switch (this.mState) {
                case 0: {
                    this.mPw.println("Monitoring activity manager...  available commands:");
                    break;
                }
                case 1: {
                    this.mPw.println("Waiting after crash...  available commands:");
                    this.mPw.println("(c)ontinue: show crash dialog");
                    this.mPw.println("(k)ill: immediately kill app");
                    break;
                }
                case 2: {
                    this.mPw.println("Waiting after early ANR...  available commands:");
                    this.mPw.println("(c)ontinue: standard ANR processing");
                    this.mPw.println("(k)ill: immediately kill app");
                    break;
                }
                case 3: {
                    this.mPw.println("Waiting after ANR...  available commands:");
                    this.mPw.println("(c)ontinue: show ANR dialog");
                    this.mPw.println("(k)ill: immediately kill app");
                    this.mPw.println("(w)ait: wait some more");
                }
            }
            this.mPw.println("(q)uit: finish monitoring");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void run() throws RemoteException {
            try {
                String line;
                this.printMessageForState();
                this.mPw.flush();
                this.mInterface.setActivityController(this, this.mMonkey);
                this.mState = 0;
                InputStreamReader converter = new InputStreamReader(this.mInput);
                BufferedReader in = new BufferedReader(converter);
                while ((line = in.readLine()) != null) {
                    boolean addNewline;
                    block22: {
                        block27: {
                            block25: {
                                block26: {
                                    block24: {
                                        block23: {
                                            addNewline = true;
                                            if (line.length() > 0) break block23;
                                            addNewline = false;
                                            break block22;
                                        }
                                        if ("q".equals(line) || "quit".equals(line)) {
                                            this.resumeController(0);
                                            return;
                                        }
                                        if (this.mState != 1) break block24;
                                        if ("c".equals(line) || "continue".equals(line)) {
                                            this.resumeController(0);
                                            break block22;
                                        } else if ("k".equals(line) || "kill".equals(line)) {
                                            this.resumeController(1);
                                            break block22;
                                        } else {
                                            this.mPw.println("Invalid command: " + line);
                                        }
                                        break block22;
                                    }
                                    if (this.mState != 3) break block25;
                                    if (!"c".equals(line) && !"continue".equals(line)) break block26;
                                    this.resumeController(0);
                                    break block22;
                                }
                                if ("k".equals(line) || "kill".equals(line)) {
                                    this.resumeController(1);
                                    break block22;
                                } else if ("w".equals(line) || "wait".equals(line)) {
                                    this.resumeController(1);
                                    break block22;
                                } else {
                                    this.mPw.println("Invalid command: " + line);
                                }
                                break block22;
                            }
                            if (this.mState != 2) break block27;
                            if ("c".equals(line) || "continue".equals(line)) {
                                this.resumeController(0);
                                break block22;
                            } else if ("k".equals(line) || "kill".equals(line)) {
                                this.resumeController(1);
                                break block22;
                            } else {
                                this.mPw.println("Invalid command: " + line);
                            }
                            break block22;
                        }
                        this.mPw.println("Invalid command: " + line);
                    }
                    MyActivityController myActivityController = this;
                    synchronized (myActivityController) {
                        if (addNewline) {
                            this.mPw.println("");
                        }
                        this.printMessageForState();
                        this.mPw.flush();
                    }
                }
                return;
            }
            catch (IOException e) {
                e.printStackTrace(this.mPw);
                this.mPw.flush();
                return;
            }
            finally {
                this.mInterface.setActivityController(null, this.mMonkey);
            }
        }
    }

    static final class IntentReceiver
    extends IIntentReceiver.Stub {
        private final PrintWriter mPw;
        private boolean mFinished = false;

        IntentReceiver(PrintWriter pw) {
            this.mPw = pw;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void performReceive(Intent intent, int resultCode, String data, Bundle extras, boolean ordered, boolean sticky, int sendingUser) {
            String line = "Broadcast completed: result=" + resultCode;
            if (data != null) {
                line = line + ", data=\"" + data + "\"";
            }
            if (extras != null) {
                line = line + ", extras: " + extras;
            }
            this.mPw.println(line);
            this.mPw.flush();
            IntentReceiver intentReceiver = this;
            synchronized (intentReceiver) {
                this.mFinished = true;
                this.notifyAll();
            }
        }

        public synchronized void waitForFinish() {
            try {
                while (!this.mFinished) {
                    this.wait();
                }
            }
            catch (InterruptedException e) {
                throw new IllegalStateException(e);
            }
        }
    }
}

