/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.app.ActivityManager;
import android.content.Context;
import android.metrics.LogMaker;
import android.os.SystemClock;
import android.util.Slog;
import com.android.internal.logging.MetricsLogger;
import com.android.server.am.ActivityRecord;
import com.android.server.am.ActivityStack;
import com.android.server.am.ActivityStackSupervisor;
import com.android.server.am.ProcessRecord;
import java.util.ArrayList;

class ActivityMetricsLogger {
    private static final String TAG = "ActivityManager";
    private static final int WINDOW_STATE_STANDARD = 0;
    private static final int WINDOW_STATE_SIDE_BY_SIDE = 1;
    private static final int WINDOW_STATE_FREEFORM = 2;
    private static final int WINDOW_STATE_ASSISTANT = 3;
    private static final int WINDOW_STATE_INVALID = -1;
    private static final long INVALID_START_TIME = -1L;
    private static final String[] TRON_WINDOW_STATE_VARZ_STRINGS = new String[]{"window_time_0", "window_time_1", "window_time_2", "window_time_3"};
    private int mWindowState = 0;
    private long mLastLogTimeSecs = SystemClock.elapsedRealtime() / 1000L;
    private final ActivityStackSupervisor mSupervisor;
    private final Context mContext;
    private long mCurrentTransitionStartTime = -1L;
    private boolean mLoggedWindowsDrawn;
    private boolean mLoggedStartingWindowDrawn;
    private boolean mLoggedTransitionStarting;

    ActivityMetricsLogger(ActivityStackSupervisor supervisor, Context context) {
        this.mSupervisor = supervisor;
        this.mContext = context;
    }

    void logWindowState() {
        long now = SystemClock.elapsedRealtime() / 1000L;
        if (this.mWindowState != -1) {
            MetricsLogger.count(this.mContext, TRON_WINDOW_STATE_VARZ_STRINGS[this.mWindowState], (int)(now - this.mLastLogTimeSecs));
        }
        this.mLastLogTimeSecs = now;
        ActivityStack stack = this.mSupervisor.getStack(3);
        if (stack != null && stack.getStackVisibilityLocked(null) != 0) {
            this.mWindowState = 1;
            return;
        }
        this.mWindowState = -1;
        stack = this.mSupervisor.getFocusedStack();
        if (stack.mStackId == 4) {
            stack = this.mSupervisor.findStackBehind(stack);
        }
        if (ActivityManager.StackId.isHomeOrRecentsStack(stack.mStackId) || stack.mStackId == 1) {
            this.mWindowState = 0;
        } else if (stack.mStackId == 3) {
            Slog.wtf(TAG, "Docked stack shouldn't be the focused stack, because it reported not being visible.");
            this.mWindowState = -1;
        } else if (stack.mStackId == 2) {
            this.mWindowState = 2;
        } else if (stack.mStackId == 6) {
            this.mWindowState = 3;
        } else if (ActivityManager.StackId.isStaticStack(stack.mStackId)) {
            throw new IllegalStateException("Unknown stack=" + stack);
        }
    }

    void notifyActivityLaunching() {
        this.mCurrentTransitionStartTime = System.currentTimeMillis();
    }

    void notifyActivityLaunched(int resultCode, ActivityRecord launchedActivity) {
        ProcessRecord processRecord = launchedActivity != null ? this.mSupervisor.mService.mProcessNames.get(launchedActivity.processName, launchedActivity.appInfo.uid) : null;
        boolean processRunning = processRecord != null;
        String componentName = launchedActivity != null ? launchedActivity.shortComponentName : null;
        boolean processSwitch = processRecord == null || !this.hasStartedActivity(processRecord, launchedActivity);
        this.notifyActivityLaunched(resultCode, componentName, processRunning, processSwitch);
    }

    private boolean hasStartedActivity(ProcessRecord record, ActivityRecord launchedActivity) {
        ArrayList<ActivityRecord> activities = record.activities;
        for (int i = activities.size() - 1; i >= 0; --i) {
            ActivityRecord activity = activities.get(i);
            if (launchedActivity == activity || activity.stopped) continue;
            return true;
        }
        return false;
    }

    private void notifyActivityLaunched(int resultCode, String componentName, boolean processRunning, boolean processSwitch) {
        if (resultCode < 0 || componentName == null || !processSwitch) {
            this.reset();
            return;
        }
        MetricsLogger.action(this.mContext, 323, componentName);
        MetricsLogger.action(this.mContext, 324, processRunning);
        MetricsLogger.action(this.mContext, 325, (int)(SystemClock.uptimeMillis() / 1000L));
        LogMaker builder = new LogMaker(761);
        builder.addTaggedData(323, componentName);
        builder.addTaggedData(324, processRunning ? 1 : 0);
        builder.addTaggedData(325, SystemClock.uptimeMillis() / 1000L);
        MetricsLogger.action(builder);
    }

    void notifyWindowsDrawn() {
        if (!this.isTransitionActive() || this.mLoggedWindowsDrawn) {
            return;
        }
        MetricsLogger.action(this.mContext, 322, this.calculateCurrentDelay());
        this.mLoggedWindowsDrawn = true;
        if (this.mLoggedTransitionStarting) {
            this.reset();
        }
    }

    void notifyStartingWindowDrawn() {
        if (!this.isTransitionActive() || this.mLoggedStartingWindowDrawn) {
            return;
        }
        this.mLoggedStartingWindowDrawn = true;
        MetricsLogger.action(this.mContext, 321, this.calculateCurrentDelay());
    }

    void notifyTransitionStarting(int reason) {
        if (!this.isTransitionActive() || this.mLoggedTransitionStarting) {
            return;
        }
        MetricsLogger.action(this.mContext, 320, reason);
        MetricsLogger.action(this.mContext, 319, this.calculateCurrentDelay());
        this.mLoggedTransitionStarting = true;
        if (this.mLoggedWindowsDrawn) {
            this.reset();
        }
    }

    private boolean isTransitionActive() {
        return this.mCurrentTransitionStartTime != -1L;
    }

    private void reset() {
        this.mCurrentTransitionStartTime = -1L;
        this.mLoggedWindowsDrawn = false;
        this.mLoggedTransitionStarting = false;
        this.mLoggedStartingWindowDrawn = false;
    }

    private int calculateCurrentDelay() {
        return (int)(System.currentTimeMillis() - this.mCurrentTransitionStartTime);
    }
}

