/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.app.ActivityManager;
import android.app.ActivityOptions;
import android.app.PendingIntent;
import android.app.PictureInPictureArgs;
import android.app.ResultInfo;
import android.content.ComponentName;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.res.CompatibilityInfo;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Message;
import android.os.PersistableBundle;
import android.os.Process;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.Trace;
import android.os.UserHandle;
import android.service.voice.IVoiceInteractionSession;
import android.util.EventLog;
import android.util.Log;
import android.util.Slog;
import android.util.TimeUtils;
import android.view.AppTransitionAnimationSpec;
import android.view.IApplicationToken;
import com.android.internal.R;
import com.android.internal.app.ResolverActivity;
import com.android.internal.content.ReferrerIntent;
import com.android.internal.util.XmlUtils;
import com.android.server.AttributeCache;
import com.android.server.am.ActivityManagerService;
import com.android.server.am.ActivityResult;
import com.android.server.am.ActivityStack;
import com.android.server.am.ActivityStackSupervisor;
import com.android.server.am.AppTimeTracker;
import com.android.server.am.ConnectionRecord;
import com.android.server.am.PendingIntentRecord;
import com.android.server.am.ProcessRecord;
import com.android.server.am.TaskPersister;
import com.android.server.am.TaskRecord;
import com.android.server.am.UriPermissionOwner;
import com.android.server.wm.AppWindowContainerController;
import com.android.server.wm.AppWindowContainerListener;
import com.android.server.wm.TaskWindowContainerController;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

final class ActivityRecord
implements AppWindowContainerListener {
    private static final String TAG = "ActivityManager";
    private static final String TAG_CONFIGURATION = "ActivityManager";
    private static final String TAG_SAVED_STATE = "ActivityManager";
    private static final String TAG_SCREENSHOTS = "ActivityManager";
    private static final String TAG_STATES = "ActivityManager";
    private static final String TAG_SWITCH = "ActivityManager";
    private static final String TAG_THUMBNAILS = "ActivityManager";
    private static final String TAG_VISIBILITY = "ActivityManager";
    private static final boolean SHOW_ACTIVITY_START_TIME = true;
    private static final String RECENTS_PACKAGE_NAME = "com.android.systemui.recents";
    private static final String ATTR_ID = "id";
    private static final String TAG_INTENT = "intent";
    private static final String ATTR_USERID = "user_id";
    private static final String TAG_PERSISTABLEBUNDLE = "persistable_bundle";
    private static final String ATTR_LAUNCHEDFROMUID = "launched_from_uid";
    private static final String ATTR_LAUNCHEDFROMPACKAGE = "launched_from_package";
    private static final String ATTR_RESOLVEDTYPE = "resolved_type";
    private static final String ATTR_COMPONENTSPECIFIED = "component_specified";
    static final String ACTIVITY_ICON_SUFFIX = "_activity_icon_";
    final ActivityManagerService service;
    final IApplicationToken.Stub appToken;
    AppWindowContainerController mWindowContainerController;
    final ActivityInfo info;
    final ApplicationInfo appInfo;
    final int launchedFromPid;
    final int launchedFromUid;
    final String launchedFromPackage;
    final int userId;
    final Intent intent;
    final ComponentName realActivity;
    final String shortComponentName;
    final String resolvedType;
    final String packageName;
    final String processName;
    final String taskAffinity;
    final boolean stateNotNeeded;
    boolean fullscreen;
    final boolean noDisplay;
    private final boolean componentSpecified;
    final boolean rootVoiceInteraction;
    static final int APPLICATION_ACTIVITY_TYPE = 0;
    static final int HOME_ACTIVITY_TYPE = 1;
    static final int RECENTS_ACTIVITY_TYPE = 2;
    static final int ASSISTANT_ACTIVITY_TYPE = 3;
    int mActivityType;
    private CharSequence nonLocalizedLabel;
    private int labelRes;
    private int icon;
    private int logo;
    private int theme;
    private int realTheme;
    private int windowFlags;
    TaskRecord task;
    private long createTime = System.currentTimeMillis();
    long displayStartTime;
    long fullyDrawnStartTime;
    private long startTime;
    long lastVisibleTime;
    long cpuTimeAtResume;
    long pauseTime;
    long launchTickTime;
    private Configuration mLastReportedConfiguration;
    private Configuration mLastReportedOverrideConfiguration;
    private int mLastReportedDisplayId;
    CompatibilityInfo compat;
    ActivityRecord resultTo;
    final String resultWho;
    final int requestCode;
    ArrayList<ResultInfo> results;
    HashSet<WeakReference<PendingIntentRecord>> pendingResults;
    ArrayList<ReferrerIntent> newIntents;
    ActivityOptions pendingOptions;
    ActivityOptions returningOptions;
    AppTimeTracker appTimeTracker;
    HashSet<ConnectionRecord> connections;
    UriPermissionOwner uriPermissions;
    ProcessRecord app;
    ActivityStack.ActivityState state;
    Bundle icicle;
    PersistableBundle persistentState;
    boolean frontOfTask;
    boolean launchFailed;
    boolean haveState;
    boolean stopped;
    boolean delayedResume;
    boolean finishing;
    boolean deferRelaunchUntilPaused;
    boolean preserveWindowOnDeferredRelaunch;
    int configChangeFlags;
    boolean keysPaused;
    int launchMode;
    boolean visible;
    boolean visibleIgnoringKeyguard;
    boolean sleeping;
    boolean nowVisible;
    boolean idle;
    boolean hasBeenLaunched;
    boolean frozenBeforeDestroy;
    boolean immersive;
    boolean forceNewConfig;
    boolean supportsPictureInPictureWhilePausing;
    PictureInPictureArgs pictureInPictureArgs = new PictureInPictureArgs();
    int launchCount;
    long lastLaunchTime;
    ComponentName requestedVrComponent;
    ArrayList<ActivityStackSupervisor.ActivityContainer> mChildContainers = new ArrayList();
    String stringName;
    private boolean inHistory;
    final ActivityStackSupervisor mStackSupervisor;
    static final int STARTING_WINDOW_NOT_SHOWN = 0;
    static final int STARTING_WINDOW_SHOWN = 1;
    static final int STARTING_WINDOW_REMOVED = 2;
    int mStartingWindowState = 0;
    boolean mTaskOverlay = false;
    boolean mUpdateTaskThumbnailWhenHidden;
    ActivityStackSupervisor.ActivityContainer mInitialActivityContainer;
    ActivityManager.TaskDescription taskDescription;
    boolean mLaunchTaskBehind;
    private int[] mVerticalSizeConfigurations;
    private int[] mHorizontalSizeConfigurations;
    private int[] mSmallestSizeConfigurations;
    boolean pendingVoiceInteractionStart;
    IVoiceInteractionSession voiceSession;
    int mRotationAnimationHint = -1;
    private final Configuration mTmpConfig1 = new Configuration();
    private final Configuration mTmpConfig2 = new Configuration();

    private static String startingWindowStateToString(int state) {
        switch (state) {
            case 0: {
                return "STARTING_WINDOW_NOT_SHOWN";
            }
            case 1: {
                return "STARTING_WINDOW_SHOWN";
            }
            case 2: {
                return "STARTING_WINDOW_REMOVED";
            }
        }
        return "unknown state=" + state;
    }

    void dump(PrintWriter pw, String prefix) {
        long now = SystemClock.uptimeMillis();
        pw.print(prefix);
        pw.print("packageName=");
        pw.print(this.packageName);
        pw.print(" processName=");
        pw.println(this.processName);
        pw.print(prefix);
        pw.print("launchedFromUid=");
        pw.print(this.launchedFromUid);
        pw.print(" launchedFromPackage=");
        pw.print(this.launchedFromPackage);
        pw.print(" userId=");
        pw.println(this.userId);
        pw.print(prefix);
        pw.print("app=");
        pw.println(this.app);
        pw.print(prefix);
        pw.println(this.intent.toInsecureStringWithClip());
        pw.print(prefix);
        pw.print("frontOfTask=");
        pw.print(this.frontOfTask);
        pw.print(" task=");
        pw.println(this.task);
        pw.print(prefix);
        pw.print("taskAffinity=");
        pw.println(this.taskAffinity);
        pw.print(prefix);
        pw.print("realActivity=");
        pw.println(this.realActivity.flattenToShortString());
        if (this.appInfo != null) {
            pw.print(prefix);
            pw.print("baseDir=");
            pw.println(this.appInfo.sourceDir);
            if (!Objects.equals(this.appInfo.sourceDir, this.appInfo.publicSourceDir)) {
                pw.print(prefix);
                pw.print("resDir=");
                pw.println(this.appInfo.publicSourceDir);
            }
            pw.print(prefix);
            pw.print("dataDir=");
            pw.println(this.appInfo.dataDir);
            if (this.appInfo.splitSourceDirs != null) {
                pw.print(prefix);
                pw.print("splitDir=");
                pw.println(Arrays.toString(this.appInfo.splitSourceDirs));
            }
        }
        pw.print(prefix);
        pw.print("stateNotNeeded=");
        pw.print(this.stateNotNeeded);
        pw.print(" componentSpecified=");
        pw.print(this.componentSpecified);
        pw.print(" mActivityType=");
        pw.println(this.mActivityType);
        if (this.rootVoiceInteraction) {
            pw.print(prefix);
            pw.print("rootVoiceInteraction=");
            pw.println(this.rootVoiceInteraction);
        }
        pw.print(prefix);
        pw.print("compat=");
        pw.print(this.compat);
        pw.print(" labelRes=0x");
        pw.print(Integer.toHexString(this.labelRes));
        pw.print(" icon=0x");
        pw.print(Integer.toHexString(this.icon));
        pw.print(" theme=0x");
        pw.println(Integer.toHexString(this.theme));
        pw.print(prefix);
        pw.print("mLastReportedConfiguration=");
        pw.println(this.mLastReportedConfiguration);
        pw.print(prefix);
        pw.print("mLastReportedOverrideConfiguration=");
        pw.println(this.mLastReportedOverrideConfiguration);
        if (this.resultTo != null || this.resultWho != null) {
            pw.print(prefix);
            pw.print("resultTo=");
            pw.print(this.resultTo);
            pw.print(" resultWho=");
            pw.print(this.resultWho);
            pw.print(" resultCode=");
            pw.println(this.requestCode);
        }
        if (this.taskDescription != null) {
            String iconFilename = this.taskDescription.getIconFilename();
            if (iconFilename != null || this.taskDescription.getLabel() != null || this.taskDescription.getPrimaryColor() != 0) {
                pw.print(prefix);
                pw.print("taskDescription:");
                pw.print(" iconFilename=");
                pw.print(this.taskDescription.getIconFilename());
                pw.print(" label=\"");
                pw.print(this.taskDescription.getLabel());
                pw.print("\"");
                pw.print(" color=");
                pw.println(Integer.toHexString(this.taskDescription.getPrimaryColor()));
            }
            if (iconFilename == null && this.taskDescription.getIcon() != null) {
                pw.print(prefix);
                pw.println("taskDescription contains Bitmap");
            }
        }
        if (this.results != null) {
            pw.print(prefix);
            pw.print("results=");
            pw.println(this.results);
        }
        if (this.pendingResults != null && this.pendingResults.size() > 0) {
            pw.print(prefix);
            pw.println("Pending Results:");
            for (WeakReference weakReference : this.pendingResults) {
                PendingIntentRecord pir = weakReference != null ? (PendingIntentRecord)weakReference.get() : null;
                pw.print(prefix);
                pw.print("  - ");
                if (pir == null) {
                    pw.println("null");
                    continue;
                }
                pw.println(pir);
                pir.dump(pw, prefix + "    ");
            }
        }
        if (this.newIntents != null && this.newIntents.size() > 0) {
            pw.print(prefix);
            pw.println("Pending New Intents:");
            for (int i = 0; i < this.newIntents.size(); ++i) {
                Intent intent = this.newIntents.get(i);
                pw.print(prefix);
                pw.print("  - ");
                if (intent == null) {
                    pw.println("null");
                    continue;
                }
                pw.println(intent.toShortString(false, true, false, true));
            }
        }
        if (this.pendingOptions != null) {
            pw.print(prefix);
            pw.print("pendingOptions=");
            pw.println(this.pendingOptions);
        }
        if (this.appTimeTracker != null) {
            this.appTimeTracker.dumpWithHeader(pw, prefix, false);
        }
        if (this.uriPermissions != null) {
            this.uriPermissions.dump(pw, prefix);
        }
        pw.print(prefix);
        pw.print("launchFailed=");
        pw.print(this.launchFailed);
        pw.print(" launchCount=");
        pw.print(this.launchCount);
        pw.print(" lastLaunchTime=");
        if (this.lastLaunchTime == 0L) {
            pw.print("0");
        } else {
            TimeUtils.formatDuration(this.lastLaunchTime, now, pw);
        }
        pw.println();
        pw.print(prefix);
        pw.print("haveState=");
        pw.print(this.haveState);
        pw.print(" icicle=");
        pw.println(this.icicle);
        pw.print(prefix);
        pw.print("state=");
        pw.print((Object)this.state);
        pw.print(" stopped=");
        pw.print(this.stopped);
        pw.print(" delayedResume=");
        pw.print(this.delayedResume);
        pw.print(" finishing=");
        pw.println(this.finishing);
        pw.print(prefix);
        pw.print("keysPaused=");
        pw.print(this.keysPaused);
        pw.print(" inHistory=");
        pw.print(this.inHistory);
        pw.print(" visible=");
        pw.print(this.visible);
        pw.print(" sleeping=");
        pw.print(this.sleeping);
        pw.print(" idle=");
        pw.print(this.idle);
        pw.print(" mStartingWindowState=");
        pw.println(ActivityRecord.startingWindowStateToString(this.mStartingWindowState));
        pw.print(prefix);
        pw.print("fullscreen=");
        pw.print(this.fullscreen);
        pw.print(" noDisplay=");
        pw.print(this.noDisplay);
        pw.print(" immersive=");
        pw.print(this.immersive);
        pw.print(" launchMode=");
        pw.println(this.launchMode);
        pw.print(prefix);
        pw.print("frozenBeforeDestroy=");
        pw.print(this.frozenBeforeDestroy);
        pw.print(" forceNewConfig=");
        pw.println(this.forceNewConfig);
        pw.print(prefix);
        pw.print("mActivityType=");
        pw.println(ActivityRecord.activityTypeToString(this.mActivityType));
        if (this.requestedVrComponent != null) {
            pw.print(prefix);
            pw.print("requestedVrComponent=");
            pw.println(this.requestedVrComponent);
        }
        if (this.displayStartTime != 0L || this.startTime != 0L) {
            pw.print(prefix);
            pw.print("displayStartTime=");
            if (this.displayStartTime == 0L) {
                pw.print("0");
            } else {
                TimeUtils.formatDuration(this.displayStartTime, now, pw);
            }
            pw.print(" startTime=");
            if (this.startTime == 0L) {
                pw.print("0");
            } else {
                TimeUtils.formatDuration(this.startTime, now, pw);
            }
            pw.println();
        }
        boolean waitingVisible = this.mStackSupervisor.mWaitingVisibleActivities.contains(this);
        if (this.lastVisibleTime != 0L || waitingVisible || this.nowVisible) {
            pw.print(prefix);
            pw.print("waitingVisible=");
            pw.print(waitingVisible);
            pw.print(" nowVisible=");
            pw.print(this.nowVisible);
            pw.print(" lastVisibleTime=");
            if (this.lastVisibleTime == 0L) {
                pw.print("0");
            } else {
                TimeUtils.formatDuration(this.lastVisibleTime, now, pw);
            }
            pw.println();
        }
        if (this.deferRelaunchUntilPaused || this.configChangeFlags != 0) {
            pw.print(prefix);
            pw.print("deferRelaunchUntilPaused=");
            pw.print(this.deferRelaunchUntilPaused);
            pw.print(" configChangeFlags=");
            pw.println(Integer.toHexString(this.configChangeFlags));
        }
        if (this.connections != null) {
            pw.print(prefix);
            pw.print("connections=");
            pw.println(this.connections);
        }
        if (this.info != null) {
            pw.println(prefix + "resizeMode=" + ActivityInfo.resizeModeToString(this.info.resizeMode));
            pw.println(prefix + "supportsPictureInPicture=" + this.info.supportsPictureInPicture());
        }
        pw.println(prefix + "supportsPictureInPictureWhilePausing: " + this.supportsPictureInPictureWhilePausing);
    }

    private boolean crossesHorizontalSizeThreshold(int firstDp, int secondDp) {
        return ActivityRecord.crossesSizeThreshold(this.mHorizontalSizeConfigurations, firstDp, secondDp);
    }

    private boolean crossesVerticalSizeThreshold(int firstDp, int secondDp) {
        return ActivityRecord.crossesSizeThreshold(this.mVerticalSizeConfigurations, firstDp, secondDp);
    }

    private boolean crossesSmallestSizeThreshold(int firstDp, int secondDp) {
        return ActivityRecord.crossesSizeThreshold(this.mSmallestSizeConfigurations, firstDp, secondDp);
    }

    private static boolean crossesSizeThreshold(int[] thresholds, int firstDp, int secondDp) {
        if (thresholds == null) {
            return false;
        }
        for (int i = thresholds.length - 1; i >= 0; --i) {
            int threshold = thresholds[i];
            if ((firstDp >= threshold || secondDp < threshold) && (firstDp < threshold || secondDp >= threshold)) continue;
            return true;
        }
        return false;
    }

    void setSizeConfigurations(int[] horizontalSizeConfiguration, int[] verticalSizeConfigurations, int[] smallestSizeConfigurations) {
        this.mHorizontalSizeConfigurations = horizontalSizeConfiguration;
        this.mVerticalSizeConfigurations = verticalSizeConfigurations;
        this.mSmallestSizeConfigurations = smallestSizeConfigurations;
    }

    private void scheduleActivityMovedToDisplay(int displayId, Configuration config) {
        if (this.app == null || this.app.thread == null) {
            return;
        }
        try {
            this.app.thread.scheduleActivityMovedToDisplay(this.appToken, displayId, new Configuration(config));
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private void scheduleConfigurationChanged(Configuration config) {
        if (this.app == null || this.app.thread == null) {
            return;
        }
        try {
            this.app.thread.scheduleActivityConfigurationChanged(this.appToken, new Configuration(config));
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    void scheduleMultiWindowModeChanged() {
        if (this.task == null || this.task.getStack() == null || this.app == null || this.app.thread == null) {
            return;
        }
        try {
            this.app.thread.scheduleMultiWindowModeChanged(this.appToken, !this.task.mFullscreen);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void schedulePictureInPictureModeChanged() {
        if (this.task == null || this.task.getStack() == null || this.app == null || this.app.thread == null) {
            return;
        }
        try {
            this.app.thread.schedulePictureInPictureModeChanged(this.appToken, this.task.getStackId() == 4);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    boolean isFreeform() {
        return this.task != null && this.task.getStackId() == 2;
    }

    static ActivityRecord forTokenLocked(IBinder token) {
        try {
            return Token.tokenToActivityRecordLocked((Token)token);
        }
        catch (ClassCastException e) {
            Slog.w("ActivityManager", "Bad activity token: " + token, e);
            return null;
        }
    }

    boolean isResolverActivity() {
        return ResolverActivity.class.getName().equals(this.realActivity.getClassName());
    }

    ActivityRecord(ActivityManagerService _service, ProcessRecord _caller, int _launchedFromPid, int _launchedFromUid, String _launchedFromPackage, Intent _intent, String _resolvedType, ActivityInfo aInfo, Configuration _configuration, ActivityRecord _resultTo, String _resultWho, int _reqCode, boolean _componentSpecified, boolean _rootVoiceInteraction, ActivityStackSupervisor supervisor, ActivityStackSupervisor.ActivityContainer container, ActivityOptions options, ActivityRecord sourceRecord) {
        this.service = _service;
        this.appToken = new Token(this);
        this.info = aInfo;
        this.launchedFromPid = _launchedFromPid;
        this.launchedFromUid = _launchedFromUid;
        this.launchedFromPackage = _launchedFromPackage;
        this.userId = UserHandle.getUserId(aInfo.applicationInfo.uid);
        this.intent = _intent;
        this.shortComponentName = _intent.getComponent().flattenToShortString();
        this.resolvedType = _resolvedType;
        this.componentSpecified = _componentSpecified;
        this.rootVoiceInteraction = _rootVoiceInteraction;
        this.mLastReportedConfiguration = new Configuration(_configuration);
        this.mLastReportedOverrideConfiguration = new Configuration();
        this.resultTo = _resultTo;
        this.resultWho = _resultWho;
        this.requestCode = _reqCode;
        this.state = ActivityStack.ActivityState.INITIALIZING;
        this.frontOfTask = false;
        this.launchFailed = false;
        this.stopped = false;
        this.delayedResume = false;
        this.finishing = false;
        this.deferRelaunchUntilPaused = false;
        this.keysPaused = false;
        this.inHistory = false;
        this.visible = false;
        this.nowVisible = false;
        this.idle = false;
        this.hasBeenLaunched = false;
        this.mStackSupervisor = supervisor;
        this.mInitialActivityContainer = container;
        this.mRotationAnimationHint = aInfo.rotationAnimation;
        if (options != null) {
            PendingIntent usageReport;
            this.pendingOptions = options;
            this.mLaunchTaskBehind = this.pendingOptions.getLaunchTaskBehind();
            int rotationAnimation = this.pendingOptions.getRotationAnimationHint();
            if (rotationAnimation >= 0) {
                this.mRotationAnimationHint = rotationAnimation;
            }
            if ((usageReport = this.pendingOptions.getUsageTimeReport()) != null) {
                this.appTimeTracker = new AppTimeTracker(usageReport);
            }
        }
        this.haveState = true;
        this.realActivity = aInfo.targetActivity == null || aInfo.targetActivity.equals(_intent.getComponent().getClassName()) && (aInfo.launchMode == 0 || aInfo.launchMode == 1) ? _intent.getComponent() : new ComponentName(aInfo.packageName, aInfo.targetActivity);
        this.taskAffinity = aInfo.taskAffinity;
        this.stateNotNeeded = (aInfo.flags & 0x10) != 0;
        this.appInfo = aInfo.applicationInfo;
        this.nonLocalizedLabel = aInfo.nonLocalizedLabel;
        this.labelRes = aInfo.labelRes;
        if (this.nonLocalizedLabel == null && this.labelRes == 0) {
            ApplicationInfo app = aInfo.applicationInfo;
            this.nonLocalizedLabel = app.nonLocalizedLabel;
            this.labelRes = app.labelRes;
        }
        this.icon = aInfo.getIconResource();
        this.logo = aInfo.getLogoResource();
        this.realTheme = this.theme = aInfo.getThemeResource();
        if (this.realTheme == 0) {
            int n = this.realTheme = aInfo.applicationInfo.targetSdkVersion < 11 ? 16973829 : 16973931;
        }
        if ((aInfo.flags & 0x200) != 0) {
            this.windowFlags |= 0x1000000;
        }
        this.processName = (aInfo.flags & 1) != 0 && _caller != null && (aInfo.applicationInfo.uid == 1000 || aInfo.applicationInfo.uid == _caller.info.uid) ? _caller.processName : aInfo.processName;
        if ((aInfo.flags & 0x20) != 0) {
            this.intent.addFlags(0x800000);
        }
        this.packageName = aInfo.applicationInfo.packageName;
        this.launchMode = aInfo.launchMode;
        AttributeCache.Entry ent = AttributeCache.instance().get(this.packageName, this.realTheme, R.styleable.Window, this.userId);
        boolean translucent = ent != null && (ent.array.getBoolean(5, false) || !ent.array.hasValue(5) && ent.array.getBoolean(25, false));
        this.fullscreen = ent != null && !ent.array.getBoolean(4, false) && !translucent;
        this.noDisplay = ent != null && ent.array.getBoolean(10, false);
        this.setActivityType(_componentSpecified, _launchedFromUid, _intent, options, sourceRecord);
        this.immersive = (aInfo.flags & 0x800) != 0;
        this.requestedVrComponent = aInfo.requestedVrComponent == null ? null : ComponentName.unflattenFromString(aInfo.requestedVrComponent);
    }

    AppWindowContainerController getWindowContainerController() {
        return this.mWindowContainerController;
    }

    void createWindowContainer() {
        if (this.mWindowContainerController != null) {
            throw new IllegalArgumentException("Window container=" + this.mWindowContainerController + " already created for r=" + this);
        }
        this.inHistory = true;
        this.task.updateOverrideConfigurationFromLaunchBounds();
        TaskWindowContainerController taskController = this.task.getWindowContainerController();
        this.mWindowContainerController = new AppWindowContainerController(taskController, this.appToken, this, Integer.MAX_VALUE, this.info.screenOrientation, this.fullscreen, (this.info.flags & 0x400) != 0, this.info.configChanges, this.task.voiceSession != null, this.mLaunchTaskBehind, this.isAlwaysFocusable(), this.appInfo.targetSdkVersion, this.mRotationAnimationHint, ActivityManagerService.getInputDispatchingTimeoutLocked(this) * 1000000L);
        this.task.addActivityToTop(this);
        this.onOverrideConfigurationSent();
    }

    void removeWindowContainer() {
        this.resumeKeyDispatchingLocked();
        this.mWindowContainerController.removeContainer(this.getDisplayId());
        this.mWindowContainerController = null;
    }

    void reparent(TaskRecord newTask, int position, String reason) {
        TaskRecord prevTask = this.task;
        if (prevTask == newTask) {
            throw new IllegalArgumentException(reason + ": task=" + newTask + " is already the parent of r=" + this);
        }
        this.mWindowContainerController.reparent(newTask.getWindowContainerController(), position);
        prevTask.removeActivity(this);
        this.task = null;
        newTask.addActivityAtIndex(position, this);
    }

    private boolean isHomeIntent(Intent intent) {
        return "android.intent.action.MAIN".equals(intent.getAction()) && intent.hasCategory("android.intent.category.HOME") && intent.getCategories().size() == 1 && intent.getData() == null && intent.getType() == null;
    }

    static boolean isMainIntent(Intent intent) {
        return "android.intent.action.MAIN".equals(intent.getAction()) && intent.hasCategory("android.intent.category.LAUNCHER") && intent.getCategories().size() == 1 && intent.getData() == null && intent.getType() == null;
    }

    private boolean canLaunchHomeActivity(int uid, ActivityRecord sourceRecord) {
        if (uid == Process.myUid() || uid == 0) {
            return true;
        }
        return sourceRecord != null && sourceRecord.isResolverActivity();
    }

    private boolean canLaunchAssistActivity(String packageName) {
        if (this.service.mAssistUtils == null) {
            return false;
        }
        ComponentName assistComponent = this.service.mAssistUtils.getActiveServiceComponentName();
        if (assistComponent != null) {
            return assistComponent.getPackageName().equals(packageName);
        }
        return false;
    }

    private void setActivityType(boolean componentSpecified, int launchedFromUid, Intent intent, ActivityOptions options, ActivityRecord sourceRecord) {
        if ((!componentSpecified || this.canLaunchHomeActivity(launchedFromUid, sourceRecord)) && this.isHomeIntent(intent) && !this.isResolverActivity()) {
            this.mActivityType = 1;
            if (this.info.resizeMode == 4 || this.info.resizeMode == 1) {
                this.info.resizeMode = 0;
            }
        } else {
            this.mActivityType = this.realActivity.getClassName().contains(RECENTS_PACKAGE_NAME) ? 2 : (options != null && options.getLaunchStackId() == 6 && this.canLaunchAssistActivity(this.launchedFromPackage) ? 3 : 0);
        }
    }

    void setTaskToAffiliateWith(TaskRecord taskToAffiliateWith) {
        if (this.launchMode != 3 && this.launchMode != 2) {
            this.task.setTaskToAffiliateWith(taskToAffiliateWith);
        }
    }

    ActivityStack getStack() {
        return this.task != null ? this.task.getStack() : null;
    }

    boolean changeWindowTranslucency(boolean toOpaque) {
        if (this.fullscreen == toOpaque) {
            return false;
        }
        this.task.numFullscreen = this.task.numFullscreen + (toOpaque ? 1 : -1);
        this.fullscreen = toOpaque;
        return true;
    }

    void takeFromHistory() {
        if (this.inHistory) {
            this.inHistory = false;
            if (this.task != null && !this.finishing) {
                this.task = null;
            }
            this.clearOptionsLocked();
        }
    }

    boolean isInHistory() {
        return this.inHistory;
    }

    boolean isInStackLocked() {
        ActivityStack stack = this.getStack();
        return stack != null && stack.isInStackLocked(this) != null;
    }

    boolean isHomeActivity() {
        return this.mActivityType == 1;
    }

    boolean isRecentsActivity() {
        return this.mActivityType == 2;
    }

    boolean isAssistantActivity() {
        return this.mActivityType == 3;
    }

    boolean isApplicationActivity() {
        return this.mActivityType == 0;
    }

    boolean isPersistable() {
        return !(this.info.persistableMode != 0 && this.info.persistableMode != 2 || this.intent != null && (this.intent.getFlags() & 0x800000) != 0);
    }

    boolean isFocusable() {
        return ActivityManager.StackId.canReceiveKeys(this.task.getStackId()) || this.isAlwaysFocusable();
    }

    boolean isResizeable() {
        return ActivityInfo.isResizeableMode(this.info.resizeMode) || this.info.supportsPictureInPicture();
    }

    boolean isNonResizableOrForcedResizable() {
        return this.info.resizeMode != 2 && this.info.resizeMode != 1;
    }

    boolean supportsPictureInPicture() {
        return this.service.mSupportsPictureInPicture && !this.isHomeActivity() && this.info.supportsPictureInPicture();
    }

    boolean supportsSplitScreen() {
        return this.service.mSupportsSplitScreenMultiWindow && this.supportsResizeableMultiWindow();
    }

    boolean supportsFreeform() {
        return this.service.mSupportsFreeformWindowManagement && this.supportsResizeableMultiWindow();
    }

    private boolean supportsResizeableMultiWindow() {
        return this.service.mSupportsMultiWindow && !this.isHomeActivity() && (ActivityInfo.isResizeableMode(this.info.resizeMode) || this.service.mForceResizableActivities);
    }

    boolean checkEnterPictureInPictureState(String caller, boolean noThrow) {
        boolean isCurrentAppLocked = this.mStackSupervisor.getLockTaskModeState() != 0;
        boolean isKeyguardLocked = this.service.isKeyguardLocked();
        boolean hasPinnedStack = this.mStackSupervisor.getStack(4) != null;
        boolean isNotLockedOrOnKeyguard = !isKeyguardLocked && !isCurrentAppLocked;
        switch (this.state) {
            case RESUMED: {
                return !isCurrentAppLocked;
            }
            case PAUSING: 
            case PAUSED: {
                return isNotLockedOrOnKeyguard && !hasPinnedStack && this.supportsPictureInPictureWhilePausing && this.checkEnterPictureInPictureOnHideAppOpsState();
            }
            case STOPPING: {
                if (!this.supportsPictureInPictureWhilePausing) break;
                return isNotLockedOrOnKeyguard && !hasPinnedStack && this.checkEnterPictureInPictureOnHideAppOpsState();
            }
        }
        if (noThrow) {
            return false;
        }
        throw new IllegalStateException(caller + ": Current activity is not visible (state=" + this.state.name() + ") " + "r=" + this);
    }

    private boolean checkEnterPictureInPictureOnHideAppOpsState() {
        try {
            return this.service.getAppOpsService().checkOperation(67, this.appInfo.uid, this.packageName) == 0;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    boolean isAlwaysFocusable() {
        return (this.info.flags & 0x40000) != 0;
    }

    boolean hasShowWhenLockedWindows() {
        return this.service.mWindowManager.containsShowWhenLockedWindow(this.appToken);
    }

    boolean hasDismissKeyguardWindows() {
        return this.service.mWindowManager.containsDismissKeyguardWindow(this.appToken);
    }

    void makeFinishingLocked() {
        if (!this.finishing) {
            ActivityStack stack = this.getStack();
            if (stack != null && this == stack.getVisibleBehindActivity()) {
                this.mStackSupervisor.requestVisibleBehindLocked(this, false);
            }
            this.finishing = true;
            if (this.stopped) {
                this.clearOptionsLocked();
            }
            if (this.service != null) {
                this.service.mTaskChangeNotificationController.notifyTaskStackChanged();
            }
        }
    }

    UriPermissionOwner getUriPermissionsLocked() {
        if (this.uriPermissions == null) {
            this.uriPermissions = new UriPermissionOwner(this.service, this);
        }
        return this.uriPermissions;
    }

    void addResultLocked(ActivityRecord from, String resultWho, int requestCode, int resultCode, Intent resultData) {
        ActivityResult r = new ActivityResult(from, resultWho, requestCode, resultCode, resultData);
        if (this.results == null) {
            this.results = new ArrayList();
        }
        this.results.add(r);
    }

    void removeResultsLocked(ActivityRecord from, String resultWho, int requestCode) {
        if (this.results != null) {
            for (int i = this.results.size() - 1; i >= 0; --i) {
                ActivityResult r = (ActivityResult)this.results.get(i);
                if (r.mFrom != from || (r.mResultWho != null ? !r.mResultWho.equals(resultWho) : resultWho != null) || r.mRequestCode != requestCode) continue;
                this.results.remove(i);
            }
        }
    }

    private void addNewIntentLocked(ReferrerIntent intent) {
        if (this.newIntents == null) {
            this.newIntents = new ArrayList();
        }
        this.newIntents.add(intent);
    }

    final void deliverNewIntentLocked(int callingUid, Intent intent, String referrer) {
        boolean isTopActivityWhileSleeping;
        this.service.grantUriPermissionFromIntentLocked(callingUid, this.packageName, intent, this.getUriPermissionsLocked(), this.userId);
        ReferrerIntent rintent = new ReferrerIntent(intent, referrer);
        boolean unsent = true;
        ActivityStack stack = this.getStack();
        boolean isTopActivityInStack = stack != null && stack.topRunningActivityLocked() == this;
        boolean bl = isTopActivityWhileSleeping = this.service.isSleepingLocked() && isTopActivityInStack;
        if ((this.state == ActivityStack.ActivityState.RESUMED || this.state == ActivityStack.ActivityState.PAUSED || isTopActivityWhileSleeping) && this.app != null && this.app.thread != null) {
            try {
                ArrayList<ReferrerIntent> ar = new ArrayList<ReferrerIntent>(1);
                ar.add(rintent);
                this.app.thread.scheduleNewIntent(ar, this.appToken, this.state == ActivityStack.ActivityState.PAUSED);
                unsent = false;
            }
            catch (RemoteException e) {
                Slog.w("ActivityManager", "Exception thrown sending new intent to " + this, e);
            }
            catch (NullPointerException e) {
                Slog.w("ActivityManager", "Exception thrown sending new intent to " + this, e);
            }
        }
        if (unsent) {
            this.addNewIntentLocked(rintent);
        }
    }

    void updateOptionsLocked(ActivityOptions options) {
        if (options != null) {
            if (this.pendingOptions != null) {
                this.pendingOptions.abort();
            }
            this.pendingOptions = options;
        }
    }

    void applyOptionsLocked() {
        if (this.pendingOptions != null && this.pendingOptions.getAnimationType() != 5) {
            int animationType = this.pendingOptions.getAnimationType();
            switch (animationType) {
                case 1: {
                    this.service.mWindowManager.overridePendingAppTransition(this.pendingOptions.getPackageName(), this.pendingOptions.getCustomEnterResId(), this.pendingOptions.getCustomExitResId(), this.pendingOptions.getOnAnimationStartListener());
                    break;
                }
                case 11: {
                    this.service.mWindowManager.overridePendingAppTransitionClipReveal(this.pendingOptions.getStartX(), this.pendingOptions.getStartY(), this.pendingOptions.getWidth(), this.pendingOptions.getHeight());
                    if (this.intent.getSourceBounds() != null) break;
                    this.intent.setSourceBounds(new Rect(this.pendingOptions.getStartX(), this.pendingOptions.getStartY(), this.pendingOptions.getStartX() + this.pendingOptions.getWidth(), this.pendingOptions.getStartY() + this.pendingOptions.getHeight()));
                    break;
                }
                case 2: {
                    this.service.mWindowManager.overridePendingAppTransitionScaleUp(this.pendingOptions.getStartX(), this.pendingOptions.getStartY(), this.pendingOptions.getWidth(), this.pendingOptions.getHeight());
                    if (this.intent.getSourceBounds() != null) break;
                    this.intent.setSourceBounds(new Rect(this.pendingOptions.getStartX(), this.pendingOptions.getStartY(), this.pendingOptions.getStartX() + this.pendingOptions.getWidth(), this.pendingOptions.getStartY() + this.pendingOptions.getHeight()));
                    break;
                }
                case 3: 
                case 4: {
                    boolean scaleUp = animationType == 3;
                    this.service.mWindowManager.overridePendingAppTransitionThumb(this.pendingOptions.getThumbnail(), this.pendingOptions.getStartX(), this.pendingOptions.getStartY(), this.pendingOptions.getOnAnimationStartListener(), scaleUp);
                    if (this.intent.getSourceBounds() != null) break;
                    this.intent.setSourceBounds(new Rect(this.pendingOptions.getStartX(), this.pendingOptions.getStartY(), this.pendingOptions.getStartX() + this.pendingOptions.getThumbnail().getWidth(), this.pendingOptions.getStartY() + this.pendingOptions.getThumbnail().getHeight()));
                    break;
                }
                case 8: 
                case 9: {
                    AppTransitionAnimationSpec[] specs = this.pendingOptions.getAnimSpecs();
                    if (animationType == 9 && specs != null) {
                        this.service.mWindowManager.overridePendingAppTransitionMultiThumb(specs, this.pendingOptions.getOnAnimationStartListener(), this.pendingOptions.getAnimationFinishedListener(), false);
                        break;
                    }
                    this.service.mWindowManager.overridePendingAppTransitionAspectScaledThumb(this.pendingOptions.getThumbnail(), this.pendingOptions.getStartX(), this.pendingOptions.getStartY(), this.pendingOptions.getWidth(), this.pendingOptions.getHeight(), this.pendingOptions.getOnAnimationStartListener(), animationType == 8);
                    if (this.intent.getSourceBounds() != null) break;
                    this.intent.setSourceBounds(new Rect(this.pendingOptions.getStartX(), this.pendingOptions.getStartY(), this.pendingOptions.getStartX() + this.pendingOptions.getWidth(), this.pendingOptions.getStartY() + this.pendingOptions.getHeight()));
                    break;
                }
                default: {
                    Slog.e("ActivityManager", "applyOptionsLocked: Unknown animationType=" + animationType);
                }
            }
            this.pendingOptions = null;
        }
    }

    ActivityOptions getOptionsForTargetActivityLocked() {
        return this.pendingOptions != null ? this.pendingOptions.forTargetActivity() : null;
    }

    void clearOptionsLocked() {
        if (this.pendingOptions != null) {
            this.pendingOptions.abort();
            this.pendingOptions = null;
        }
    }

    ActivityOptions takeOptionsLocked() {
        ActivityOptions opts = this.pendingOptions;
        this.pendingOptions = null;
        return opts;
    }

    void removeUriPermissionsLocked() {
        if (this.uriPermissions != null) {
            this.uriPermissions.removeUriPermissionsLocked();
            this.uriPermissions = null;
        }
    }

    void pauseKeyDispatchingLocked() {
        if (!this.keysPaused) {
            this.keysPaused = true;
            this.mWindowContainerController.pauseKeyDispatching();
        }
    }

    void resumeKeyDispatchingLocked() {
        if (this.keysPaused) {
            this.keysPaused = false;
            this.mWindowContainerController.resumeKeyDispatching();
        }
    }

    void updateThumbnailLocked(Bitmap newThumbnail, CharSequence description) {
        boolean thumbnailUpdated;
        if (newThumbnail != null && (thumbnailUpdated = this.task.setLastThumbnailLocked(newThumbnail)) && this.isPersistable()) {
            this.service.notifyTaskPersisterLocked(this.task, false);
        }
        this.task.lastDescription = description;
    }

    final Bitmap screenshotActivityLocked() {
        if (ActivityManager.ENABLE_TASK_SNAPSHOTS) {
            return null;
        }
        if (this.noDisplay) {
            return null;
        }
        ActivityStack stack = this.getStack();
        if (stack.isHomeOrRecentsStack()) {
            return null;
        }
        int w = this.service.mThumbnailWidth;
        int h = this.service.mThumbnailHeight;
        if (w <= 0) {
            Slog.e("ActivityManager", "\tInvalid thumbnail dimensions: " + w + "x" + h);
            return null;
        }
        if (stack.mStackId == 3 && this.mStackSupervisor.mIsDockMinimized) {
            return null;
        }
        float scale = 0.0f;
        h = -1;
        w = -1;
        scale = this.service.mFullscreenThumbnailScale;
        return this.mWindowContainerController.screenshotApplications(this.getDisplayId(), w, h, scale);
    }

    void setVisibility(boolean visible) {
        this.mWindowContainerController.setVisibility(visible);
    }

    void setVisible(boolean newVisible) {
        this.visible = newVisible;
        if (!this.visible && this.mUpdateTaskThumbnailWhenHidden) {
            this.updateThumbnailLocked(this.screenshotActivityLocked(), null);
            this.mUpdateTaskThumbnailWhenHidden = false;
        }
        this.mWindowContainerController.setVisibility(this.visible);
        ArrayList<ActivityStackSupervisor.ActivityContainer> containers = this.mChildContainers;
        for (int containerNdx = containers.size() - 1; containerNdx >= 0; --containerNdx) {
            ActivityStackSupervisor.ActivityContainer container = containers.get(containerNdx);
            container.setVisible(this.visible);
        }
        this.mStackSupervisor.mAppVisibilitiesChangedSinceLastPause = true;
    }

    void notifyAppResumed(boolean wasStopped, boolean allowSavedSurface) {
        this.mWindowContainerController.notifyAppResumed(wasStopped, allowSavedSurface);
    }

    void notifyUnknownVisibilityLaunched() {
        this.mWindowContainerController.notifyUnknownVisibilityLaunched();
    }

    boolean shouldBeVisibleIgnoringKeyguard(boolean behindTranslucentActivity, boolean stackVisibleBehind, ActivityRecord visibleBehind, boolean behindFullscreenActivity) {
        boolean isVisible;
        if (!this.okToShowLocked()) {
            return false;
        }
        boolean activityVisibleBehind = (behindTranslucentActivity || stackVisibleBehind) && visibleBehind == this;
        boolean bl = isVisible = !behindFullscreenActivity || this.mLaunchTaskBehind || activityVisibleBehind;
        if (this.service.mSupportsLeanbackOnly && isVisible && this.isRecentsActivity()) {
            isVisible = this.mStackSupervisor.getStack(3) != null || this.mStackSupervisor.isFocusedStack(this.getStack());
        }
        return isVisible;
    }

    void makeVisibleIfNeeded(ActivityRecord starting) {
        if (this.state == ActivityStack.ActivityState.RESUMED || this == starting) {
            return;
        }
        ActivityStack stack = this.getStack();
        try {
            if (stack.mTranslucentActivityWaiting != null) {
                this.updateOptionsLocked(this.returningOptions);
                stack.mUndrawnActivitiesBelowTopTranslucent.add(this);
            }
            this.setVisible(true);
            this.sleeping = false;
            this.app.pendingUiClean = true;
            this.app.thread.scheduleWindowVisibility(this.appToken, true);
            this.mStackSupervisor.mStoppingActivities.remove(this);
            this.mStackSupervisor.mGoingToSleepActivities.remove(this);
        }
        catch (Exception e) {
            Slog.w("ActivityManager", "Exception thrown making visibile: " + this.intent.getComponent(), e);
        }
        this.handleAlreadyVisible();
    }

    boolean handleAlreadyVisible() {
        this.stopFreezingScreenLocked(false);
        try {
            if (this.returningOptions != null) {
                this.app.thread.scheduleOnNewActivityOptions(this.appToken, this.returningOptions.toBundle());
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return this.state == ActivityStack.ActivityState.RESUMED;
    }

    static void activityResumedLocked(IBinder token) {
        ActivityRecord r = ActivityRecord.forTokenLocked(token);
        if (r != null) {
            r.icicle = null;
            r.haveState = false;
        }
    }

    void completeResumeLocked() {
        ProcessRecord app;
        boolean wasVisible = this.visible;
        this.visible = true;
        if (!wasVisible) {
            this.mStackSupervisor.mAppVisibilitiesChangedSinceLastPause = true;
        }
        this.idle = false;
        this.results = null;
        this.newIntents = null;
        this.stopped = false;
        if (this.isHomeActivity() && (app = this.task.mActivities.get((int)0).app) != null && app != this.service.mHomeProcess) {
            this.service.mHomeProcess = app;
        }
        if (this.nowVisible) {
            this.mStackSupervisor.reportActivityVisibleLocked(this);
        }
        this.mStackSupervisor.scheduleIdleTimeoutLocked(this);
        this.mStackSupervisor.reportResumedActivityLocked(this);
        this.resumeKeyDispatchingLocked();
        ActivityStack stack = this.getStack();
        stack.mNoAnimActivities.clear();
        this.cpuTimeAtResume = this.app != null ? this.service.mProcessCpuTracker.getCpuTimeForPid(this.app.pid) : 0L;
        this.returningOptions = null;
        if (stack.getVisibleBehindActivity() == this) {
            stack.setVisibleBehindActivity(null);
        }
        this.mStackSupervisor.checkReadyForSleepLocked();
    }

    final void activityStoppedLocked(Bundle newIcicle, PersistableBundle newPersistentState, CharSequence description) {
        ActivityStack stack = this.getStack();
        if (this.state != ActivityStack.ActivityState.STOPPING) {
            Slog.i("ActivityManager", "Activity reported stop, but no longer stopping: " + this);
            stack.mHandler.removeMessages(104, this);
            return;
        }
        if (newPersistentState != null) {
            this.persistentState = newPersistentState;
            this.service.notifyTaskPersisterLocked(this.task, false);
        }
        if (newIcicle != null) {
            this.icicle = newIcicle;
            this.haveState = true;
            this.launchCount = 0;
            this.updateThumbnailLocked(null, description);
        }
        if (!this.stopped) {
            stack.mHandler.removeMessages(104, this);
            this.stopped = true;
            this.state = ActivityStack.ActivityState.STOPPED;
            this.mWindowContainerController.notifyAppStopped();
            if (stack.getVisibleBehindActivity() == this) {
                this.mStackSupervisor.requestVisibleBehindLocked(this, false);
            }
            if (this.finishing) {
                this.clearOptionsLocked();
            } else if (this.deferRelaunchUntilPaused) {
                stack.destroyActivityLocked(this, true, "stop-config");
                this.mStackSupervisor.resumeFocusedStackTopActivityLocked();
            } else {
                this.mStackSupervisor.updatePreviousProcessLocked(this);
            }
        }
    }

    void startLaunchTickingLocked() {
        if (ActivityManagerService.IS_USER_BUILD) {
            return;
        }
        if (this.launchTickTime == 0L) {
            this.launchTickTime = SystemClock.uptimeMillis();
            this.continueLaunchTickingLocked();
        }
    }

    boolean continueLaunchTickingLocked() {
        if (this.launchTickTime == 0L) {
            return false;
        }
        ActivityStack stack = this.getStack();
        if (stack == null) {
            return false;
        }
        Message msg = stack.mHandler.obtainMessage(103, this);
        stack.mHandler.removeMessages(103);
        stack.mHandler.sendMessageDelayed(msg, 500L);
        return true;
    }

    void finishLaunchTickingLocked() {
        this.launchTickTime = 0L;
        ActivityStack stack = this.getStack();
        if (stack != null) {
            stack.mHandler.removeMessages(103);
        }
    }

    public boolean mayFreezeScreenLocked(ProcessRecord app) {
        return app != null && !app.crashing && !app.notResponding;
    }

    public void startFreezingScreenLocked(ProcessRecord app, int configChanges) {
        if (this.mayFreezeScreenLocked(app)) {
            this.mWindowContainerController.startFreezingScreen(configChanges);
        }
    }

    public void stopFreezingScreenLocked(boolean force) {
        if (force || this.frozenBeforeDestroy) {
            this.frozenBeforeDestroy = false;
            this.mWindowContainerController.stopFreezingScreen(force);
        }
    }

    public void reportFullyDrawnLocked() {
        long curTime = SystemClock.uptimeMillis();
        if (this.displayStartTime != 0L) {
            this.reportLaunchTimeLocked(curTime);
        }
        ActivityStack stack = this.getStack();
        if (this.fullyDrawnStartTime != 0L && stack != null) {
            long thisTime = curTime - this.fullyDrawnStartTime;
            long totalTime = stack.mFullyDrawnStartTime != 0L ? curTime - stack.mFullyDrawnStartTime : thisTime;
            Trace.asyncTraceEnd(64L, "drawing", 0);
            EventLog.writeEvent(30042, this.userId, System.identityHashCode(this), this.shortComponentName, thisTime, totalTime);
            StringBuilder sb = this.service.mStringBuilder;
            sb.setLength(0);
            sb.append("Fully drawn ");
            sb.append(this.shortComponentName);
            sb.append(": ");
            TimeUtils.formatDuration(thisTime, sb);
            if (thisTime != totalTime) {
                sb.append(" (total ");
                TimeUtils.formatDuration(totalTime, sb);
                sb.append(")");
            }
            Log.i("ActivityManager", sb.toString());
            if (totalTime > 0L) {
                // empty if block
            }
            stack.mFullyDrawnStartTime = 0L;
        }
        this.fullyDrawnStartTime = 0L;
    }

    private void reportLaunchTimeLocked(long curTime) {
        ActivityStack stack = this.getStack();
        if (stack == null) {
            return;
        }
        long thisTime = curTime - this.displayStartTime;
        long totalTime = stack.mLaunchStartTime != 0L ? curTime - stack.mLaunchStartTime : thisTime;
        Trace.asyncTraceEnd(64L, "launching: " + this.packageName, 0);
        EventLog.writeEvent(30009, this.userId, System.identityHashCode(this), this.shortComponentName, thisTime, totalTime);
        StringBuilder sb = this.service.mStringBuilder;
        sb.setLength(0);
        sb.append("Displayed ");
        sb.append(this.shortComponentName);
        sb.append(": ");
        TimeUtils.formatDuration(thisTime, sb);
        if (thisTime != totalTime) {
            sb.append(" (total ");
            TimeUtils.formatDuration(totalTime, sb);
            sb.append(")");
        }
        Log.i("ActivityManager", sb.toString());
        this.mStackSupervisor.reportActivityLaunchedLocked(false, this, thisTime, totalTime);
        if (totalTime > 0L) {
            // empty if block
        }
        this.displayStartTime = 0L;
        stack.mLaunchStartTime = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onWindowsDrawn() {
        ActivityManagerService activityManagerService = this.service;
        synchronized (activityManagerService) {
            this.mStackSupervisor.mActivityMetricsLogger.notifyWindowsDrawn();
            if (this.displayStartTime != 0L) {
                this.reportLaunchTimeLocked(SystemClock.uptimeMillis());
            }
            this.mStackSupervisor.sendWaitingVisibleReportLocked(this);
            this.startTime = 0L;
            this.finishLaunchTickingLocked();
            if (this.task != null) {
                this.task.hasBeenVisible = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onWindowsVisible() {
        ActivityManagerService activityManagerService = this.service;
        synchronized (activityManagerService) {
            this.mStackSupervisor.reportActivityVisibleLocked(this);
            if (!this.nowVisible) {
                this.nowVisible = true;
                this.lastVisibleTime = SystemClock.uptimeMillis();
                if (!this.idle) {
                    this.mStackSupervisor.processStoppingActivitiesLocked(null, false, true);
                } else {
                    int size = this.mStackSupervisor.mWaitingVisibleActivities.size();
                    if (size > 0) {
                        for (int i = 0; i < size; ++i) {
                            ActivityRecord activityRecord = this.mStackSupervisor.mWaitingVisibleActivities.get(i);
                        }
                        this.mStackSupervisor.mWaitingVisibleActivities.clear();
                        this.mStackSupervisor.scheduleIdleLocked();
                    }
                }
                this.service.scheduleAppGcsLocked();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onWindowsGone() {
        ActivityManagerService activityManagerService = this.service;
        synchronized (activityManagerService) {
            this.nowVisible = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean keyDispatchingTimedOut(String reason) {
        ProcessRecord anrApp;
        ActivityRecord anrActivity;
        ActivityManagerService activityManagerService = this.service;
        synchronized (activityManagerService) {
            anrActivity = this.getWaitingHistoryRecordLocked();
            anrApp = this.app;
        }
        return this.service.inputDispatchingTimedOut(anrApp, anrActivity, this, false, reason);
    }

    private ActivityRecord getWaitingHistoryRecordLocked() {
        if (this.mStackSupervisor.mWaitingVisibleActivities.contains(this) || this.stopped) {
            ActivityStack stack = this.mStackSupervisor.getFocusedStack();
            ActivityRecord r = stack.mResumedActivity;
            if (r == null) {
                r = stack.mPausingActivity;
            }
            if (r != null) {
                return r;
            }
        }
        return this;
    }

    public boolean okToShowLocked() {
        return (this.info.flags & 0x400) != 0 || this.mStackSupervisor.isCurrentProfileLocked(this.userId) && !this.service.mUserController.isUserStoppingOrShuttingDownLocked(this.userId);
    }

    public boolean isInterestingToUserLocked() {
        return this.visible || this.nowVisible || this.state == ActivityStack.ActivityState.PAUSING || this.state == ActivityStack.ActivityState.RESUMED;
    }

    void setSleeping(boolean _sleeping) {
        this.setSleeping(_sleeping, false);
    }

    void setSleeping(boolean _sleeping, boolean force) {
        if (!force && this.sleeping == _sleeping) {
            return;
        }
        if (this.app != null && this.app.thread != null) {
            try {
                this.app.thread.scheduleSleeping(this.appToken, _sleeping);
                if (_sleeping && !this.mStackSupervisor.mGoingToSleepActivities.contains(this)) {
                    this.mStackSupervisor.mGoingToSleepActivities.add(this);
                }
                this.sleeping = _sleeping;
            }
            catch (RemoteException e) {
                Slog.w("ActivityManager", "Exception thrown when sleeping: " + this.intent.getComponent(), e);
            }
        }
    }

    static int getTaskForActivityLocked(IBinder token, boolean onlyRoot) {
        ActivityRecord r = ActivityRecord.forTokenLocked(token);
        if (r == null) {
            return -1;
        }
        TaskRecord task = r.task;
        int activityNdx = task.mActivities.indexOf(r);
        if (activityNdx < 0 || onlyRoot && activityNdx > task.findEffectiveRootIndex()) {
            return -1;
        }
        return task.taskId;
    }

    static ActivityRecord isInStackLocked(IBinder token) {
        ActivityRecord r = ActivityRecord.forTokenLocked(token);
        return r != null ? r.getStack().isInStackLocked(r) : null;
    }

    static ActivityStack getStackLocked(IBinder token) {
        ActivityRecord r = ActivityRecord.isInStackLocked(token);
        if (r != null) {
            return r.getStack();
        }
        return null;
    }

    int getDisplayId() {
        ActivityStack stack = this.getStack();
        if (stack == null) {
            return -1;
        }
        return stack.mDisplayId;
    }

    final boolean isDestroyable() {
        if (this.finishing || this.app == null || this.state == ActivityStack.ActivityState.DESTROYING || this.state == ActivityStack.ActivityState.DESTROYED) {
            return false;
        }
        ActivityStack stack = this.getStack();
        if (stack == null || this == stack.mResumedActivity || this == stack.mPausingActivity || !this.haveState || !this.stopped) {
            return false;
        }
        return !this.visible;
    }

    private static String createImageFilename(long createTime, int taskId) {
        return String.valueOf(taskId) + ACTIVITY_ICON_SUFFIX + createTime + ".png";
    }

    void setTaskDescription(ActivityManager.TaskDescription _taskDescription) {
        Bitmap icon;
        if (_taskDescription.getIconFilename() == null && (icon = _taskDescription.getIcon()) != null) {
            String iconFilename = ActivityRecord.createImageFilename(this.createTime, this.task.taskId);
            File iconFile = new File(TaskPersister.getUserImagesDir(this.task.userId), iconFilename);
            String iconFilePath = iconFile.getAbsolutePath();
            this.service.mRecentTasks.saveImage(icon, iconFilePath);
            _taskDescription.setIconFilename(iconFilePath);
        }
        this.taskDescription = _taskDescription;
    }

    void setVoiceSessionLocked(IVoiceInteractionSession session) {
        this.voiceSession = session;
        this.pendingVoiceInteractionStart = false;
    }

    void clearVoiceSessionLocked() {
        this.voiceSession = null;
        this.pendingVoiceInteractionStart = false;
    }

    void showStartingWindow(ActivityRecord prev, boolean newTask, boolean taskSwitch) {
        if (this.mWindowContainerController == null) {
            return;
        }
        CompatibilityInfo compatInfo = this.service.compatibilityInfoForPackageLocked(this.info.applicationInfo);
        boolean shown = this.mWindowContainerController.addStartingWindow(this.packageName, this.theme, compatInfo, this.nonLocalizedLabel, this.labelRes, this.icon, this.logo, this.windowFlags, prev != null ? prev.appToken : null, newTask, taskSwitch, this.isProcessRunning());
        if (shown) {
            this.mStartingWindowState = 1;
        }
    }

    void removeOrphanedStartingWindow(boolean behindFullscreenActivity) {
        if (this.state == ActivityStack.ActivityState.INITIALIZING && this.mStartingWindowState == 1 && behindFullscreenActivity) {
            this.mStartingWindowState = 2;
            this.mWindowContainerController.removeStartingWindow();
        }
    }

    int getRequestedOrientation() {
        return this.mWindowContainerController.getOrientation();
    }

    void setRequestedOrientation(int requestedOrientation) {
        Configuration displayConfig;
        if (!(this.task == null || this.task.mFullscreen && this.task.getStack().mFullscreen)) {
            return;
        }
        int displayId = this.getDisplayId();
        Configuration config = this.mWindowContainerController.setOrientation(requestedOrientation, displayId, displayConfig = this.mStackSupervisor.getDisplayOverrideConfiguration(displayId), this.mayFreezeScreenLocked(this.app));
        if (config != null) {
            this.frozenBeforeDestroy = true;
            if (!this.service.updateDisplayOverrideConfigurationLocked(config, this, false, displayId)) {
                this.mStackSupervisor.resumeFocusedStackTopActivityLocked();
            }
        }
        this.service.mTaskChangeNotificationController.notifyActivityRequestedOrientationChanged(this.task.taskId, requestedOrientation);
    }

    void setLastReportedGlobalConfiguration(Configuration config) {
        this.mLastReportedConfiguration.setTo(config);
    }

    void setLastReportedMergedOverrideConfiguration(Configuration config) {
        this.mLastReportedOverrideConfiguration.setTo(config);
    }

    void onOverrideConfigurationSent() {
        this.mLastReportedOverrideConfiguration.setTo(this.task.getMergedOverrideConfiguration());
    }

    boolean ensureActivityConfigurationLocked(int globalChanges, boolean preserveWindow) {
        boolean displayChanged;
        ActivityStack stack = this.getStack();
        if (stack.mConfigWillChange) {
            return true;
        }
        if (this.finishing) {
            this.stopFreezingScreenLocked(false);
            return true;
        }
        int newDisplayId = this.getDisplayId();
        boolean bl = displayChanged = this.mLastReportedDisplayId != newDisplayId;
        if (displayChanged) {
            this.mLastReportedDisplayId = newDisplayId;
        }
        this.mTmpConfig1.setTo(this.mLastReportedConfiguration);
        this.mTmpConfig1.updateFrom(this.mLastReportedOverrideConfiguration);
        if (this.task.getConfiguration().equals(this.mTmpConfig1) && !this.forceNewConfig && !displayChanged) {
            return true;
        }
        Configuration newGlobalConfig = this.service.getGlobalConfiguration();
        Configuration newTaskMergedOverrideConfig = this.task.getMergedOverrideConfiguration();
        this.mTmpConfig1.setTo(this.mLastReportedConfiguration);
        this.mTmpConfig2.setTo(this.mLastReportedOverrideConfiguration);
        this.mLastReportedConfiguration.setTo(newGlobalConfig);
        this.mLastReportedOverrideConfiguration.setTo(newTaskMergedOverrideConfig);
        int taskChanges = ActivityRecord.getTaskConfigurationChanges(this, newTaskMergedOverrideConfig, this.mTmpConfig2);
        int changes = this.mTmpConfig1.diff(newGlobalConfig) | taskChanges;
        if (changes == 0 && !this.forceNewConfig) {
            if (displayChanged) {
                this.scheduleActivityMovedToDisplay(newDisplayId, newTaskMergedOverrideConfig);
            } else {
                this.scheduleConfigurationChanged(newTaskMergedOverrideConfig);
            }
            return true;
        }
        if (this.app == null || this.app.thread == null) {
            this.stopFreezingScreenLocked(false);
            this.forceNewConfig = false;
            return true;
        }
        if (this.shouldRelaunchLocked(changes, newGlobalConfig, newTaskMergedOverrideConfig) || this.forceNewConfig) {
            this.configChangeFlags |= changes;
            this.startFreezingScreenLocked(this.app, globalChanges);
            this.forceNewConfig = false;
            preserveWindow &= ActivityRecord.isResizeOnlyChange(changes);
            if (this.app == null || this.app.thread == null) {
                stack.destroyActivityLocked(this, true, "config");
            } else {
                if (this.state == ActivityStack.ActivityState.PAUSING) {
                    this.deferRelaunchUntilPaused = true;
                    this.preserveWindowOnDeferredRelaunch = preserveWindow;
                    return true;
                }
                if (this.state == ActivityStack.ActivityState.RESUMED) {
                    this.relaunchActivityLocked(true, preserveWindow);
                } else {
                    this.relaunchActivityLocked(false, preserveWindow);
                }
            }
            return false;
        }
        if (displayChanged) {
            this.scheduleActivityMovedToDisplay(newDisplayId, newTaskMergedOverrideConfig);
        } else {
            this.scheduleConfigurationChanged(newTaskMergedOverrideConfig);
        }
        this.stopFreezingScreenLocked(false);
        return true;
    }

    private boolean shouldRelaunchLocked(int changes, Configuration newGlobalConfig, Configuration newTaskMergedOverrideConfig) {
        int configChanged = this.info.getRealConfigChanged();
        if (this.appInfo.targetSdkVersion < 10000 && this.requestedVrComponent != null && (ActivityRecord.isInVrUiMode(newGlobalConfig) || ActivityRecord.isInVrUiMode(newTaskMergedOverrideConfig))) {
            configChanged |= 0x200;
        }
        return (changes & ~configChanged) != 0;
    }

    private static int getTaskConfigurationChanges(ActivityRecord record, Configuration taskConfig, Configuration oldTaskOverride) {
        int newSmallest;
        int oldSmallest;
        int taskChanges;
        if (Configuration.EMPTY.equals(oldTaskOverride) && !Configuration.EMPTY.equals(taskConfig)) {
            oldTaskOverride = record.task.extractOverrideConfig(record.mLastReportedConfiguration);
        }
        if (Configuration.EMPTY.equals(taskConfig) && !Configuration.EMPTY.equals(oldTaskOverride)) {
            taskConfig = record.task.extractOverrideConfig(record.mLastReportedConfiguration);
        }
        if (((taskChanges = oldTaskOverride.diff(taskConfig, true)) & 0x400) != 0) {
            boolean crosses;
            boolean bl = crosses = record.crossesHorizontalSizeThreshold(oldTaskOverride.screenWidthDp, taskConfig.screenWidthDp) || record.crossesVerticalSizeThreshold(oldTaskOverride.screenHeightDp, taskConfig.screenHeightDp);
            if (!crosses) {
                taskChanges &= 0xFFFFFBFF;
            }
        }
        if ((taskChanges & 0x800) != 0 && !record.crossesSmallestSizeThreshold(oldSmallest = oldTaskOverride.smallestScreenWidthDp, newSmallest = taskConfig.smallestScreenWidthDp)) {
            taskChanges &= 0xFFFFF7FF;
        }
        return taskChanges;
    }

    private static boolean isResizeOnlyChange(int change) {
        return (change & 0xFFFFF27F) == 0;
    }

    void relaunchActivityLocked(boolean andResume, boolean preserveWindow) {
        if (this.service.mSuppressResizeConfigChanges && preserveWindow) {
            this.configChangeFlags = 0;
            return;
        }
        ArrayList<ResultInfo> pendingResults = null;
        ArrayList<ReferrerIntent> pendingNewIntents = null;
        if (andResume) {
            pendingResults = this.results;
            pendingNewIntents = this.newIntents;
        }
        EventLog.writeEvent(andResume ? 30019 : 30020, this.userId, System.identityHashCode(this), this.task.taskId, this.shortComponentName);
        this.startFreezingScreenLocked(this.app, 0);
        this.mStackSupervisor.removeChildActivityContainers(this);
        try {
            this.forceNewConfig = false;
            this.mStackSupervisor.activityRelaunchingLocked(this);
            this.app.thread.scheduleRelaunchActivity(this.appToken, pendingResults, pendingNewIntents, this.configChangeFlags, !andResume, new Configuration(this.service.getGlobalConfiguration()), new Configuration(this.task.getMergedOverrideConfiguration()), preserveWindow);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        if (andResume) {
            this.results = null;
            this.newIntents = null;
            this.service.showUnsupportedZoomDialogIfNeededLocked(this);
            this.service.showAskCompatModeDialogLocked(this);
        } else {
            this.service.mHandler.removeMessages(101, this);
            this.state = ActivityStack.ActivityState.PAUSED;
            if (this.stopped) {
                this.getStack().addToStopping(this, true, false);
            }
        }
        this.configChangeFlags = 0;
        this.deferRelaunchUntilPaused = false;
        this.preserveWindowOnDeferredRelaunch = false;
    }

    boolean isProcessRunning() {
        ProcessRecord proc = this.app;
        if (proc == null) {
            proc = this.service.mProcessNames.get(this.processName, this.info.applicationInfo.uid);
        }
        return proc != null && proc.thread != null;
    }

    void saveToXml(XmlSerializer out) throws IOException, XmlPullParserException {
        out.attribute(null, ATTR_ID, String.valueOf(this.createTime));
        out.attribute(null, ATTR_LAUNCHEDFROMUID, String.valueOf(this.launchedFromUid));
        if (this.launchedFromPackage != null) {
            out.attribute(null, ATTR_LAUNCHEDFROMPACKAGE, this.launchedFromPackage);
        }
        if (this.resolvedType != null) {
            out.attribute(null, ATTR_RESOLVEDTYPE, this.resolvedType);
        }
        out.attribute(null, ATTR_COMPONENTSPECIFIED, String.valueOf(this.componentSpecified));
        out.attribute(null, ATTR_USERID, String.valueOf(this.userId));
        if (this.taskDescription != null) {
            this.taskDescription.saveToXml(out);
        }
        out.startTag(null, TAG_INTENT);
        this.intent.saveToXml(out);
        out.endTag(null, TAG_INTENT);
        if (this.isPersistable() && this.persistentState != null) {
            out.startTag(null, TAG_PERSISTABLEBUNDLE);
            this.persistentState.saveToXml(out);
            out.endTag(null, TAG_PERSISTABLEBUNDLE);
        }
    }

    static ActivityRecord restoreFromXml(XmlPullParser in, ActivityStackSupervisor stackSupervisor) throws IOException, XmlPullParserException {
        int event;
        Intent intent = null;
        PersistableBundle persistentState = null;
        int launchedFromUid = 0;
        String launchedFromPackage = null;
        String resolvedType = null;
        boolean componentSpecified = false;
        int userId = 0;
        long createTime = -1L;
        int outerDepth = in.getDepth();
        ActivityManager.TaskDescription taskDescription = new ActivityManager.TaskDescription();
        for (int attrNdx = in.getAttributeCount() - 1; attrNdx >= 0; --attrNdx) {
            String attrName = in.getAttributeName(attrNdx);
            String attrValue = in.getAttributeValue(attrNdx);
            if (ATTR_ID.equals(attrName)) {
                createTime = Long.parseLong(attrValue);
                continue;
            }
            if (ATTR_LAUNCHEDFROMUID.equals(attrName)) {
                launchedFromUid = Integer.parseInt(attrValue);
                continue;
            }
            if (ATTR_LAUNCHEDFROMPACKAGE.equals(attrName)) {
                launchedFromPackage = attrValue;
                continue;
            }
            if (ATTR_RESOLVEDTYPE.equals(attrName)) {
                resolvedType = attrValue;
                continue;
            }
            if (ATTR_COMPONENTSPECIFIED.equals(attrName)) {
                componentSpecified = Boolean.parseBoolean(attrValue);
                continue;
            }
            if (ATTR_USERID.equals(attrName)) {
                userId = Integer.parseInt(attrValue);
                continue;
            }
            if (attrName.startsWith("task_description_")) {
                taskDescription.restoreFromXml(attrName, attrValue);
                continue;
            }
            Log.d("ActivityManager", "Unknown ActivityRecord attribute=" + attrName);
        }
        while ((event = in.next()) != 1 && (event != 3 || in.getDepth() >= outerDepth)) {
            if (event != 2) continue;
            String name = in.getName();
            if (TAG_INTENT.equals(name)) {
                intent = Intent.restoreFromXml(in);
                continue;
            }
            if (TAG_PERSISTABLEBUNDLE.equals(name)) {
                persistentState = PersistableBundle.restoreFromXml(in);
                continue;
            }
            Slog.w("ActivityManager", "restoreActivity: unexpected name=" + name);
            XmlUtils.skipCurrentTag(in);
        }
        if (intent == null) {
            throw new XmlPullParserException("restoreActivity error intent=" + intent);
        }
        ActivityManagerService service = stackSupervisor.mService;
        ActivityInfo aInfo = stackSupervisor.resolveActivity(intent, resolvedType, 0, null, userId);
        if (aInfo == null) {
            throw new XmlPullParserException("restoreActivity resolver error. Intent=" + intent + " resolvedType=" + resolvedType);
        }
        ActivityRecord r = new ActivityRecord(service, null, 0, launchedFromUid, launchedFromPackage, intent, resolvedType, aInfo, service.getConfiguration(), null, null, 0, componentSpecified, false, stackSupervisor, null, null, null);
        r.persistentState = persistentState;
        r.taskDescription = taskDescription;
        r.createTime = createTime;
        return r;
    }

    private static String activityTypeToString(int type) {
        switch (type) {
            case 0: {
                return "APPLICATION_ACTIVITY_TYPE";
            }
            case 1: {
                return "HOME_ACTIVITY_TYPE";
            }
            case 2: {
                return "RECENTS_ACTIVITY_TYPE";
            }
            case 3: {
                return "ASSISTANT_ACTIVITY_TYPE";
            }
        }
        return Integer.toString(type);
    }

    private static boolean isInVrUiMode(Configuration config) {
        return (config.uiMode & 0xF) == 7;
    }

    public String toString() {
        if (this.stringName != null) {
            return this.stringName + " t" + (this.task == null ? -1 : this.task.taskId) + (this.finishing ? " f}" : "}");
        }
        StringBuilder sb = new StringBuilder(128);
        sb.append("ActivityRecord{");
        sb.append(Integer.toHexString(System.identityHashCode(this)));
        sb.append(" u");
        sb.append(this.userId);
        sb.append(' ');
        sb.append(this.intent.getComponent().flattenToShortString());
        this.stringName = sb.toString();
        return this.toString();
    }

    static class Token
    extends IApplicationToken.Stub {
        private final WeakReference<ActivityRecord> weakActivity;

        Token(ActivityRecord activity) {
            this.weakActivity = new WeakReference<ActivityRecord>(activity);
        }

        private static ActivityRecord tokenToActivityRecordLocked(Token token) {
            if (token == null) {
                return null;
            }
            ActivityRecord r = (ActivityRecord)token.weakActivity.get();
            if (r == null || r.getStack() == null) {
                return null;
            }
            return r;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(128);
            sb.append("Token{");
            sb.append(Integer.toHexString(System.identityHashCode(this)));
            sb.append(' ');
            sb.append(this.weakActivity.get());
            sb.append('}');
            return sb.toString();
        }
    }
}

