/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.text.BidiFormatter;
import android.util.Slog;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.TextView;
import com.android.internal.logging.MetricsLogger;
import com.android.server.am.ActivityManagerService;
import com.android.server.am.ActivityRecord;
import com.android.server.am.BaseErrorDialog;
import com.android.server.am.ProcessRecord;

final class AppNotRespondingDialog
extends BaseErrorDialog
implements View.OnClickListener {
    private static final String TAG = "AppNotRespondingDialog";
    static final int FORCE_CLOSE = 1;
    static final int WAIT = 2;
    static final int WAIT_AND_REPORT = 3;
    public static final int CANT_SHOW = -1;
    public static final int ALREADY_SHOWING = -2;
    private final ActivityManagerService mService;
    private final ProcessRecord mProc;
    private final Handler mHandler = new Handler(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message msg) {
            Intent appErrorIntent = null;
            MetricsLogger.action(AppNotRespondingDialog.this.getContext(), 317, msg.what);
            switch (msg.what) {
                case 1: {
                    AppNotRespondingDialog.this.mService.killAppAtUsersRequest(AppNotRespondingDialog.this.mProc, AppNotRespondingDialog.this);
                    break;
                }
                case 2: 
                case 3: {
                    ActivityManagerService activityManagerService = AppNotRespondingDialog.this.mService;
                    synchronized (activityManagerService) {
                        ProcessRecord app = AppNotRespondingDialog.this.mProc;
                        if (msg.what == 3) {
                            appErrorIntent = ((AppNotRespondingDialog)AppNotRespondingDialog.this).mService.mAppErrors.createAppErrorIntentLocked(app, System.currentTimeMillis(), null);
                        }
                        app.notResponding = false;
                        app.notRespondingReport = null;
                        if (app.anrDialog == AppNotRespondingDialog.this) {
                            app.anrDialog = null;
                        }
                        ((AppNotRespondingDialog)AppNotRespondingDialog.this).mService.mServices.scheduleServiceTimeoutLocked(app);
                        break;
                    }
                }
            }
            if (appErrorIntent != null) {
                try {
                    AppNotRespondingDialog.this.getContext().startActivity(appErrorIntent);
                }
                catch (ActivityNotFoundException e) {
                    Slog.w(AppNotRespondingDialog.TAG, "bug report receiver dissappeared", e);
                }
            }
            AppNotRespondingDialog.this.dismiss();
        }
    };

    public AppNotRespondingDialog(ActivityManagerService service, Context context, ProcessRecord app, ActivityRecord activity, boolean aboveSystem) {
        super(context);
        int resid;
        this.mService = service;
        this.mProc = app;
        Resources res = context.getResources();
        this.setCancelable(false);
        CharSequence name1 = activity != null ? activity.info.loadLabel(context.getPackageManager()) : null;
        CharSequence name2 = null;
        if (app.pkgList.size() == 1 && (name2 = context.getPackageManager().getApplicationLabel(app.info)) != null) {
            if (name1 != null) {
                resid = 17039471;
            } else {
                name1 = name2;
                name2 = app.processName;
                resid = 17039473;
            }
        } else if (name1 != null) {
            name2 = app.processName;
            resid = 17039472;
        } else {
            name1 = app.processName;
            resid = 17039474;
        }
        BidiFormatter bidi = BidiFormatter.getInstance();
        this.setTitle(name2 != null ? res.getString(resid, bidi.unicodeWrap(name1.toString()), bidi.unicodeWrap(name2.toString())) : res.getString(resid, bidi.unicodeWrap(name1.toString())));
        if (aboveSystem) {
            this.getWindow().setType(2010);
        }
        WindowManager.LayoutParams attrs = this.getWindow().getAttributes();
        attrs.setTitle("Application Not Responding: " + app.info.processName);
        attrs.privateFlags = 272;
        this.getWindow().setAttributes(attrs);
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        FrameLayout frame = (FrameLayout)this.findViewById(16908331);
        Context context = this.getContext();
        LayoutInflater.from(context).inflate(17367090, (ViewGroup)frame, true);
        TextView report = (TextView)this.findViewById(16908685);
        report.setOnClickListener(this);
        boolean hasReceiver = this.mProc.errorReportReceiver != null;
        report.setVisibility(hasReceiver ? 0 : 8);
        TextView close = (TextView)this.findViewById(16908683);
        close.setOnClickListener(this);
        TextView wait = (TextView)this.findViewById(16908687);
        wait.setOnClickListener(this);
        this.findViewById(16908796).setVisibility(0);
    }

    @Override
    public void onClick(View v) {
        switch (v.getId()) {
            case 16908685: {
                this.mHandler.obtainMessage(3).sendToTarget();
                break;
            }
            case 16908683: {
                this.mHandler.obtainMessage(1).sendToTarget();
                break;
            }
            case 16908687: {
                this.mHandler.obtainMessage(2).sendToTarget();
                break;
            }
        }
    }
}

