/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.app.ActivityManager;
import android.app.AppGlobals;
import android.app.AppOpsManager;
import android.app.BroadcastOptions;
import android.content.ComponentName;
import android.content.IIntentReceiver;
import android.content.IIntentSender;
import android.content.Intent;
import android.content.IntentSender;
import android.content.pm.ActivityInfo;
import android.content.pm.ResolveInfo;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.UserHandle;
import android.util.EventLog;
import android.util.Slog;
import android.util.SparseArray;
import android.util.TimeUtils;
import com.android.server.DeviceIdleController;
import com.android.server.am.ActivityManagerService;
import com.android.server.am.BroadcastFilter;
import com.android.server.am.BroadcastRecord;
import com.android.server.am.ProcessRecord;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Set;

public final class BroadcastQueue {
    private static final String TAG = "BroadcastQueue";
    private static final String TAG_MU = "BroadcastQueue_MU";
    private static final String TAG_BROADCAST = "BroadcastQueue";
    static final int MAX_BROADCAST_HISTORY = ActivityManager.isLowRamDeviceStatic() ? 10 : 50;
    static final int MAX_BROADCAST_SUMMARY_HISTORY = ActivityManager.isLowRamDeviceStatic() ? 25 : 300;
    final ActivityManagerService mService;
    final String mQueueName;
    final long mTimeoutPeriod;
    final boolean mDelayBehindServices;
    final ArrayList<BroadcastRecord> mParallelBroadcasts = new ArrayList();
    final ArrayList<BroadcastRecord> mOrderedBroadcasts = new ArrayList();
    final BroadcastRecord[] mBroadcastHistory = new BroadcastRecord[MAX_BROADCAST_HISTORY];
    int mHistoryNext = 0;
    final Intent[] mBroadcastSummaryHistory = new Intent[MAX_BROADCAST_SUMMARY_HISTORY];
    int mSummaryHistoryNext = 0;
    final long[] mSummaryHistoryEnqueueTime = new long[MAX_BROADCAST_SUMMARY_HISTORY];
    final long[] mSummaryHistoryDispatchTime = new long[MAX_BROADCAST_SUMMARY_HISTORY];
    final long[] mSummaryHistoryFinishTime = new long[MAX_BROADCAST_SUMMARY_HISTORY];
    boolean mBroadcastsScheduled = false;
    boolean mPendingBroadcastTimeoutMessage;
    BroadcastRecord mPendingBroadcast = null;
    int mPendingBroadcastRecvIndex;
    static final int BROADCAST_INTENT_MSG = 200;
    static final int BROADCAST_TIMEOUT_MSG = 201;
    static final int SCHEDULE_TEMP_WHITELIST_MSG = 202;
    final BroadcastHandler mHandler;

    BroadcastQueue(ActivityManagerService service, Handler handler, String name, long timeoutPeriod, boolean allowDelayBehindServices) {
        this.mService = service;
        this.mHandler = new BroadcastHandler(handler.getLooper());
        this.mQueueName = name;
        this.mTimeoutPeriod = timeoutPeriod;
        this.mDelayBehindServices = allowDelayBehindServices;
    }

    public boolean isPendingBroadcastProcessLocked(int pid) {
        return this.mPendingBroadcast != null && this.mPendingBroadcast.curApp.pid == pid;
    }

    public void enqueueParallelBroadcastLocked(BroadcastRecord r) {
        this.mParallelBroadcasts.add(r);
        r.enqueueClockTime = System.currentTimeMillis();
    }

    public void enqueueOrderedBroadcastLocked(BroadcastRecord r) {
        this.mOrderedBroadcasts.add(r);
        r.enqueueClockTime = System.currentTimeMillis();
    }

    public final boolean replaceParallelBroadcastLocked(BroadcastRecord r) {
        Intent intent = r.intent;
        for (int i = this.mParallelBroadcasts.size() - 1; i >= 0; --i) {
            Intent curIntent = this.mParallelBroadcasts.get((int)i).intent;
            if (!intent.filterEquals(curIntent)) continue;
            this.mParallelBroadcasts.set(i, r);
            return true;
        }
        return false;
    }

    public final boolean replaceOrderedBroadcastLocked(BroadcastRecord r) {
        Intent intent = r.intent;
        for (int i = this.mOrderedBroadcasts.size() - 1; i > 0; --i) {
            if (!intent.filterEquals(this.mOrderedBroadcasts.get((int)i).intent)) continue;
            this.mOrderedBroadcasts.set(i, r);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void processCurBroadcastLocked(BroadcastRecord r, ProcessRecord app) throws RemoteException {
        if (app.thread == null) {
            throw new RemoteException();
        }
        if (app.inFullBackup) {
            this.skipReceiverLocked(r);
            return;
        }
        r.receiver = app.thread.asBinder();
        r.curApp = app;
        app.curReceivers.add(r);
        app.forceProcessStateUpTo(11);
        this.mService.updateLruProcessLocked(app, false, null);
        this.mService.updateOomAdjLocked();
        r.intent.setComponent(r.curComponent);
        boolean started = false;
        try {
            this.mService.notifyPackageUse(r.intent.getComponent().getPackageName(), 3);
            app.thread.scheduleReceiver(new Intent(r.intent), r.curReceiver, this.mService.compatibilityInfoForPackageLocked(r.curReceiver.applicationInfo), r.resultCode, r.resultData, r.resultExtras, r.ordered, r.userId, app.repProcState);
            started = true;
        }
        finally {
            if (!started) {
                r.receiver = null;
                r.curApp = null;
                app.curReceivers.remove(r);
            }
        }
    }

    public boolean sendPendingBroadcastsLocked(ProcessRecord app) {
        boolean didSomething = false;
        BroadcastRecord br = this.mPendingBroadcast;
        if (br != null && br.curApp.pid == app.pid) {
            if (br.curApp != app) {
                Slog.e("BroadcastQueue", "App mismatch when sending pending broadcast to " + app.processName + ", intended target is " + br.curApp.processName);
                return false;
            }
            try {
                this.mPendingBroadcast = null;
                this.processCurBroadcastLocked(br, app);
                didSomething = true;
            }
            catch (Exception e) {
                Slog.w("BroadcastQueue", "Exception in new application when starting receiver " + br.curComponent.flattenToShortString(), e);
                this.logBroadcastReceiverDiscardLocked(br);
                this.finishReceiverLocked(br, br.resultCode, br.resultData, br.resultExtras, br.resultAbort, false);
                this.scheduleBroadcastsLocked();
                br.state = 0;
                throw new RuntimeException(e.getMessage());
            }
        }
        return didSomething;
    }

    public void skipPendingBroadcastLocked(int pid) {
        BroadcastRecord br = this.mPendingBroadcast;
        if (br != null && br.curApp.pid == pid) {
            br.state = 0;
            br.nextReceiver = this.mPendingBroadcastRecvIndex;
            this.mPendingBroadcast = null;
            this.scheduleBroadcastsLocked();
        }
    }

    public void skipCurrentReceiverLocked(ProcessRecord app) {
        BroadcastRecord r = null;
        if (this.mOrderedBroadcasts.size() > 0) {
            BroadcastRecord br = this.mOrderedBroadcasts.get(0);
            if (br.curApp == app) {
                r = br;
            }
        }
        if (r == null && this.mPendingBroadcast != null && this.mPendingBroadcast.curApp == app) {
            r = this.mPendingBroadcast;
        }
        if (r != null) {
            this.skipReceiverLocked(r);
        }
    }

    private void skipReceiverLocked(BroadcastRecord r) {
        this.logBroadcastReceiverDiscardLocked(r);
        this.finishReceiverLocked(r, r.resultCode, r.resultData, r.resultExtras, r.resultAbort, false);
        this.scheduleBroadcastsLocked();
    }

    public void scheduleBroadcastsLocked() {
        if (this.mBroadcastsScheduled) {
            return;
        }
        this.mHandler.sendMessage(this.mHandler.obtainMessage(200, this));
        this.mBroadcastsScheduled = true;
    }

    public BroadcastRecord getMatchingOrderedReceiver(IBinder receiver) {
        BroadcastRecord r;
        if (this.mOrderedBroadcasts.size() > 0 && (r = this.mOrderedBroadcasts.get(0)) != null && r.receiver == receiver) {
            return r;
        }
        return null;
    }

    public boolean finishReceiverLocked(BroadcastRecord r, int resultCode, String resultData, Bundle resultExtras, boolean resultAbort, boolean waitForServices) {
        int state = r.state;
        ActivityInfo receiver = r.curReceiver;
        r.state = 0;
        if (state == 0) {
            Slog.w("BroadcastQueue", "finishReceiver [" + this.mQueueName + "] called but state is IDLE");
        }
        r.receiver = null;
        r.intent.setComponent(null);
        if (r.curApp != null && r.curApp.curReceivers.contains(r)) {
            r.curApp.curReceivers.remove(r);
        }
        if (r.curFilter != null) {
            r.curFilter.receiverList.curBroadcast = null;
        }
        r.curFilter = null;
        r.curReceiver = null;
        r.curApp = null;
        this.mPendingBroadcast = null;
        r.resultCode = resultCode;
        r.resultData = resultData;
        r.resultExtras = resultExtras;
        r.resultAbort = resultAbort && (r.intent.getFlags() & 0x8000000) == 0 ? resultAbort : false;
        if (waitForServices && r.curComponent != null && r.queue.mDelayBehindServices && r.queue.mOrderedBroadcasts.size() > 0 && r.queue.mOrderedBroadcasts.get(0) == r) {
            Object obj;
            ActivityInfo nextReceiver = r.nextReceiver < r.receivers.size() ? ((obj = r.receivers.get(r.nextReceiver)) instanceof ActivityInfo ? (ActivityInfo)obj : null) : null;
            if ((receiver == null || nextReceiver == null || receiver.applicationInfo.uid != nextReceiver.applicationInfo.uid || !receiver.processName.equals(nextReceiver.processName)) && this.mService.mServices.hasBackgroundServicesLocked(r.userId)) {
                Slog.i("BroadcastQueue", "Delay finish: " + r.curComponent.flattenToShortString());
                r.state = 4;
                return false;
            }
        }
        r.curComponent = null;
        return state == 1 || state == 3;
    }

    public void backgroundServicesFinishedLocked(int userId) {
        if (this.mOrderedBroadcasts.size() > 0) {
            BroadcastRecord br = this.mOrderedBroadcasts.get(0);
            if (br.userId == userId && br.state == 4) {
                Slog.i("BroadcastQueue", "Resuming delayed broadcast");
                br.curComponent = null;
                br.state = 0;
                this.processNextBroadcast(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void performReceiveLocked(ProcessRecord app, IIntentReceiver receiver, Intent intent, int resultCode, String data, Bundle extras, boolean ordered, boolean sticky, int sendingUser) throws RemoteException {
        if (app != null) {
            if (app.thread != null) {
                try {
                    app.thread.scheduleRegisteredReceiver(receiver, intent, resultCode, data, extras, ordered, sticky, sendingUser, app.repProcState);
                }
                catch (RemoteException ex) {
                    ActivityManagerService activityManagerService = this.mService;
                    synchronized (activityManagerService) {
                        Slog.w("BroadcastQueue", "Can't deliver broadcast to " + app.processName + " (pid " + app.pid + "). Crashing it.");
                        app.scheduleCrash("can't deliver broadcast");
                    }
                    throw ex;
                }
            }
            throw new RemoteException("app.thread must not be null");
        }
        receiver.performReceive(intent, resultCode, data, extras, ordered, sticky, sendingUser);
    }

    private void deliverToRegisteredReceiverLocked(BroadcastRecord r, BroadcastFilter filter, boolean ordered, int index) {
        block21: {
            int perm;
            boolean skip = false;
            if (filter.requiredPermission != null) {
                perm = this.mService.checkComponentPermission(filter.requiredPermission, r.callingPid, r.callingUid, -1, true);
                if (perm != 0) {
                    Slog.w("BroadcastQueue", "Permission Denial: broadcasting " + r.intent.toString() + " from " + r.callerPackage + " (pid=" + r.callingPid + ", uid=" + r.callingUid + ")" + " requires " + filter.requiredPermission + " due to registered receiver " + filter);
                    skip = true;
                } else {
                    int opCode = AppOpsManager.permissionToOpCode(filter.requiredPermission);
                    if (opCode != -1 && this.mService.mAppOpsService.noteOperation(opCode, r.callingUid, r.callerPackage) != 0) {
                        Slog.w("BroadcastQueue", "Appop Denial: broadcasting " + r.intent.toString() + " from " + r.callerPackage + " (pid=" + r.callingPid + ", uid=" + r.callingUid + ")" + " requires appop " + AppOpsManager.permissionToOp(filter.requiredPermission) + " due to registered receiver " + filter);
                        skip = true;
                    }
                }
            }
            if (!skip && r.requiredPermissions != null && r.requiredPermissions.length > 0) {
                for (int i = 0; i < r.requiredPermissions.length; ++i) {
                    String requiredPermission = r.requiredPermissions[i];
                    int perm2 = this.mService.checkComponentPermission(requiredPermission, filter.receiverList.pid, filter.receiverList.uid, -1, true);
                    if (perm2 != 0) {
                        Slog.w("BroadcastQueue", "Permission Denial: receiving " + r.intent.toString() + " to " + filter.receiverList.app + " (pid=" + filter.receiverList.pid + ", uid=" + filter.receiverList.uid + ")" + " requires " + requiredPermission + " due to sender " + r.callerPackage + " (uid " + r.callingUid + ")");
                        skip = true;
                        break;
                    }
                    int appOp = AppOpsManager.permissionToOpCode(requiredPermission);
                    if (appOp == -1 || appOp == r.appOp || this.mService.mAppOpsService.noteOperation(appOp, filter.receiverList.uid, filter.packageName) == 0) continue;
                    Slog.w("BroadcastQueue", "Appop Denial: receiving " + r.intent.toString() + " to " + filter.receiverList.app + " (pid=" + filter.receiverList.pid + ", uid=" + filter.receiverList.uid + ")" + " requires appop " + AppOpsManager.permissionToOp(requiredPermission) + " due to sender " + r.callerPackage + " (uid " + r.callingUid + ")");
                    skip = true;
                    break;
                }
            }
            if (!(skip || r.requiredPermissions != null && r.requiredPermissions.length != 0 || (perm = this.mService.checkComponentPermission(null, filter.receiverList.pid, filter.receiverList.uid, -1, true)) == 0)) {
                Slog.w("BroadcastQueue", "Permission Denial: security check failed when receiving " + r.intent.toString() + " to " + filter.receiverList.app + " (pid=" + filter.receiverList.pid + ", uid=" + filter.receiverList.uid + ")" + " due to sender " + r.callerPackage + " (uid " + r.callingUid + ")");
                skip = true;
            }
            if (!skip && r.appOp != -1 && this.mService.mAppOpsService.noteOperation(r.appOp, filter.receiverList.uid, filter.packageName) != 0) {
                Slog.w("BroadcastQueue", "Appop Denial: receiving " + r.intent.toString() + " to " + filter.receiverList.app + " (pid=" + filter.receiverList.pid + ", uid=" + filter.receiverList.uid + ")" + " requires appop " + AppOpsManager.opToName(r.appOp) + " due to sender " + r.callerPackage + " (uid " + r.callingUid + ")");
                skip = true;
            }
            if (!this.mService.mIntentFirewall.checkBroadcast(r.intent, r.callingUid, r.callingPid, r.resolvedType, filter.receiverList.uid)) {
                skip = true;
            }
            if (!skip && (filter.receiverList.app == null || filter.receiverList.app.crashing)) {
                Slog.w("BroadcastQueue", "Skipping deliver [" + this.mQueueName + "] " + r + " to " + filter.receiverList + ": process crashing");
                skip = true;
            }
            if (skip) {
                r.delivery[index] = 2;
                return;
            }
            if (this.mService.mPermissionReviewRequired && !this.requestStartTargetPermissionsReviewIfNeededLocked(r, filter.packageName, filter.owningUserId)) {
                r.delivery[index] = 2;
                return;
            }
            r.delivery[index] = 1;
            if (ordered) {
                r.receiver = filter.receiverList.receiver.asBinder();
                r.curFilter = filter;
                filter.receiverList.curBroadcast = r;
                r.state = 2;
                if (filter.receiverList.app != null) {
                    r.curApp = filter.receiverList.app;
                    filter.receiverList.app.curReceivers.add(r);
                    this.mService.updateOomAdjLocked(r.curApp);
                }
            }
            try {
                if (filter.receiverList.app != null && filter.receiverList.app.inFullBackup) {
                    if (ordered) {
                        this.skipReceiverLocked(r);
                    }
                } else {
                    this.performReceiveLocked(filter.receiverList.app, filter.receiverList.receiver, new Intent(r.intent), r.resultCode, r.resultData, r.resultExtras, r.ordered, r.initialSticky, r.userId);
                }
                if (ordered) {
                    r.state = 3;
                }
            }
            catch (RemoteException e) {
                Slog.w("BroadcastQueue", "Failure sending broadcast " + r.intent, e);
                if (!ordered) break block21;
                r.receiver = null;
                r.curFilter = null;
                filter.receiverList.curBroadcast = null;
                if (filter.receiverList.app == null) break block21;
                filter.receiverList.app.curReceivers.remove(r);
            }
        }
    }

    private boolean requestStartTargetPermissionsReviewIfNeededLocked(BroadcastRecord receiverRecord, String receivingPackageName, final int receivingUserId) {
        boolean callerForeground;
        if (!this.mService.getPackageManagerInternalLocked().isPermissionsReviewRequired(receivingPackageName, receivingUserId)) {
            return true;
        }
        boolean bl = receiverRecord.callerApp != null ? receiverRecord.callerApp.setSchedGroup != 0 : (callerForeground = true);
        if (callerForeground && receiverRecord.intent.getComponent() != null) {
            IIntentSender target = this.mService.getIntentSenderLocked(1, receiverRecord.callerPackage, receiverRecord.callingUid, receiverRecord.userId, null, null, 0, new Intent[]{receiverRecord.intent}, new String[]{receiverRecord.intent.resolveType(this.mService.mContext.getContentResolver())}, 0x54000000, null);
            final Intent intent = new Intent("android.intent.action.REVIEW_PERMISSIONS");
            intent.addFlags(0x10800000);
            intent.putExtra("android.intent.extra.PACKAGE_NAME", receivingPackageName);
            intent.putExtra("android.intent.extra.INTENT", new IntentSender(target));
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    BroadcastQueue.this.mService.mContext.startActivityAsUser(intent, new UserHandle(receivingUserId));
                }
            });
        } else {
            Slog.w("BroadcastQueue", "u" + receivingUserId + " Receiving a broadcast in package" + receivingPackageName + " requires a permissions review");
        }
        return false;
    }

    final void scheduleTempWhitelistLocked(int uid, long duration, BroadcastRecord r) {
        if (duration > Integer.MAX_VALUE) {
            duration = Integer.MAX_VALUE;
        }
        StringBuilder b = new StringBuilder();
        b.append("broadcast:");
        UserHandle.formatUid(b, r.callingUid);
        b.append(":");
        if (r.intent.getAction() != null) {
            b.append(r.intent.getAction());
        } else if (r.intent.getComponent() != null) {
            b.append(r.intent.getComponent().flattenToShortString());
        } else if (r.intent.getData() != null) {
            b.append(r.intent.getData());
        }
        this.mHandler.obtainMessage(202, uid, (int)duration, b.toString()).sendToTarget();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void processNextBroadcast(boolean fromMsg) {
        ActivityManagerService activityManagerService = this.mService;
        synchronized (activityManagerService) {
            int allowed22;
            int opCode;
            BroadcastRecord r;
            this.mService.updateCpuStats();
            if (fromMsg) {
                this.mBroadcastsScheduled = false;
            }
            while (this.mParallelBroadcasts.size() > 0) {
                r = this.mParallelBroadcasts.remove(0);
                r.dispatchTime = SystemClock.uptimeMillis();
                r.dispatchClockTime = System.currentTimeMillis();
                int N = r.receivers.size();
                for (int i = 0; i < N; ++i) {
                    Object target = r.receivers.get(i);
                    this.deliverToRegisteredReceiverLocked(r, (BroadcastFilter)target, false, i);
                }
                this.addBroadcastToHistoryLocked(r);
            }
            if (this.mPendingBroadcast != null) {
                boolean isDead;
                SparseArray<ProcessRecord> i = this.mService.mPidsSelfLocked;
                synchronized (i) {
                    ProcessRecord proc = this.mService.mPidsSelfLocked.get(this.mPendingBroadcast.curApp.pid);
                    isDead = proc == null || proc.crashing;
                }
                if (!isDead) {
                    return;
                }
                Slog.w("BroadcastQueue", "pending app  [" + this.mQueueName + "]" + this.mPendingBroadcast.curApp + " died before responding to broadcast");
                this.mPendingBroadcast.state = 0;
                this.mPendingBroadcast.nextReceiver = this.mPendingBroadcastRecvIndex;
                this.mPendingBroadcast = null;
            }
            boolean looped = false;
            do {
                int numReceivers;
                if (this.mOrderedBroadcasts.size() == 0) {
                    this.mService.scheduleAppGcsLocked();
                    if (looped) {
                        this.mService.updateOomAdjLocked();
                    }
                    return;
                }
                r = this.mOrderedBroadcasts.get(0);
                boolean forceReceive = false;
                int n = numReceivers = r.receivers != null ? r.receivers.size() : 0;
                if (this.mService.mProcessesReady && r.dispatchTime > 0L) {
                    long now = SystemClock.uptimeMillis();
                    if (numReceivers > 0 && now > r.dispatchTime + 2L * this.mTimeoutPeriod * (long)numReceivers) {
                        Slog.w("BroadcastQueue", "Hung broadcast [" + this.mQueueName + "] discarded after timeout failure:" + " now=" + now + " dispatchTime=" + r.dispatchTime + " startTime=" + r.receiverTime + " intent=" + r.intent + " numReceivers=" + numReceivers + " nextReceiver=" + r.nextReceiver + " state=" + r.state);
                        this.broadcastTimeoutLocked(false);
                        forceReceive = true;
                        r.state = 0;
                    }
                }
                if (r.state != 0) {
                    return;
                }
                if (r.receivers != null && r.nextReceiver < numReceivers && !r.resultAbort && !forceReceive) continue;
                if (r.resultTo != null) {
                    try {
                        this.performReceiveLocked(r.callerApp, r.resultTo, new Intent(r.intent), r.resultCode, r.resultData, r.resultExtras, false, false, r.userId);
                        r.resultTo = null;
                    }
                    catch (RemoteException e) {
                        r.resultTo = null;
                        Slog.w("BroadcastQueue", "Failure [" + this.mQueueName + "] sending broadcast result of " + r.intent, e);
                    }
                }
                this.cancelBroadcastTimeoutLocked();
                this.addBroadcastToHistoryLocked(r);
                if (r.intent.getComponent() == null && r.intent.getPackage() == null && (r.intent.getFlags() & 0x40000000) == 0) {
                    this.mService.addBroadcastStatLocked(r.intent.getAction(), r.callerPackage, r.manifestCount, r.manifestSkipCount, r.finishTime - r.dispatchTime);
                }
                this.mOrderedBroadcasts.remove(0);
                r = null;
                looped = true;
            } while (r == null);
            int recIdx = r.nextReceiver++;
            r.receiverTime = SystemClock.uptimeMillis();
            if (recIdx == 0) {
                r.dispatchTime = r.receiverTime;
                r.dispatchClockTime = System.currentTimeMillis();
            }
            if (!this.mPendingBroadcastTimeoutMessage) {
                long timeoutTime = r.receiverTime + this.mTimeoutPeriod;
                this.setBroadcastTimeoutLocked(timeoutTime);
            }
            BroadcastOptions brOptions = r.options;
            Object nextReceiver = r.receivers.get(recIdx);
            if (nextReceiver instanceof BroadcastFilter) {
                BroadcastFilter filter = (BroadcastFilter)nextReceiver;
                this.deliverToRegisteredReceiverLocked(r, filter, r.ordered, recIdx);
                if (r.receiver == null || !r.ordered) {
                    r.state = 0;
                    this.scheduleBroadcastsLocked();
                } else if (brOptions != null && brOptions.getTemporaryAppWhitelistDuration() > 0L) {
                    this.scheduleTempWhitelistLocked(filter.owningUid, brOptions.getTemporaryAppWhitelistDuration(), r);
                }
                return;
            }
            ResolveInfo info = (ResolveInfo)nextReceiver;
            ComponentName component = new ComponentName(info.activityInfo.applicationInfo.packageName, info.activityInfo.name);
            boolean skip = false;
            if (brOptions != null && (info.activityInfo.applicationInfo.targetSdkVersion < brOptions.getMinManifestReceiverApiLevel() || info.activityInfo.applicationInfo.targetSdkVersion > brOptions.getMaxManifestReceiverApiLevel())) {
                skip = true;
            }
            int perm = this.mService.checkComponentPermission(info.activityInfo.permission, r.callingPid, r.callingUid, info.activityInfo.applicationInfo.uid, info.activityInfo.exported);
            if (!skip && perm != 0) {
                if (!info.activityInfo.exported) {
                    Slog.w("BroadcastQueue", "Permission Denial: broadcasting " + r.intent.toString() + " from " + r.callerPackage + " (pid=" + r.callingPid + ", uid=" + r.callingUid + ")" + " is not exported from uid " + info.activityInfo.applicationInfo.uid + " due to receiver " + component.flattenToShortString());
                } else {
                    Slog.w("BroadcastQueue", "Permission Denial: broadcasting " + r.intent.toString() + " from " + r.callerPackage + " (pid=" + r.callingPid + ", uid=" + r.callingUid + ")" + " requires " + info.activityInfo.permission + " due to receiver " + component.flattenToShortString());
                }
                skip = true;
            } else if (!skip && info.activityInfo.permission != null && (opCode = AppOpsManager.permissionToOpCode(info.activityInfo.permission)) != -1 && this.mService.mAppOpsService.noteOperation(opCode, r.callingUid, r.callerPackage) != 0) {
                Slog.w("BroadcastQueue", "Appop Denial: broadcasting " + r.intent.toString() + " from " + r.callerPackage + " (pid=" + r.callingPid + ", uid=" + r.callingUid + ")" + " requires appop " + AppOpsManager.permissionToOp(info.activityInfo.permission) + " due to registered receiver " + component.flattenToShortString());
                skip = true;
            }
            if (!skip && info.activityInfo.applicationInfo.uid != 1000 && r.requiredPermissions != null && r.requiredPermissions.length > 0) {
                for (int i = 0; i < r.requiredPermissions.length; ++i) {
                    String requiredPermission = r.requiredPermissions[i];
                    try {
                        perm = AppGlobals.getPackageManager().checkPermission(requiredPermission, info.activityInfo.applicationInfo.packageName, UserHandle.getUserId(info.activityInfo.applicationInfo.uid));
                    }
                    catch (RemoteException e) {
                        perm = -1;
                    }
                    if (perm != 0) {
                        Slog.w("BroadcastQueue", "Permission Denial: receiving " + r.intent + " to " + component.flattenToShortString() + " requires " + requiredPermission + " due to sender " + r.callerPackage + " (uid " + r.callingUid + ")");
                        skip = true;
                        break;
                    }
                    int appOp = AppOpsManager.permissionToOpCode(requiredPermission);
                    if (appOp == -1 || appOp == r.appOp || this.mService.mAppOpsService.noteOperation(appOp, info.activityInfo.applicationInfo.uid, info.activityInfo.packageName) == 0) continue;
                    Slog.w("BroadcastQueue", "Appop Denial: receiving " + r.intent + " to " + component.flattenToShortString() + " requires appop " + AppOpsManager.permissionToOp(requiredPermission) + " due to sender " + r.callerPackage + " (uid " + r.callingUid + ")");
                    skip = true;
                    break;
                }
            }
            if (!skip && r.appOp != -1 && this.mService.mAppOpsService.noteOperation(r.appOp, info.activityInfo.applicationInfo.uid, info.activityInfo.packageName) != 0) {
                Slog.w("BroadcastQueue", "Appop Denial: receiving " + r.intent + " to " + component.flattenToShortString() + " requires appop " + AppOpsManager.opToName(r.appOp) + " due to sender " + r.callerPackage + " (uid " + r.callingUid + ")");
                skip = true;
            }
            if (!skip) {
                skip = !this.mService.mIntentFirewall.checkBroadcast(r.intent, r.callingUid, r.callingPid, r.resolvedType, info.activityInfo.applicationInfo.uid);
            }
            boolean isSingleton = false;
            try {
                isSingleton = this.mService.isSingleton(info.activityInfo.processName, info.activityInfo.applicationInfo, info.activityInfo.name, info.activityInfo.flags);
            }
            catch (SecurityException e) {
                Slog.w("BroadcastQueue", e.getMessage());
                skip = true;
            }
            if ((info.activityInfo.flags & 0x40000000) != 0 && ActivityManager.checkUidPermission("android.permission.INTERACT_ACROSS_USERS", info.activityInfo.applicationInfo.uid) != 0) {
                Slog.w("BroadcastQueue", "Permission Denial: Receiver " + component.flattenToShortString() + " requests FLAG_SINGLE_USER, but app does not hold " + "android.permission.INTERACT_ACROSS_USERS");
                skip = true;
            }
            if (!skip) {
                ++r.manifestCount;
            } else {
                ++r.manifestSkipCount;
            }
            if (r.curApp != null && r.curApp.crashing) {
                Slog.w("BroadcastQueue", "Skipping deliver ordered [" + this.mQueueName + "] " + r + " to " + r.curApp + ": process crashing");
                skip = true;
            }
            if (!skip) {
                boolean isAvailable = false;
                try {
                    isAvailable = AppGlobals.getPackageManager().isPackageAvailable(info.activityInfo.packageName, UserHandle.getUserId(info.activityInfo.applicationInfo.uid));
                }
                catch (Exception e) {
                    Slog.w("BroadcastQueue", "Exception getting recipient info for " + info.activityInfo.packageName, e);
                }
                if (!isAvailable) {
                    skip = true;
                }
            }
            if (this.mService.mPermissionReviewRequired && !skip && !this.requestStartTargetPermissionsReviewIfNeededLocked(r, info.activityInfo.packageName, UserHandle.getUserId(info.activityInfo.applicationInfo.uid))) {
                skip = true;
            }
            int receiverUid = info.activityInfo.applicationInfo.uid;
            if (r.callingUid != 1000 && isSingleton && this.mService.isValidSingletonCall(r.callingUid, receiverUid)) {
                info.activityInfo = this.mService.getActivityInfoForUser(info.activityInfo, 0);
            }
            String targetProcess = info.activityInfo.processName;
            ProcessRecord app = this.mService.getProcessRecordLocked(targetProcess, info.activityInfo.applicationInfo.uid, false);
            if (!skip && (allowed22 = this.mService.getAppStartModeLocked(info.activityInfo.applicationInfo.uid, info.activityInfo.packageName, info.activityInfo.applicationInfo.targetSdkVersion, -1, true, false)) != 0) {
                if (allowed22 == 3) {
                    Slog.w("BroadcastQueue", "Background execution disabled: receiving " + r.intent + " to " + component.flattenToShortString());
                    skip = true;
                } else if ((r.intent.getFlags() & 0x800000) != 0 || r.intent.getComponent() == null && r.intent.getPackage() == null && (r.intent.getFlags() & 0x1000000) == 0) {
                    Slog.w("BroadcastQueue", "Background execution not allowed: receiving " + r.intent + " to " + component.flattenToShortString());
                    skip = true;
                }
            }
            if (skip) {
                r.delivery[recIdx] = 2;
                r.receiver = null;
                r.curFilter = null;
                r.state = 0;
                this.scheduleBroadcastsLocked();
                return;
            }
            r.delivery[recIdx] = 1;
            r.state = 1;
            r.curComponent = component;
            r.curReceiver = info.activityInfo;
            if (brOptions != null && brOptions.getTemporaryAppWhitelistDuration() > 0L) {
                this.scheduleTempWhitelistLocked(receiverUid, brOptions.getTemporaryAppWhitelistDuration(), r);
            }
            try {
                AppGlobals.getPackageManager().setPackageStoppedState(r.curComponent.getPackageName(), false, UserHandle.getUserId(r.callingUid));
            }
            catch (RemoteException allowed22) {
            }
            catch (IllegalArgumentException e) {
                Slog.w("BroadcastQueue", "Failed trying to unstop package " + r.curComponent.getPackageName() + ": " + e);
            }
            if (app != null && app.thread != null) {
                try {
                    app.addPackage(info.activityInfo.packageName, info.activityInfo.applicationInfo.versionCode, this.mService.mProcessStats);
                    this.processCurBroadcastLocked(r, app);
                    return;
                }
                catch (RemoteException e) {
                    Slog.w("BroadcastQueue", "Exception when sending broadcast to " + r.curComponent, e);
                }
                catch (RuntimeException e) {
                    Slog.wtf("BroadcastQueue", "Failed sending broadcast to " + r.curComponent + " with " + r.intent, e);
                    this.logBroadcastReceiverDiscardLocked(r);
                    this.finishReceiverLocked(r, r.resultCode, r.resultData, r.resultExtras, r.resultAbort, false);
                    this.scheduleBroadcastsLocked();
                    r.state = 0;
                    return;
                }
            }
            if ((r.curApp = this.mService.startProcessLocked(targetProcess, info.activityInfo.applicationInfo, true, r.intent.getFlags() | 4, "broadcast", r.curComponent, (r.intent.getFlags() & 0x2000000) != 0, false, false)) == null) {
                Slog.w("BroadcastQueue", "Unable to launch app " + info.activityInfo.applicationInfo.packageName + "/" + info.activityInfo.applicationInfo.uid + " for broadcast " + r.intent + ": process is bad");
                this.logBroadcastReceiverDiscardLocked(r);
                this.finishReceiverLocked(r, r.resultCode, r.resultData, r.resultExtras, r.resultAbort, false);
                this.scheduleBroadcastsLocked();
                r.state = 0;
                return;
            }
            this.mPendingBroadcast = r;
            this.mPendingBroadcastRecvIndex = recIdx;
        }
    }

    final void setBroadcastTimeoutLocked(long timeoutTime) {
        if (!this.mPendingBroadcastTimeoutMessage) {
            Message msg = this.mHandler.obtainMessage(201, this);
            this.mHandler.sendMessageAtTime(msg, timeoutTime);
            this.mPendingBroadcastTimeoutMessage = true;
        }
    }

    final void cancelBroadcastTimeoutLocked() {
        if (this.mPendingBroadcastTimeoutMessage) {
            this.mHandler.removeMessages(201, this);
            this.mPendingBroadcastTimeoutMessage = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void broadcastTimeoutLocked(boolean fromMsg) {
        if (fromMsg) {
            this.mPendingBroadcastTimeoutMessage = false;
        }
        if (this.mOrderedBroadcasts.size() == 0) {
            return;
        }
        long now = SystemClock.uptimeMillis();
        BroadcastRecord r = this.mOrderedBroadcasts.get(0);
        if (fromMsg) {
            if (this.mService.mDidDexOpt) {
                this.mService.mDidDexOpt = false;
                long timeoutTime = SystemClock.uptimeMillis() + this.mTimeoutPeriod;
                this.setBroadcastTimeoutLocked(timeoutTime);
                return;
            }
            if (!this.mService.mProcessesReady) {
                return;
            }
            long timeoutTime = r.receiverTime + this.mTimeoutPeriod;
            if (timeoutTime > now) {
                this.setBroadcastTimeoutLocked(timeoutTime);
                return;
            }
        }
        BroadcastRecord br = this.mOrderedBroadcasts.get(0);
        if (br.state == 4) {
            Slog.i("BroadcastQueue", "Waited long enough for: " + (br.curComponent != null ? br.curComponent.flattenToShortString() : "(null)"));
            br.curComponent = null;
            br.state = 0;
            this.processNextBroadcast(false);
            return;
        }
        Slog.w("BroadcastQueue", "Timeout of broadcast " + r + " - receiver=" + r.receiver + ", started " + (now - r.receiverTime) + "ms ago");
        r.receiverTime = now;
        ++r.anrCount;
        if (r.nextReceiver <= 0) {
            Slog.w("BroadcastQueue", "Timeout on receiver with nextReceiver <= 0");
            return;
        }
        ProcessRecord app = null;
        String anrMessage = null;
        Object curReceiver = r.receivers.get(r.nextReceiver - 1);
        r.delivery[r.nextReceiver - 1] = 3;
        Slog.w("BroadcastQueue", "Receiver during timeout: " + curReceiver);
        this.logBroadcastReceiverDiscardLocked(r);
        if (curReceiver instanceof BroadcastFilter) {
            BroadcastFilter bf = (BroadcastFilter)curReceiver;
            if (bf.receiverList.pid != 0 && bf.receiverList.pid != ActivityManagerService.MY_PID) {
                SparseArray<ProcessRecord> sparseArray = this.mService.mPidsSelfLocked;
                synchronized (sparseArray) {
                    app = this.mService.mPidsSelfLocked.get(bf.receiverList.pid);
                }
            }
        } else {
            app = r.curApp;
        }
        if (app != null) {
            anrMessage = "Broadcast of " + r.intent.toString();
        }
        if (this.mPendingBroadcast == r) {
            this.mPendingBroadcast = null;
        }
        this.finishReceiverLocked(r, r.resultCode, r.resultData, r.resultExtras, r.resultAbort, false);
        this.scheduleBroadcastsLocked();
        if (anrMessage != null) {
            this.mHandler.post(new AppNotResponding(app, anrMessage));
        }
    }

    private final int ringAdvance(int x, int increment, int ringSize) {
        if ((x += increment) < 0) {
            return ringSize - 1;
        }
        if (x >= ringSize) {
            return 0;
        }
        return x;
    }

    private final void addBroadcastToHistoryLocked(BroadcastRecord r) {
        if (r.callingUid < 0) {
            return;
        }
        r.finishTime = SystemClock.uptimeMillis();
        this.mBroadcastHistory[this.mHistoryNext] = r;
        this.mHistoryNext = this.ringAdvance(this.mHistoryNext, 1, MAX_BROADCAST_HISTORY);
        this.mBroadcastSummaryHistory[this.mSummaryHistoryNext] = r.intent;
        this.mSummaryHistoryEnqueueTime[this.mSummaryHistoryNext] = r.enqueueClockTime;
        this.mSummaryHistoryDispatchTime[this.mSummaryHistoryNext] = r.dispatchClockTime;
        this.mSummaryHistoryFinishTime[this.mSummaryHistoryNext] = System.currentTimeMillis();
        this.mSummaryHistoryNext = this.ringAdvance(this.mSummaryHistoryNext, 1, MAX_BROADCAST_SUMMARY_HISTORY);
    }

    boolean cleanupDisabledPackageReceiversLocked(String packageName, Set<String> filterByClasses, int userId, boolean doit) {
        int i;
        boolean didSomething = false;
        for (i = this.mParallelBroadcasts.size() - 1; i >= 0; --i) {
            if (doit || !(didSomething |= this.mParallelBroadcasts.get(i).cleanupDisabledPackageReceiversLocked(packageName, filterByClasses, userId, doit))) continue;
            return true;
        }
        for (i = this.mOrderedBroadcasts.size() - 1; i >= 0; --i) {
            if (doit || !(didSomething |= this.mOrderedBroadcasts.get(i).cleanupDisabledPackageReceiversLocked(packageName, filterByClasses, userId, doit))) continue;
            return true;
        }
        return didSomething;
    }

    final void logBroadcastReceiverDiscardLocked(BroadcastRecord r) {
        int logIndex = r.nextReceiver - 1;
        if (logIndex >= 0 && logIndex < r.receivers.size()) {
            Object curReceiver = r.receivers.get(logIndex);
            if (curReceiver instanceof BroadcastFilter) {
                BroadcastFilter bf = (BroadcastFilter)curReceiver;
                EventLog.writeEvent(30024, bf.owningUserId, System.identityHashCode(r), r.intent.getAction(), logIndex, System.identityHashCode(bf));
            } else {
                ResolveInfo ri = (ResolveInfo)curReceiver;
                EventLog.writeEvent(30025, UserHandle.getUserId(ri.activityInfo.applicationInfo.uid), System.identityHashCode(r), r.intent.getAction(), logIndex, ri.toString());
            }
        } else {
            if (logIndex < 0) {
                Slog.w("BroadcastQueue", "Discarding broadcast before first receiver is invoked: " + r);
            }
            EventLog.writeEvent(30025, -1, System.identityHashCode(r), r.intent.getAction(), r.nextReceiver, "NONE");
        }
    }

    final boolean dumpLocked(FileDescriptor fd, PrintWriter pw, String[] args, int opti, boolean dumpAll, String dumpPackage, boolean needSep) {
        Bundle bundle;
        int lastIndex;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        if (this.mParallelBroadcasts.size() > 0 || this.mOrderedBroadcasts.size() > 0 || this.mPendingBroadcast != null) {
            BroadcastRecord br;
            int i;
            boolean printed = false;
            for (i = this.mParallelBroadcasts.size() - 1; i >= 0; --i) {
                br = this.mParallelBroadcasts.get(i);
                if (dumpPackage != null && !dumpPackage.equals(br.callerPackage)) continue;
                if (!printed) {
                    if (needSep) {
                        pw.println();
                    }
                    needSep = true;
                    printed = true;
                    pw.println("  Active broadcasts [" + this.mQueueName + "]:");
                }
                pw.println("  Active Broadcast " + this.mQueueName + " #" + i + ":");
                br.dump(pw, "    ", sdf);
            }
            printed = false;
            needSep = true;
            for (i = this.mOrderedBroadcasts.size() - 1; i >= 0; --i) {
                br = this.mOrderedBroadcasts.get(i);
                if (dumpPackage != null && !dumpPackage.equals(br.callerPackage)) continue;
                if (!printed) {
                    if (needSep) {
                        pw.println();
                    }
                    needSep = true;
                    printed = true;
                    pw.println("  Active ordered broadcasts [" + this.mQueueName + "]:");
                }
                pw.println("  Active Ordered Broadcast " + this.mQueueName + " #" + i + ":");
                this.mOrderedBroadcasts.get(i).dump(pw, "    ", sdf);
            }
            if (dumpPackage == null || this.mPendingBroadcast != null && dumpPackage.equals(this.mPendingBroadcast.callerPackage)) {
                if (needSep) {
                    pw.println();
                }
                pw.println("  Pending broadcast [" + this.mQueueName + "]:");
                if (this.mPendingBroadcast != null) {
                    this.mPendingBroadcast.dump(pw, "    ", sdf);
                } else {
                    pw.println("    (null)");
                }
                needSep = true;
            }
        }
        boolean printed = false;
        int i = -1;
        int ringIndex = lastIndex = this.mHistoryNext;
        do {
            BroadcastRecord r;
            if ((r = this.mBroadcastHistory[ringIndex = this.ringAdvance(ringIndex, -1, MAX_BROADCAST_HISTORY)]) == null) continue;
            ++i;
            if (dumpPackage != null && !dumpPackage.equals(r.callerPackage)) continue;
            if (!printed) {
                if (needSep) {
                    pw.println();
                }
                needSep = true;
                pw.println("  Historical broadcasts [" + this.mQueueName + "]:");
                printed = true;
            }
            if (dumpAll) {
                pw.print("  Historical Broadcast " + this.mQueueName + " #");
                pw.print(i);
                pw.println(":");
                r.dump(pw, "    ", sdf);
                continue;
            }
            pw.print("  #");
            pw.print(i);
            pw.print(": ");
            pw.println(r);
            pw.print("    ");
            pw.println(r.intent.toShortString(false, true, true, false));
            if (r.targetComp != null && r.targetComp != r.intent.getComponent()) {
                pw.print("    targetComp: ");
                pw.println(r.targetComp.toShortString());
            }
            if ((bundle = r.intent.getExtras()) == null) continue;
            pw.print("    extras: ");
            pw.println(bundle.toString());
        } while (ringIndex != lastIndex);
        if (dumpPackage == null) {
            lastIndex = ringIndex = this.mSummaryHistoryNext;
            if (dumpAll) {
                printed = false;
                i = -1;
            } else {
                int j = i;
                while (j > 0 && ringIndex != lastIndex) {
                    BroadcastRecord r = this.mBroadcastHistory[ringIndex = this.ringAdvance(ringIndex, -1, MAX_BROADCAST_SUMMARY_HISTORY)];
                    if (r == null) continue;
                    --j;
                }
            }
            do {
                Intent intent;
                if ((intent = this.mBroadcastSummaryHistory[ringIndex = this.ringAdvance(ringIndex, -1, MAX_BROADCAST_SUMMARY_HISTORY)]) == null) continue;
                if (!printed) {
                    if (needSep) {
                        pw.println();
                    }
                    needSep = true;
                    pw.println("  Historical broadcasts summary [" + this.mQueueName + "]:");
                    printed = true;
                }
                if (!dumpAll && i >= 50) {
                    pw.println("  ...");
                    break;
                }
                pw.print("  #");
                pw.print(++i);
                pw.print(": ");
                pw.println(intent.toShortString(false, true, true, false));
                pw.print("    ");
                TimeUtils.formatDuration(this.mSummaryHistoryDispatchTime[ringIndex] - this.mSummaryHistoryEnqueueTime[ringIndex], pw);
                pw.print(" dispatch ");
                TimeUtils.formatDuration(this.mSummaryHistoryFinishTime[ringIndex] - this.mSummaryHistoryDispatchTime[ringIndex], pw);
                pw.println(" finish");
                pw.print("    enq=");
                pw.print(sdf.format(new Date(this.mSummaryHistoryEnqueueTime[ringIndex])));
                pw.print(" disp=");
                pw.print(sdf.format(new Date(this.mSummaryHistoryDispatchTime[ringIndex])));
                pw.print(" fin=");
                pw.println(sdf.format(new Date(this.mSummaryHistoryFinishTime[ringIndex])));
                bundle = intent.getExtras();
                if (bundle == null) continue;
                pw.print("    extras: ");
                pw.println(bundle.toString());
            } while (ringIndex != lastIndex);
        }
        return needSep;
    }

    private final class AppNotResponding
    implements Runnable {
        private final ProcessRecord mApp;
        private final String mAnnotation;

        public AppNotResponding(ProcessRecord app, String annotation) {
            this.mApp = app;
            this.mAnnotation = annotation;
        }

        @Override
        public void run() {
            BroadcastQueue.this.mService.mAppErrors.appNotResponding(this.mApp, null, null, false, this.mAnnotation);
        }
    }

    private final class BroadcastHandler
    extends Handler {
        public BroadcastHandler(Looper looper) {
            super(looper, null, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 200: {
                    BroadcastQueue.this.processNextBroadcast(true);
                    break;
                }
                case 201: {
                    ActivityManagerService activityManagerService = BroadcastQueue.this.mService;
                    synchronized (activityManagerService) {
                        BroadcastQueue.this.broadcastTimeoutLocked(true);
                        break;
                    }
                }
                case 202: {
                    DeviceIdleController.LocalService dic = BroadcastQueue.this.mService.mLocalDeviceIdleController;
                    if (dic == null) break;
                    dic.addPowerSaveTempWhitelistAppDirect(UserHandle.getAppId(msg.arg1), msg.arg2, true, (String)msg.obj);
                }
            }
        }
    }
}

