/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.util.EventLog;

public class EventLogTags {
    public static final int CONFIGURATION_CHANGED = 2719;
    public static final int CPU = 2721;
    public static final int BOOT_PROGRESS_AMS_READY = 3040;
    public static final int BOOT_PROGRESS_ENABLE_SCREEN = 3050;
    public static final int AM_FINISH_ACTIVITY = 30001;
    public static final int AM_TASK_TO_FRONT = 30002;
    public static final int AM_NEW_INTENT = 30003;
    public static final int AM_CREATE_TASK = 30004;
    public static final int AM_CREATE_ACTIVITY = 30005;
    public static final int AM_RESTART_ACTIVITY = 30006;
    public static final int AM_RESUME_ACTIVITY = 30007;
    public static final int AM_ANR = 30008;
    public static final int AM_ACTIVITY_LAUNCH_TIME = 30009;
    public static final int AM_PROC_BOUND = 30010;
    public static final int AM_PROC_DIED = 30011;
    public static final int AM_FAILED_TO_PAUSE = 30012;
    public static final int AM_PAUSE_ACTIVITY = 30013;
    public static final int AM_PROC_START = 30014;
    public static final int AM_PROC_BAD = 30015;
    public static final int AM_PROC_GOOD = 30016;
    public static final int AM_LOW_MEMORY = 30017;
    public static final int AM_DESTROY_ACTIVITY = 30018;
    public static final int AM_RELAUNCH_RESUME_ACTIVITY = 30019;
    public static final int AM_RELAUNCH_ACTIVITY = 30020;
    public static final int AM_ON_PAUSED_CALLED = 30021;
    public static final int AM_ON_RESUME_CALLED = 30022;
    public static final int AM_KILL = 30023;
    public static final int AM_BROADCAST_DISCARD_FILTER = 30024;
    public static final int AM_BROADCAST_DISCARD_APP = 30025;
    public static final int AM_CREATE_SERVICE = 30030;
    public static final int AM_DESTROY_SERVICE = 30031;
    public static final int AM_PROCESS_CRASHED_TOO_MUCH = 30032;
    public static final int AM_DROP_PROCESS = 30033;
    public static final int AM_SERVICE_CRASHED_TOO_MUCH = 30034;
    public static final int AM_SCHEDULE_SERVICE_RESTART = 30035;
    public static final int AM_PROVIDER_LOST_PROCESS = 30036;
    public static final int AM_PROCESS_START_TIMEOUT = 30037;
    public static final int AM_CRASH = 30039;
    public static final int AM_WTF = 30040;
    public static final int AM_SWITCH_USER = 30041;
    public static final int AM_ACTIVITY_FULLY_DRAWN_TIME = 30042;
    public static final int AM_SET_RESUMED_ACTIVITY = 30043;
    public static final int AM_FOCUSED_STACK = 30044;
    public static final int AM_PRE_BOOT = 30045;
    public static final int AM_MEMINFO = 30046;
    public static final int AM_PSS = 30047;
    public static final int AM_STOP_ACTIVITY = 30048;
    public static final int AM_ON_STOP_CALLED = 30049;
    public static final int AM_MEM_FACTOR = 30050;
    public static final int AM_USER_STATE_CHANGED = 30051;

    private EventLogTags() {
    }

    public static void writeConfigurationChanged(int configMask) {
        EventLog.writeEvent(2719, configMask);
    }

    public static void writeCpu(int total, int user, int system, int iowait, int irq, int softirq) {
        EventLog.writeEvent(2721, total, user, system, iowait, irq, softirq);
    }

    public static void writeBootProgressAmsReady(long time) {
        EventLog.writeEvent(3040, time);
    }

    public static void writeBootProgressEnableScreen(long time) {
        EventLog.writeEvent(3050, time);
    }

    public static void writeAmFinishActivity(int user, int token, int taskId, String componentName, String reason) {
        EventLog.writeEvent(30001, user, token, taskId, componentName, reason);
    }

    public static void writeAmTaskToFront(int user, int task) {
        EventLog.writeEvent(30002, user, task);
    }

    public static void writeAmNewIntent(int user, int token, int taskId, String componentName, String action, String mimeType, String uri, int flags) {
        EventLog.writeEvent(30003, user, token, taskId, componentName, action, mimeType, uri, flags);
    }

    public static void writeAmCreateTask(int user, int taskId) {
        EventLog.writeEvent(30004, user, taskId);
    }

    public static void writeAmCreateActivity(int user, int token, int taskId, String componentName, String action, String mimeType, String uri, int flags) {
        EventLog.writeEvent(30005, user, token, taskId, componentName, action, mimeType, uri, flags);
    }

    public static void writeAmRestartActivity(int user, int token, int taskId, String componentName) {
        EventLog.writeEvent(30006, user, token, taskId, componentName);
    }

    public static void writeAmResumeActivity(int user, int token, int taskId, String componentName) {
        EventLog.writeEvent(30007, user, token, taskId, componentName);
    }

    public static void writeAmAnr(int user, int pid, String packageName, int flags, String reason) {
        EventLog.writeEvent(30008, user, pid, packageName, flags, reason);
    }

    public static void writeAmActivityLaunchTime(int user, int token, String componentName, long time) {
        EventLog.writeEvent(30009, user, token, componentName, time);
    }

    public static void writeAmProcBound(int user, int pid, String processName) {
        EventLog.writeEvent(30010, user, pid, processName);
    }

    public static void writeAmProcDied(int user, int pid, String processName) {
        EventLog.writeEvent(30011, user, pid, processName);
    }

    public static void writeAmFailedToPause(int user, int token, String wantingToPause, String currentlyPausing) {
        EventLog.writeEvent(30012, user, token, wantingToPause, currentlyPausing);
    }

    public static void writeAmPauseActivity(int user, int token, String componentName) {
        EventLog.writeEvent(30013, user, token, componentName);
    }

    public static void writeAmProcStart(int user, int pid, int uid, String processName, String type, String component) {
        EventLog.writeEvent(30014, user, pid, uid, processName, type, component);
    }

    public static void writeAmProcBad(int user, int uid, String processName) {
        EventLog.writeEvent(30015, user, uid, processName);
    }

    public static void writeAmProcGood(int user, int uid, String processName) {
        EventLog.writeEvent(30016, user, uid, processName);
    }

    public static void writeAmLowMemory(int numProcesses) {
        EventLog.writeEvent(30017, numProcesses);
    }

    public static void writeAmDestroyActivity(int user, int token, int taskId, String componentName, String reason) {
        EventLog.writeEvent(30018, user, token, taskId, componentName, reason);
    }

    public static void writeAmRelaunchResumeActivity(int user, int token, int taskId, String componentName) {
        EventLog.writeEvent(30019, user, token, taskId, componentName);
    }

    public static void writeAmRelaunchActivity(int user, int token, int taskId, String componentName) {
        EventLog.writeEvent(30020, user, token, taskId, componentName);
    }

    public static void writeAmOnPausedCalled(int user, String componentName, String reason) {
        EventLog.writeEvent(30021, user, componentName, reason);
    }

    public static void writeAmOnResumeCalled(int user, String componentName, String reason) {
        EventLog.writeEvent(30022, user, componentName, reason);
    }

    public static void writeAmKill(int user, int pid, String processName, int oomadj, String reason) {
        EventLog.writeEvent(30023, user, pid, processName, oomadj, reason);
    }

    public static void writeAmBroadcastDiscardFilter(int user, int broadcast, String action, int receiverNumber, int broadcastfilter) {
        EventLog.writeEvent(30024, user, broadcast, action, receiverNumber, broadcastfilter);
    }

    public static void writeAmBroadcastDiscardApp(int user, int broadcast, String action, int receiverNumber, String app) {
        EventLog.writeEvent(30025, user, broadcast, action, receiverNumber, app);
    }

    public static void writeAmCreateService(int user, int serviceRecord, String name, int uid, int pid) {
        EventLog.writeEvent(30030, user, serviceRecord, name, uid, pid);
    }

    public static void writeAmDestroyService(int user, int serviceRecord, int pid) {
        EventLog.writeEvent(30031, user, serviceRecord, pid);
    }

    public static void writeAmProcessCrashedTooMuch(int user, String name, int pid) {
        EventLog.writeEvent(30032, user, name, pid);
    }

    public static void writeAmDropProcess(int pid) {
        EventLog.writeEvent(30033, pid);
    }

    public static void writeAmServiceCrashedTooMuch(int user, int crashCount, String componentName, int pid) {
        EventLog.writeEvent(30034, user, crashCount, componentName, pid);
    }

    public static void writeAmScheduleServiceRestart(int user, String componentName, long time) {
        EventLog.writeEvent(30035, user, componentName, time);
    }

    public static void writeAmProviderLostProcess(int user, String packageName, int uid, String name) {
        EventLog.writeEvent(30036, user, packageName, uid, name);
    }

    public static void writeAmProcessStartTimeout(int user, int pid, int uid, String processName) {
        EventLog.writeEvent(30037, user, pid, uid, processName);
    }

    public static void writeAmCrash(int user, int pid, String processName, int flags, String exception, String message, String file, int line) {
        EventLog.writeEvent(30039, user, pid, processName, flags, exception, message, file, line);
    }

    public static void writeAmWtf(int user, int pid, String processName, int flags, String tag, String message) {
        EventLog.writeEvent(30040, user, pid, processName, flags, tag, message);
    }

    public static void writeAmSwitchUser(int id2) {
        EventLog.writeEvent(30041, id2);
    }

    public static void writeAmActivityFullyDrawnTime(int user, int token, String componentName, long time) {
        EventLog.writeEvent(30042, user, token, componentName, time);
    }

    public static void writeAmSetResumedActivity(int user, String componentName, String reason) {
        EventLog.writeEvent(30043, user, componentName, reason);
    }

    public static void writeAmFocusedStack(int user, int focusedStackId, int lastFocusedStackId, String reason) {
        EventLog.writeEvent(30044, user, focusedStackId, lastFocusedStackId, reason);
    }

    public static void writeAmPreBoot(int user, String package_) {
        EventLog.writeEvent(30045, user, package_);
    }

    public static void writeAmMeminfo(long cached, long free, long zram, long kernel, long native_) {
        EventLog.writeEvent(30046, cached, free, zram, kernel, native_);
    }

    public static void writeAmPss(int pid, int uid, String processName, long pss, long uss, long swappss) {
        EventLog.writeEvent(30047, pid, uid, processName, pss, uss, swappss);
    }

    public static void writeAmStopActivity(int user, int token, String componentName) {
        EventLog.writeEvent(30048, user, token, componentName);
    }

    public static void writeAmOnStopCalled(int user, String componentName, String reason) {
        EventLog.writeEvent(30049, user, componentName, reason);
    }

    public static void writeAmMemFactor(int current, int previous) {
        EventLog.writeEvent(30050, current, previous);
    }

    public static void writeAmUserStateChanged(int id2, int state) {
        EventLog.writeEvent(30051, id2, state);
    }
}

