/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.app.ActivityManager;
import android.app.ITaskStackListener;
import android.content.ComponentName;
import android.os.Binder;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Process;
import android.os.RemoteCallbackList;
import android.os.RemoteException;
import com.android.server.am.ActivityManagerService;
import com.android.server.am.ActivityStackSupervisor;
import com.android.server.am.TaskChangeNotificationController$$Lambda$176;
import com.android.server.am.TaskChangeNotificationController$$Lambda$177;
import com.android.server.am.TaskChangeNotificationController$$Lambda$178;
import com.android.server.am.TaskChangeNotificationController$$Lambda$179;
import com.android.server.am.TaskChangeNotificationController$$Lambda$180;
import com.android.server.am.TaskChangeNotificationController$$Lambda$181;
import com.android.server.am.TaskChangeNotificationController$$Lambda$182;
import com.android.server.am.TaskChangeNotificationController$$Lambda$183;
import com.android.server.am.TaskChangeNotificationController$$Lambda$184;
import com.android.server.am.TaskChangeNotificationController$$Lambda$185;
import com.android.server.am.TaskChangeNotificationController$$Lambda$186;
import com.android.server.am.TaskChangeNotificationController$$Lambda$187;
import com.android.server.am.TaskChangeNotificationController$$Lambda$188;
import com.android.server.am.TaskChangeNotificationController$$Lambda$189;
import java.util.ArrayList;

class TaskChangeNotificationController {
    static final int LOG_STACK_STATE_MSG = 1;
    static final int NOTIFY_TASK_STACK_CHANGE_LISTENERS_MSG = 2;
    static final int NOTIFY_ACTIVITY_PINNED_LISTENERS_MSG = 3;
    static final int NOTIFY_PINNED_ACTIVITY_RESTART_ATTEMPT_LISTENERS_MSG = 4;
    static final int NOTIFY_PINNED_STACK_ANIMATION_ENDED_LISTENERS_MSG = 5;
    static final int NOTIFY_FORCED_RESIZABLE_MSG = 6;
    static final int NOTIFY_ACTIVITY_DISMISSING_DOCKED_STACK_MSG = 7;
    static final int NOTIFY_TASK_ADDED_LISTENERS_MSG = 8;
    static final int NOTIFY_TASK_REMOVED_LISTENERS_MSG = 9;
    static final int NOTIFY_TASK_MOVED_TO_FRONT_LISTENERS_MSG = 10;
    static final int NOTIFY_TASK_DESCRIPTION_CHANGED_LISTENERS_MSG = 11;
    static final int NOTIFY_ACTIVITY_REQUESTED_ORIENTATION_CHANGED_LISTENERS = 12;
    static final int NOTIFY_TASK_REMOVAL_STARTED_LISTENERS = 13;
    static final int NOTIFY_TASK_PROFILE_LOCKED_LISTENERS_MSG = 14;
    static final int NOTIFY_TASK_SNAPSHOT_CHANGED_LISTENERS_MSG = 15;
    static final int NOTIFY_TASK_STACK_CHANGE_LISTENERS_DELAY = 100;
    private final ActivityManagerService mService;
    private final ActivityStackSupervisor mStackSupervisor;
    private final Handler mHandler;
    private final RemoteCallbackList<ITaskStackListener> mRemoteTaskStackListeners = new RemoteCallbackList();
    private final ArrayList<ITaskStackListener> mLocalTaskStackListeners = new ArrayList();
    private final TaskStackConsumer mNotifyTaskStackChanged = TaskChangeNotificationController$$Lambda$176.get$Lambda();
    private final TaskStackConsumer mNotifyTaskCreated = TaskChangeNotificationController$$Lambda$177.get$Lambda();
    private final TaskStackConsumer mNotifyTaskRemoved = TaskChangeNotificationController$$Lambda$178.get$Lambda();
    private final TaskStackConsumer mNotifyTaskMovedToFront = TaskChangeNotificationController$$Lambda$179.get$Lambda();
    private final TaskStackConsumer mNotifyTaskDescriptionChanged = TaskChangeNotificationController$$Lambda$180.get$Lambda();
    private final TaskStackConsumer mNotifyActivityRequestedOrientationChanged = TaskChangeNotificationController$$Lambda$181.get$Lambda();
    private final TaskStackConsumer mNotifyTaskRemovalStarted = TaskChangeNotificationController$$Lambda$182.get$Lambda();
    private final TaskStackConsumer mNotifyActivityPinned = TaskChangeNotificationController$$Lambda$183.get$Lambda();
    private final TaskStackConsumer mNotifyPinnedActivityRestartAttempt = TaskChangeNotificationController$$Lambda$184.get$Lambda();
    private final TaskStackConsumer mNotifyPinnedStackAnimationEnded = TaskChangeNotificationController$$Lambda$185.get$Lambda();
    private final TaskStackConsumer mNotifyActivityForcedResizable = TaskChangeNotificationController$$Lambda$186.get$Lambda();
    private final TaskStackConsumer mNotifyActivityDismissingDockedStack = TaskChangeNotificationController$$Lambda$187.get$Lambda();
    private final TaskStackConsumer mNotifyTaskProfileLocked = TaskChangeNotificationController$$Lambda$188.get$Lambda();
    private final TaskStackConsumer mNotifyTaskSnapshotChanged = TaskChangeNotificationController$$Lambda$189.get$Lambda();

    public TaskChangeNotificationController(ActivityManagerService service, ActivityStackSupervisor stackSupervisor, Handler handler) {
        this.mService = service;
        this.mStackSupervisor = stackSupervisor;
        this.mHandler = new MainHandler(handler.getLooper());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerTaskStackListener(ITaskStackListener listener) {
        ActivityManagerService activityManagerService = this.mService;
        synchronized (activityManagerService) {
            if (listener != null) {
                if (Binder.getCallingPid() == Process.myPid()) {
                    if (!this.mLocalTaskStackListeners.contains(listener)) {
                        this.mLocalTaskStackListeners.add(listener);
                    }
                } else {
                    this.mRemoteTaskStackListeners.register(listener);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterTaskStackListener(ITaskStackListener listener) {
        ActivityManagerService activityManagerService = this.mService;
        synchronized (activityManagerService) {
            if (listener != null) {
                if (Binder.getCallingPid() == Process.myPid()) {
                    this.mLocalTaskStackListeners.remove(listener);
                } else {
                    this.mRemoteTaskStackListeners.unregister(listener);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void forAllRemoteListeners(TaskStackConsumer callback, Message message) {
        ActivityManagerService activityManagerService = this.mService;
        synchronized (activityManagerService) {
            for (int i = this.mRemoteTaskStackListeners.beginBroadcast() - 1; i >= 0; --i) {
                try {
                    callback.accept(this.mRemoteTaskStackListeners.getBroadcastItem(i), message);
                    continue;
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            this.mRemoteTaskStackListeners.finishBroadcast();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void forAllLocalListeners(TaskStackConsumer callback, Message message) {
        ActivityManagerService activityManagerService = this.mService;
        synchronized (activityManagerService) {
            for (int i = this.mLocalTaskStackListeners.size() - 1; i >= 0; --i) {
                try {
                    callback.accept(this.mLocalTaskStackListeners.get(i), message);
                    continue;
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
        }
    }

    void notifyTaskStackChanged() {
        this.mHandler.sendEmptyMessage(1);
        this.mHandler.removeMessages(2);
        Message msg = this.mHandler.obtainMessage(2);
        this.forAllLocalListeners(this.mNotifyTaskStackChanged, msg);
        this.mHandler.sendMessageDelayed(msg, 100L);
    }

    void notifyActivityPinned() {
        this.mHandler.removeMessages(3);
        Message msg = this.mHandler.obtainMessage(3);
        this.forAllLocalListeners(this.mNotifyActivityPinned, msg);
        msg.sendToTarget();
    }

    void notifyPinnedActivityRestartAttempt(String launchedFromPackage) {
        this.mHandler.removeMessages(4);
        Message msg = this.mHandler.obtainMessage(4, launchedFromPackage);
        this.forAllLocalListeners(this.mNotifyPinnedActivityRestartAttempt, msg);
        msg.sendToTarget();
    }

    void notifyPinnedStackAnimationEnded() {
        this.mHandler.removeMessages(5);
        Message msg = this.mHandler.obtainMessage(5);
        this.forAllLocalListeners(this.mNotifyPinnedStackAnimationEnded, msg);
        msg.sendToTarget();
    }

    void notifyActivityDismissingDockedStack() {
        this.mHandler.removeMessages(7);
        Message message = this.mHandler.obtainMessage(7);
        this.forAllLocalListeners(this.mNotifyActivityDismissingDockedStack, message);
    }

    void notifyActivityForcedResizable(int taskId, String packageName) {
        this.mHandler.removeMessages(6);
        Message msg = this.mHandler.obtainMessage(6, taskId, 0, packageName);
        this.forAllLocalListeners(this.mNotifyActivityForcedResizable, msg);
        msg.sendToTarget();
    }

    void notifyTaskCreated(int taskId, ComponentName componentName) {
        Message msg = this.mHandler.obtainMessage(8, taskId, 0, componentName);
        this.forAllLocalListeners(this.mNotifyTaskCreated, msg);
        msg.sendToTarget();
    }

    void notifyTaskRemoved(int taskId) {
        Message msg = this.mHandler.obtainMessage(9, taskId, 0);
        this.forAllLocalListeners(this.mNotifyTaskRemoved, msg);
        msg.sendToTarget();
    }

    void notifyTaskMovedToFront(int taskId) {
        Message msg = this.mHandler.obtainMessage(10, taskId, 0);
        this.forAllLocalListeners(this.mNotifyTaskMovedToFront, msg);
        msg.sendToTarget();
    }

    void notifyTaskDescriptionChanged(int taskId, ActivityManager.TaskDescription taskDescription) {
        Message msg = this.mHandler.obtainMessage(11, taskId, 0, taskDescription);
        this.forAllLocalListeners(this.mNotifyTaskDescriptionChanged, msg);
        msg.sendToTarget();
    }

    void notifyActivityRequestedOrientationChanged(int taskId, int orientation) {
        Message msg = this.mHandler.obtainMessage(12, taskId, orientation);
        this.forAllLocalListeners(this.mNotifyActivityRequestedOrientationChanged, msg);
        msg.sendToTarget();
    }

    void notifyTaskRemovalStarted(int taskId) {
        Message msg = this.mHandler.obtainMessage(13, taskId, 0);
        this.forAllLocalListeners(this.mNotifyTaskRemovalStarted, msg);
        msg.sendToTarget();
    }

    void notifyTaskProfileLocked(int taskId, int userId) {
        Message msg = this.mHandler.obtainMessage(14, taskId, userId);
        this.forAllLocalListeners(this.mNotifyTaskProfileLocked, msg);
        msg.sendToTarget();
    }

    void notifyTaskSnapshotChanged(int taskId, ActivityManager.TaskSnapshot snapshot) {
        Message msg = this.mHandler.obtainMessage(15, taskId, 0, snapshot);
        this.forAllLocalListeners(this.mNotifyTaskSnapshotChanged, msg);
        msg.sendToTarget();
    }

    static final /* synthetic */ void lambda$new$38$TaskChangeNotificationController(ITaskStackListener l, Message m) throws RemoteException {
        l.onTaskSnapshotChanged(m.arg1, (ActivityManager.TaskSnapshot)m.obj);
    }

    static final /* synthetic */ void lambda$new$37$TaskChangeNotificationController(ITaskStackListener l, Message m) throws RemoteException {
        l.onTaskProfileLocked(m.arg1, m.arg2);
    }

    static final /* synthetic */ void lambda$new$36$TaskChangeNotificationController(ITaskStackListener l, Message m) throws RemoteException {
        l.onActivityDismissingDockedStack();
    }

    static final /* synthetic */ void lambda$new$35$TaskChangeNotificationController(ITaskStackListener l, Message m) throws RemoteException {
        l.onActivityForcedResizable((String)m.obj, m.arg1);
    }

    static final /* synthetic */ void lambda$new$34$TaskChangeNotificationController(ITaskStackListener l, Message m) throws RemoteException {
        l.onPinnedStackAnimationEnded();
    }

    static final /* synthetic */ void lambda$new$33$TaskChangeNotificationController(ITaskStackListener l, Message m) throws RemoteException {
        l.onPinnedActivityRestartAttempt((String)m.obj);
    }

    static final /* synthetic */ void lambda$new$32$TaskChangeNotificationController(ITaskStackListener l, Message m) throws RemoteException {
        l.onActivityPinned();
    }

    static final /* synthetic */ void lambda$new$31$TaskChangeNotificationController(ITaskStackListener l, Message m) throws RemoteException {
        l.onTaskRemovalStarted(m.arg1);
    }

    static final /* synthetic */ void lambda$new$30$TaskChangeNotificationController(ITaskStackListener l, Message m) throws RemoteException {
        l.onActivityRequestedOrientationChanged(m.arg1, m.arg2);
    }

    static final /* synthetic */ void lambda$new$29$TaskChangeNotificationController(ITaskStackListener l, Message m) throws RemoteException {
        l.onTaskDescriptionChanged(m.arg1, (ActivityManager.TaskDescription)m.obj);
    }

    static final /* synthetic */ void lambda$new$28$TaskChangeNotificationController(ITaskStackListener l, Message m) throws RemoteException {
        l.onTaskMovedToFront(m.arg1);
    }

    static final /* synthetic */ void lambda$new$27$TaskChangeNotificationController(ITaskStackListener l, Message m) throws RemoteException {
        l.onTaskRemoved(m.arg1);
    }

    static final /* synthetic */ void lambda$new$26$TaskChangeNotificationController(ITaskStackListener l, Message m) throws RemoteException {
        l.onTaskCreated(m.arg1, (ComponentName)m.obj);
    }

    static final /* synthetic */ void lambda$new$25$TaskChangeNotificationController(ITaskStackListener l, Message m) throws RemoteException {
        l.onTaskStackChanged();
    }

    private class MainHandler
    extends Handler {
        public MainHandler(Looper looper) {
            super(looper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    ActivityManagerService activityManagerService = TaskChangeNotificationController.this.mService;
                    synchronized (activityManagerService) {
                        TaskChangeNotificationController.this.mStackSupervisor.logStackState();
                        break;
                    }
                }
                case 2: {
                    TaskChangeNotificationController.this.forAllRemoteListeners(TaskChangeNotificationController.this.mNotifyTaskStackChanged, msg);
                    break;
                }
                case 8: {
                    TaskChangeNotificationController.this.forAllRemoteListeners(TaskChangeNotificationController.this.mNotifyTaskCreated, msg);
                    break;
                }
                case 9: {
                    TaskChangeNotificationController.this.forAllRemoteListeners(TaskChangeNotificationController.this.mNotifyTaskRemoved, msg);
                    break;
                }
                case 10: {
                    TaskChangeNotificationController.this.forAllRemoteListeners(TaskChangeNotificationController.this.mNotifyTaskMovedToFront, msg);
                    break;
                }
                case 11: {
                    TaskChangeNotificationController.this.forAllRemoteListeners(TaskChangeNotificationController.this.mNotifyTaskDescriptionChanged, msg);
                    break;
                }
                case 12: {
                    TaskChangeNotificationController.this.forAllRemoteListeners(TaskChangeNotificationController.this.mNotifyActivityRequestedOrientationChanged, msg);
                    break;
                }
                case 13: {
                    TaskChangeNotificationController.this.forAllRemoteListeners(TaskChangeNotificationController.this.mNotifyTaskRemovalStarted, msg);
                    break;
                }
                case 3: {
                    TaskChangeNotificationController.this.forAllRemoteListeners(TaskChangeNotificationController.this.mNotifyActivityPinned, msg);
                    break;
                }
                case 4: {
                    TaskChangeNotificationController.this.forAllRemoteListeners(TaskChangeNotificationController.this.mNotifyPinnedActivityRestartAttempt, msg);
                    break;
                }
                case 5: {
                    TaskChangeNotificationController.this.forAllRemoteListeners(TaskChangeNotificationController.this.mNotifyPinnedStackAnimationEnded, msg);
                    break;
                }
                case 6: {
                    TaskChangeNotificationController.this.forAllRemoteListeners(TaskChangeNotificationController.this.mNotifyActivityForcedResizable, msg);
                    break;
                }
                case 7: {
                    TaskChangeNotificationController.this.forAllRemoteListeners(TaskChangeNotificationController.this.mNotifyActivityDismissingDockedStack, msg);
                    break;
                }
                case 14: {
                    TaskChangeNotificationController.this.forAllRemoteListeners(TaskChangeNotificationController.this.mNotifyTaskProfileLocked, msg);
                    break;
                }
                case 15: {
                    TaskChangeNotificationController.this.forAllRemoteListeners(TaskChangeNotificationController.this.mNotifyTaskSnapshotChanged, msg);
                }
            }
        }
    }

    @FunctionalInterface
    public static interface TaskStackConsumer {
        public void accept(ITaskStackListener var1, Message var2) throws RemoteException;
    }
}

