/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.am;

import android.os.SystemClock;
import android.os.UserHandle;
import android.util.TimeUtils;
import com.android.server.am.ProcessList;

public final class UidRecord {
    final int uid;
    int curProcState;
    int setProcState = 17;
    long lastBackgroundTime;
    boolean ephemeral;
    boolean curWhitelist;
    boolean setWhitelist;
    boolean idle;
    int numProcs;
    static final int CHANGE_PROCSTATE = 0;
    static final int CHANGE_GONE = 1;
    static final int CHANGE_GONE_IDLE = 2;
    static final int CHANGE_IDLE = 3;
    static final int CHANGE_ACTIVE = 4;
    ChangeItem pendingChange;

    public UidRecord(int _uid) {
        this.uid = _uid;
        this.reset();
    }

    public void reset() {
        this.curProcState = 16;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append("UidRecord{");
        sb.append(Integer.toHexString(System.identityHashCode(this)));
        sb.append(' ');
        UserHandle.formatUid(sb, this.uid);
        sb.append(' ');
        sb.append(ProcessList.makeProcStateString(this.curProcState));
        if (this.ephemeral) {
            sb.append(" ephemeral");
        }
        if (this.curWhitelist) {
            sb.append(" whitelist");
        }
        if (this.lastBackgroundTime > 0L) {
            sb.append(" bg:");
            TimeUtils.formatDuration(SystemClock.elapsedRealtime() - this.lastBackgroundTime, sb);
        }
        if (this.idle) {
            sb.append(" idle");
        }
        sb.append(" procs:");
        sb.append(this.numProcs);
        sb.append("}");
        return sb.toString();
    }

    static final class ChangeItem {
        UidRecord uidRecord;
        int uid;
        int change;
        int processState;
        boolean ephemeral;

        ChangeItem() {
        }
    }
}

