/*
 * Decompiled with CFR 0.152.
 */
package com.android.server.audio;

import android.media.AudioAttributes;
import android.media.AudioFocusInfo;
import android.media.IAudioFocusDispatcher;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import com.android.server.audio.MediaFocusControl;
import java.io.PrintWriter;
import java.util.NoSuchElementException;

public class FocusRequester {
    private static final String TAG = "MediaFocusControl";
    private static final boolean DEBUG = false;
    private MediaFocusControl.AudioFocusDeathHandler mDeathHandler;
    private IAudioFocusDispatcher mFocusDispatcher;
    private final IBinder mSourceRef;
    private final String mClientId;
    private final String mPackageName;
    private final int mCallingUid;
    private final MediaFocusControl mFocusController;
    private final int mFocusGainRequest;
    private final int mGrantFlags;
    private int mFocusLossReceived;
    private boolean mFocusLossWasNotified;
    private final AudioAttributes mAttributes;

    FocusRequester(AudioAttributes aa, int focusRequest, int grantFlags, IAudioFocusDispatcher afl, IBinder source, String id2, MediaFocusControl.AudioFocusDeathHandler hdlr, String pn, int uid, MediaFocusControl ctlr) {
        this.mAttributes = aa;
        this.mFocusDispatcher = afl;
        this.mSourceRef = source;
        this.mClientId = id2;
        this.mDeathHandler = hdlr;
        this.mPackageName = pn;
        this.mCallingUid = uid;
        this.mFocusGainRequest = focusRequest;
        this.mGrantFlags = grantFlags;
        this.mFocusLossReceived = 0;
        this.mFocusController = ctlr;
    }

    boolean hasSameClient(String otherClient) {
        try {
            return this.mClientId.compareTo(otherClient) == 0;
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    boolean isLockedFocusOwner() {
        return (this.mGrantFlags & 4) != 0;
    }

    boolean hasSameBinder(IBinder ib) {
        return this.mSourceRef != null && this.mSourceRef.equals(ib);
    }

    boolean hasSamePackage(String pack) {
        try {
            return this.mPackageName.compareTo(pack) == 0;
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    boolean hasSameUid(int uid) {
        return this.mCallingUid == uid;
    }

    int getClientUid() {
        return this.mCallingUid;
    }

    String getClientId() {
        return this.mClientId;
    }

    int getGainRequest() {
        return this.mFocusGainRequest;
    }

    int getGrantFlags() {
        return this.mGrantFlags;
    }

    AudioAttributes getAudioAttributes() {
        return this.mAttributes;
    }

    private static String focusChangeToString(int focus) {
        switch (focus) {
            case 0: {
                return "none";
            }
            case 1: {
                return "GAIN";
            }
            case 2: {
                return "GAIN_TRANSIENT";
            }
            case 3: {
                return "GAIN_TRANSIENT_MAY_DUCK";
            }
            case 4: {
                return "GAIN_TRANSIENT_EXCLUSIVE";
            }
            case -1: {
                return "LOSS";
            }
            case -2: {
                return "LOSS_TRANSIENT";
            }
            case -3: {
                return "LOSS_TRANSIENT_CAN_DUCK";
            }
        }
        return "[invalid focus change" + focus + "]";
    }

    private String focusGainToString() {
        return FocusRequester.focusChangeToString(this.mFocusGainRequest);
    }

    private String focusLossToString() {
        return FocusRequester.focusChangeToString(this.mFocusLossReceived);
    }

    private static String flagsToString(int flags) {
        String msg = new String();
        if ((flags & 1) != 0) {
            msg = msg + "DELAY_OK";
        }
        if ((flags & 4) != 0) {
            if (!msg.isEmpty()) {
                msg = msg + "|";
            }
            msg = msg + "LOCK";
        }
        if ((flags & 2) != 0) {
            if (!msg.isEmpty()) {
                msg = msg + "|";
            }
            msg = msg + "PAUSES_ON_DUCKABLE_LOSS";
        }
        return msg;
    }

    void dump(PrintWriter pw) {
        pw.println("  source:" + this.mSourceRef + " -- pack: " + this.mPackageName + " -- client: " + this.mClientId + " -- gain: " + this.focusGainToString() + " -- flags: " + FocusRequester.flagsToString(this.mGrantFlags) + " -- loss: " + this.focusLossToString() + " -- notified: " + this.mFocusLossWasNotified + " -- uid: " + this.mCallingUid + " -- attr: " + this.mAttributes);
    }

    void release() {
        try {
            if (this.mSourceRef != null && this.mDeathHandler != null) {
                this.mSourceRef.unlinkToDeath(this.mDeathHandler, 0);
                this.mDeathHandler = null;
                this.mFocusDispatcher = null;
            }
        }
        catch (NoSuchElementException e) {
            Log.e(TAG, "FocusRequester.release() hit ", e);
        }
    }

    protected void finalize() throws Throwable {
        this.release();
        super.finalize();
    }

    private int focusLossForGainRequest(int gainRequest) {
        switch (gainRequest) {
            case 1: {
                switch (this.mFocusLossReceived) {
                    case -3: 
                    case -2: 
                    case -1: 
                    case 0: {
                        return -1;
                    }
                }
            }
            case 2: 
            case 4: {
                switch (this.mFocusLossReceived) {
                    case -3: 
                    case -2: 
                    case 0: {
                        return -2;
                    }
                    case -1: {
                        return -1;
                    }
                }
            }
            case 3: {
                switch (this.mFocusLossReceived) {
                    case -3: 
                    case 0: {
                        return -3;
                    }
                    case -2: {
                        return -2;
                    }
                    case -1: {
                        return -1;
                    }
                }
            }
        }
        Log.e(TAG, "focusLossForGainRequest() for invalid focus request " + gainRequest);
        return 0;
    }

    void handleExternalFocusGain(int focusGain, FocusRequester fr) {
        int focusLoss = this.focusLossForGainRequest(focusGain);
        this.handleFocusLoss(focusLoss, fr);
    }

    void handleFocusGain(int focusGain) {
        try {
            int oldLoss = this.mFocusLossReceived;
            this.mFocusLossReceived = 0;
            this.mFocusController.notifyExtPolicyFocusGrant_syncAf(this.toAudioFocusInfo(), 1);
            IAudioFocusDispatcher fd = this.mFocusDispatcher;
            if (fd != null) {
                if (this.mFocusLossWasNotified) {
                    fd.dispatchAudioFocusChange(focusGain, this.mClientId);
                } else if (oldLoss == -3) {
                    this.mFocusController.unduckPlayers(this);
                }
            }
            this.mFocusLossWasNotified = false;
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failure to signal gain of audio focus due to: ", e);
        }
    }

    void handleFocusLoss(int focusLoss, FocusRequester fr) {
        try {
            if (focusLoss != this.mFocusLossReceived) {
                this.mFocusLossReceived = focusLoss;
                this.mFocusLossWasNotified = false;
                if (!this.mFocusController.mustNotifyFocusOwnerOnDuck() && this.mFocusLossReceived == -3 && (this.mGrantFlags & 2) == 0) {
                    this.mFocusController.notifyExtPolicyFocusLoss_syncAf(this.toAudioFocusInfo(), false);
                    return;
                }
                boolean handled = false;
                if (focusLoss == -3) {
                    // empty if block
                }
                if (handled) {
                    return;
                }
                IAudioFocusDispatcher fd = this.mFocusDispatcher;
                if (fd != null) {
                    this.mFocusController.notifyExtPolicyFocusLoss_syncAf(this.toAudioFocusInfo(), true);
                    this.mFocusLossWasNotified = true;
                    fd.dispatchAudioFocusChange(this.mFocusLossReceived, this.mClientId);
                }
            }
        }
        catch (RemoteException e) {
            Log.e(TAG, "Failure to signal loss of audio focus due to:", e);
        }
    }

    AudioFocusInfo toAudioFocusInfo() {
        return new AudioFocusInfo(this.mAttributes, this.mCallingUid, this.mClientId, this.mPackageName, this.mFocusGainRequest, this.mFocusLossReceived, this.mGrantFlags);
    }
}

